/*
 * STR - Support for explicit length strings. These have the advantage of
 *       allowing to pass around substrings without copying, to use the length
 *       as a quick hash, and to contain the \0 character.
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2004/01/13 - EvB - Created
 * 2004/05/11 - EvB - Split off from misc
 */


char str_id[] = "STR - Copyright (C) 2004 Emile van Bergen.";


/*
 * INCLUDES & DEFINES
 */


#include <string.h>		/* For memchr */
#include <ctype.h>		/* For toupper, tolower */

#include <misc.h>		/* For MIN */
#include <str.h>


/*
 * FUNCTIONS
 */


void *memrchr(void *s, int c, size_t n)
{
	void *ret;
	int t;

	t = 1;				/* catch n == 0 case */
	for(ret = s + n - 1; 
	    ret >= s && (t = *(unsigned char *)ret - (unsigned char)c);
	    ret--);

	if (t == 0) return ret;
	return 0;
}


size_t memspn(void *data, size_t len, char *set, int setlen)
{
    unsigned char *p;

    for(p = (unsigned char *)data; len != 0 && memchr(set, *p, setlen); len--, p++);
    return p - (unsigned char *)data;
}


size_t memcspn(void *data, size_t len, char *set, int setlen)
{
    unsigned char *p;

    for(p = (unsigned char *)data; len != 0 && memchr(set, *p, setlen) == 0; len--, p++);
    return p - (unsigned char *)data;
}


/* returns bare word in STR, adjusts s, stripping any delimiters. */

STR str_getword(STR *s, char *delim, int delimcnt) 
{
   STR ret;
   int n;

   n = memspn(s->p, s->l, delim, delimcnt);
   s->p += n; s->l -= n;

   n = memcspn(s->p, s->l, delim, delimcnt);
   ret.p = s->p;
   ret.l = n;
   s->p += n; s->l -= n;

   return ret;
}


/* copy string, limit size to destination buffer  */

ssize_t cpstr(char *d, ssize_t dl, char *s, ssize_t sl)
{
    ssize_t ret; 

    memcpy(d, s, ret = MIN(sl, dl));
    return ret;
}


/* copy and terminate string */

ssize_t cptstr(char *d, ssize_t dl, char *s, ssize_t sl)
{
    ssize_t ret; 

    memcpy(d, s, ret = MIN(sl, dl - 1));
    d[ret] = 0;
    return ret;
}


void str_toupper(char *p, ssize_t l)
{
	while(l--) { *p = toupper(*p); p++; }
}


void str_tolower(char *p, ssize_t l)
{
	while(l--) { *p = tolower(*p); p++; }
}
