/*
 * STR - Support for explicit length strings. These have the advantage of
 *       allowing to pass around substrings without copying, to use the length
 *       as a quick hash, and to contain the \0 character.
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2004/01/13 - EvB - Created
 * 2004/05/11 - EvB - Split off from misc
 */


#ifndef _STR_H
#define _STR_H 1


/*
 * INCLUDES & DEFINES
 */


#include <sys/types.h>		/* for ssize_t */


/*
 * TYPES
 */

typedef struct str {
    char *p;
    ssize_t l;
} STR;

/*
 * PROTOTYPES
 */

void *memrchr(void *s, int c, size_t n);
size_t memspn(void *data, size_t len, char *set, int setlen);
size_t memcspn(void *data, size_t len, char *set, int setlen);

ssize_t cpstr(char *d, ssize_t dl, char *s, ssize_t sl);   /* copy string */
ssize_t cptstr(char *d, ssize_t dl, char *s, ssize_t sl);  /* copy, terminate */

void str_tolower(char *p, ssize_t l);
void str_toupper(char *p, ssize_t l);

STR str_getword(STR *s, char *delim, int delimcnt);

#endif

