/*
 * STREAM - Functions to support efficient I/O streams based on fastrings
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2004/01/13 - EvB - Created
 */

char stream_id[] = "STREAM - Copyright (C) 2004 Emile van Bergen.";


/*
 * INCLUDES & DEFINES
 */


#include <string.h>		/* for memchr() */
#include <stdlib.h>		/* for malloc() */

#include <stream.h>


/* 
 * FUNCTIONS
 */


STRM *strm_new(int fd, ssize_t bufsize)
{
    STRM *ret;
    size_t pagesize;
 
    pagesize = GETPAGESIZE;
    bufsize = ((bufsize + pagesize - 1) / pagesize) * pagesize;

    ret = (STRM *)malloc(sizeof(STRM)); if (!ret) return 0;
    memset(ret, 0, sizeof(STRM));
    ret->bufsize = bufsize;
    ret->r = ring_new(bufsize * 2); if (!ret->r) { free(ret); return 0; }
    ret->fd = fd;

    return ret;
}


void strm_del(STRM *strm)
{
    ring_del(strm->r);
    free(strm);
}


STR strm_getline(STRM *strm)
{
    ssize_t max, len, rd, rl;
    char *end, *rp;
    
    for(;;) {
	max = ring_maxget(strm->r);
	end = memchr(strm->r->r, '\n', max);
	if (end) { rl = end - strm->r->r + 1; break; }
	if (strm->eof) { rl = max; break; }
        rd = ring_maxput(strm->r); 
	if (!rd) { rl = max; break; }	   /* line cut in two */
	if (rd > strm->bufsize) rd = strm->bufsize;
	len = safe_read(strm->fd, strm->r->w, rd);
	ring_put(strm->r, len);
	if (!len) strm->eof++;
    }
    strm->aux++;
    rp = strm->r->r; 
    ring_get(strm->r, rl);
    return (STR){rp, rl};
}

