/*
 * STREAM - Functions to support efficient I/O streams based on fastrings
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2004/01/13 - EvB - Created
 */


#include <fastring.h>
#include <str.h>


typedef struct stream {
    RING *r;
    int fd, eof, aux;		/* line counter or other state info */
    size_t bufsize;
} STRM;


STRM *strm_new(int fd, ssize_t bufsize);
void strm_del(STRM *strm);

STR strm_getline(STRM *strm);

