# Standard things

sp 		:= $(sp).x
dirstack_$(sp)	:= $(d)
d		:= $(dir)


# Local variables

CF_$(d)		:= -I$(d) -Icommon -Iserver

LIBOBJS_$(d)	:= $(d)/langcompile.o $(d)/langvm.o $(d)/langdisasm.o 
TSTOBJS_$(d)	:= $(d)/langtest.o
OBJS_$(d)	:= $(LIBOBJS_$(d)) $(TSTOBJS_$(d))
DEPS_$(d)	:= $(OBJS_$(d):%=%.d)
PRPS_$(d)	:= $(OBJS_$(d):%.o=%.i)

CLEAN		:= $(CLEAN) $(OBJS_$(d)) $(DEPS_$(d)) $(PRPS_$(d)) \
		   $(d)/langtest $(d)/language.a

TGT_TEST	:= $(TGT_TEST) $(d)/langtest


# Local rules

$(OBJS_$(d)):	$(d)/Rules.mk common/platform.h
$(OBJS_$(d)):	CF_TGT := $(CF_$(d))

$(PRPS_$(d)):	$(d)/Rules.mk common/platform.h
$(PRPS_$(d)):	CF_TGT := $(CF_$(d))

$(d)/language.a: $(LIBOBJS_$(d))
		$(ARCHIVE)

$(d)/langtest:	LL_TGT := $(S_LL_CRYPT) -levb1
$(d)/langtest:	$(TSTOBJS_$(d)) language/language.a common/common.a
		$(LINK)


# Standard things

-include	$(DEPS_$(d))

d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))

