#
# $Id: acct.sh,v 1.1 1996/01/06 02:04:15 lf Exp $
#

acct_start ()
{
	SID=`mksid`; export SID
	START_TIME=`mktime`; export START_TIME
	
	(
		echo "Acct-Session-Id = \"$SID\""
		echo "User-Name = \"$RADIUS_USER_NAME\""
		echo "Acct-Status-Type = Start"
		echo "Acct-Authentic = RADIUS"
		echo "Service-Type = $RADIUS_SERVICE_TYPE"
		TYPE="`echo $RADIUS_SERVICE_TYPE | tr [A-Z] [a-z]`"
		if [ $TYPE = "framed" ]
		then
			echo "Framed-Protocol = $RADIUS_FRAMED_PROTOCOL"
		fi
	) | radacct
}

acct_stop ()
{
	STOP_TIME=`mktime`

	(
		echo "Acct-Session-Id = \"$SID\""
		echo "User-Name = \"$RADIUS_USER_NAME\""
		echo "Acct-Status-Type = Stop"
		echo "Acct-Authentic = RADIUS"
		echo "Acct-Session-Time = `expr $STOP_TIME - $START_TIME`"
		echo "Service-Type = $RADIUS_SERVICE_TYPE"
		TYPE="`echo $RADIUS_SERVICE_TYPE | tr [A-Z] [a-z]`"
		if [ $TYPE = "framed" ]
		then
			echo "Framed-Protocol = $RADIUS_FRAMED_PROTOCOL"
		fi
	) | radacct
}
