#
# $Id: slip.sh,v 1.2 1996/01/06 03:26:48 lf Exp $
#

do_slip ()
{
	# start account record
	acct_start

	CTYPE="`echo $RADIUS_FRAMED_COMPRESSION | tr [A-Z] [a-z]`"
	case $CTYPE in
	 van_jacobson_tcp_ip)
		PROTO=cslip
		;;
	 none)
		PROTO=slip
		;;
	 # default on Portmasters is compressed slip
	 # if no Framed-Compression attribute is present
	 *)
		PROTO=cslip
		;;
	esac

	echo "protocol $PROTO local $IPADDRESS remote $RADIUS_FRAMED_IP_ADDRESS"

	# switch to slip line discipline
	#
	# -h exit when carrier is lost
	# -l create lock file
	# -n equivalent: mesg n
	TTY=`tty` # directly doesnt work, how knows why?
	slattach -hln -p $PROTO $TTY & SLA_PID=$!
	sleep 2

	# configure interface, set up host route
	INAME=`getifname`
	ifconfig $INAME $IPADDRESS \
		pointopoint $RADIUS_FRAMED_IP_ADDRESS \
		netmask $RADIUS_FRAMED_IP_NETMASK \
		mtu $RADIUS_FRAMED_MTU up

	route add $RADIUS_FRAMED_IP_ADDRESS $INAME

	wait $SLA_PID

	# normally the kernel does this job, but just in case
	ifconfig $INAME down 2>/dev/null
	route del $RADIUS_FRAMED_IP_ADDRESS 2>/dev/null

	# stop accounting record
	acct_stop
}
