/*
 * $Id: log.c,v 1.6 1996/01/05 02:29:56 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>

/*
 * Function: rc_log
 *
 * Purpose: Log information to the user
 *
 * Arguments: priority (just like syslog), rest like printf
 *
 * Returns: nothing
 *
 */

void rc_log(int prio, char *format, ...)
{
        char buff[1024];
        va_list ap;
                    
        va_start(ap,format);
        vsprintf(buff, format, ap);
        va_end(ap);

	fprintf(stderr,"%s\n", buff);
	
	/* stderr usually is unbuffered, but just to make sure */
	fflush(stderr);
}
