/*
 * $Id: radacct.c,v 1.6 1996/01/06 01:58:18 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

static char	rcsid[] =
		"$Id: radacct.c,v 1.6 1996/01/06 01:58:18 lf Exp $";

static char	copyright_1[] =
		"$Copyright: (C) 1995 Lars Fenneberg $";

static char	copyright_2[] =
		"$Parts: (C) 1992 Livingston Enterprises, Inc. $";

static char	copyright_3[] =
		"$Parts: (C) 1992,1993, 1994,1995 The Regents of the \
University of Michigan and Merit Network, Inc. All Rights Reserved $";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/param.h>
#include	<netinet/in.h>
#include	<sys/time.h>
#include	<sys/termios.h>
#include	<sys/signal.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<unistd.h>
#include	<pwd.h>
#include	<string.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<syslog.h>

#include	"radius.h"

void usage(char *program)
{
	fprintf(stderr,"Usage: %s [-i <client_port>]\n\n", program);
	fprintf(stderr,"  -i            ttyname to send to the server\n");
	fprintf(stderr,"  -V            output version information\n");
	fprintf(stderr,"  -h            output this text\n");
	exit(ERROR_RC);
}

void version(char *program)
{
	fprintf(stderr,"%s: %s\n", program ,rcsid);
	exit(ERROR_RC);
}

int
main (int argc, char **argv)
{
	int             result = ERROR_RC;
	VALUE_PAIR	*send = NULL;
    	UINT4		client_port;
    	int		c;
        
        extern char *optarg;
        extern int optind;
              

	if (rc_read_config(RADIUSCLIENT_CONF) != 0)
		exit(ERROR_RC);
	
	if (rc_read_dictionary(conf_dictionary) != 0)
		exit (ERROR_RC);

        if (rc_read_mapfile(conf_mapfile) != 0)
        	exit (ERROR_RC);

	/* we take stdout here, because stdin is usually connected
	 * to our input file
	 */
	client_port = rc_map2id(ttyname(1));

	while ((c = getopt(argc,argv,"i:hV")) > 0)
	{
		switch(c) {
			case 'i':
				client_port = rc_map2id(optarg);
				break;
			case 'V':
				version(argv[0]);
				break;
			case 'h':
				usage(argv[0]);
				break;
			default:
				exit(ERROR_RC);
				break;
		}
	}

	if ((send = rc_avpair_readin(stdin))) {
		result = rc_acct(client_port, send);
		if (result == OK_RC)
		{
			rc_log(LOG_NOTICE, "RADIUS accounting OK");
		}
		else
		{
			rc_log(LOG_NOTICE, "RADIUS accounting failed (RC=%i)", result);
		}
		rc_avpair_free(send);
	}

	exit (result);
}
