/*
 * $Id: radlogin.c,v 1.10 1996/01/06 01:58:18 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

static char	rcsid[] =
		"$Id: radlogin.c,v 1.10 1996/01/06 01:58:18 lf Exp $";

static char	copyright_1[] =
		"$Copyright: (C) 1995 Lars Fenneberg $";

static char	copyright_2[] =
		"$Parts: (C) 1992 Livingston Enterprises, Inc. $";

static char	copyright_3[] =
		"$Parts: (C) 1992,1993, 1994,1995 The Regents of the \
University of Michigan and Merit Network, Inc. All Rights Reserved $";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/param.h>
#include	<netinet/in.h>
#include	<sys/time.h>
#include	<sys/signal.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<unistd.h>
#include	<pwd.h>
#include	<string.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<syslog.h>

#ifdef SHADOW_PASSWORD
#include <shadow.h>
#endif

#include	"radius.h"

void alarm_handler(int sn)
{
	rc_log(LOG_ERR,"\r\nlogin timed out after %d seconds. Bye.", conf_login_timeout);
	sleep(1);
	exit(1);	
}

int auth_radius(UINT4 client_port, char *username, char *passwd)
{

	VALUE_PAIR 	*send, *received, *vp;
	UINT4		service;
	char 		msg[4096], *p, username_realm[256];
	char            name[2048], value[2048]; /* more than enough */
	int 		result;

	send = NULL;

	/*
	 * Fill in User-Name
	 */

	 strncpy(username_realm, username, sizeof(username_realm));

	 /* Append default realm */
	 if ((strchr(username_realm, '@') == NULL) && conf_default_realm &&
	     (*conf_default_realm != '\0'))
	 {
		strncat(username_realm, "@", sizeof(username_realm));
		strncat(username_realm, conf_default_realm, sizeof(username_realm));
	 } 

	rc_avpair_add(&send, PW_USER_NAME, username_realm);
	
	/*
	 * Fill in User-Password
	 */
	 
	rc_avpair_add(&send, PW_USER_PASSWORD, passwd); 	  

	/*
	 * Fill in Service-Type
	 */
	
	service = PW_LOGIN;
	rc_avpair_add(&send, PW_SERVICE_TYPE, &service);
	
	result = rc_auth(client_port, send, &received, msg);
	
	if (result == OK_RC)
	{
		setenv("RADIUS_USER_NAME", username, 1);
	
		vp = received;
		while (vp)
		{
			strcpy(name, "RADIUS_");
			rc_avpair_tostr(vp, name+7, sizeof(name)-7, value, sizeof(value));
			
			/* Translate "-" => "_" and uppercase*/
			for(p = name; *p; p++) {
				*p = toupper(*p);
				if (*p == '-') *p = '_';
			}
			
			setenv(name, value, 1);
			
			vp = vp->next;
		}
		rc_log(LOG_NOTICE, "\"%s\" RADIUS authentication OK", username);
	}
	else
	{
		rc_log(LOG_NOTICE, "\"%s\" RADIUS authentication failed (RC=%i)", username, result);
	}
	
	return result;
}

int auth_local(char *username, char *passwd)
{
	struct passwd	*pw;
	char		*xpasswd;
#ifdef SHADOW_PASSWORD
	struct spwd	*spw;
#endif

	if ((pw = getpwnam(username)) == NULL) {
		endpwent();
		rc_log(LOG_NOTICE, "\"%s\" local authentication failed", username);
		return BADRESP_RC;
	}
	endpwent();
	
#ifdef SHADOW_PASSWORD
        if((spw = getspnam(pw->pw_name)) == NULL) {
		endspent();
		rc_log (LOG_NOTICE, "\"%s\" local authentication failed", username);
		return BADRESP_RC;
        }
        else 
        { 
        	pw->pw_passwd = spw->sp_pwdp; 
        }
        endspent();
#endif /* SHADOW_PASSWORD */

	xpasswd = crypt(passwd, pw->pw_passwd);
	
	if (*pw->pw_passwd == '\0' || strcmp(xpasswd, pw->pw_passwd)) {
		rc_log(LOG_NOTICE, "\"%s\" local authentication failed", username);
		return BADRESP_RC;		
	}

	rc_log(LOG_NOTICE, "\"%s\" local authentication OK", username);
	return OK_RC;
}

void
local_login(char *username)
{
	if (*username == '-') {
		rc_log(LOG_WARNING, "username can't start with a dash");
		exit(ERROR_RC);
	}
	execl(conf_login_local, conf_login_local, "-f", username, NULL);
	rc_log(LOG_ERR, "couldn't execute %s", conf_login_local);
	sleep(1);	/* give the user time to read */
	exit(ERROR_RC);
}

void
radius_login(char *username)
{
	execl(conf_login_radius, conf_login_radius, NULL);
	rc_log(LOG_ERR, "couldn't execute %s", conf_login_radius);
	sleep(1);	/* give the user time to read */
	exit(ERROR_RC);
}

void usage(char *program)
{
	fprintf(stderr,"Usage: %s [-i <client_port>]\n", program);
	fprintf(stderr,"  -i		ttyname to send to the server\n");
	fprintf(stderr,"  -V		output version information\n");
	fprintf(stderr,"  -h		output this text\n");     
        exit(ERROR_RC);
}

void version(char *program)
{
	fprintf(stderr,"%s: %s\n", program ,rcsid);
	exit(ERROR_RC);
}

int
main (int argc, char **argv)
{
	int             result;
	char		username[128];
	char            passwd[AUTH_PASS_LEN + 1];
	int 		tries, remaining, c;
	UINT4		client_port;

        extern char *optarg;
        extern int optind;

	if (rc_read_config(RADIUSCLIENT_CONF) != 0)
		exit(ERROR_RC);
	
	if (rc_read_dictionary(conf_dictionary) != 0)
		exit (ERROR_RC);

	if (rc_read_mapfile(conf_mapfile) != 0)
		exit (ERROR_RC);

	client_port = rc_map2id(ttyname(1));

	while ((c = getopt(argc,argv,"i:hV")) > 0)
	{
		switch(c) {
			case 'i':
				client_port = rc_map2id(optarg);
				break;
			case 'V':
				version(argv[0]);
				break;
			case 'h':
				usage(argv[0]);
				break;
			default:
				exit(ERROR_RC);
				break;
		}
	}
	
	if ((argc - optind) == 1)
	{
		strncpy(username,argv[optind], sizeof(username));
	}
	else
	{
		*username = '\0';
	}

	signal(SIGALRM, alarm_handler);

	remaining = conf_login_timeout;
	tries = 1;
	while (tries <= conf_login_tries)
	{
	 alarm(remaining);

	 while (!*username) {
	 		strncpy(username, rc_getstr ("login: ",1), sizeof(username));
	 }
	 strncpy (passwd, rc_getstr("Password: ",0), sizeof (passwd));		

	 remaining = alarm(0);

 	 if (conf_auth_type & AUTH_LOCAL_FST)
 	 {
 	 	result = auth_local(username, passwd);
 	 	if (result != OK_RC) {
 	 		if (conf_auth_type & AUTH_RADIUS_SND) {
 	 			result = auth_radius(client_port, username, passwd);
 	 			if (result == OK_RC) {
					memset(passwd, '\0', sizeof(passwd));
 	 				radius_login(username); /* never returns */
 	 			}
 	 		}
 	 	} else {
			memset(passwd, '\0', sizeof(passwd));
 	 		local_login(username); /* never returns */
 	 	}
 	 }
 	 else
 	 {
		result = auth_radius(client_port, username, passwd);
 	 	if (result != OK_RC) {
 	 		if (conf_auth_type & AUTH_LOCAL_SND) {
 	 			result = auth_local(username, passwd);
 	 			if (result == OK_RC)
 	 			{
 	 				memset(passwd, '\0', sizeof(passwd));
 	 				local_login(username); /* never returns */
 	 			}
 	 		}
 	 	} else {
 	 		memset(passwd, '\0', sizeof(passwd));
 	 		radius_login(username); /* never returns */
 	 	}
 	 }

	 *username = '\0';
	 
	 if ((++tries) <= conf_login_tries) {
		alarm(remaining);
	 	sleep(tries * 2);
	 	remaining = alarm(0);
	 }

	}

	rc_log(LOG_INFO, "maximum login tries exceeded. Go away!");
	sleep(1);
	
	exit (ERROR_RC);
}
