/*
 * $Id: radstatus.c,v 1.3 1996/01/06 01:58:18 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

static char	rcsid[] =
		"$Id: radstatus.c,v 1.3 1996/01/06 01:58:18 lf Exp $";

static char	copyright_1[] =
		"$Copyright: (C) 1995 Lars Fenneberg $";

static char	copyright_2[] =
		"$Parts: (C) 1992 Livingston Enterprises, Inc. $";

static char	copyright_3[] =
		"$Parts: (C) 1992,1993, 1994,1995 The Regents of the \
University of Michigan and Merit Network, Inc. All Rights Reserved $";

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<syslog.h>
#include	<unistd.h>
#include	<stdlib.h>

#include	"radius.h"

void usage(char *program)
{
	fprintf(stderr,"Usage: %s [-hV] [server]...\n\n", program);
        fprintf(stderr,"  -V            output version information\n");
        fprintf(stderr,"  -h            output this text\n");
	exit(ERROR_RC);
}

void version(char *program)
{
	fprintf(stderr,"%s: %s\n", program ,rcsid);
	exit(ERROR_RC);
}

void main (int argc, char **argv)
{
	int             result = ERROR_RC;
    	int		c,i;
    	char		*p;
        
        extern int optind;

	if (rc_read_config(RADIUSCLIENT_CONF) != 0)
		exit(ERROR_RC);
	
	if (rc_read_dictionary(conf_dictionary) != 0)
		exit (ERROR_RC);

	while ((c = getopt(argc,argv,"hV")) > 0)
	{
		switch(c) {
			case 'V':
				version(argv[0]);
				break;
			case 'h':
				usage(argv[0]);
				break;
			default:
				exit(ERROR_RC);
				break;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc > 0) {
		for (i = 0; i < argc; i++) {
			if ((p = strchr(argv[i], ':')) == NULL) {
				result = rc_check(argv[i],rc_getport(AUTH));
			} else if (!strcmp(p+1, "auth")) {
				*p = '\0';
				result = rc_check(argv[i],rc_getport(AUTH));
			} else if (!strcmp(p+1, "acct")) {
				*p = '\0';
				result = rc_check(argv[i],rc_getport(ACCT));
			} else {
				*p = '\0';
				result = rc_check(argv[i], atoi(p+1));
			}
		}
	} else {
		for(i=0; i<conf_numauth ; i++)
		{
			result = rc_check(conf_authserver[i],conf_authserver_port[i]);
		}
		for(i=0; i<conf_numacct ; i++)
		{
			result = rc_check(conf_authserver[i],conf_authserver_port[i]);
		}
	}
}
