#
# $Id: acct.sh,v 1.2 1996/01/07 03:14:30 lf Exp $
#

acct_start ()
{
	export SID=`mksid`
	export START_TIME=`mktime`
	
	(
		echo "Acct-Session-Id = \"$SID\""
		echo "User-Name = \"$RADIUS_USER_NAME\""
		echo "Acct-Status-Type = Start"
		echo "Acct-Authentic = RADIUS"
		echo "Service-Type = $RADIUS_SERVICE_TYPE"
		TYPE="`echo $RADIUS_SERVICE_TYPE | tr [A-Z] [a-z]`"
		if [ $TYPE = "framed" ]
		then
			echo "Framed-Protocol = $RADIUS_FRAMED_PROTOCOL"
			FTYPE="`echo $RADIUS_FRAMED_PROTOCOL | tr [A-Z] [a-z]`"
			if [ $FTYPE = "ppp" ]
			then
				export START_IOCTETS=`ppptraffic -r $INAME`
				export START_OOCTETS=`ppptraffic -s $INAME`
			fi
		fi
	) | radacct
}

acct_stop ()
{
	STOP_TIME=`mktime`

	(
		echo "Acct-Session-Id = \"$SID\""
		echo "User-Name = \"$RADIUS_USER_NAME\""
		echo "Acct-Status-Type = Stop"
		echo "Acct-Authentic = RADIUS"
		echo "Service-Type = $RADIUS_SERVICE_TYPE"
		TYPE="`echo $RADIUS_SERVICE_TYPE | tr [A-Z] [a-z]`"
		if [ $TYPE = "framed" ]
		then
			echo "Framed-Protocol = $RADIUS_FRAMED_PROTOCOL"
			FTYPE="`echo $RADIUS_FRAMED_PROTOCOL | tr [A-Z] [a-z]`"
			if [ $FTYPE = "ppp" ]
			then
				STOP_IOCTETS=`ppptraffic -r $INAME`
				STOP_OOCTETS=`ppptraffic -s $INAME`
				echo "Acct-Input-Octets = `expr $STOP_IOCTETS - $START_IOCTETS`"
				echo "Acct-Output-Octets = `expr $STOP_OOCTETS - $START_OOCTETS`"
			fi
		fi
		echo "Acct-Session-Time = `expr $STOP_TIME - $START_TIME`"
	) | radacct
}
