#
# $Id: rlogin.sh,v 1.1 1996/01/06 02:04:15 lf Exp $
#

remote_login ()
{
	# start accounting record
	acct_start

	# full path names are neccessary because they are also executed via
	# su and su might have other $PATH settings. add the options you need.

	TELNET="`type -path telnet` -e '' -l $RADIUS_USER_NAME"
	RLOGIN="`type -path rlogin` -E -l $RADIUS_USER_NAME"

	case "$RADIUS_LOGIN_IP_HOST" in
	 # default host
	 0.0.0.0)
		IPADDRESS=$DEFAULT_HOST
		;;
	 255.255.255.255)
		unset IPADDRESS
		while [ -z "$IPADDRESS" ]
		do
			echo -n "connect> "
			# FIXME: this is insecure... someone could pass options, etc.
			read IPADDRESS
		done
		;;
	 *)
		IPADDRESS=$RADIUS_LOGIN_IP_HOST		
		;;
	esac

	LTYPE="`echo $RADIUS_LOGIN_SERVICE | tr [A-Z] [a-z]`"
	case "$LTYPE" in
	 telnet)
		COMMAND="$TELNET \"$IPADDRESS $RADIUS_LOGIN_PORT\""
		;;

	 rlogin)
		COMMAND="$RLOGIN $IPADDRESS"
		;;
	esac

	if [ "$RADIUS_RUN_USER_ID" = "" ]
	then
		$COMMAND
	else
		su $RADIUS_RUN_USER_ID -c "exec  $COMMAND"
	fi

	# stop account record
	acct_stop
}
