#
# $Id: slip.sh,v 1.3 1996/01/07 03:14:30 lf Exp $
#

do_slip ()
{
	# start account record
	acct_start

	CTYPE="`echo $RADIUS_FRAMED_COMPRESSION | tr [A-Z] [a-z]`"
	case "$CTYPE" in
	 van_jacobson_tcp_ip)
		PROTO=cslip
		;;
	 none)
		PROTO=slip
		;;
	 # default on Portmasters is compressed slip
	 # if no Framed-Compression attribute is present
	 *)
		PROTO=cslip
		;;
	esac

	case "$RADIUS_FRAMED_IP_ADDRESS" in
	 # this is nonsense... slip can't negotiate addresses,
	 # so handle it like dynamic
	 255.255.255.255|255.255.255.254)
		R_IPADDRESS=`get_dynamic`
		R_NETMASK=$DYNAMIC_NETMASK
		;;
	 *)
		R_IPADDRESS=$RADIUS_FRAMED_IP_ADDRESS
		R_NETMASK=$RADIUS_FRAMED_IP_NETMASK
		;;
	esac

	# in case the RADIUS server didn't say us everything,
	# provide a default
	if [ "$RADIUS_FRAMED_MTU" = "" ]
	then
		export RADIUS_FRAMED_MTU=296
	fi

	echo "protocol $PROTO local $IPADDRESS remote $R_IPADDRESS"

	# switch to slip line discipline
	#
	# -h exit when carrier is lost
	# -l create lock file
	# -n equivalent: mesg n
	TTY=`tty` # directly doesnt work, who knows why?
	slattach -hln -p $PROTO $TTY & SLA_PID=$!
	sleep 2

	# configure interface, set up host route
	INAME=`getifname $TTY`; export INAME
	ifconfig $INAME $IPADDRESS \
		pointopoint $R_IPADDRESS \
		netmask $R_NETMASK \
		mtu $RADIUS_FRAMED_MTU up

	route add $R_IPADDRESS $INAME

	wait $SLA_PID

	# normally the kernel does this job, but just in case
	route del $R_IPADDRESS 2>/dev/null
	ifconfig $INAME down 2>/dev/null

	# stop accounting record
	acct_stop
}
