/*
 * $Id: radexample.c,v 1.3 1996/03/18 23:20:26 lf Exp $
 *
 * Copyright (C) 1995,1996 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */


static char	rcsid[] =
		"$Id: radexample.c,v 1.3 1996/03/18 23:20:26 lf Exp $";

static char	copyright_1[] =
		"$Copyright: (C) 1995,1996 Lars Fenneberg $";

#include	<sys/types.h>

#include	<syslog.h>
#include	<string.h>

#include	"../src/radius.h"
#include	"../src/pathnames.h"

int
main (int argc, char **argv)
{
	int             result;
	char		username[128];
	char            passwd[AUTH_PASS_LEN + 1];
	VALUE_PAIR 	*send, *received;
	UINT4		service;
	char 		msg[4096], username_realm[256];

	if (rc_read_config(_PATH_ETC_RADIUSCLIENT_CONF) != 0)
		exit(ERROR_RC);
	
	if (rc_read_dictionary(conf_dictionary) != 0)
		exit (ERROR_RC);

	strncpy(username, rc_getstr ("login: ",1), sizeof(username));
	strncpy (passwd, rc_getstr("Password: ",0), sizeof (passwd));		

	send = NULL;

	/*
	 * Fill in User-Name
	 */

	strncpy(username_realm, username, sizeof(username_realm));

	/* Append default realm */
	if ((strchr(username_realm, '@') == NULL) && conf_default_realm &&
	    (*conf_default_realm != '\0'))
	{
		strncat(username_realm, "@", sizeof(username_realm));
		strncat(username_realm, conf_default_realm, sizeof(username_realm));
	} 

	rc_avpair_add(&send, PW_USER_NAME, username_realm);
	
	/*
	 * Fill in User-Password
	 */
	 
	rc_avpair_add(&send, PW_USER_PASSWORD, passwd); 	  

	/*
	 * Fill in Service-Type
	 */
	
	service = PW_AUTHENTICATE_ONLY;
	rc_avpair_add(&send, PW_SERVICE_TYPE, &service);
	
	result = rc_auth(0, send, &received, msg);
	
	if (result == OK_RC)
	{
		rc_log(LOG_NOTICE, "\"%s\" RADIUS authentication OK", username);
	}
	else
	{
		rc_log(LOG_NOTICE, "\"%s\" RADIUS authentication failed (RC=%i)", username, result);
	}
	
	return result;
}
