/*
 * $Id: util.c,v 1.3 1996/03/18 23:20:19 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * Copyright 1992 Livingston Enterprises, Inc.
 *
 * Copyright 1992,1993, 1994,1995 The Regents of the University of Michigan 
 * and Merit Network, Inc. All Rights Reserved
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/termios.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <string.h>

#include "radius.h"

/*
 * Function: rc_str2tm
 *
 * Purpose: Turns printable string into correct tm struct entries.
 *
 */

static char * months[] =
		{
			"Jan", "Feb", "Mar", "Apr", "May", "Jun",
			"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
		};

void rc_str2tm (char *valstr, struct tm *tm)
{
	int             i;

	/* Get the month */
	for (i = 0; i < 12; i++)
	{
		if (strncmp (months[i], valstr, 3) == 0)
		{
			tm->tm_mon = i;
			i = 13;
		}
	}

	/* Get the Day */
	tm->tm_mday = atoi (&valstr[4]);

	/* Now the year */
	tm->tm_year = atoi (&valstr[7]) - 1900;
}

/*
 * Function: rc_mksid
 *
 * Purpose: generate a quite unique string
 *
 * Remarks: not that unique at all...
 *
 */

char *rc_mksid(void)
{
	static char buf[14];
	
	sprintf(buf, "%08lX%04X", (unsigned long int) time(NULL), (unsigned int) getpid());
	return buf;
}

/*
 * Function: rc_getifname
 *
 * Purpose: get the network interface name associated with this tty
 *
 */

char *rc_getifname(char *tty)
{
	static char 	name[512];
	int		fd;
	
	if ((fd = open(tty, O_RDWR|O_NDELAY)) < 0) {
		rc_log(LOG_ERR, "rc_getifname: can't open %s: %s", tty, strerror(errno));
		return NULL;
	}
	if (ioctl(fd, SIOCGIFNAME, name) < 0) {
		rc_log(LOG_ERR, "rc_getifname: can't ioctl %s: %s", tty, strerror(errno));
		return NULL;
	}
	close(fd);

	return name;
}

/*
 * Function: rc_getstr
 *
 * Purpose: Reads in a string from the user (with or witout echo)
 *
 */
 
char *rc_getstr (char *prompt, int do_echo)
{
	int             echo = 0;
	int             ch;
	char           *p;
	FILE           *infp;
	FILE           *outfp;
	sigset_t        newset;
	sigset_t        oldset;
	struct termios  term;
	static char     buf[GETSTR_LENGTH];

	infp = stdin;
	outfp = stderr;

	sigemptyset (&newset);
	sigaddset (&newset, SIGINT);
	sigaddset (&newset, SIGTSTP);
	sigaddset (&newset, SIGQUIT);

	sigprocmask (SIG_BLOCK, &newset, &oldset);

	(void) tcgetattr (fileno (infp), &term);
	if (!do_echo && (echo = (term.c_lflag & ECHO)))
	{
		term.c_lflag &= ~ECHO;
		(void) tcsetattr (fileno (infp), TCSAFLUSH, &term);
	}
	(void) fputs (prompt, outfp);
	rewind (outfp);			/* implied flush */

	for (p = buf ; ((ch = getc (infp)) != EOF) && (ch != '\n'); )
	{
		if (p < buf + AUTH_PASS_LEN)
		{
			*p++ = ch;
		}
	}
	*p = '\0';
	
	if (!do_echo) (void) write (fileno (outfp), "\n", 1);
	if (!do_echo && echo)
	{
		term.c_lflag |= ECHO;
		tcsetattr (fileno (infp), TCSAFLUSH, &term);
	}

	sigprocmask (SIG_SETMASK, &oldset, NULL);

	return (buf);
}
