/*
 * $Id: env.c,v 1.1 1996/03/15 13:53:04 lf Exp $
 *
 * Copyright (C) 1995,1996 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "radius.h"

/*
 * Function: rc_new_env
 *
 * Purpose: allocate space for a new environment
 *
 */
 
struct env *rc_new_env(int size)
{
	struct env *p;

	if (size < 1)
		return NULL;

	if ((p = malloc(sizeof(*p))) == NULL)
		return NULL;
		
	if ((p->env = malloc(size * sizeof(char *))) == NULL)
	{
		free(p);
		return NULL;
	} 

	p->env[0] = NULL;
	
	p->size = 0;
	p->maxsize = size;	
		
	return p;
}

/*
 * Function: rc_free_env
 *
 * Purpose: free the space used by an env structure
 *
 */
 
 void rc_free_env(struct env *env)
 {
	free(env->env);
	free(env); 
 }

/*
 * Function: rc_add_env
 *
 * Purpose: add an environment entry
 *
 */
 
int rc_add_env(struct env *env, char *name, char *value)
{
	int i;
	char *new_env;

	for (i = 0; env->env[i] != NULL; i++)
	{
		if (strncmp(env->env[i], name, MAX(strchr(env->env[i], '=') - env->env[i],strlen(name))) == 0)
			break;	
	}

	if (env->env[i])
	{
		if ((new_env = realloc(env->env[i], strlen(name)+strlen(value)+1)) == NULL)
			return (-1);

		env->env[i] = new_env;

		sprintf(env->env[i],"%s=%s", name, value);
	} else {
		if (env->size == (env->maxsize-1))
			return (-1);
	
		if ((env->env[env->size] = malloc(strlen(name)+strlen(value)+1)) == NULL)
			return (-1);
	
		sprintf(env->env[env->size],"%s=%s", name, value);
	
		env->size++;

		env->env[env->size] = NULL;
	}

	return 0;		
}

/*
 * Function: rc_import_env
 *
 * Purpose: imports an array of null-terminated strings
 *
 */
 
int rc_import_env(struct env *env, char **import)
{
	char *es;
	
	while (*import)
	{
		es = strchr(*import, '=');
		
		if (!es)
		{
			import++;
			continue;
		}
		
		/* ok, i grant thats not very clean... */
		*es = '\0';

		if (rc_add_env(env, *import, es+1) < 0)
		{
			*es = '=';
			return (-1);
		}
	
		*es = '=';
	
		import++;
	}
	
	return 0;
}
