/*
 * $Id: log.c,v 1.8 1996/05/05 00:13:07 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>

#include "config.h"
#include "radius.h"

/*
 * Function: rc_openlog
 *
 * Purpose: open log
 *
 * Arguments: identification string
 *
 * Returns: nothing
 *
 */

void rc_openlog(char *ident)
{
	openlog(ident, LOG_PID, SYSLOG_FACILITY);
}

/*
 * Function: rc_log
 *
 * Purpose: log information
 *
 * Arguments: priority (just like syslog), rest like printf
 *
 * Returns: nothing
 *
 */

void rc_log(int prio, const char *format, ...)
{
	char buff[1024];
	va_list ap;
                                    
	va_start(ap,format);
    vsnprintf(buff, sizeof(buff), format, ap);
    va_end(ap);
                                                            
	syslog(prio, "%s", buff);
}
