
sub register_config {
	my $name = shift;
	my $value = shift;

	print "register_config: $name = $value\n" if $debug;

	$conf_default_tab{$nane} = $value;
	undef $conf_tab{$name};
}

sub get_config {
	my $name = shift;
	my $value = $conf_tab{$name};

	if ($value) {
		return $value;
	} else {
		$value = $conf_default_tab{$name};
		warn "$name not specified in config file";
		warn "using default value: $value";
		return $value;
	}
}

sub read_config {
	my $file = shift;
	my $name, $value;

	open(CONF,"<$file") || die "couldn't open file $config_file: $!";

	while (<CONF>) {
		
		next if /^#/;

		chomp;

		/^([^\s]+)\s+"(.+)"$/;
		$name = $1; $value = $2;

		print "read_config: $name = $value\n" if $debug;

		$conf_tab{$name} = $value;
	}	
	
	close(CONF);
}

sub write_config {
	my $file = shift;

	die "config file $file already exists" if (-r $file);

	print "Writing configuration file $file...\n";
	print "You have to change it to suit your needs!\n";

	open(CONF,">$file") || die "couldn't open file $file: $!";
	
	foreach $name (sort (keys %conf_tab)) {
		printf CONF "%s\t\t\"%s\"\n", $name, $conf_tab{$name};
	}

	close(CONF);
}

1;
