/*
 * $Id$
 *
 * Copyright (C) 1996 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

#include <unistd.h>
#include <string.h>
#include <getopt.h>
#include <errno.h>
#include <syslog.h>
#include <stdio.h>

#include "config.h"
#include "radius.h"
#include "pathnames.h"

static char *pname = NULL;

void usage(void)
{
	exit(ERROR_RC);
}

void main(int argc, char **argv, char ** environ)
{
	char *port = NULL;
	char *p;
	int c;
	FILE *f;
	char sfile[PATH_MAX];

        extern char *optarg;
        extern int optind;

	pname = (pname = strrchr(argv[0],'/'))?pname+1:argv[0];

	while ((c = getopt(argc,argv,"i:")) > 0)
	{
		switch(c) {
	        	case 'i':
	               		port = optarg;
	               		break;
			default:
				exit(ERROR_RC);
				break;
		}
	}		

	if (!port)
		usage();

	argc -= optind;
	argv += optind;

	if ((p = strrchr(port,'/')) != NULL)
		port = p+1;

	sprintf(sfile, _PATH_RADCLIENT_STATUS, port);
	if ((f = fopen(sfile, "w")) == NULL) {
		rc_log(LOG_CRIT,"can't open %s: %s", sfile, strerror(errno));
		exit(ERROR_RC);
	}
		
	fprintf(f, "%s:%d:idle\n", port, getpid());
	
	fclose(f);
	
	execve(argv[0], &argv[0], environ);

	rc_log(LOG_CRIT, "can't execute %s: %s", argv[0], strerror(errno));
	exit(ERROR_RC);
}
