/*
 * $Id: radstatus.c,v 1.7 1996/05/05 00:13:21 lf Exp $
 *
 * Copyright (C) 1995,1996 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

static char	rcsid[] =
		"$Id: radstatus.c,v 1.7 1996/05/05 00:13:21 lf Exp $";

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<syslog.h>
#include	<unistd.h>
#include	<stdlib.h>

#include	"config.h"
#include	"radius.h"
#include	"pathnames.h"
#include	"messages.h"

static char *pname;

void usage(void)
{
	fprintf(stderr,"Usage: %s [-Vh] [server[:port]]...\n\n", pname);
	fprintf(stderr,"  -V            output version information\n");
	fprintf(stderr,"  -h            output this text\n");
	exit(ERROR_RC);
}

void version(void)
{
	fprintf(stderr,"%s: %s\n", pname ,rcsid);
	exit(ERROR_RC);
}

void main (int argc, char **argv)
{
	int		result = ERROR_RC;
   	int		c,i;
    char	*p, msg[4096];
    SERVER	*srv;
	
	extern int optind;

	pname = (pname = strrchr(argv[0],'/'))?pname+1:argv[0];

	rc_openlog(pname);

	if (rc_read_config(_PATH_RADIUSCLIENT_CONF) != 0)
		exit(ERROR_RC);
	
	if (rc_read_dictionary(rc_conf_str("dictionary")) != 0)
		exit (ERROR_RC);

	while ((c = getopt(argc,argv,"hV")) > 0)
	{
		switch(c) {
			case 'V':
				version();
				break;
			case 'h':
				usage();
				break;
			default:
				exit(ERROR_RC);
				break;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc > 0) {
		for (i = 0; i < argc; i++) {
			if ((p = strchr(argv[i], ':')) == NULL) {
				result = rc_check(argv[i],rc_getport(AUTH), msg);
			} else if (!strcmp(p+1, "auth")) {
				*p = '\0';
				result = rc_check(argv[i],rc_getport(AUTH), msg);
			} else if (!strcmp(p+1, "acct")) {
				*p = '\0';
				result = rc_check(argv[i],rc_getport(ACCT), msg);
			} else {
				*p = '\0';
				result = rc_check(argv[i], atoi(p+1), msg);
			}
			if (result == OK_RC)
				printf(msg);
			else
				printf(SC_STATUS_FAILED);
		}
	} else {
		srv = rc_conf_srv("authserver");
		for(i=0; i<srv->max ; i++)
		{
			result = rc_check(srv->name[i], srv->port[i], msg);
			printf(msg);
		}
		
		srv = rc_conf_srv("acctserver");
		for(i=0; i<srv->max ; i++)
		{
			result = rc_check(srv->name[i], srv->port[i], msg);
			printf(msg);
		}
	}
}
