/*
 * $Id: ppptraffic.c,v 1.4 1996/05/13 00:05:29 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

static	char rcsid[] = "$Id: ppptraffic.c,v 1.4 1996/05/13 00:05:29 lf Exp $";

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <syslog.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

#include "config.h"

#ifdef PPP_NEW
#include <net/ppp_defs.h>
#include <net/if_ppp.h>
#else
#include <linux/ppp.h>
#endif

#include "radius.h"

static char *pname;

void usage(void)
{
	fprintf(stderr,"Usage: %s [-Vhsr] <interface>\n", pname);
	fprintf(stderr,"  -r		output bytes received through this interface\n");
	fprintf(stderr,"  -s		output bytes sent through this interface\n");
	fprintf(stderr,"  -V		output version information\n");
	fprintf(stderr,"  -h		output this text\n");     
        exit(ERROR_RC);
}

void version(void)
{
	fprintf(stderr,"%s: %s\n", pname ,rcsid);
	exit(ERROR_RC);
}

int
main (int argc, char ** argv)
{
	int sk;
	int flag_r, flag_s, c;
	unsigned long received, sent;
	char ifacename[16];
	
	extern char *optarg;
        extern int optind;

	pname = (pname = strrchr(argv[0],'/'))?pname+1:argv[0];

	flag_r = flag_s = 0;

	while ((c = getopt(argc,argv,"rshV")) > 0)
	{
		switch(c) {
			case 'r':
				flag_r++;
				break;
			case 's':
				flag_s++;
				break;
			case 'V':
				version();
				break;
			case 'h':
				usage();
				break;
			default:
				return(ERROR_RC);
				break;
		}
	}

	if ((flag_r || !flag_s) && (!flag_r || flag_s))
	{
		fprintf(stderr, "%s: either -s or -r flag has to be specified\n", pname);
		return(ERROR_RC);
	}
	
	if ((argc - optind) == 1)
	{
		if (strncmp(argv[optind], "ppp", 3)) {
			fprintf(stderr, "%s: illegal interface name: %s\n", pname, argv[optind]);
			return(ERROR_RC);
		}
		strncpy(ifacename,argv[optind], sizeof(ifacename));
	}
	else
	{
		usage();
	}


	if ((sk = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
   	{
   		fprintf(stderr, "socket: %s\n", strerror(errno));
   		return (ERROR_RC);
   	}

#ifdef PPP_NEW
   	{
		struct ifpppstatsreq req;

   		memset (&req, 0, sizeof (req));
   		strcpy (req.ifr__name, ifacename);
   		req.stats_ptr = (caddr_t) &req.stats;

   		if (ioctl (sk, SIOCGPPPSTATS, &req) < 0)
   		{
        		switch (errno) {
        			case ENOTTY:
                 			fprintf(stderr, "%s: ppp (>2.2) kernel support missing\n", pname);
					return (ERROR_RC);
                                	break;
				case ENODEV:
					memset(&req.stats, 0, sizeof(req.stats));
					break;
				default:
					fprintf(stderr, "%s: ioctl(SIOCGPPPSTATS): %s\n", pname, strerror(errno));
					return (ERROR_RC);
			}
                                                                                                                                                                        
   		}

		received = req.stats.p.ppp_ibytes;
		sent = req.stats.p.ppp_obytes;
   	}
#else
   	{
		struct pppstats
		{
			struct ppp_stats  stats;
  			char	 slcomp[64];		/* sizeof(struct slcompress slcomp) */
		};

   		struct pppstats pppinfo;
   		struct ifreq req;

   		memset (&req, 0, sizeof (req));
   		strcpy (req.ifr_ifrn.ifrn_name, ifacename);
   		req.ifr_ifru.ifru_data = &pppinfo;

   		if (ioctl (sk, SIOCDEVPRIVATE, &req) < 0)
   		{
			fprintf(stderr, "%s: ioctl(SIOCDEVPRIVATE): %s\n", pname, strerror(errno));
			return (ERROR_RC);
   		}

		received = pppinfo.stats.rbytes;
		sent = pppinfo.stats.sbytes; 

   	}
#endif

	if (flag_r) printf("%ld", received);
	if (flag_s) printf("%ld", sent);

   	close(sk);
   	return (OK_RC);
}
