/*
 * $Id: config.h,v 1.2 1996/05/05 00:13:01 lf Exp $
 *
 * Copyright (C) 1996 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at in5y050@public.uni-hamburg.de 
 * and I'll send you a copy.
 *
 */

/*
 * define the position of the radiusclient config file 
 */

#define _PATH_RADIUSCLIENT_CONF	"/etc/radclient/radiusclient.conf"

/*
 * PATH setting for programs startet by radlogin
 */

#define PATH	"/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin"

/*
 * define PPP_NEW if you have pppd version >=2.2
 */

#define PPP_NEW

/*
 * define RADIUS_116 if you have an original Livingston radiusd v1.16,
 * it has a bug in accounting request digest calculation.
 * this define entirely disables the digest checking for _accounting_ (
 * not authentication) requests. this is a possible security breach but
 * not a very big one. you also loose the checksum function of the digest,
 * but this shouldn't be a problem if your RADIUS server has UDP checksums
 * enabled.
 */

#undef RADIUS_116

/*
 * define SCPO if you want radlogin to derive the service type from
 * the username (Susername is SLIP, Cusername is compressed slip,
 * Pusername is PPP, Ousername for outbound and Ausername is admin login) 
 * and supply it to the RADIUS server.
 */
 
#define SCP

/*
 * Linux (>=1.3.x) only: define this if you want to use /dev/urandom instead 
 * of the normal libc rand(3) function for the generation of the request
 * authenticator. This increases user password security.
 * For more information on this random number generator see drivers/char/random.c
 * in the Linux kernel source.
 * You can define this even if you don't have /dev/urandom, the code will
 * fall back to the old method.
 * If you don't have the neccessary /dev entries, create them with
 *	mknod /dev/random c 1 8
 *	mknod /dev/urandom c 1 9
 */
 
#define DEV_URANDOM

/*
 * to use shadow passwords define this
 * put -lshadow into LIBSHADOW in MCONFIG
 */
 
#define SHADOW_PASSWORD

/*
 * lockfile prefix path for outbound ports
 */

#define LOCK_PREFIX	"/var/lock/LCK.."

/*
 * syslog facility for all the radiuslclient programs
 */

#define SYSLOG_FACILITY	LOG_LOCAL0
