/*
 * exec.c	Execute external programs.
 *
 * Version:	@(#)exec.c  1.82  19-Dec-1998  miquels@cistron.nl
 *
 */
char exec_sccsid[] =
"@(#)exec.c	1.82 Copyright 1998 Cistron Internet Services B.V."; 

#include	<sys/types.h>
#include	<sys/time.h>
#include	<sys/file.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<fcntl.h>
#include	<time.h>
#include	<ctype.h>
#include	<unistd.h>
#include	<signal.h>
#include	<errno.h>
#include	<sys/wait.h>

#include	"radiusd.h"

#ifdef XTRADIUS
	#include	<netinet/in.h>
#endif
/*
 *	Replace %<whatever> in a string.
 *
 *	%p   Port number
 *	%n   NAS IP address
 *	%f   Framed IP address
 *	%u   User name
 *	%c   Callback-Number
 *	%t   MTU
 *	%a   Protocol (SLIP/PPP)
 *	%s   Speed (PW_CONNECT_INFO)
 *	%i   Calling Station ID
 *
 */
char *radius_xlate(char *str, VALUE_PAIR *request, VALUE_PAIR *reply)
{
	static char buf[2048];
	int n, i = 0, c;
	char *p;
	VALUE_PAIR *tmp;

#ifdef XTRADIUS
	DICT_VALUE	*dval;
	static char 	tmpstr[2048];
	int	k;
#endif
	for(p = str; *p; p++) {
		if (i >= AUTH_STRING_LEN)
			break;
		c = *p;
		if (c != '%' && c != '\\') {
			buf[i++] = *p;
			continue;
		}
		if (*++p == 0) break;
#ifdef XTRADIUS
		// Lookup Current Char
		for (k=0;paramchar[k] != '\0' && paramchar[k] != *p;k++) {}
		
		if (paramchar[k] == *p && c == '%') {
			// Do param substitution		
			tmp = NULL;			
			if ((tmp = pairfind(request,paramcode[k])) == NULL) {
				tmp = pairfind(reply,paramcode[k]);
			}
			
			if (tmp != NULL) {
				if (tmp->attribute != PW_PASSWORD) {
					switch (tmp->type) {
						case PW_TYPE_STRING:
							// Look for space in strings
							if (strchr(tmp->strvalue,' ') != NULL) {
								strcpy(tmpstr, "\"");
								strcat(tmpstr,tmp->strvalue);
								strcat(tmpstr,"\"");
							} else {
								strcpy(tmpstr, tmp->strvalue);
							}
     							strcpy(buf + i, tmpstr);
							i += strlen(buf + i);
							break;
						case PW_TYPE_INTEGER:
							dval = dict_valget(tmp->lvalue, tmp->name);
							if(dval != (DICT_VALUE *)NULL) {
								sprintf(buf + i, "%s", dval->name);
								i += strlen(buf + i);
							} else {
								sprintf(buf + i, "%d", (n = tmp->lvalue));
								i += strlen(buf + i);
							}
	//						sprintf(buf + i, "%d", (n = tmp->lvalue));
	//						i += strlen(buf + i);
							break;
						case PW_TYPE_IPADDR:
							ipaddr2str(buf + i, tmp->lvalue);
							i += strlen(buf + i);
							break;
					}
				}
			} else {
#if 0 // DEBUG INFO
				log(L_DBG,"Xtradius: Don't have param value for %c",*p);
#endif
				strcpy(buf + i, "unknown");
				i += strlen(buf + i);
			}
		} else {
			log(L_ERR,"Xtradius: Undefined exec param %c in execparams",*p);
			buf[i++] = '%';
			buf[i++] = *p;
		}
#else
		if (c == '%') switch(*p) {
			case '%':
				buf[i++] = *p;
				break;
			case 'f': /* Framed IP address */
				n = 0;
				if ((tmp = pairfind(reply,
				     PW_FRAMED_IP_ADDRESS)) != NULL) {
					n = tmp->lvalue;
				}
				ipaddr2str(buf + i, n);
				i += strlen(buf + i);
				break;
			case 'n': /* NAS IP address */
				n = 0;
				if ((tmp = pairfind(request,
				     PW_NAS_IP_ADDRESS)) != NULL) {
					n = tmp->lvalue;
				}
				ipaddr2str(buf + i, n);
				i += strlen(buf + i);
				break;
			case 't': /* MTU */
				n = 0;
				if ((tmp = pairfind(reply,
				     PW_FRAMED_MTU)) != NULL) {
					n = tmp->lvalue;
				}
				sprintf(buf + i, "%d", n);
				i += strlen(buf + i);
				break;
			case 'p': /* Port number */
				n = 0;
				if ((tmp = pairfind(request,
				     PW_NAS_PORT_ID)) != NULL) {
					n = tmp->lvalue;
				}
				sprintf(buf + i, "%d", n);
				i += strlen(buf + i);
				break;
			case 'u': /* User name */
				if ((tmp = pairfind(request,
				     PW_USER_NAME)) != NULL)
					strcpy(buf + i, tmp->strvalue);
				else
					strcpy(buf + i, "unknown");
				i += strlen(buf + i);
				break;
			case 'i': /* Calling station ID */
				if ((tmp = pairfind(request,
				     PW_CALLING_STATION_ID)) != NULL)
					strcpy(buf + i, tmp->strvalue);
				else
					strcpy(buf + i, "unknown");
				i += strlen(buf + i);
				break;
			case 'c': /* Callback-Number */
				if ((tmp = pairfind(reply,
				     PW_CALLBACK_NUMBER)) != NULL)
					strcpy(buf + i, tmp->strvalue);
				else
					strcpy(buf + i, "unknown");
				i += strlen(buf + i);
				break;
			case 'a': /* Protocol: SLIP/PPP */
				if ((tmp = pairfind(reply,
				     PW_FRAMED_PROTOCOL)) != NULL)
		strcpy(buf + i, tmp->lvalue == PW_PPP ? "PPP" : "SLIP");
				else
					strcpy(buf + i, "unknown");
				i += strlen(buf + i);
				break;
			case 's': /* Speed */
				if ((tmp = pairfind(request,
				     PW_CONNECT_INFO)) != NULL)
					strcpy(buf + i, tmp->strvalue);
				else
					strcpy(buf + i, "unknown");
				i += strlen(buf + i);
				break;
			default:
				buf[i++] = '%';
				buf[i++] = *p;
				break;
		}
#endif
		if (c == '\\') switch(*p) {
			case 'n':
				buf[i++] = '\n';
				break;
			case 'r':
				buf[i++] = '\r';
				break;
			case 't':
				buf[i++] = '\t';
				break;
			default:
				buf[i++] = '\\';
				buf[i++] = *p;
				break;
		}
	}
	if (i >= AUTH_STRING_LEN)
		i = AUTH_STRING_LEN - 1;
	buf[i++] = 0;

	return buf;
}

/*
 *	Execute a program on successful authentication.
 *	Return 0 if exec_wait == 0.
 *	Return the exit code of the called program if exec_wait != 0.
 *
 */
int radius_exec_program(char *cmd, VALUE_PAIR *request, VALUE_PAIR **reply,
		int exec_wait, char **user_msg)
{
	VALUE_PAIR	*vp;
	static char	message[4096];
	char		answer[4096];
	char		*argv[32];
	char		*buf, *p;
	int		pd[2];
	pid_t		pid;
	int		argc = -1;
	int		comma = 0;
	int		status;
	int		n, left, done;
	void		(*oldsig)(int) = NULL;
#ifdef XTRADIUS
	char		p2[4096];
	char		*envp[4096];
	int		envlen;
#endif
	

	/*
	 *	(hs)	- Open a pipe for child/parent communication.
	 *		- Reset the signal handler for SIGCHLD, so
	 *		  we have a chance to notice the dead child here and
	 *  		  not in some signal handler.
	 *		  This has to be done for the exec_wait case only, since
	 *		  if we don't wait we aren't interested in any
	 *		  gone children ...
	 */	
	if (exec_wait) {
		if (pipe(pd) != 0) {
			log(L_ERR|L_CONS, "Couldn't open pipe: %m");
			pd[0] = pd[1] = 0;
		}
		if ((oldsig = signal(SIGCHLD, SIG_DFL)) == SIG_ERR) {
			log(L_ERR|L_CONS, "Can't reset SIGCHLD: %m");
			oldsig = NULL;
		}
	}

	if ((pid = fork()) == 0) {
		/*	
		 *	Child
		 */
		buf = radius_xlate(cmd, request, *reply);

		/*
		 *	XXX FIXME: This is debugging info.
		 */
// Removed as cistron 1.6.4  #ifndef XTRADIUS
		log(L_INFO, "Exec-Program: %s", buf);
// Removed as cistron 1.6.4 #endif

		/*
		 *	Build vector list and execute.
		 */
		p = strtok(buf, " \t");
		if (p) do {
#ifdef XTRADIUS
			while (p[0] == '"') {
				strcpy(p2,p);
				strcat(p2," ");
				p = strtok(NULL, " \t");
				strcat(p2,p);
				p = strdup(p2);
				if (strrchr(p+1, '"') != NULL) break;
			};
#endif
			argv[++argc] = p;
			p = strtok(NULL, " \t");
		} while(p != NULL);
		argv[++argc] = p;
		if (argc == 0) {
			log(L_ERR, "Exec-Program: empty command line.");
			exit(1);
		}

		if (exec_wait) {
			if (close(pd[0]) != 0)
				log(L_ERR|L_CONS, "Can't close pipe: %m");
			if (dup2(pd[1], 1) != 1)
				log(L_ERR|L_CONS, "Can't dup stdout: %m");
		}

		for(n = 32; n >= 3; n--)
			close(n);

#ifdef XTRADIUS
		envlen = radius_env(request,*reply, envp);
		execve(argv[0], argv, envp);
//		free(envp);
#else
		execvp(argv[0], argv);
#endif

		log(L_ERR, "Exec-Program: %s: %m", argv[0]);
		exit(1);
	}

	/*
	 *	Parent 
	 */
	if (pid < 0) {
		log(L_ERR|L_CONS, "Couldn't fork: %m");
		return -1;
	}
	if (!exec_wait) {
		return 0;
	}

	/*
	 *	(hs) Do we have a pipe?
	 *	--> Close the write side of the pipe 
	 *	--> Read from it.
	 */
	done = 0;
	if (pd[0] || pd[1]) {
		if (close(pd[1]) != 0)
			log(L_ERR|L_CONS, "Can't close pipe: %m");

		/*
		 *	(hs) Read until we doesn't get any more
		 *	or until the message is full.
		 */
		done = 0;
		left = sizeof(answer) - 1;
		while ((n = read(pd[0], answer + done, left)) > 0) {
			done += n;
			left -= n;
			if (left <= 0) break;
		}
		answer[done] = 0;

		/*
		 *	(hs) Make sure that the writer can't block
		 *	while writing in a pipe that isn't read anymore.
		 */
		close(pd[0]);
	}

	/*
	 *	Parse the output, if any.
	 */
	if (done) {
		/*
		 *	For backwards compatibility, first check
		 *	for plain text (user_msg).
		 */
		vp = NULL;
		n = userparse(answer, &vp);
		if (vp) pairfree(vp);
		vp = NULL;

		if (n != 0) {
			log(L_DBG, "Exec-Program-Wait: plaintext: %s", answer);
			if (user_msg) {
				strncpy(message, answer, sizeof(message));
				message[sizeof(message) - 1] = 0;
				*user_msg = message;
			}
		} else {
			/*
			 *	HACK: Replace '\n' with ',' so that
			 *	userparse() can parse the buffer in
			 *	one go (the proper way would be to
			 *	fix userparse(), but oh well).
			 */
			for (p = answer; *p; p++) {
				if (*p == '\r') *(p++) = ' ';

				if (*p == '\n') {
					*p = comma ? ' ' : ',';
					p++;
					comma = 0;
				}
				if (*p == ',') comma++;
				
				if (*p == '=') comma = 0;
			}

			/*
			 *  Replace any trailing comma by a NUL.
			 */
 			if (answer[strlen(answer) - 1] == ',')
 				answer[strlen(answer) - 1] = '\0';

			log(L_DBG,"Exec-Program-Wait: value-pairs: %s", answer);
			if (userparse(answer, &vp) != 0)
				log(L_ERR,
		"Exec-Program-Wait: %s: unparsable reply", cmd);
			else {
				pairmove(reply, &vp);
				pairfree(vp);
			}
		}
	}

	while(waitpid(pid, &status, 0) != pid)
		/* do nothing */;

	/*
	 *	(hs) Now we let our cleanup_sig handler take care for
	 *	all signals that will arise.
	 */
	if (oldsig && (signal(SIGCHLD, oldsig) == SIG_ERR))
		log(L_ERR|L_CONS,
			"Can't set SIGCHLD to the cleanup handler: %m");
	sig_cleanup(SIGCHLD);

	if (WIFEXITED(status)) {
		status = WEXITSTATUS(status);
// Removed as cistron 1.6.4  #ifndef XTRADIUS
		log(L_INFO, "Exec-Program: returned: %d", status);
// Removed as cistron 1.6.4  #endif
		return status;
	}
	log(L_ERR|L_CONS, "Exec-Program: Abnormal child exit (killed or coredump)");

	return 1;
}

#ifdef XTRADIUS
/*
 *	Replace char in a string with the user password.
 *
 */
 char *set_user_password(char *str, char *pass)
{
	static char buf[2048];
	int i = 0, c;
	char *p;
	char pwdchar;
	
	for(c=0;paramchar[c]!='\0';c++) {
		if (paramcode[c] == PW_PASSWORD) {
			pwdchar = paramchar[c];
		}
	}

	for(p = str; *p; p++) {
		c = *p;
		if (c != '%' && c != '\\') {
			buf[i++] = *p;
			continue;
		}
		if (*++p == 0) break;
		if (c == '%') switch(*p) {
			case '%':
				buf[i++] = *p;
				break;
			default:
				if (*p == pwdchar) {
					strcpy(buf + i, pass);
					i += strlen(buf + i);
				} else {
					buf[i++] = '%';
					buf[i++] = *p;
				}
				break;
		}
		if (c == '\\') switch(*p) {
			case 'n':
				buf[i++] = '\n';
				break;
			case 'r':
				buf[i++] = '\r';
				break;
			case 't':
				buf[i++] = '\t';
				break;
			default:
				buf[i++] = '\\';
				buf[i++] = *p;
				break;
		}
	}
	buf[i++] = 0;

	return buf;
}

/*
 *	Replace %k in a string with the ID.
 *
 */
 char *set_session_id(char *str, int id)
{
	static char buf[2048];
	int i = 0, c;
	char *p;

	for(p = str; *p; p++) {
		c = *p;
		if (c != '%' && c != '\\') {
			buf[i++] = *p;
			continue;
		}
		if (*++p == 0) break;
		if (c == '%') switch(*p) {
			case '%':
				buf[i++] = *p;
				break;
			case 'k': /* Session id */
				sprintf(buf + i, "%d", id);
				i += strlen(buf + i);
				break;
			default:
				buf[i++] = '%';
				buf[i++] = *p;
				break;
		}
		if (c == '\\') switch(*p) {
			case 'n':
				buf[i++] = '\n';
				break;
			case 'r':
				buf[i++] = '\r';
				break;
			case 't':
				buf[i++] = '\t';
				break;
			default:
				buf[i++] = '\\';
				buf[i++] = *p;
				break;
		}
	}
	buf[i++] = 0;

	return buf;
}

/*
 *	Replace %x in a string with the Detail file path.
 *
 */
char *set_detail_log(char *str, char *logfilename)
{
	static char buf[2048];
	int i = 0, c;
	char *p;

	for(p = str; *p; p++) {
		c = *p;
		if (c != '%' && c != '\\') {
			buf[i++] = *p;
			continue;
		}
		if (*++p == 0) break;
		if (c == '%') switch(*p) {
			case '%':
				buf[i++] = *p;
				break;
			case 'x': /* detail File */
				strcpy(buf + i, logfilename);
				i += strlen(buf + i);
				break;
			default:
				buf[i++] = '%';
				buf[i++] = *p;
				break;
		}
		if (c == '\\') switch(*p) {
			case 'n':
				buf[i++] = '\n';
				break;
			case 'r':
				buf[i++] = '\r';
				break;
			case 't':
				buf[i++] = '\t';
				break;
			default:
				buf[i++] = '\\';
				buf[i++] = *p;
				break;
		}
	}
	buf[i++] = 0;

	return buf;
}

int radius_env(VALUE_PAIR *request, VALUE_PAIR *reply, char *envp[])
{
	char 		buf[4096];
	char 		tmpstr[4096];
	DICT_VALUE	*dict_valget();
	DICT_VALUE	*dval;
	char		buffer[32];
	int		ii;
	int		envlen;


	envlen = 0;
	strcpy(buf,"");
	while(request) {
		switch(request->type) {
		  	case PW_TYPE_STRING:
				sprintf(buf,"%s=%s",request->name, request->strvalue);
				// For CHAP-xxx binary data we need to pack it in hex
				if ((request->attribute == PW_CHAP_PASSWORD) ||
				    (request->attribute == PW_CHAP_CHALLENGE)) {
					for (ii=0; ii < request->length; ii++)
						sprintf(tmpstr+ii*2, "%02X", (unsigned char)request->strvalue[ii]);
					tmpstr[request->length*2] = '\0';
					sprintf(buf, "%s=%s", request->name, tmpstr);
				}
				break;
		  	case PW_TYPE_INTEGER:
		  		dval = dict_valget(request->lvalue, request->name);
		  		if(dval != (DICT_VALUE *)NULL) {
		  			sprintf(buf, "%s=%s", request->name, dval->name);
		  		}
		  		else {
		  			sprintf(buf, "%s=%ld", request->name, (long)request->lvalue);
		  		}
		  		break;
	
  			case PW_TYPE_IPADDR:
		  		ipaddr2str(buffer, request->lvalue);
		  		sprintf(buf, "%s=%s", request->name, buffer);
		  		break;

		  	case PW_TYPE_DATE:
		  		strftime(buffer, sizeof(buffer), "%b %e %Y",
		  			localtime((time_t *)&request->lvalue));
  				sprintf(buf, "%s=\"%s\"", request->name, buffer);
		  		break;

		  	default:
		  		sprintf(buf, "Unknown type %d", request->type);
		  		break;
		  	}
  		envp[envlen] = strdup(buf);
		request = request->next;
		envlen++;
	}
	sprintf(buf, "PATH=%s",getenv("PATH"));
	envp[envlen] = strdup(buf);
	envlen++;
	envp[envlen] = 0;
	return envlen;
}
#endif
