/****************************************************************************
accounting.c 

All are free to use, redistribute, and modify the code.
It is meant to work as a plugin with Xtradius v.1 beta rel.

--
Ahmad S. Al-rasheedan Kuwait, Feb. 2000 (alrasheedan@yahoo.com)
****************************************************************************/

#include<stdio.h>
#include<mysql.h>
#include "conf.h"

char *construct_SQL();

typedef struct {
char *login; /* login name */
char *AST;   /* time user stayed online */
char *FIA;   /* Framed IP address */
char *AIP;   /* input packets */
char *AOP;   /* output packets */
} D_REC;

main(int argc, char *argv[])
{
MYSQL mysql;
D_REC myrecord; 

char *SQL;
int rc;

/* initialise structure */

if ( argc == 2)
	myrecord.login = argv[1];
		else
			{
			myrecord.login = argv[1];
			myrecord.AST   = argv[2];
			myrecord.FIA   = argv[3];
			myrecord.AIP   = argv[4];
			myrecord.AOP   = argv[5]; 
			}

/* can we initiate a mysql connection  */

mysql_init(&mysql);
if (!mysql_real_connect(&mysql,MY_HOST,USER,USER_PASSWD,DATABASE,0,NULL,0))
{
    fprintf(stderr, "Failed to connect to database: Error: %s\n",
          mysql_error(&mysql));
}


/* 

is the user coming in or terminating his connection?
based on the way accounting was called (i.e number of arguments,
the SQL will be constructed and construct_SQL() will
return the correct SQL statement to be executed by MySQL

*/

		if ( argc == 2)
	             SQL = (char *) strdup(construct_SQL(myrecord, START));
		else
	             SQL = (char *) strdup(construct_SQL(myrecord, STOP));



/* insert record in accounting database  */

rc = mysql_query(&mysql, SQL );
 if (rc)
  {
   fprintf(stderr, "Failed to execute SQL command: Error: %s\n", 
    mysql_error(&mysql));
     mysql_close(&mysql);
      exit(1);
       }

/* free SQL */

free(SQL);

/* close SQL link */

mysql_close(&mysql);
}

/*

The following will construct an SQL statement based on the value
of action (START or STOP) and return a string SQL command.

*/

char *construct_SQL(D_REC local_record, int action)
{
char *LOCAL_SQL;
int TIME=1;

if ( action == START )  /* user is logging in */
	{
		LOCAL_SQL = (char *) malloc((strlen(SQL_IN) + 
	 	  strlen(local_record.login))*sizeof(char));
                  if (!LOCAL_SQL)
                          {
                            fprintf( stderr, "Faild to allocate memory\n");
                              exit(1);
                               }
		    sprintf(LOCAL_SQL, SQL_IN, local_record.login); 
		    }

		else   /* he must be logging out */
		{
		LOCAL_SQL = (char *) malloc((strlen(SQL_OUT) +
		  strlen(local_record.AST) + strlen(local_record.FIA) +
	            strlen(local_record.AIP) + 
                      strlen(local_record.AOP))*sizeof(char));
                       if (!LOCAL_SQL)
                              {
                               fprintf( stderr, "Faild to allocate memory\n");
                                 exit(1);
                                 }
		sprintf(LOCAL_SQL, SQL_OUT,
                  local_record.login, local_record.AST, local_record.FIA, 
		    local_record.AIP, local_record.AOP);
		    }
return LOCAL_SQL;
}

