#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <sys/ioctl.h>

/*
 * read the password in from the user, returns NULL on an error, based upon
 * sample code in the excellent book "Building Secure Software" by John Viega
 * and Gary McGraw
 */
char *read_pass(char *prompt)
{
  char *buf = (char *)malloc(sizeof(char) * 4096);
  char *res;
  int n;
  int fn = fileno(stdin);
  struct termio t;

  if (!buf)
  {
    fprintf(stderr, "Out of memory.\n");
    return(NULL);
  }

  fprintf(stdout, "%s", prompt);
  fflush(stdout);

  /* don't echo the keystrokes to the screen */
  if(!ioctl(fn, TCGETA, &t))
  {
    t.c_lflag &= ~ECHO;
    ioctl(fn, TCSETA, &t);
  }

  res = fgets(buf, 4096, stdin);
  if(!res)
  {
    fprintf(stderr, "Error in input.\n");
    return(NULL);
  }
  n = strlen(res);
  while(buf[n-1] != '\n')
  {
    buf = (char *)realloc(buf, n + 4096);
    if(!buf)
    {
      fprintf(stderr,"Out of memory.\n");
      return(NULL);
    }
    res = fgets(buf+n, 4096, stdin);
    if(!res)
    {
      fprintf(stderr, "Error in input.\n");
      return(NULL); 
    }
    n += strlen(res);
  }
  buf[n-1] = 0;
  if(!ioctl(fn, TCGETA, &t))
  {
    t.c_lflag |= ECHO;
    ioctl(fn, TCSETA, &t);
  }
  fprintf(stdout,"\n");
  return buf;
}

