/*
  File autogenerated by gengetopt version 2.8
  generated with the following command:
  gengetopt --unamed-opts --input=cmdline.ggo 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/*
 * Modified by SN 22Apr2003
 *
 * 03Aug2003 - Changed embarassing typo in help screen that was found
 *             mid-presentation at DefCon 11. Ugh.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void cmdline_parser_print_version (void)
{
	printf ("%s %s\n", PACKAGE, VERSION);
}

void cmdline_parser_print_help (void)
{
	cmdline_parser_print_version ();
	printf("Usage:\n"
  "  ncrypt <options> [ops] <-i in_file> <-o out_file> <wipe-only files>\n"
  "  Options include the following:\n"
  "    -h  --help          This help cruft\n"
  "    -V  --version       Print version and exit\n"
  "    -v  --verbose       Verbose mode\n"
  "    -a  --aes           Use AES when encrypting/decrypting (same as rijndael)\n"
  "    -r  --rijndael      Use rijndael when encrypting/decrypting (default)\n"
  "    -s  --serpent       Use serpent when encrypting/decrypting\n"
  "    -t  --twofish       Use twofish when encrypting/decrypting\n"
  "    -z  --encrypt-wipe  Wipe input file after encrypting\n"
  "  Ops include the following:\n"
  "    -e  --encrypt       Encryption mode\n"
  "    -d  --decrypt       Decryption mode\n"
  "    -g  --wipe-gutmann  Wipe using Gutmann mode\n"
  "    -m  --wipe-military Wipe using DoD 5220.22-M (military grade) mode\n"
  "  Examples: (more in man page)\n"
  "  ncrypt -e -m --serpent -i plaintext.txt -o ciphertext.enc\n"
  "   (encrypts plaintext.txt with serpent to ciphertext.enc, wipes plaintext.txt)\n"
  "  ncrypt -g log1.txt log2.txt\n"
  "    (wipes log files securely in current directory)\n");
}


#ifndef HAVE_STRDUP
/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *gengetopt_strdup (const char *s)
{
	char *result = (char*)malloc(strlen(s) + 1);
	if (result == (char*)0)
		return (char*)0;
	strcpy(result, s);
	return result;
}
#endif /* HAVE_STRDUP */

int cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
	int c;	/* Character of the parsed option.  */
	int missing_required_options = 0;
	int Algorithm_group_counter = 0;
	int Operation_group_counter = 0;  
	int wiping = 0;

	args_info->help_given = 0;
	args_info->version_given = 0;
	args_info->input_given = 0;
	args_info->output_given = 0;
	args_info->verbose_given = 0;
	args_info->encrypt_given = 0;
	args_info->decrypt_given = 0;
	args_info->wipe_given_gutmann = 0;
	args_info->wipe_given_military = 0;
	args_info->wipe_on_encrypt = 0;
	args_info->aes_given = 0;
	args_info->rijndael_given = 0;
	args_info->serpent_given = 0;
	args_info->twofish_given = 0;
	
#define clear_args() { args_info->input_arg = NULL; args_info->output_arg = NULL;}
	clear_args();

	args_info->inputs = NULL;
	args_info->inputs_num = 0;

	optarg = 0;
	optind = 1;
	opterr = 1;
	optopt = '?';

	while (1)
	{
		int option_index = 0;
		char *stop_char;
		static struct option long_options[] = {
			{ "help",	0, NULL, 'h' },
			{ "version",	0, NULL, 'V' },
			{ "input",	1, NULL, 'i' },
			{ "output",	1, NULL, 'o' },
			{ "wipe-gutmann",	0, NULL, 'g' },
			{ "verbose",	0, NULL, 'v' },
			{ "encrypt",	0, NULL, 'e' },
			{ "decrypt",	0, NULL, 'd' },
			{ "wipe-military",	0, NULL, 'm' },
			{ "aes",	0, NULL, 'a' },
			{ "rijndael",	0, NULL, 'r' },
			{ "serpent",	0, NULL, 's' },
			{ "twofish",	0, NULL, 't' },
			{ "encrypt-wipe",	0, NULL, 'z' },
			{ NULL,	0, NULL, 0 }
		};
		
		c = getopt_long (argc, argv, "hVi:o:gvedmarstz", long_options, &option_index);

		if (c == -1) break;	/* Exit from `while (1)' loop.  */

		switch (c)
		{
			case 'h':	/* Print help and exit.  */
				clear_args ();
				cmdline_parser_print_help ();
				exit (EXIT_SUCCESS);
			case 'V':	/* Print version and exit.  */
				clear_args ();
				cmdline_parser_print_version ();
				exit (EXIT_SUCCESS);
			case 'i':	/* Read from filename */
				if (args_info->input_given)
				{
					fprintf (stderr, "%s: `--input' (`-i') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->input_given = 1;
				args_info->input_arg = strdup (optarg);
				break;
			case 'o':	/* Write to filename */
				if (args_info->output_given)
				{
					fprintf (stderr, "%s: `--output' (`-o') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->output_given = 1;
				args_info->output_arg = strdup (optarg);
				break;
			case 'g':	/* Wipe file during encryption.  */
				if (args_info->wipe_given_gutmann)
				{
					fprintf (stderr, "%s: `--wipe-gutmann' (`-g') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->wipe_given_gutmann = 1;
				Operation_group_counter += 1;
				wiping++;
				break;
			case 'v':	/* Verbose mode.  */
				if (args_info->verbose_given)
				{
					fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->verbose_given = 1;
				break;
			case 'e':	/* Encrypt files.  */
				if (args_info->encrypt_given)
				{
					fprintf (stderr, "%s: `--encrypt' (`-e') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->encrypt_given = 1;
				Operation_group_counter += 1;
				break;
			case 'd':	/* Decrypt files.  */
				if (args_info->decrypt_given)
				{
					fprintf (stderr, "%s: `--decrypt' (`-d') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->decrypt_given = 1;
				Operation_group_counter += 1;
				break;
			case 'm':	/* Wipe files.  */
				if (args_info->wipe_given_military)
				{
					fprintf (stderr, "%s: `--wipe-military' (`-m') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->wipe_given_military = 1;
				Operation_group_counter += 1;
				wiping++;
				break;
			case 'a':
				if (args_info->aes_given)
				{
					fprintf (stderr, "%s: `--aes' (`-a') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->aes_given = 1;
				Algorithm_group_counter += 1;
				break;
			case 'r':	/* Rijndael (default).  */
				if (args_info->rijndael_given)
				{
					fprintf (stderr, "%s: `--rijndael' (`-r') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->rijndael_given = 1;
				Algorithm_group_counter += 1;
				break;
			case 's':	/* Serpent.  */
				if (args_info->serpent_given)
				{
					fprintf (stderr, "%s: `--serpent' (`-s') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->serpent_given = 1;
				Algorithm_group_counter += 1;
				break;
			case 't':	/* Twofish.  */
				if (args_info->twofish_given)
				{
					fprintf (stderr, "%s: `--twofish' (`-t') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->twofish_given = 1;
				Algorithm_group_counter += 1;
				break;
			case 'z':      /* wipe when encrypting */
				if (args_info->wipe_on_encrypt)
				{
					fprintf (stderr, "%s: `--encrypt-wipe' (`-z') option given more than once\n", PACKAGE);
					clear_args ();
					exit (EXIT_FAILURE);
				}
				args_info->wipe_on_encrypt = 1;
				break;
			case 0:	/* Long option with no short option */
			case '?':	/* Invalid option.  */
				/* `getopt_long' already printed an error message.  */
				exit (EXIT_FAILURE);
			default:	/* bug: option not considered.  */
				fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
				abort ();
		} /* switch */
	} /* while */
	if (!Algorithm_group_counter && wiping) args_info->wipe_only = 1;
	if ( Algorithm_group_counter > 1)
	{
		fprintf (stderr, "%s: %d algorithms were given, only one is required\n", PACKAGE,Algorithm_group_counter);
		cmdline_parser_print_help ();
		missing_required_options = 1;
	}
	
	if ( Operation_group_counter < 1)
	{
		fprintf (stderr, "%s: You must decide to encrypt, decrypt, or wipe\n", PACKAGE);
		cmdline_parser_print_help ();
		missing_required_options = 1;
	}
	else if (!args_info->wipe_only)
	{
		if(!args_info->input_given)
		{
			fprintf (stderr, "%s: An input file is required for encryption or decryption\n", PACKAGE);
			missing_required_options = 1;
		}
		if(!args_info->output_given)
		{
			fprintf (stderr, "%s: An output file is required for encryption or decryption\n", PACKAGE);
			missing_required_options = 1;
		}
		if (missing_required_options) cmdline_parser_print_help (); 
	}
	
	if ( missing_required_options )
		exit (EXIT_FAILURE);
	
	if (optind < argc)
	{
		int i = 0;
		args_info->inputs_num = argc - optind;
		args_info->inputs = (char **)(malloc ((args_info->inputs_num)*sizeof(char *)));
		while (optind < argc)
			args_info->inputs[i++] = strdup (argv[optind++]); 
	}
	return 0;
}
