#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

/* Load File into memory */

char *
load_file(const char *filename) {
	int res = 1;
	int fptr;
	struct stat *fbufstat;
	char *fbuf;
	int tmp_errno=0;
	fbufstat = malloc(sizeof(struct stat));
	
	if ((fptr = open(filename,O_RDONLY)) != -1) {
		fstat(fptr,fbufstat);
		
		fbuf =  malloc(fbufstat->st_size+1);
		*fbuf = 0;
		
		read(fptr,fbuf,fbufstat->st_size);
		
		close(fptr);
		
		fbuf[fbufstat->st_size] = 0;
		
	} else {
		tmp_errno = errno;
		res = 0;
		fbuf = malloc(strlen(strerror(tmp_errno)+2));
		fbuf[0] = 0;
		strcat((fbuf+1),strerror(tmp_errno));
		fbuf[strlen(strerror(tmp_errno))+1] = 0;
	}
	
	return(fbuf);
}
