// ControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BackLog.h"
#include "ControlDlg.h"
#include "support.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlDlg dialog


CControlDlg::CControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CControlDlg)
	m_strPathName="";
	m_bLogExportType = 0;
	//}}AFX_DATA_INIT
}


void CControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlDlg)
	DDX_Text(pDX, LOG_DIRECTORY_EDIT, m_strPathName);
	DDV_MaxChars(pDX, m_strPathName, 4096);
	DDX_Radio(pDX, IDC_DATE_RADIO, m_bLogExportType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CControlDlg, CDialog)
	//{{AFX_MSG_MAP(CControlDlg)
	ON_BN_CLICKED(IDC_DATE_RADIO, OnDateRadio)
	ON_BN_CLICKED(IDC_DATE_SERVER_RADIO, OnDateServerRadio)
	ON_BN_CLICKED(IDC_DATE_LOGTYPE_RADIO, OnDateLogtypeRadio)
	ON_BN_CLICKED(IDC_DATE_LOGTYPE_SERVER_RADIO, OnDateLogtypeServerRadio)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlDlg message handlers

BOOL CControlDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	int read_config_result = 0;
	Reg_Config reg_config;
	char error_msg[200] = "I could not find default values in the registry. \nSome default remote control values will be used.\n";
	
	// Create the ToolTip control.
	m_remote_tooltip.Create(this);
	m_remote_tooltip.Activate(TRUE);
	m_remote_tooltip.AddTool(GetDlgItem(LOG_DIRECTORY_EDIT), "Enter a valid directory in which you would like BackLog to store log files");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_DATE_RADIO), "Create a file for each Date that arrives at BackLog");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_DATE_SERVER_RADIO), "Create a file for each System / Date that arrives at BackLog");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_DATE_LOGTYPE_RADIO), "Create a file for each Log Type / Date that arrives at BackLog");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_DATE_LOGTYPE_SERVER_RADIO), "Create a file for each System / Log Type / Date that arrives at BackLog");
	

	// Read the Registry settings
	read_config_result = Read_Config_Registry(&reg_config);

	if (read_config_result > 0)
	{	
		read_config_result += 1;
		MessageBox(error_msg,"Error Reading the Registry",MB_ICONERROR|MB_OK);
	}

	m_strPathName = reg_config.str_PathName;
	m_bLogExportType = 0;
	if(reg_config.dw_LogType == OUTPUT_TYPE_DATE) {
		m_bLogExportType = 0;
	} else if(reg_config.dw_LogType == OUTPUT_TYPE_DATE_SVR) {
		m_bLogExportType = 1;
	} else if(reg_config.dw_LogType == OUTPUT_TYPE_DATE_LOG) {
		m_bLogExportType = 2;
	} else if(reg_config.dw_LogType == OUTPUT_TYPE_DATE_LOG_SVR) {
		m_bLogExportType = 3;
	} else {
		m_bLogExportType = 0;
	}

	UpdateData(FALSE);
	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


BOOL CControlDlg::IsDirectory(char * path)
{
	if(!path)				return(FALSE);
	if(strlen(path) < 3)	return(FALSE); // Must be at least "C:\"
	if(!((path[0] >= 'a' && path[0] <= 'z') || (path[0] >= 'A' && path[0] <= 'Z'))) {
		return(FALSE);
	}
	if(path[1] != ':')		return(FALSE);
	if(path[2] != '\\')		return(FALSE);

	// Ok, anything else is fair game.
	DWORD Attributes;
	Attributes=GetFileAttributes(path);
	if(Attributes == 0xFFFFFFFF) {
		// File or directory does not exist
		return(FALSE);
	}
	if(Attributes & FILE_ATTRIBUTE_DIRECTORY) {
		return(TRUE);
	}

	return(FALSE);
}


void CControlDlg::OnOK() 
{
	Reg_Config Registry_struct;
	char error_msg[200];
	int i_errornum = 0;

	strncpy(error_msg,"Problems were encountered in writing to the registry.\nCheck that you are running SNARE BackLog with Administrator\nprivileges. Error code = ",200);
	
	//Need to update the data from the Window
	UpdateData(TRUE);

	// HERE: Check directory
	strncpy(Registry_struct.str_PathName,m_strPathName,SIZE_OF_PATHNAME);
	if(!(IsDirectory(Registry_struct.str_PathName))) {
		MessageBox("The \"Directory Path\" must exist in order for Snare to write to the path.","Error",MB_OK|MB_ICONERROR);
		return;
	}
	Registry_struct.dw_LogType = m_bLogExportType+1;

	i_errornum = Write_Config_Registry(&Registry_struct);

	if (i_errornum > 0) {	
		MessageBox("Registry Write","Error Writing to the Registry",MB_OK|MB_ICONERROR);
		return;
	}

	CDialog::OnOK();
}

BOOL CControlDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_remote_tooltip.RelayEvent(pMsg);
	return CDialog::PreTranslateMessage(pMsg);
}

void CControlDlg::OnDateRadio() 
{
	UpdateData(TRUE);
	m_bLogExportType = 0;
	UpdateData(FALSE);
}

void CControlDlg::OnDateServerRadio() 
{
	UpdateData(TRUE);
	m_bLogExportType = 1;
	UpdateData(FALSE);	
}

void CControlDlg::OnDateLogtypeRadio() 
{
	UpdateData(TRUE);
	m_bLogExportType = 2;
	UpdateData(FALSE);
}

void CControlDlg::OnDateLogtypeServerRadio() 
{
	UpdateData(TRUE);
	m_bLogExportType = 3;
	UpdateData(FALSE);
}
