#include "stdafx.h"   //Only required for the BackLog GUI
#include <windows.h>
#include <winsvc.h>
#include <aclapi.h>
#include <stdio.h>
#include "support.h"


int Restart_Service() 
{
	int returncode=0;
	returncode += Stop_Service();
	returncode += Start_Service();
	return(returncode);
}

int Stop_Service()
{
	SERVICE_STATUS ssStatus;
    DWORD dwStartTime;
    DWORD dwTimeout=30000; // 30 seconds
	SC_HANDLE hSCM;
	SC_HANDLE schService;

	dwStartTime = GetTickCount();

    // Open the SCM database
    hSCM = OpenSCManager( NULL, NULL, SC_MANAGER_CONNECT );
    if ( !hSCM ) {
		return(1);
	}
 
    schService = OpenService( 
        hSCM,          // SCM database 
        "BackLog",          // service name
        SERVICE_ALL_ACCESS); 
 
    if (schService == NULL) 
    { 
        CloseServiceHandle(hSCM);
		return(1); 
    }
 

	if (!ControlService(schService,SERVICE_CONTROL_STOP,&ssStatus ) ) {
		CloseServiceHandle(schService);
		CloseServiceHandle(hSCM);
		return(1);
	}

    // Wait for the service to stop
	while ( ssStatus.dwCurrentState != SERVICE_STOPPED ) 
    {
		Sleep( ssStatus.dwWaitHint );
        if ( !QueryServiceStatus( schService, &ssStatus ) ) {
			CloseServiceHandle(schService);
			CloseServiceHandle(hSCM);

			return(1);
		}

		if ( ssStatus.dwCurrentState == SERVICE_STOPPED )
			break;

        if ( GetTickCount() - dwStartTime > dwTimeout ) {
			CloseServiceHandle(schService);
			CloseServiceHandle(hSCM);

			return(1);
		}
	}

	CloseServiceHandle(schService);
	CloseServiceHandle(hSCM);

	return(0);
}


int Start_Service()
{
	SERVICE_STATUS ssStatus;
    DWORD dwOldCheckPoint; 
    DWORD dwStartTickCount;
    DWORD dwWaitTime;
    DWORD dwStatus;

	SC_HANDLE hSCM;
	SC_HANDLE schService;

    // Open the SCM database
    hSCM = OpenSCManager( NULL, NULL, SC_MANAGER_CONNECT );
    if ( !hSCM ) {
		return(2);
	}
 
    schService = OpenService( 
        hSCM,          // SCM database 
        "BackLog",          // service name
        SERVICE_ALL_ACCESS); 
 
    if (schService == NULL) 
    {
		CloseServiceHandle(hSCM);
        return(2); 
    }
 
    if (!StartService(
            schService,  // handle to service 
            0,           // number of arguments 
            NULL) )      // no arguments 
    {
		// Excellent - Service not working.
		CloseServiceHandle(schService);
		CloseServiceHandle(hSCM);

        return(2); 
    }
 
    // Check the status until the service is no longer start pending. 
 
    if (!QueryServiceStatus( 
            schService,   // handle to service 
            &ssStatus) )  // address of status information structure
    {
		CloseServiceHandle(schService);
		CloseServiceHandle(hSCM);
		return(2);
    }
 
    // Save the tick count and initial checkpoint.

    dwStartTickCount = GetTickCount();
    dwOldCheckPoint = ssStatus.dwCheckPoint;

    while (ssStatus.dwCurrentState == SERVICE_START_PENDING) 
    { 
        // Do not wait longer than the wait hint. A good interval is 
        // one tenth the wait hint, but no less than 1 second and no 
        // more than 10 seconds. 
 
        dwWaitTime = ssStatus.dwWaitHint / 10;

        if( dwWaitTime < 1000 )
            dwWaitTime = 1000;
        else if ( dwWaitTime > 10000 )
            dwWaitTime = 10000;

        Sleep( dwWaitTime );

        // Check the status again. 
 
        if (!QueryServiceStatus( 
                schService,   // handle to service 
                &ssStatus) )  // address of structure
            break; 
 
        if ( ssStatus.dwCheckPoint > dwOldCheckPoint ) {
            // The service is making progress.
            dwStartTickCount = GetTickCount();
            dwOldCheckPoint = ssStatus.dwCheckPoint;
        } else {
            if(GetTickCount()-dwStartTickCount > ssStatus.dwWaitHint)
            {
                // No progress made within the wait hint
                break;
            }
        }
    } 

    if (ssStatus.dwCurrentState == SERVICE_RUNNING) 
    {
		// Service started.
        dwStatus = 0;
    } else { 
        dwStatus = 2;
    }
 
	CloseServiceHandle(schService);
	CloseServiceHandle(hSCM);

    return dwStatus;
}


// Write a DWORD to the registry
BOOL MyWriteProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nValue)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_DWORD,
		(LPBYTE)&nValue, sizeof(nValue));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get a DWORD from the registry
DWORD MyGetProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nDefault)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return nDefault;
	DWORD dwValue;
	DWORD dwType;
	DWORD dwCount = sizeof(DWORD);
	LONG lResult = RegQueryValueEx(hSecKey, (LPTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)&dwValue, &dwCount);
	RegCloseKey(hSecKey);
	if (lResult == ERROR_SUCCESS)
	{
		return dwValue;
	}
	return nDefault;
}

// Write a string to the registry
BOOL MyWriteProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_SZ,
		(unsigned char *)lpszString, strlen(lpszString)+1);
//		(unsigned char *)lpszString, (strlen(lpszString)+1) * sizeof(LPCTSTR));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get a string from the registry
BOOL MyGetProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString, DWORD dwStringBuffer)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	DWORD dwSize = dwStringBuffer;
	DWORD dwType;
	LONG lResult = RegQueryValueEx(hSecKey, (LPCTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)lpszString, &dwSize);
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get the setion registry key
HKEY MyGetSectionKey(LPCTSTR lpszSection)
{
	HKEY hSectionKey = NULL;
	HKEY hAppKey = MyGetServiceRegistryKey();
	if (hAppKey == NULL)
		return NULL;
	
	DWORD dw;
	RegCreateKeyEx(hAppKey, lpszSection, 0, REG_NONE,
		REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
		&hSectionKey, &dw);
	RegCloseKey(hAppKey);
	return hSectionKey;
}

HKEY MyGetServiceRegistryKey()
{
	// Store the information within the InterSect Alliance high level key.
	char m_sServiceName[256]="InterSect Alliance";
	
	HKEY hServicesKey = NULL;
	HKEY hParametersKey = NULL;
	HKEY hAppKey = NULL;
	
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE", 0, KEY_WRITE|KEY_READ,
		&hServicesKey) == ERROR_SUCCESS)
	{
		DWORD dw;
		if (RegCreateKeyEx(hServicesKey, m_sServiceName, 0, REG_NONE,
			REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
			&hAppKey, &dw) == ERROR_SUCCESS)
		{
			RegCreateKeyEx(hAppKey, "BackLog", 0, REG_NONE,
				REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
				&hParametersKey, &dw);
		}
	}
	if (hServicesKey != NULL)
		RegCloseKey(hServicesKey);
	if (hAppKey != NULL)
		RegCloseKey(hAppKey);
	
	return hParametersKey;
}

int Read_Config_Registry(Reg_Config *pRegistry_struct)
{
	char strpathname[SIZE_OF_PATHNAME]="";
	DWORD dw_LogType = OUTPUT_TYPE_DATE;
	int i_return_val = 0;

	// Defaults to system32/logfiles if no hostname found, or key is out of bounds.
	if(!MyGetProfileString("Config","Path",strpathname,SIZE_OF_PATHNAME)) 
	{
		ExpandEnvironmentStrings("%SystemRoot%\\system32\\LogFiles",strpathname,SIZE_OF_PATHNAME);

		if(DirExists(strpathname)!=TRUE) {
			// Hmm.. we might be on an XP box.
			ExpandEnvironmentStrings("%SystemRoot%\\Security\\Logs",strpathname,SIZE_OF_PATHNAME);
			if(DirExists(strpathname)!=TRUE) {
				i_return_val += 1;
			}
		}
	}

	strncpy(pRegistry_struct->str_PathName,strpathname,SIZE_OF_PATHNAME);

	dw_LogType=MyGetProfileDWORD("Config","OutputType",1);
	pRegistry_struct->dw_LogType = dw_LogType;

	return i_return_val;
}

int DirExists(char * dir)
{
    WIN32_FIND_DATA data;
    HANDLE hFile = FindFirstFile(dir, &data);

	if(!dir) {
		return(-1);
	}

    if (hFile == INVALID_HANDLE_VALUE) { // directory doesn't exist
        return FALSE;
    } else {
        // is it folder or file?
        FindClose(hFile);
        if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
            return TRUE;
		}
        return -1;
    }
}

int Write_Config_Registry(Reg_Config *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_pathname[SIZE_OF_PATHNAME]="";
    
	// Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS ) {
		// The registry key does not exist and was thus unable to be opened.
		// Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS) {
			// The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	// Now attempt to set the registry values

	// No error checking required on this Reg Value
	strncpy(str_pathname,pRegistry_struct->str_PathName,SIZE_OF_PATHNAME);
	if ( RegSetValueEx(hKey, "Path",0,REG_SZ,
			  (CONST BYTE *) str_pathname,strlen(str_pathname)) 
			  != ERROR_SUCCESS ) {
		i_return_val += 4;
	}
				
	// If Audit is out of bounds, then it becomes 1
	if ((pRegistry_struct->dw_LogType < OUTPUT_TYPE_DATE) | (pRegistry_struct->dw_LogType > OUTPUT_TYPE_DATE_LOG_SVR)) {
		pRegistry_struct->dw_LogType = OUTPUT_TYPE_DATE;
	}

	if ( RegSetValueEx(hKey, "OutputType",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_LogType,
			  sizeof(pRegistry_struct->dw_LogType))
			  != ERROR_SUCCESS )
		i_return_val += 8;

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}




BOOL IsNT5(void) {
	DWORD winVer;
	BOOL returncode=FALSE;
	winVer=GetVersion();
	if(winVer<0x80000000) {
		OSVERSIONINFO *osvi;
		osvi=(OSVERSIONINFO *)malloc(sizeof(OSVERSIONINFO));
		if(osvi!=NULL) {
			memset(osvi,0,sizeof(OSVERSIONINFO));
			osvi->dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
			GetVersionEx(osvi);
			if(osvi->dwMajorVersion>=5) {
				returncode=TRUE;
			}
			free(osvi);
		}
	}
	return(returncode);
}
