/*
FILE: Epilog.h
*/

#include "NTService.h"
#include "support.h"
#include <ntsecapi.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAX_EVENT 4096
#define MAX_STRING 1024
#define MAX_OUTPUT_STRING 8192
#define MAX_LINE_GRAB 10
#define DEFAULT_CACHE 320000
#define DIR_NEW_FILE 2

struct _node
{
	int excludematchflag;				// Include or exclude search term matches?
	char match[SIZE_OF_GENERALMATCH];
	struct _node *next;
};

typedef struct _node Node;

// Store a linked list of our target destinations.
struct _hostnode
{
	SOCKET Socket;
	struct sockaddr_in server;
	char HostName[512];
	DWORD SocketType;
	struct _hostnode *next;
};

typedef struct _hostnode HostNode;

// Linked List
struct _msgcache {
	char msg[MAX_OUTPUT_STRING];
	// Log type
	char type[MAX_TYPE];
	int msglen;
	struct _msgcache *next;
};

typedef struct _msgcache MsgCache;

struct _log_node
{
	// firstly, is this actually a directory that we are just
	// watching for the latest file:
	int dir;
	int dir_check;
	char dir_name[SIZE_OF_LOGNAME];
	// If it is a directory, we can also record the desired format
	char format[SIZE_OF_LOGNAME];

	// File name
	char name[SIZE_OF_LOGNAME];
	char old_name[SIZE_OF_LOGNAME]; //since there is no indode, we need other ways of tracking files

	/* File stream on which the file is open; -1 if it's not open. */
	FILE *fs;

	// partial msg storage
	char pmsg[MAX_EVENT];

	// Log type
	char type[MAX_TYPE];

	/* Attributes of the file the last time we checked. */
	long old_size;
	long size;
	time_t mtime;
	_dev_t dev;
	_ino_t ino;
	unsigned short mode;
	
	// a flag used to identify when there are still more entries to grab.
	int still_more;

	// When did the last error occur (zero means no error)
	time_t last_error;

	struct _log_node *next;
};

typedef struct _log_node LogNode;

class CEpilogService : public CNTService
{
public:
	CEpilogService();
	virtual BOOL OnInit();
    virtual void Run();
    virtual BOOL OnUserControl(DWORD dwOpcode);
	void OnShutdown();
	void OnStop();
	void OnSignal();

    void SaveStatus();

// 	int SNAREDEBUG;

private:
	HANDLE m_hEventList[3]; // Three elements at the moment.
};

// Function Prototypes.
BOOL	InitWinsock				(char *, int);
int		RunServer				();
void	TerminateWinsock		(SOCKET);
SOCKET	StartServer				(UINT, char *);
BOOL	WINAPI ClientThread		(LPVOID);

void	syslogdate				(char *, struct tm *);
int		wildmatch				(char *, char *);
int		FindDirFile				(LogNode *f);
char *	getdate					(char *date, BOOL ytday = false);

SOCKET	ConnectToServer			(HostNode *, UINT, char *, int, DWORD);
BOOL	SendToSocket			(HostNode *, char *buf, int nSize, char *szError, int eSize);
void	GetFQDN					(char *string,int length);

int		ReadObjectives();
static	Node *	AddToList		(char *match, int excludeflag);

int		CheckObjective			(char *searchterm);
void	ResetCurrentNode		(void);
void	NextItemInList			(void);
Node *	GetCurrentItem			(void);
int		IsValidItem				(void);
void	DestroyList				(void);

HostNode *	OpenSockets			(char *lpszDestination, DWORD dwDestPort, DWORD SocketType);

void	GetHostname				(char * Hostname,int size);
void	GetDestPort				(DWORD * dwDestPort);
void	GetSocketType			(DWORD * SocketType);
void	GetSyslog				(DWORD * dwSyslog);
void	GetSyslogHeader			(DWORD * dwSyslogHeader);
void	GetWEBSERVER_ACTIVE		(DWORD * WEBSERVER_ACTIVE);
void	GetPortNumber			(DWORD * dwPortNumber);
void	GetDestination			(char * lpszDestination,int size);
void	GetLogNames			(char * lpszLogFileNames,int size);
void	GetDelim				(char * DELIM,int size);
void	GetPassword				(char * lpszPassword,int size);
void	GetIPAddress			(char * lpszIPAddress,int size);
int 	AddLogWatch				(Reg_Log *rl);
int		ReadLogs				();
int 	file_has_changed		(LogNode *f);

// thread structure
typedef struct
{
	SOCKET hSocket;
	BOOL bTerminate;
} ThreadStruct;