//
// Epilog - Generic text file analysis and forwarding
// Copyright 2001-2007 InterSect Alliance Pty Ltd
// http://www.intersectalliance.com/
//
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <winsock2.h>
#include <lm.h>

#include <comdef.h>
#include <activeds.h>

//#include <atlbase.h>
#include <windows.h>

#include "WebPages.h"
#include "Version.h"

#include "support.h"
#include "MD5.h"

#include "webserver.h"

extern void DebugMsg(const char* pszFormat, ...);

extern int SNAREDEBUG;
extern HANDLE hMutex;
extern EventCache *MCHead;

char WEB_CONFIG_FILENAME[MAX_AUDIT_CONFIG_LINE] = "\0";

// Make sure we return the size, or zero (for strings).
// Note that for the most part, the socket will be ignored
int HandleWebPages(char *HTTPBuffer,char *HTTPOutputBuffer,int size,SOCKET http_socket, HANDLE event)
{
	int returncode=0, refreshflag=0;
	char *ArgPosition, *pos, *pos2, *pos3;
	char TBuffer[2048]="";

	if(!HTTPBuffer || !HTTPOutputBuffer) {
		return(0);
	}

	// Stuff without the header/footer
	if(!strcmp(HTTPBuffer,"/intersect.gif")) {
		return(InterSectImage(HTTPBuffer,HTTPOutputBuffer,size));
	} else {
		char * pBuffer=HTTPOutputBuffer;
		int length=0;
		int psize=0;

		ArgPosition=strstr(HTTPBuffer,"?");
		// No arguments passed?
		if(!ArgPosition) {
			// Set argument position to the beginning of the buffer.
			ArgPosition=HTTPBuffer;
		} else {
			ArgPosition++;
		}

		if(!strncmp(HTTPBuffer,"/eventlog",9)) refreshflag=1;
		returncode=DefaultHeader(HTTPBuffer,pBuffer,size, refreshflag);
		length=(int)strlen(HTTPOutputBuffer);
		
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}

		// Check for a config argument, but only if you are the master
		pos2 = HTTPBuffer + 1;
		pos = strstr(pos2,"/");
		pos3 = strstr(pos2,"?");
		if (pos && (!pos3 || pos < pos3)) {
			HTTPBuffer = pos;
			strncpy_s(WEB_CONFIG_FILENAME, MAX_AUDIT_CONFIG_LINE, pos2,_TRUNCATE);
			pos = strstr(WEB_CONFIG_FILENAME,"/");
			*pos = '\0';
		} else {
			WEB_CONFIG_FILENAME[0] = '\0';
		}

		// Web pages
		if(!strcmp(HTTPBuffer,"/network")) {
			returncode+=Network_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/network?",9)) {
			strncpy_s(pBuffer,psize,"Nothing here yet",_TRUNCATE);
		} else if(!strcmp(HTTPBuffer,"/remote")) {
			returncode+=Remote_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setremote",10)) {
			returncode+=Remote_Set(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/objective",10)) {
			returncode+=Objective_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setobjective",13)) {
			returncode+=Objective_Display(HTTPBuffer,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/changeobjective",16)) {
			returncode+=Objective_Result(HTTPBuffer,pBuffer,psize);
		} else if (!strncmp(HTTPBuffer, "/log", 4)) {
			returncode += Log_Config(ArgPosition, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/setlog", 7)) {
			returncode += Log_Display(HTTPBuffer, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/changelog", 10)) {
			returncode += Log_Result(HTTPBuffer, pBuffer, psize);
		} else if(!strcmp(HTTPBuffer,"/restart")) {
			returncode+=Restart(HTTPBuffer,pBuffer,psize,event);
		} else if(!strncmp(HTTPBuffer,"/restart?",10)) {
			strncpy_s(pBuffer,psize,"Nothing here yet",_TRUNCATE);
		} else if(!strncmp(HTTPBuffer,"/setnetwork",11)) {
			returncode+=Network_Set(HTTPBuffer,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/status",6)) {
			returncode+=Status_Page(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/eventlog",9)) {
			returncode+=Current_Events(ArgPosition,pBuffer,psize);
		} else if(strlen(TBuffer)) {
			strncpy_s(pBuffer,psize,TBuffer,_TRUNCATE);
		} else if(!strcmp(HTTPBuffer,"/")) {
			returncode+=Status_Page(ArgPosition,pBuffer,psize);
		} else {
			// Here: Consider returning a 404 instead.
			// returncode=+Status_Page(ArgPosition,pBuffer,psize);
			if(SNAREDEBUG) { DebugMsg("No page - sending a 404"); }
			Display404(http_socket);
			return(-1);
		}

		pBuffer = HTTPOutputBuffer;
		length=(int)strlen(HTTPOutputBuffer);
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}

		returncode+=DefaultFooter(HTTPBuffer,pBuffer,psize);
	}

	return(returncode);
}


// This page will be usefull for debug information
int Status_Page(char *source, char *dest, int size)
{
	_snprintf_s(dest,size,_TRUNCATE,"<HTML><BODY><H2><CENTER>Epilog Version %s Status Page</H2></CENTER><P><center><font color=green>Epilog for Windows is currently active.</font></CENTER></BODY></HTML>",EPILOG_VERSION);
	return(0);
}

int Network_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Config config_struct;
	Reg_Network network_struct;
	DWORD dw_config_error,dw_network_error;
	char str_DestPort[10];
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug"};
	UINT i,i_SyslogFacility,i_SyslogPriority;
		
	dw_config_error = Read_Config_Registry(&config_struct);
	dw_network_error = Read_Network_Registry(&network_struct);

	// This function will display the form used to set the audit configuration
	// The result of the form will be sent to "network_set"
	strncpy_s(dest,size,"<form method=get action=setnetwork><h2><center>SNARE Network Configuration</h2>",_TRUNCATE);

	// Will display an error if unable to completely read from the registry
	if ((dw_network_error > 0) || (dw_config_error > 0)) {
		dw_network_error += WEB_READ_NETWORK_ERROR_CODE;
		dw_config_error += WEB_READ_CONFIG_ERROR_CODE;

		_snprintf_s(dest,size,_TRUNCATE,"%s<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: %d.%d</b><br>",dest,dw_network_error,dw_config_error);
	}

	_snprintf_s(dest,size,_TRUNCATE,"%s<br>The following network configuration parameters of the SNARE unit is set to the following values:<br><br>" \
				"<table  width=70%% border=0>" \
				"<tr bgcolor=#FFFFCC><td>Override detected DNS Name with: </td>" \
				"<td><input type=text name=str_ClientName size=25 value=\"%s\"></td></tr>",dest,config_struct.str_ClientName);

	// Here: Two alternatives: Allow a user-supplied comma-separated list, or
	// alternatively, add a new element for each new system?
	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Destination Snare Server address </td><td><input type=text name=str_Destination size=25 value=\"",_TRUNCATE);
	strncat_s(dest,size,network_struct.str_Destination,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Destination Port <br>(if SYSLOG Header NOT enabled)</td><td><input type=text name=dw_DestPort size=8 value=\"",_TRUNCATE);
	_itoa_s(network_struct.dw_DestPort,str_DestPort,10);
	strncat_s(dest,size,str_DestPort,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFFF><td><br></td></tr>",_TRUNCATE);

	// First 3 bits = facility (eg: emerg, alert, etc.)
	// Rest = priority. Note that there is a gap between ftp and local1.
	i_SyslogPriority = (UINT)network_struct.dw_SyslogDest & 7;
	i_SyslogFacility = (UINT)network_struct.dw_SyslogDest >> 3;
	if(i_SyslogFacility > 11) { 
		i_SyslogFacility = i_SyslogFacility - 4;
	}

	//Need to convert this next section to YES or NO
	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Enable SYSLOG Header?</td><td><input type=checkbox name=dw_Syslog",_TRUNCATE);
	if (network_struct.dw_Syslog != 0) {
		strncat_s(dest,size," checked",_TRUNCATE);
	}
	strncat_s(dest,size,"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>SYSLOG Facility </td><td><select name=SyslogFacility>",_TRUNCATE);
	for (i = 0; i < 19; i++)
	{
		strncat_s(dest,size,"<option",_TRUNCATE);
		if (i == i_SyslogFacility) {
			strncat_s(dest,size," selected>",_TRUNCATE);
		} else {
			strncat_s(dest,size,">",_TRUNCATE);
		}
		strncat_s(dest,size,str_facility[i],_TRUNCATE);
	}
	strncat_s(dest,size,"</select></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>SYSLOG Priority </td><td><select name=SyslogPriority>",_TRUNCATE);
	for (i = 0; i <= 7; i++) {
		strncat_s(dest,size,"<option",_TRUNCATE);
		if (i == i_SyslogPriority) {
			strncat_s(dest,size," selected>",_TRUNCATE);
		} else {
			strncat_s(dest,size,">",_TRUNCATE);
		}
		strncat_s(dest,size,str_priority[i],_TRUNCATE);
	}
	
	strncat_s(dest,size,"</select></td></tr>" \
		         "</table><br>" \
				 "<input type=submit value=\"Change Configuration\">    " \
				 "<input type=reset value=\"Reset Form\"></form>",_TRUNCATE);
	
	return(0);
}

int Network_Set(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100]="", web_port[100]="",syslog_fac[100]="",syslog_pri[100]="";
	char Argument[100]="";
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug"};
	Reg_Network network_struct;
	Reg_Config config_struct;
	DWORD dw_error_network = 1,dw_error_config = 1,dw_SyslogClass = 0;
	int i;

	if(!source || !dest || !size) {
		return(0);
	}

	// This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy_s(dest,size,"<h2><center>SNARE Network Configuration</h2>",_TRUNCATE);

	// Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	// via a checkbox will not be listed if the checkbox has been deselected.
	// Checking is limited to ensuring the Detsination port in the range 1-65535.
	// The variable associated with the checkbox (dw_Syslog) must be
	// exactly "on" or it will be defaulted to "off".

	network_struct.dw_DestPort = -1;
	network_struct.dw_SocketType=SOCKETTYPE_UDP;	// UDP
	network_struct.dw_Syslog = 0;

	while((psource=GetNextArgument(psource,Variable,_countof(Variable),Argument,_countof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_ClientName") != NULL) {
			strncpy_s(config_struct.str_ClientName,_countof(config_struct.str_ClientName),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_Destination") != NULL) {
			strncpy_s(network_struct.str_Destination,_countof(network_struct.str_Destination),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"dw_DestPort") != NULL)	{
			strncpy_s(web_port,_countof(web_port),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"SyslogPriority") != NULL) {
			strncpy_s(syslog_pri,_countof(syslog_pri),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"SyslogFacility") != NULL) {
			strncpy_s(syslog_fac,_countof(syslog_fac),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"dw_Syslog") != NULL) {
			if (strcmp(Argument,"on") == 0)
				network_struct.dw_Syslog = 1;
		}
	}

	for (i = 0; i <= 7; i++) {
		if (strstr(syslog_pri,str_priority[i]) != NULL) {
			network_struct.dw_SyslogDest = i;
			break;
		}
	}
	for (i = 0; i <= 19; i++) {
		if (strstr(syslog_fac,str_facility[i]) != NULL) {
			dw_SyslogClass = i;
			break;
		}
	}

	if(dw_SyslogClass > 11) {
		dw_SyslogClass = dw_SyslogClass + 4;
	}
	network_struct.dw_SyslogDest = network_struct.dw_SyslogDest | (dw_SyslogClass << 3);


	network_struct.dw_DestPort = atoi(web_port);
	if ((network_struct.dw_DestPort < 1) || (network_struct.dw_DestPort > 65535)) {
		strncat_s(dest,size,"The Destination Port value must be between 1 and 65535. Use the 'back' button to change the value.",_TRUNCATE);
	} else {

		dw_error_network = Write_Network_Registry(&network_struct);

		dw_error_config = Write_Config_Registry(&config_struct);

		if ((dw_error_network != 0) || (dw_error_config != 0)) {
			strncat_s(dest,size,"Values have NOT been changed.",_TRUNCATE);
		} else {
			strncat_s(dest,size,"Values have been changed.",_TRUNCATE);
		}
	}
	return(0);

}


int Remote_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Remote remote_struct;
	DWORD dw_remote_error;
	char str_WebPort[10];
	char str_remerr[10];

	dw_remote_error = Read_Remote_Registry(&remote_struct);

	// This function will display the form used to set the remote audit configuration
	strncpy_s(dest,size,"\n<form method=get action=setremote><h2><center>SNARE Remote Control Configuration</h2>",_TRUNCATE);

	// Will display an error if unable to completely read from the registry
	if (dw_remote_error > 0)
	{
		dw_remote_error += WEB_READ_REMOTE_ERROR_CODE;
		_itoa_s(dw_remote_error,str_remerr,10);
		
		strncat_s(dest,size,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: ",_TRUNCATE);
		strncat_s(dest,size,str_remerr,_TRUNCATE);
		strncat_s(dest,size,"</b><br>\n",_TRUNCATE);
	}
	strncat_s(dest,size,"<br>The following remote control configuration parameters of the SNARE unit is set to the following values:<br><br>" \
		"<table  width=70% border=0>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Restrict remote control of SNARE agent to certain hosts </td><td><input type=checkbox name=dw_Restrict",_TRUNCATE);

	if (remote_struct.dw_Restrict != 0)
		strncat_s(dest,size," checked",_TRUNCATE);
	strncat_s(dest,size,"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>IP Address allowed to remote control SNARE </td><td><input type=text name=str_RestrictIP size=12 value=\"",_TRUNCATE);
	strncat_s(dest,size,remote_struct.str_RestrictIP,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>\n",_TRUNCATE);
	

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Require a password for remote control? </td><td><input type=checkbox name=dw_Password",_TRUNCATE);

	if (remote_struct.dw_Password != 0)
		strncat_s(dest,size," checked",_TRUNCATE);
	strncat_s(dest,size,"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Password to allow remote control of SNARE </td><td><input type=password name=str_Password size=12 value=\"",_TRUNCATE);
	strncat_s(dest,size,remote_struct.str_Password,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>\n",_TRUNCATE);


	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Change Web Server default (6162) port </td><td><input type=checkbox name=dw_PortChange",_TRUNCATE);

	if (remote_struct.dw_WebPortChange != 0)
		strncat_s(dest,size," checked",_TRUNCATE);
	strncat_s(dest,size,"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Web Server Port </td><td><input type=text name=dw_WebPort size=8 value=\"",_TRUNCATE);
	_itoa_s(remote_struct.dw_WebPort,str_WebPort,10);
	strncat_s(dest,size,str_WebPort,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"</table><br>\n",_TRUNCATE);
	strncat_s(dest,size,"<input type=submit value=\"Change Configuration\">    ",_TRUNCATE);
	strncat_s(dest,size,"<input type=reset value=\"Reset Form\"></form>",_TRUNCATE);
	
	return(0);
}

int Remote_Set(char *source, char *dest, int size) 
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100], web_port[100];
	char Argument[100];
	Reg_Remote remote_struct;
	DWORD dw_error = 0;
	
	dw_error = Read_Remote_Registry(&remote_struct);

	// This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy_s(dest,size,"<h2><center>SNARE Remote Control Configuration</h2>",_TRUNCATE);

	// Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	// via a checkbox will not be listed if the checkbox has been deselected.
	// Also be aware that there may not be any arguments for this objective. If a sysadmin does not want
	// remote control, then there will be no arguments.
	// Hence: Checking is limited to Webport in the range 1-65535 only if portchange is "on"
	// The three variable associated with the checkboxes (dw_Allow, dw_Restrict, and dw_PortChange) must be
	// exactly "on" or they will be defaulted to "off".
	// str_RestrictIP can be anything it wants to be, so long as it is within size bounds.

	// Configure the defaults.
	remote_struct.dw_WebPort = -1;
	remote_struct.dw_Password = 0;
	remote_struct.dw_Restrict = 0;
	remote_struct.dw_WebPortChange = 0;

	while((psource=GetNextArgument(psource,Variable,_countof(Variable),Argument,_countof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"dw_WebPort") != NULL) {
			strncpy_s(web_port,_countof(web_port),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_RestrictIP") != NULL) {
			strncpy_s(remote_struct.str_RestrictIP,_countof(remote_struct.str_RestrictIP),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_Password") != NULL) {
			if(strcmp(Argument,remote_struct.str_Password)!=0) {
				// Changed
				// mD5 things here.
				strncpy_s(remote_struct.str_Password,_countof(remote_struct.str_Password),MD5String(Argument),_TRUNCATE);
			}
		}
		if (strstr(Variable,"dw_Password") != NULL)	{
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_Password = 1;
			} else {
				remote_struct.dw_Password = 0;
			}
		}
		if (strstr(Variable,"dw_Restrict") != NULL)
		{
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_Restrict = 1;
			} else {
				remote_struct.dw_Restrict = 0;
			}
		}
		if (strstr(Variable,"dw_PortChange") != NULL)
		{
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_WebPortChange = 1;
			} else {
				remote_struct.dw_WebPortChange = 0;
			}
		}
	}

	remote_struct.dw_WebPort = atoi(web_port);
	if ((remote_struct.dw_WebPort < 1) || (remote_struct.dw_WebPort > 65535))
	{
		strncat_s(dest,size,"The Web Port value must be between 1 and 65535. Use the 'back' button to change the value.",_TRUNCATE);
	} else {
		// Check remote_struct.str_Password against the existing password.
		
		dw_error = Write_Remote_Registry(&remote_struct);
		if (dw_error != 0)
		{
			strncat_s(dest,size,"Remote Control Values have NOT been changed. Report error: ",_TRUNCATE);
			//**********PUT AN ERROR CODE IN HERE
		} else {
			strncat_s(dest,size,"Remote Control Values have been changed.",_TRUNCATE);
		}
	}
	return(0);
}


int Objective_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective;
	DWORD dw_objective_error = 0;
	int i_objective_count = 0;
	char str_obj_count[10];
	char str_match_metachar_remove[SIZE_OF_GENERALMATCH*2];


	strncpy_s(dest,size,"<form method=get action=setobjective><H2><CENTER>SNARE Filtering Objectives Configuration</H2>",_TRUNCATE);
		
	dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
	if (dw_objective_error == 0)
	{
		strncat_s(dest,size,"<br>The following filtering objectives of the SNARE unit are active:<br><br>" \
		"<table  width=100% border=1>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFBB><center><td width=10%><b>Action Required</b></td>" \
			        "<td width=10%><b>User Include/Exclude</b></td><td><b>Search Term</b></td></center></tr>",_TRUNCATE);

		while (dw_objective_error == 0)
		{
			_itoa_s(i_objective_count,str_obj_count,10);		
			
			if ((i_objective_count%2) == 0)
				strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td><input type=submit name=",_TRUNCATE);
			else
				strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td><input type=submit name=",_TRUNCATE);

			strncat_s(dest,size,str_obj_count,_TRUNCATE);
			strncat_s(dest,size," value=Delete>     ",_TRUNCATE);

			strncat_s(dest,size,"<input type=submit name=",_TRUNCATE);
			strncat_s(dest,size,str_obj_count,_TRUNCATE);
			strncat_s(dest,size," value=Modify>",_TRUNCATE);
			strncat_s(dest,size,"</td><td>",_TRUNCATE);


			// Debracket the strings in here. For HTML display purposes, the HTML metacharacters
			// need to be replaced. This is done with the "debracket" routine.
			// Note that the new strings are allowed to be twice as long as the real strings

			debracket(reg_objective.str_match,str_match_metachar_remove,SIZE_OF_GENERALMATCH*2);

			if(reg_objective.dw_match_type!=0) {
				strncat_s(dest,size,"Exclude",_TRUNCATE);
			} else {
				strncat_s(dest,size,"Include",_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>",_TRUNCATE);
			
			if (strlen(reg_objective.str_match) == 0) {
				strncat_s(dest,size,"&nbsp",_TRUNCATE);
			} else {
				strncat_s(dest,size,str_match_metachar_remove,_TRUNCATE);
			}
		
			strncat_s(dest,size,"</td></tr>",_TRUNCATE);

			i_objective_count++;
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		}
		strncat_s(dest,size,"</table><br>",_TRUNCATE);
	} else {
		strncat_s(dest,size,"<br>There are no current filtering objectives active.<br><br>",_TRUNCATE);
	}

	strncat_s(dest,size,"Select this button to add a new objective.  ",_TRUNCATE);
	strncat_s(dest,size,"<input type=submit name=0",_TRUNCATE);
	strncat_s(dest,size," value=Add>",_TRUNCATE);

	return(0);
}

int Objective_Display(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective;
	DWORD dw_objective_error = 0, dw_objective_write_error = 0,dw_objective_delete_error = 0;
;
	char str_objerr[10];
	int i_set=0,i_objective_count = 0,i_type = 0;
	char *psource=source, Variable[100], Argument[100];
	char str_temp[20], str_temp_objective[10];
	

	//This function will display an existing, or a blank, objective
	strncpy_s(dest,size,"<form method=get action=changeobjective><h2><center>SNARE Filtering Objective Configuration</h2>",_TRUNCATE);

	//Determine whether the objective will be modified or deleted
	while((psource=GetNextArgument(psource,Variable,_countof(Variable),Argument,_countof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Argument,"Delete") != NULL)
		{
			sscanf_s(Variable,"%20[^?]?%10[^\n]\n",str_temp, _countof(str_temp),str_temp_objective,_countof(str_temp_objective));
			i_type = 0;
			break;
		}
		if (strstr(Argument,"Modify") != NULL)
		{
			sscanf_s(Variable,"%20[^?]?%10[^\n]\n",str_temp, _countof(str_temp),str_temp_objective,_countof(str_temp_objective));
			i_type = 1;
			break;
		}
		if (strstr(Argument,"Add") != NULL)
		{
			strncpy_s(str_temp_objective,_countof(str_temp_objective),"-2",_TRUNCATE);
			i_type = 2;
			break;
		}
	}

	//Extract the objective number. I have to do this stuff, because atoi returns 0 if it cannot convert the string
	if (strcmp(str_temp_objective,"0") == 0)
		i_objective_count = -1;
	else
		i_objective_count = atoi(str_temp_objective);

	//If the objective number could not be successfully extracted, return immediately.
	if (i_objective_count == 0)
	{
		strncat_s(dest,size,"<br><b>NOTE: It appears the URL is encoded incorrectly.",_TRUNCATE);
		return 0;
	}

	if (i_objective_count == -1)
		i_objective_count = 0;
		
	//If the objective is being modified or added
	if (i_type > 0) {
		if (i_type == 1) {
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		} else {
			strncpy_s(reg_objective.str_match,_countof(reg_objective.str_match),"*",_TRUNCATE);
			strncpy_s(reg_objective.str_match_type,_countof(reg_objective.str_match_type),INCLUDE,_TRUNCATE);
		}

		// Will display an error if unable to completely read from the registry
		if (dw_objective_error > 0) {
			dw_objective_error += WEB_READ_OBJECTIVE_ERROR_CODE;
			_itoa_s(dw_objective_error,str_objerr,10);
	
			_snprintf_s(dest,size,_TRUNCATE,"%s<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
						"may be used.<br> Report error: %s</b><br>",dest,str_objerr);
		}

		strncat_s(dest,size,"<br>The following parameters of the SNARE objective may be set:<br><br>" \
			"<table  width=100% border=0>",_TRUNCATE);

		//Identify the high level event. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		_snprintf_s(dest,size,_TRUNCATE,"%s<tr bgcolor=#FFFFBB><td>General Search Term<br><i>Wildcards accepted</i></td>"
			"<td><input type=text name=str_match size=50 value=\"%s\"></td></tr>",dest,reg_objective.str_match);

		_snprintf_s(dest,size,_TRUNCATE,"%s<tr bgcolor=#FFFFCC><td>Select the User Match Type</td><td>"
			"<input type=radio name=str_match_type value=%s%s>Include    "
			"<input type=radio name=str_match_type value=%s%s>Exclude    </td></tr>",
			dest,INCLUDE, (strstr(reg_objective.str_match_type,INCLUDE)?" checked":""),EXCLUDE,(strstr(reg_objective.str_match_type,EXCLUDE)?" checked":""));

		//Identify the event type to capture. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		//Identify the log type to capture. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		_snprintf_s(dest,size,_TRUNCATE,"%s</table><br>"
			"<input type=hidden name=objnumber value=%s>"
			"<input type=submit value=\"Change Configuration\">    "
			"<input type=reset value=\"Reset Form\"></form>",dest,str_temp_objective);
	} else {
		dw_objective_delete_error = Delete_Objective(i_objective_count);
		i_objective_count++;
		dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		while (dw_objective_error == 0)
		{
			dw_objective_write_error = Write_Objective_Registry(i_objective_count-1,&reg_objective);
			dw_objective_delete_error = Delete_Objective(i_objective_count);
			i_objective_count++;
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		}

		if (dw_objective_delete_error == 0) {
			strncat_s(dest,size,"<br>The objective has been deleted.",_TRUNCATE);
		} else {
			strncat_s(dest,size,"<br>The objective was unable to be deleted.",_TRUNCATE);
			//***REPORT AN ERROR
		}
	}
	
	return(0);
}


int Objective_Result(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective, reg_objective_read;
	// DWORD dw_objective_error = -1;
	DWORD dw_objective_error = 0;

	int i_objective_count = 0,i_objective = 0, i_event_type_set = 0, i_event_type_log_set = 0;
	char str_obj_count[10];
	char *psource=source, Variable[100], Argument[100];

	strncpy_s(dest,size,"<form method=get action=setobjective><H2><CENTER>SNARE Filtering Objectives Configuration</H2>",_TRUNCATE);

	while((psource=GetNextArgument(psource,Variable,_countof(Variable),Argument,_countof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_match_type") != NULL) {
			strncpy_s(reg_objective.str_match_type,_countof(reg_objective.str_match_type),Argument,_TRUNCATE);
			continue;
		}
		if (strstr(Variable,"str_match") != NULL) {
			strncpy_s(reg_objective.str_match,_countof(reg_objective.str_match),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"objnumber") != NULL) {
			strncpy_s(str_obj_count,_countof(str_obj_count),Argument,_TRUNCATE);
		}
	}

	if(!dw_objective_error) {
		i_objective = atoi(str_obj_count);
		
		//-2 = "Add a new objective", hence we must go to the end of the list.
		if (i_objective == -2)
		{
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective_read);
			while (dw_objective_error == 0)
			{
				i_objective_count++;
				dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective_read);
			}
			i_objective = i_objective_count;
		}

		dw_objective_error = Write_Objective_Registry(i_objective,&reg_objective);
		if (dw_objective_error  == 0)
			strncat_s(dest,size,"<br>The objective has been modifed/added.",_TRUNCATE);
		else
			strncat_s(dest,size,"<br>The objective was unable to be modifed/added.",_TRUNCATE);
			//***REPORT AN ERROR
	}

	return(0);
}


int DefaultHeader(char *source, char *dest, int size, int refreshflag)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy_s(dest,size,"<HTML><head>" \
	"<title>InterSect Alliance - Information Technology Security</title>" \
	"<meta name=\"TITLE\" content=\"InterSect Alliance - Information Technology Security\">" \
	"<style type=\"text/css\">\n" \
	"body {\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" font-size: 10px; font-weight: normal;\n" \
	" margin: 0px;\n" \
	"}\n" \
	"h1 {\n" \
	" font-size: 30px;\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" color: white;\n" \
	"}\n" \
	"h2 {\n" \
	" font-size: 30px;\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" color: black;\n" \
	"}\n" \
	"font {\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" text-decoration: none; font-size: 10px;\n" \
	" font-weight: normal;\n" \
	"}\n" \
	"table {\n" \
	" margin: 0px; padding: 0px;\n" \
	"}\n" \
	"td {\n" \
	" font-size: 75%;\n" \
	"}\n" \
	"</style>\n" \
	"<meta HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">" \
	"<meta HTTP-EQUIV=\"Expires\" CONTENT=\"-1\">" ,_TRUNCATE);
	if (refreshflag) strncat_s(dest,size,"<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"10\">",_TRUNCATE);
	strncat_s(dest,size,"</head>" \
	"<body text=black bgcolor=white link=#000066 vlink=#000044 alink=#000055>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=3 width=100%>" \
	"<tbody>" \
    "<tr>" \
    "<td height=70><img src=/intersect.gif alt=\"InterSect\" width=205 height=70 hspace=20 vspace=0 border=0 align=Right>" \
    "</td>" \
    "<td height=70 width=1% bgcolor=#eeeeee><br></td>" \
	"<td height=70 width=1% bgcolor=#dddddd><br></td>" \
	"<td height=70 width=1% bgcolor=#cccccc><br></td>" \
	"<td height=70 width=1% bgcolor=#ccbbbb><br></td>" \
	"<td height=70 width=1% bgcolor=#ccaaaa><br></td>" \
	"<td height=70 width=1% bgcolor=#cc9999><br></td>" \
	"<td height=70 width=1% bgcolor=#cc8888><br></td>" \
	"<td height=70 width=1% bgcolor=#cc7777><br></td>" \
	"<td height=70 width=1% bgcolor=#cc6666><br></td>" \
	"<td height=70 width=1% bgcolor=#cc5555><br></td>" \
	"<td height=70 width=1% bgcolor=#cc4444><br></td>" \
	"<td height=70 width=1% bgcolor=#cc3333><br></td>" \
	"<td height=70 width=1% bgcolor=#cc2222><br></td>" \
	"<td height=70 width=1% bgcolor=#cc1111><br></td>" \
	"<td height=70 width=86% bgcolor=#cc0000><div align=right><center><h1>Epilog for Windows&nbsp;</h1></center></div></td>" \
    "</tr>" \
    "</tbody>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=1 width=100%>" \
    "<tr><td height=3 border=0 bgcolor=white width=100%></td></tr>" \
    "<tr><td height=3 border=0 bgcolor=black width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=#AAAAAA width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=white width=100%></td></tr>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=5 columns=2 width=100% height=100%>" \
	"<tbody>" \
    "<tr>" \
      "<td valign=Top width=20% bgcolor=#cc0000>" \
      "<div align=Center><font color=#ffffff>" \
      "<br>" \
      "<font face=\"Helvetica,Arial,sans-serif\" size=-1><B>" \
      "<br><A HREF=\"/eventlog\" style=\"color:FFFFFF;text-decoration:none\">Latest Events</A><br>" \
      "<br><A HREF=\"log\" style=\"color:FFFFFF;text-decoration:none\">Log Configuration</A><br>\n" \
      "<br><A HREF=\"/network\" style=\"color:FFFFFF;text-decoration:none\">Network Configuration</A><br>" \
      "<br><A HREF=\"/remote\" style=\"color:FFFFFF;text-decoration:none\">Remote Control Configuration</A><br>" \
      "<br><A HREF=\"/objective\" style=\"color:FFFFFF;text-decoration:none\">Objectives Configuration</A><br>" \
      "<br><A HREF=\"/status\" style=\"color:FFFFFF;text-decoration:none\">View Audit Service Status</A><br>" \
	  "<br><A HREF=\"/restart\" style=\"color:FFFFFF;text-decoration:none\">Apply the Latest Audit Configuration</A><br>" \
	  "</div>" \
      "</b></font>" \
      "<br>" \
      
    "</td>" \
    "<td width=100% valign=Top>" \
     "<table cellpadding=0 cellspacing=10 border=0 width=100%>" \
      "<tbody>" \
       "<tr>" \
        "<td valign=Top align=Justify>",_TRUNCATE);
//   This line is used for SnareApache and SnareSquid support.
//      "<br><A HREF=\"switch\" style=\"color:FFFFFF;text-decoration:none\">Switch Configuration Files</A><br>\n" \

	return(0);
}

int DefaultFooter(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy_s(dest,size,"</td>" \
		"</tr>" \
		"</tbody>" \
		"</table>" \
		"</body><center>" \
		"<BR><BR><FONT SIZE=-1 face=helvetica>(c) <A HREF=\"http://www.intersectalliance.com\">Intersect Alliance</A> Pty Ltd 1999-2007. " \
		"This site is powered by <A HREF=\"http://www.intersectalliance.com/projects/\">SNARE for Windows.</A></FONT>" \
		"</center></html>",_TRUNCATE);

	return(0);
}

int Restart(char *source, char *dest, int size, HANDLE event)
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy_s(dest,size,"<HTML><BODY><H2><CENTER>Reapply the Latest Configuration</H2><P>Snare Objectives have been reapplied to the running system.</CENTER></BODY></HTML>",_TRUNCATE);

	// Notify the main thread that we want to reapply config changes
	SetEvent(event);

    return(0);
}

HRESULT VarToBytes(VARIANT Variant,LPBYTE *bytes,long *plcb)
{
    HRESULT hr = E_FAIL;
    SAFEARRAY *pArrayVal = NULL;
    CHAR HUGEP *pArray = NULL;

	if(!plcb) {
		return(hr);
	}

    // Retrieve the safe array....
    pArrayVal = Variant.parray;
	
    if (pArrayVal != NULL) {
		long cSize;

		if(!Variant.parray->rgsabound) {
			if(SNAREDEBUG) { DebugMsg("WARNING: Variant array is corrupted. I'm not touching it."); }
			return(E_FAIL);
		}

		// try / catch
		try {
			cSize = pArrayVal->rgsabound[0].cElements;
		} catch(...) {
			if(SNAREDEBUG) { DebugMsg("CRASH: cSize grab failed. Some null-pointer wierdness going on here."); }
			return(E_FAIL);
		}

		// Just a small 'what the?' check
		if(cSize > 16384 || cSize <= 0) {
			if(SNAREDEBUG) { DebugMsg("Size: %d is just plain silly. Must be a corruption. Exiting",cSize); }
			return(E_FAIL);
		}

        *bytes = (LPBYTE)malloc( cSize );

        if( *bytes == NULL ) return E_FAIL;

        hr = SafeArrayAccessData(pArrayVal, (void HUGEP * FAR *) &pArray);
        if (SUCCEEDED(hr)) {
            // Copy the bytes to the safe array.
		    memcpy( *bytes, pArray, cSize );
		    SafeArrayUnaccessData( pArrayVal );
            *plcb = cSize;
            hr = S_OK;
        } else {
			// Clean up
			free(*bytes);
			return(E_FAIL);
		}
    } else {
        hr = E_OUTOFMEMORY;
    }

    return hr;
}


// Lets go about this VERY differently. It appears that getting a users group membership
// is relatively easy. Lets work backwards from that.
//
// General instructions:
// $ expr `./base64 intersect.gif | wc -c` - `./base64 intersect.gif | wc -l` "*" 2 + 1
//   2029
// ./base64 intersect.gif | sed 's/^/   "/' | sed 's/.$/"  \\/' >out.txt
// 
//  mangle out.txt as appropriate - add the (wc -c) - ((wc -l)*2) + 1 figure to the buffer size.
int InterSectImage(char *source, char *dest, int size)
{
	char IntersectGif[2029];
	char temp[2029];
	int size2;

	strncpy_s(IntersectGif,2029,"R0lGODlhzQBGALMAAB8aF01JR2toZtwrGYF+fONVRo+Mi5eWleuCePKzrLOysszLy/jRzunl" \
	    "5f////j29SwAAAAAzQBGAEAI/gAdCBxIsKDBgw4eIFxIUCHDhxAjSkT4AMGAAQgmatw40CHH" \
	    "jxs9ghQJsuTEBxdTpkxgsqXLlzBjyvyoMuXMmzAB6NQp0MDOnzoDkOz504ADn0CTAniAVOlO" \
		"oQqcSgVqdKpVAARrXiyA0+XQkkCJ7jRakMDPAA3MjmUYtikAsgfV6lTw9WFYgwKACj34gIFW" \
		"jF0DCx5MeGPUsw08WtTKMqFcAGgZNghQ9ChQAQ1Kuq36s7DnzxL7/kXw4DFah6gFpk4o8ADV" \
		"Bwpjs45d1/Lau6Bz6y5YQCvXmbV3Cx++MUHvvxcZHFSgoOGB5g4WGFhAfUFmAwqqL2i94EGD" \
		"AwSZ/nNXreDA9gXmq5vvmb165sDBIcYnfjAB8gLz6ev3up+ifa0i5VeYgCEtROBIsyUIm0Gy" \
		"seZgbatFqNqEBB2nUkb9BXbXZgJN9hN0YukE10FtVYbQY1clxVmKSjW0WE0HZijRhiYetIBS" \
		"AdjVGYcUPZAXi0Bth9tBHv4EnkEWqjQUU5SxKMB2HTEFpJBXrTiVjFhO9F9NGKIIpE7g8ahZ" \
		"ZUNmaeZGL6rUkQJNfgllQmyyCKJBHJZ55p0LNZBkSr8VhN4D66mGnkGBEjRdRwcUetQB7zmw" \
		"HnraBYqddo3ieecDe2IUo6WcdtrRlkp6KuqoqmH6F34ZbkrqpZkOoOqq/7DqZmpNjcVqK55/" \
		"VSrjqyR2BmdSkSHEoVtS2TbVXkV+CQB0yho5EKgp6XorQmFJudZjBJAkZq87GfvWQo/NKWyN" \
		"8jnQwJDQXlTrtNT6KuYDN/6UmLcjGlTiWic2K68D+s5VEEq+Ycmrve6S21GbKrK1o8Edndsv" \
		"AN3ZqRrCAAiAUJopKcfuTQ0oYMChGwsU709vCuRXwAMl2+x7FF9FpVVWFhsyfMRaPBByDj0m" \
		"wMc898wzwgZYK2JLdfo6s4ytKqSzz0z3zGiIbw1cdLdH75rpbz/qC2XWci40NU9Vy4jxRWGX" \
		"/dnYA6zLWgPW8fUvTEtS5KDZoD2QLp/LpYceiP6DFqRoT1B+pxBzDk33HV2PHkloon/TLRhy" \
		"KzkuuWB9JYnh5C8N7OndgOmnOeaUN3DfgqCb9DmenDd6eulho315qpfSLRpjq7NOd6av244g" \
		"f2f+RXpH+9UON+h/6W78RpmqPXfIuMHbZAAEzMvXsCkKLdVesBnQslRPDtSv4g6MjWqWtd/l" \
		"MLDSQm0UsU5565RQD2zPYmYPL9XhXwl4JHx/NJ71k83A2xbBuiVAgpgmfSkDmmGGhLb9Yal/" \
		"Q3MAwsBHL4URkGEDWVrTeqbADW6QYvo7FfliAsFvdShIhcOg9xaGr7jUDzwPyxFB7pY/s5Ww" \
		"XocJynVUKJB7RZBBGv70oNPeQxWfcU1E3TlIAx24nxsy6IhUsSBPCphBxDyIQqvpodEKckQZ" \
		"HkSEsMtJwVpYkPMlpWQDnCIPHQDFKfFri2WkWL1MNpoeXfGOEIINbRS0PBKO8YfL0QsCV3hB" \
		"MiIkTsqKGBwNYkZ/FQRtDBCJyoAEovi56QEpiln7jheRHO4EjUkbiCebZZSRTQmTVXqjVTg5" \
		"EdecxSMnq0mfwgUR6j1FamRaJCs5ogAC9OxNaGuMl760vqLg8ja63CXcTqW0+u3QkBz5GlaU" \
		"2RVIluZDH3GLAAg0FGlSsysA45K56tedRqaILuNCJtW+eRPxqaaNKUqiJSlZF2+ys53FA6ne" \
		"PY3nzgLtM2TeqeM/jxdLGDHIY+Jim0GsQ5K2pQyNDhVZZuClnTdVlKED1UhsGNCqAWjMOdsp" \
		"j0ekQyc0OupNzBHcQJ5zKECdZ0QONQ8TOVkRyA1AV94xAOMSZYD3DEokMvVbEj2203mt5wHM" \
		"OVTfBJId7ugvoxJBm0qUZ66IdqhtbKNUdCoq0ehUCl6ZsWrbKKodh1x0kFAliFQL8NG0lm5L" \
		"CJAe3QICADs=",_TRUNCATE);

	size2=base64decode (temp, IntersectGif);

	memcpy(dest,temp,size2);
	return(size2);
}

int debracket(char *source, char *dest, int length)
{
	//This routine is simply to replace the HTML metacharacters "<" and ">" with
	// "&lt;" and "&gt;". That's all!

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) return(1);

      while(*source) {
              if(*source == '<') {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='l'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } else if(*source == '>') {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='g'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } else {
                      if(count < length) { *dest=*source; dest++; count++;}
              }
              source++;
      }
      *dest='\0';

	  dest=copyofdest;

      return(0);
}

int Display404(SOCKET http_socket)
{
	char HTTPBuffer[512];
	// Overwrite HTTPBuffer with the header data.
	strncpy_s(HTTPBuffer,_countof(HTTPBuffer), "HTTP/1.0 404 Not Found\r\n" \
						"Server: SNARE/1.0\r\n" \
						"MIME-version: 1.0\r\n" \
						"Content-type: text/html\r\n\r\n" \
						"<html><body><center><h2>Page Not Found</h2></center></body></html>",
			_TRUNCATE);

	return(send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0));
}

int DisplayTextHeader(SOCKET http_socket)
{
	char HTTPBuffer[512];
	// Overwrite HTTPBuffer with the header data.
	strncpy_s(HTTPBuffer,_countof(HTTPBuffer), "HTTP/1.0 200 OK\r\n" \
						"Server: SNARE/1.0\r\n" \
						"MIME-version: 1.0\r\n" \
						"Content-type: text/plain\r\n\r\n",
			_TRUNCATE);
	return(send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0));
}

int Log_Config(char *source, char *dest, int size)
{
	Reg_Log log_struct;
	int i_log_count= 0;
	DWORD dw_log_error;
	char str_log_count[10];
	char str_name_metachar_remove[MAX_AUDIT_CONFIG_LINE * 2];
	char str_format_metachar_remove[MAX_AUDIT_CONFIG_LINE * 2];

	FILE *configfile = (FILE *) NULL;

	if (!source || !dest || !size) {
		return(0);
	}

	strcpy_s(log_struct.name, _countof(log_struct.name), "");
	strcpy_s(log_struct.type, _countof(log_struct.type), "");

	strncpy_s(dest,size,
		"<form action=setlog><H2><CENTER>SNARE Log Configuration</H2>",
		_TRUNCATE);

	dw_log_error = Read_Log_Registry(i_log_count,&log_struct);
	if (dw_log_error == 0)
	{
		strncat_s(dest,size,
			"<br>The following log files are being monitored by SNARE:<br><br>"
			"<table  width=100% border=1>", _TRUNCATE);

		strncat_s(dest,size,
			"<tr bgcolor=#FFFFBB><center><td width=\"10%\"><b>Action Required</b></td><td width=\"20%\"><b>Log Type</b></td>"
			"<td width=\"50%\"><b>Log File or Directory</b></td>"
			"<td width=\"20%\"><b>Log File Format</b></td>"
			"</center></tr>", _TRUNCATE);

		while (dw_log_error == 0) {
			_snprintf_s(str_log_count, 10, _TRUNCATE, "%d", i_log_count);

			if ((i_log_count) == 0)
				strncat_s(dest,size,
					"<tr bgcolor=#FFFFCC><td><input type=submit name=",
					_TRUNCATE);
			else
				strncat_s(dest,size,
					"<tr bgcolor=#FFFFBB><td><input type=submit name=",
					_TRUNCATE);

			strncat_s(dest,size, str_log_count, _TRUNCATE);
			strncat_s(dest,size, " value=Delete>     ",
				_TRUNCATE);

			strncat_s(dest,size, "<input type=submit name=",
				_TRUNCATE);
			strncat_s(dest,size, str_log_count, _TRUNCATE);
			strncat_s(dest,size, " value=Modify>", _TRUNCATE);
			strncat_s(dest,size, "</td><td>", _TRUNCATE);

			strncat_s(dest,size, log_struct.type,
				_TRUNCATE);
			strncat_s(dest,size, "</td><td>", _TRUNCATE);

			// Debracket the strings in here. For HTML display purposes, the HTML metacharacters
			// need to be replaced. This is done with the "debracket" routine.
			// Note that the new strings are allowed to be twice as long as the real strings
			debracket(log_struct.name,
				  str_name_metachar_remove,
				  MAX_AUDIT_CONFIG_LINE * 2);
			debracket(log_struct.format,
				  str_format_metachar_remove,
				  MAX_AUDIT_CONFIG_LINE * 2);

			if (strlen(log_struct.name) == 0) {
				strncat_s(dest,size, "&nbsp", _TRUNCATE);
			} else {
				strncat_s(dest,size, str_name_metachar_remove,
					_TRUNCATE);
			}
			strncat_s(dest,size, "</td><td>", _TRUNCATE);

			if (strlen(log_struct.format) == 0) {
				strncat_s(dest,size, "&nbsp", _TRUNCATE);
			} else {
				strncat_s(dest,size, str_format_metachar_remove,
					_TRUNCATE);
			}
			strncat_s(dest,size, "</td></tr>", _TRUNCATE);

			i_log_count++;
			dw_log_error = Read_Log_Registry(i_log_count,&log_struct);
		}
		strncat_s(dest,size, "</table><br>", _TRUNCATE);
	} else {
		strncat_s(dest,size,
			"<br>There are no current log monitors active.<br><br>",
			_TRUNCATE);
	}

	strncat_s(dest,size, "Select this button to add a new log monitor.  ",
		_TRUNCATE);
	strncat_s(dest,size, "<input type=submit name=0", _TRUNCATE);
	strncat_s(dest,size, " value=Add>", _TRUNCATE);

	return (0);
}

int Log_Display(char *source, char *dest, int size)
{
	Reg_Log log_struct;
	int dw_log_error = 0, dw_log_delete_error = 0, dw_log_write_error = 0;
	char str_logerr[10];
	int i_log_count = 0, i_type = 0, i;
	char *psource = source, Variable[100], Argument[100];
	char str_temp[20], str_temp_log[10];
	int selected=0,log_type_count = 9;		// Don't forget to change this when adding new types
	char str_log_type_count[10];
	char *str_value[] = {"GenericLog", "ApacheLog", "ExchMTLog", "IISWebLog", "ISAFWSLog", "ISAWebLog", "MSProxySvr", "SMTPSvcLog", "SquidProxyLog"};
	char *str_descr[] = {"Generic log format (default)", "Apache web logs", "Exchange message tracking logs", "Microsoft IIS web server logs", "Microsoft ISA firewall logs", "Microsoft ISA web logs", "Microsoft proxy server logs", "Microsoft SMTP logs", "Squid proxy logs"};

	// This function will display an existing, or a blank, log
	strncpy_s(dest,size,
		"<form action=changelog name=monitor><h2><center>SNARE Log Configuration</h2>",
		_TRUNCATE);

	// Determine whether the log will be modified or deleted
	while ((psource =
		GetNextArgument(psource, Variable, _countof (Variable), Argument,
				_countof (Argument))) != (char *) NULL) {
		if (strstr(Argument, "Delete") != NULL) {
			sscanf_s(Variable, "%20[^?]?%10[^\n]\n", str_temp,_countof(str_temp),
			       str_temp_log,_countof(str_temp_log));
			i_type = 0;
			break;
		}
		if (strstr(Argument, "Modify") != NULL) {
			sscanf_s(Variable, "%20[^?]?%10[^\n]\n", str_temp,_countof(str_temp),
			       str_temp_log,_countof(str_temp_log));
			i_type = 1;
			break;
		}
		if (strstr(Argument, "Add") != NULL) {
			strncpy_s(str_temp_log,_countof (str_temp_log), "-2",_TRUNCATE);
			i_type = 2;
			break;
		}
	}

	// Extract the log number. I have to do this stuff, because atoi returns 0 if it cannot convert the string
	if (strcmp(str_temp_log, "0") == 0)
		i_log_count = -1;
	else
		i_log_count = atoi(str_temp_log);

	// If the log number could not be successfully extracted, return immediately.
	if (i_log_count == 0) {
		strncat_s(dest,size,
			"<br><b>NOTE: It appears the URL is encoded incorrectly.",
			_TRUNCATE);
		return 0;
	}

	if (i_log_count == -1)
		i_log_count = 0;

	// If the log is being modified or added
	if (i_type > 0) {
		if (i_type == 1) {
			dw_log_error = Read_Log_Registry(i_log_count,&log_struct);
		} else {
			// Defaults
			strncpy_s(log_struct.name, _countof(log_struct.name), "",_TRUNCATE);
			strncpy_s(log_struct.type, _countof(log_struct.type), "GenericLog",_TRUNCATE);
			strncpy_s(log_struct.format, _countof(log_struct.format), "",_TRUNCATE);
		}

		// Will display an error if unable to completely read from the config file
		if (dw_log_error > 0) {
			dw_log_error += WEB_READ_LOG_ERROR_CODE;
			_snprintf_s(str_logerr, 10, _TRUNCATE, "%d", dw_log_error);

			strncat_s(dest,size,
				"<br><b>NOTE: Some errors were encountered in reading the configuration file. Default values "
				"may be used.<br> Report error: ",
				_TRUNCATE);
			strncat_s(dest,size, str_logerr, _TRUNCATE);
			strncat_s(dest,size, "</b><br>", _TRUNCATE);
		}

		strncat_s(dest,size,
			"<br>The following parameters of the SNARE log inputs may be set:<br><br>"
			"<table  width=100% border=0>", _TRUNCATE);

		_itoa_s(log_type_count,str_log_type_count,_countof(str_log_type_count),10);
		strncat_s(dest,size,
			"<tr bgcolor=#FFFFCC><td>Select the Log Type</td><td><select name=str_log_type "
			"OnChange=\"if (document.monitor.str_log_type.selectedIndex == ",
			_TRUNCATE);
		strncat_s(dest,size, str_log_type_count, _TRUNCATE);
		strncat_s(dest,size,
			") {alert('WARNING: SNARE Server only supports certain log types');document.monitor.custom_log_type.disabled = false;"
			"} else {"
			"document.monitor.custom_log_type.disabled = true;}\">",
			_TRUNCATE);

		for (i = 0; i < log_type_count; i++) {
			strncat_s(dest,size, "<option value=", _TRUNCATE);
			strncat_s(dest,size, str_value[i], _TRUNCATE);
			if (strncmp(str_value[i], log_struct.type, MAX_AUDIT_CONFIG_LINE) == 0) {
				strncat_s(dest,size, " selected>", _TRUNCATE);
				selected = 1;
			} else {
				strncat_s(dest,size, ">", _TRUNCATE);
			}
			strncat_s(dest,size, str_descr[i], _TRUNCATE);
		}
		_snprintf_s(dest,size, _TRUNCATE, "%s<option value=Other%s>Custom Event Log",dest,(selected?"":" selected"));

		/*if (strcmp(log_struct.str_general_match, ".*") == 0) {
			strncat_s(dest,size, " checked", _TRUNCATE);
			strncpy_s(log_struct.str_general_match_type, _countof(log_struct.str_general_match_type), "Any",_TRUNCATE);
		}
		strncat_s(dest,size, ">Match Any String    ", _TRUNCATE);
		*/
		_snprintf_s(dest,size, _TRUNCATE, "%s</select><input name=custom_log_type value=\"%s\"%s /></td></tr>"
			"<tr bgcolor=#FFFFBB><td>Log File or Directory<br></td><td>"
			"<input type=text name=str_log_name size=50 value=\"%s\"></td></tr>"
			"<tr bgcolor=#FFFFBB><td>Log Name Format:<br />(optional) ",dest,(selected?"":log_struct.type),(selected?" disabled":""),log_struct.name);
//DMM
		strncat_s(dest,size,"<a href=\"javascript:void(0)\" onClick=\"myWindow = window.open('', 'tinyWindow', 'width=350,height=300'); "
					"myWindow.document.write('<html><body><p>A percent sign (%) is used the represent the date format YYMMDD. Wildcards are acceptable.</p>"
					"<p>e.g. log names like ISALOG_20060913_WEB_000.w3c would be represented as ISALOG_20%_WEB_*.w3c).</p>"
					"If this field is not defined, the first matching entry will be used (this is fine in most cases).</body></html>'); "
					"myWindow.document.close();"
					"\">Help</a>", _TRUNCATE);

		_snprintf_s(dest,size, _TRUNCATE,"%s</td><td><input type=text name=str_log_format size=50 value=\"%s\"></td></tr>"
			"</table><br>"
			"<input type=hidden name=lognumber value=%s>"
			"<input type=submit value=\"Change Configuration\">    "
			"<input type=reset value=\"Reset Form\"></form>",dest,log_struct.format, str_temp_log);
	} else {

		dw_log_delete_error = Delete_Log(i_log_count);
		i_log_count++;
		dw_log_error = Read_Log_Registry(i_log_count,&log_struct);
		while (dw_log_error == 0)
		{
			dw_log_write_error = Write_Log_Registry(i_log_count-1,&log_struct);
			dw_log_delete_error = Delete_Log(i_log_count);
			i_log_count++;
			dw_log_error = Read_Log_Registry(i_log_count,&log_struct);
		}
		if (dw_log_delete_error == 0)
			strncat_s(dest,size,
				"<br><b>The log monitor has been removed<br><a href=\"log\">Return to Log display</a>.",
				_TRUNCATE);
		else
			strncat_s(dest,size,
				"<br>The log monitor was unable to be deleted.",
				_TRUNCATE);
	}

	return (0);
}

int Log_Result(char *source, char *dest, int size)
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Log log_struct, log_struct_read;
	int dw_log_error = 0;
	int i_log = 0, i_log_count = 0;
	char str_log_count[10];
	char *psource = source, Variable[100], Argument[512], CustomLogType[SIZE_OF_LOGNAME];

	strncpy_s(dest, size, "<form action=setlog><H2><CENTER>SNARE Log Configuration</H2>",_TRUNCATE);

	while ((psource =
		GetNextArgument(psource, Variable, _countof (Variable), Argument,
				_countof (Argument))) != (char *) NULL) {

		if (strstr(Variable, "str_log_name") != NULL) {
			strncpy_s(log_struct.name, _countof (log_struct.name), Argument,_TRUNCATE);
		}

		if (strstr(Variable, "str_log_format") != NULL) {
			strncpy_s(log_struct.format, _countof (log_struct.format), Argument,_TRUNCATE);
		}
		
		if (strstr(Variable, "lognumber") != NULL) {
			strncpy_s(str_log_count, _countof (str_log_count), Argument,_TRUNCATE);
		}

		if (strstr(Variable, "str_log_type") != NULL) {
			strncpy_s(log_struct.type, _countof (log_struct.type), Argument,_TRUNCATE);
		}

		if (strstr(Variable, "custom_log_type") != NULL) {
			strncpy_s(CustomLogType, _countof (CustomLogType), Argument,_TRUNCATE);
		}
	}
	
	if (!strcmp(log_struct.type,"Other")) {
		strncpy_s(log_struct.type, _countof (log_struct.type), CustomLogType,_TRUNCATE);
	}
	if (!dw_log_error) {

		i_log = atoi(str_log_count);

		//-2 = "Add a new log monitor"
		if (i_log == -2) {
			dw_log_error = Read_Log_Registry(i_log_count,&log_struct_read);
			while (dw_log_error == 0)
			{
				i_log_count++;
				dw_log_error = Read_Log_Registry(i_log_count,&log_struct_read);
			}
			i_log = i_log_count;
		}

		dw_log_error = Write_Log_Registry(i_log,&log_struct);

		if (dw_log_error == 0)
			strncat_s(dest,size, "<br>The log monitor has been modified/added.", _TRUNCATE);
		else
			strncat_s(dest,size, "<br>The log monitor was unable to be modified/added.", _TRUNCATE);
	}

	return (0);
}

int Current_Events(char *source, char *dest, int size)
{
	DWORD dwWaitRes=0;
	EventCache *myMsg=NULL;
	_snprintf_s(dest,size, _TRUNCATE,"<HTML><BODY><H2><CENTER>Current Events</H2></CENTER><P><center><br />");
	dwWaitRes = WaitForSingleObject(hMutex,500);
	strncat_s(dest,size,"<table border=1 cellspacing=0 cellpadding=2 width=\"99%\" bgcolor=\"white\">\n" \
		"<tr bgcolor=\"#ffffcc\"><td width=10%>Date</td><td width=10%>System</td><td width=10%>Type</td><td>Strings</td></tr>\n",_TRUNCATE);
	if(dwWaitRes == WAIT_OBJECT_0) {
		myMsg = MCHead;
		int i=0;
		for (myMsg = MCHead; myMsg && i < 20; myMsg = myMsg->next, i++) {
			if (myMsg->seenflag) {
				if (i%2) _snprintf_s(dest,size, _TRUNCATE,"%s<tr bgcolor=#FEFEFE>", dest);
				else _snprintf_s(dest,size, _TRUNCATE,"%s<tr bgcolor=#EEEEEE>", dest);
			} else {
				if (i%2) _snprintf_s(dest,size, _TRUNCATE,"%s<tr bgcolor=#DDFFDD>", dest);
				else _snprintf_s(dest,size, _TRUNCATE,"%s<tr bgcolor=#CCEECC>", dest);
			}
			_snprintf_s(dest,size, _TRUNCATE,"%s<td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", dest, myMsg->SubmitTime, myMsg->Hostname, myMsg->type, myMsg->msg);
			myMsg->seenflag=1;
		}
	}
	ReleaseMutex(hMutex);
	_snprintf_s(dest,size,_TRUNCATE,"%s</table></CENTER></BODY></HTML>",dest);
	return(0);
}