//#include "stdafx.h"   //Only required for the SNARE GUI
// Let us access the win2k+ apis if required
#define _WIN32_WINNT 0x500
#include <windows.h>
#include <winsvc.h>
#include <aclapi.h>
#include <stdio.h>
#include "support.h"


//Note that these functions are self contained, since they will need to be shared
//with the "web server".

//NOTE: Retrun value of 0 = SUCCESS
//		Return value of 1 to 4 = Higher End Registry Read/Write Failure
//		Return value > 4 = Lower End Registry Read/Write Failure
//Also, return values are in binary.

int Read_Config_Registry(Reg_Config *pRegistry_struct)
{
	char strclientname[SIZE_OF_CLIENTNAME]="";
	int i_return_val = 0;

	//Defaults to NULL if no hostname found, or key is out of bounds.
	if(!MyGetProfileString("Config","Clientname",strclientname,SIZE_OF_CLIENTNAME)) {
		strcpy_s(pRegistry_struct->str_ClientName,_countof(pRegistry_struct->str_ClientName),"");
		i_return_val += 1;
	} else {
		strncpy_s(pRegistry_struct->str_ClientName,SIZE_OF_CLIENTNAME,strclientname,_TRUNCATE);
	}

	return i_return_val;
}


int Read_Objective_Registry(int i_objective_number, Reg_Objective *pRegistry_struct)
{
	HKEY hKey;
	DWORD  dw_objective_bytes = SIZE_OF_AN_OBJECTIVE, dwRegType;
	char objective_buffer[SIZE_OF_AN_OBJECTIVE]="";
	char str_objective[SIZE_OF_AN_OBJECTIVE]="";
	int o_return_val = 0,i_type = 0,i_event_type_log = 0;
	char str_objective_to_read[20] = "",str_temp[5]=""; 
	char str_temp_general[SIZE_OF_GENERALMATCH+2]="";
  	char str_temp_match_type[SIZE_OF_MATCH_TYPE]="";
	long error_type=0;

	//_itoa_s_s(i_objective_number,str_temp,10);
	//strncat(str_objective_to_read,_countof(str_temp),str_temp,_TRUNCATE);
	_snprintf_s(str_objective_to_read,_countof(str_objective_to_read),_TRUNCATE,"Objective%d",i_objective_number);

	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME, 0, KEY_READ,&hKey ) 
		== ERROR_SUCCESS )	{
		error_type = RegQueryValueEx(hKey, str_objective_to_read, NULL, &dwRegType, 
		     (LPBYTE) objective_buffer, &dw_objective_bytes );
	  if ( error_type == ERROR_SUCCESS ) {
			// Reject any str_objective that is longer than 1056 chars
		  if ((dwRegType == REG_SZ) & (dw_objective_bytes <= SIZE_OF_AN_OBJECTIVE)) {
				strncpy_s( str_objective,dw_objective_bytes,objective_buffer,_TRUNCATE);
		  } else {
				// reject the str_objective and return immediately
				return (o_return_val + 1);
		  }
	  } else {
		  // Retain this error value as 4, since the error control in the other routines
		  // look for errors in the range 1 to 3.
		  return (o_return_val + 4);
	  }

	  // Close the registry key when done
	  RegCloseKey(hKey);
	  
    } else {
	   return (o_return_val + 2);
	}
	


	// NOTE: This line is TAB delimited.
	// Note str_general_temp is 514 bytes to allow for the two wildcard characters
	sscanf_s(str_objective,"%514[^\t]\t%4[^\n]\n",str_temp_general,_countof(str_temp_general),str_temp_match_type,_countof(str_temp_match_type));

	
	// Copy all the values to the struct

	//If the str_objective doesn't contain a valid user match type, assume it is "0"
	if (_stricmp(str_temp_match_type,"1") == 0) {
		strncpy_s(pRegistry_struct->str_match_type,SIZE_OF_MATCH_TYPE,EXCLUDE,_TRUNCATE);
		pRegistry_struct->dw_match_type = 1;
	} else {
		strncpy_s(pRegistry_struct->str_match_type,SIZE_OF_MATCH_TYPE,INCLUDE,_TRUNCATE);
		pRegistry_struct->dw_match_type = 0;
	}

	i_type = 0;


	// Remove the wildcard characters from the generla match temp string
	remove_wildcard_start_and_end(str_temp_general,pRegistry_struct->str_match,SIZE_OF_GENERALMATCH);

	// if the general search term is greater than 512 chars, reject the str_objective
	// Note that the statements below won't do much since the struct var should have been
	// throttled by the function to remove the wildcard chars
	// if (_countof(pRegistry_struct->str_match) < 513)
	//  strncpy_s(pRegistry_struct->str_match,SIZE_OF_GENERALMATCH,str_temp_general,_TRUNCATE);
	// else
	//  return (i_return_val += 512);

	return(o_return_val);
}

int Read_Network_Registry(Reg_Network *pRegistry_struct)
{
	char str_destination[SIZE_OF_DESTINATION] = "127.0.0.1";
	DWORD dw_Destination_port = 6161, dw_Destination_port_buffer = 6161;
	DWORD dw_SocketType = SOCKETTYPE_UDP; // UDP
	DWORD dw_Syslog = 1, dw_Syslog_buffer = 1;
	DWORD dw_Syslog_Dest = 13, dw_Syslog_Dest_buffer = 13;
	int i_return_val = 0;
  

	if(!MyGetProfileString("Network","Destination",str_destination,SIZE_OF_DESTINATION)) {
		strncpy_s(str_destination,SIZE_OF_DESTINATION,"127.0.0.1",_TRUNCATE);
		i_return_val += 1;
	}

	dw_Syslog_Dest=MyGetProfileDWORD("Network","SyslogDest",13);
	dw_Syslog=MyGetProfileDWORD("Network","Syslog",0);
	dw_Destination_port=MyGetProfileDWORD("Network","DestPort",6161);
	dw_SocketType=MyGetProfileDWORD("Network","SocketType",SOCKETTYPE_UDP);
	
	if(dw_Destination_port > 65535 || dw_Destination_port < 1) {
		dw_Destination_port = 6161;
		i_return_val += 4;
	}

	dw_SocketType=SOCKETTYPE_UDP;	// UDP

	// Write the values to the struct
	strncpy_s( pRegistry_struct->str_Destination,SIZE_OF_DESTINATION,str_destination,_TRUNCATE);
	pRegistry_struct->dw_SyslogDest = dw_Syslog_Dest;
	pRegistry_struct->dw_Syslog = dw_Syslog;
	pRegistry_struct->dw_DestPort = dw_Destination_port;
	pRegistry_struct->dw_SocketType = dw_SocketType;
	return i_return_val;
}

int Read_Remote_Registry(Reg_Remote *pRegistry_struct)
{
	char str_restrictip[SIZE_OF_RESTRICTIP] = "127.0.0.1";
	char str_password[SIZE_OF_PASSWORD] = "password";
	DWORD dw_webport = 6162;
	DWORD dw_allow = 0, dw_allow_buffer = 0, dw_password = 0;
	DWORD dw_restrict = 0, dw_restrict_buffer = 0;
	DWORD dw_webportchange = 0, dw_webportchange_buffer = 0;
	int i_return_val = 0;
    
	if(!MyGetProfileString("Remote","RestrictIP",str_restrictip,SIZE_OF_RESTRICTIP)) {
		strncpy_s(str_restrictip,SIZE_OF_RESTRICTIP,"127.0.0.1",_TRUNCATE);
		i_return_val += 1;
	}

	dw_allow=MyGetProfileDWORD("Remote","Allow",1);
	dw_password=MyGetProfileDWORD("Remote","AccessKey",0);
	dw_webport=MyGetProfileDWORD("Remote","WebPort",6162);
	
	if(dw_webport > 65535 || dw_webport < 1) {
		dw_webport = 6162;
		i_return_val += 2;
	}
	
	dw_restrict=MyGetProfileDWORD("Remote","Restrict",1);
	dw_webportchange=MyGetProfileDWORD("Remote","WebPortChange",0);

	if(!MyGetProfileString("Remote","AccessKeySet",str_password,SIZE_OF_PASSWORD)) {
		strncpy_s(str_password,SIZE_OF_PASSWORD,"",_TRUNCATE);
		i_return_val += 4;
	}

	   
   // Copy all the values into the structure
   strncpy_s( pRegistry_struct->str_Password,SIZE_OF_PASSWORD,str_password,_TRUNCATE);
   strncpy_s( pRegistry_struct->str_RestrictIP,SIZE_OF_RESTRICTIP,str_restrictip,_TRUNCATE);
   pRegistry_struct->dw_Restrict = dw_restrict;
   pRegistry_struct->dw_WebPortChange = dw_webportchange;
   pRegistry_struct->dw_WebPort = dw_webport;
   pRegistry_struct->dw_Password = dw_password;
   pRegistry_struct->dw_Allow = dw_allow;

   // Return the error code
   return i_return_val;
}

int Read_Log_Registry(int i_log_number, Reg_Log *pRegistry_struct)
{
	HKEY hKey;
	DWORD  dw_log_bytes = SIZE_OF_LOGNAME, dwRegType;
	char log_buffer[SIZE_OF_LOGNAME]="";
	char str_log[SIZE_OF_LOGNAME]="";
	int o_return_val = 0;
	char str_log_to_read[20] = "";
	long error_type=0;
	char *pos, *pos2, *pos3;

	_snprintf_s(str_log_to_read,_countof(str_log_to_read),_TRUNCATE,"Log%d",i_log_number);

	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, LOG_KEY_NAME, 0, KEY_READ,&hKey ) == ERROR_SUCCESS )	{
		error_type = RegQueryValueEx(hKey, str_log_to_read, NULL, &dwRegType, (LPBYTE) log_buffer, &dw_log_bytes );
	  if ( error_type == ERROR_SUCCESS ) {
			// Reject any str_log that is longer than 512 chars
		  if ((dwRegType == REG_SZ) & (dw_log_bytes <= SIZE_OF_LOGNAME)) {
				strncpy_s( str_log,dw_log_bytes,log_buffer,_TRUNCATE);
		  } else {
				// reject the str_log and return immediately
				return (o_return_val + 1);
		  }
	  } else {
		  // Retain this error value as 4, since the error control in the other routines
		  // look for errors in the range 1 to 3.
		  return (o_return_val + 4);
	  }

	  // Close the registry key when done
	  RegCloseKey(hKey);
	  
	} else {
	   return (o_return_val + 2);
	}

	// Valid formats: logname, logtype|logname, logtype|logname|logformat

	pos = strstr(str_log, "|");
	if (!pos) {
		//assume the default Epilog	format
		strncpy_s(pRegistry_struct->type, SIZE_OF_LOGNAME, "GenericLog",_TRUNCATE);
		// Record the name and open the file for reading
		strncpy_s(pRegistry_struct->name, SIZE_OF_LOGNAME, str_log,_TRUNCATE);
		//Set the format to NULL
		strncpy_s(pRegistry_struct->format, SIZE_OF_LOGNAME, "",_TRUNCATE);
	} else {
		pos2 = str_log;
		pos3 = pos + 1;
		*pos='\0';
		strncpy_s(pRegistry_struct->type, SIZE_OF_LOGNAME, pos2,_TRUNCATE);
		pos = strstr(pos3, "|");
		if (!pos) {
			// Record the name and open the file for reading
			strncpy_s(pRegistry_struct->name, SIZE_OF_LOGNAME, pos3,_TRUNCATE);
			//Set the format to NULL
			strncpy_s(pRegistry_struct->format, SIZE_OF_LOGNAME, "",_TRUNCATE);
		} else {
			pos2 = pos + 1;
			*pos='\0';
			// Record the name and open the file for reading
			strncpy_s(pRegistry_struct->name, SIZE_OF_LOGNAME, pos3,_TRUNCATE);
			//Set the format to NULL
			strncpy_s(pRegistry_struct->format, SIZE_OF_LOGNAME, pos2,_TRUNCATE);
		}
	}

	return(o_return_val);
}

int Write_Config_Registry(Reg_Config *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_clientnamebuffer[SIZE_OF_CLIENTNAME]="";
    
	// Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		// The registry key does not exist and was thus unable to be opened.
		// Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS) {
			// The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	// Now attempt to set the registry values

	// No error checking required on this Reg Value
	strncpy_s(str_clientnamebuffer,SIZE_OF_CLIENTNAME,pRegistry_struct->str_ClientName,_TRUNCATE);
	if ( RegSetValueEx(hKey, "Clientname",0,REG_SZ,
			  (CONST BYTE *) str_clientnamebuffer,(DWORD)strlen(str_clientnamebuffer)) 
			  != ERROR_SUCCESS ) {
		i_return_val += 4;
	}
				
	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Write_Network_Registry(Reg_Network *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_destination[SIZE_OF_DESTINATION]="";
    
	// Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, NETWORK_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		// The registry key does not exist and was thus unable to be opened.
		// Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, NETWORK_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val ++;
			return i_return_val;
		}
	}
		
	// Now attempt to set the registry values

	// No error checking required on this Reg Value
	strncpy_s(str_destination,SIZE_OF_DESTINATION,pRegistry_struct->str_Destination,_TRUNCATE);
	if ( RegSetValueEx(hKey, "Destination",0,REG_SZ,
			  (CONST BYTE *) str_destination,(DWORD)strlen(str_destination)) 
			  != ERROR_SUCCESS ) {
		i_return_val ++;
	}
		
	// If DestPort is out of bounds, then it becomes 6161
	if ((pRegistry_struct->dw_DestPort < 1) | (pRegistry_struct->dw_DestPort > 65535)) {
		pRegistry_struct->dw_DestPort = 6161;
	}

	if ( RegSetValueEx(hKey, "DestPort",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_DestPort,
			  sizeof(pRegistry_struct->dw_DestPort))
			  != ERROR_SUCCESS ) {
		i_return_val ++;
	}

	pRegistry_struct->dw_SocketType=SOCKETTYPE_UDP;
	if ( RegSetValueEx(hKey, "SocketType",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_SocketType,
			  sizeof(pRegistry_struct->dw_SocketType))
			  != ERROR_SUCCESS ) {
		i_return_val ++;
	}


	// If Syslog is out of bounds, then it becomes 1
	if ((pRegistry_struct->dw_Syslog < 0) | (pRegistry_struct->dw_Syslog > 1)) {
		pRegistry_struct->dw_Syslog = 1;
	}
	if ( RegSetValueEx(hKey, "Syslog",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Syslog,
			  sizeof(pRegistry_struct->dw_Syslog))
			  != ERROR_SUCCESS ) {
		i_return_val ++;
	}

	// No error checking for the Syslog catgeory and criticality
	if ( RegSetValueEx(hKey, "SyslogDest",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_SyslogDest,
			  sizeof(pRegistry_struct->dw_SyslogDest))
			  != ERROR_SUCCESS ) {
		i_return_val ++;
	}

	// Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Write_Remote_Registry(Reg_Remote *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_restrictip[SIZE_OF_RESTRICTIP]="";
	char str_password[SIZE_OF_PASSWORD]="";
    
	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, REMOTE_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, REMOTE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
			//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	//Now attempt to set the registry values

	//No error checking required on this Reg Value
	strncpy_s(str_restrictip,SIZE_OF_RESTRICTIP,pRegistry_struct->str_RestrictIP,_TRUNCATE);
	if ( RegSetValueEx(hKey, "RestrictIP",0,REG_SZ,
			  (CONST BYTE *) str_restrictip,(DWORD)strlen(str_restrictip)) 
			  != ERROR_SUCCESS ) {
		i_return_val += 4;
	}
		
	//If WebPort is out of bounds, then it becomes 6162
	if ((pRegistry_struct->dw_WebPort < 1) | (pRegistry_struct->dw_WebPort > 65535)) {
		pRegistry_struct->dw_WebPort = 6162;
	}

	if ( RegSetValueEx(hKey, "WebPort",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_WebPort,
			  sizeof(pRegistry_struct->dw_WebPort))
			  != ERROR_SUCCESS ) {
		i_return_val += 8;
	}

	//If Allow is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Allow < 0) | (pRegistry_struct->dw_Allow > 1)) {
		pRegistry_struct->dw_Allow = 0;
	}

	if ( RegSetValueEx(hKey, "Allow",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Allow,
			  sizeof(pRegistry_struct->dw_Allow))
			  != ERROR_SUCCESS ) {
		i_return_val += 16;
	}

	//If Password is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Password < 0) | (pRegistry_struct->dw_Password > 1)) {
		pRegistry_struct->dw_Password = 0;
	}

	if ( RegSetValueEx(hKey, "AccessKey",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Password,
			  sizeof(pRegistry_struct->dw_Password))
			  != ERROR_SUCCESS ) {
		i_return_val += 256;
	}


	//If Restrict is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Restrict < 0) | (pRegistry_struct->dw_Restrict > 1)) {
		pRegistry_struct->dw_Restrict = 0;
	}

	if ( RegSetValueEx(hKey, "Restrict",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Restrict,
			  sizeof(pRegistry_struct->dw_Restrict))
			  != ERROR_SUCCESS )
		i_return_val += 32;

	//If WebPortChange is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_WebPortChange < 0) | (pRegistry_struct->dw_WebPortChange > 1))
		pRegistry_struct->dw_WebPortChange = 0;

	if ( RegSetValueEx(hKey, "WebPortChange",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_WebPortChange,
			  sizeof(pRegistry_struct->dw_WebPortChange))
			  != ERROR_SUCCESS )
		i_return_val += 64;
		
	//No error checking required on this Reg Value
	strncpy_s(str_password,SIZE_OF_PASSWORD,pRegistry_struct->str_Password,_TRUNCATE);
	if ( RegSetValueEx(hKey, "AccessKeySet",0,REG_SZ,
			  (CONST BYTE *) str_password,(DWORD)strlen(str_password)) 
			  != ERROR_SUCCESS )
		i_return_val += 128;

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Write_Objective_Registry(int i_objective_number, Reg_Objective *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100,i_AlertType = 0,i_EventType = 0;
	DWORD i_EventLogType = 0;
	int i_return_val = 0;
	char str_GeneralMatch[SIZE_OF_GENERALMATCH];
	char str_event_log[SIZE_OF_EVENTLOG]="",str_event_type[SIZE_OF_EVENTLOG]="";
	char str_objective[SIZE_OF_AN_OBJECTIVE] = "";
	char str_objective_to_read[20] = "Objective",str_temp[10]=""; 
	char str_match_type[SIZE_OF_MATCH_TYPE];
	char str_GeneralMatchPlusTwo[SIZE_OF_GENERALMATCH+2];

	_itoa_s(i_objective_number,str_temp,10);
	strncat_s(str_objective_to_read,_countof(str_objective_to_read),str_temp,_TRUNCATE);


		if (strstr(pRegistry_struct->str_match_type,EXCLUDE) != NULL)
			strncpy_s(str_match_type,SIZE_OF_MATCH_TYPE,"1",_TRUNCATE);
		else
			strncpy_s(str_match_type,SIZE_OF_MATCH_TYPE,"0",_TRUNCATE);

		//Need to make sure the length is limited
		strncpy_s(str_GeneralMatch,SIZE_OF_GENERALMATCH,pRegistry_struct->str_match,_TRUNCATE);

		//This is to add a "*" character to the start and end of the general string
		add_wildcard_start_and_end(str_GeneralMatch,str_GeneralMatchPlusTwo,SIZE_OF_GENERALMATCH+2);
		
		//form the str_objective
		strncat_s(str_objective,_countof(str_objective),str_GeneralMatchPlusTwo,_TRUNCATE);
		strncat_s(str_objective,_countof(str_objective),OBJECTIVE_DELIMITER,_TRUNCATE);
		strncat_s(str_objective,_countof(str_objective),str_match_type,_TRUNCATE);
		

	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}

	//No error checking required on this Reg Value
	//strncpy_s(str_buffer,1024,pRegistry_struct->str_RestrictIP,_TRUNCATE);
	
	if ( RegSetValueEx(hKey, str_objective_to_read,0,REG_SZ,
			  (CONST BYTE *) str_objective,(DWORD)strlen(str_objective)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Write_Log_Registry(int i_log_number, Reg_Log *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100,i_AlertType = 0,i_EventType = 0;
	DWORD i_EventLogType = 0;
	int i_return_val = 0;
	char str_event_log[SIZE_OF_EVENTLOG]="",str_event_type[SIZE_OF_EVENTLOG]="";
	char str_log[SIZE_OF_LOGNAME] = "";
	char str_log_to_read[20] = "Log",str_temp[10]=""; 

	_itoa_s(i_log_number,str_temp,10);
	strncat_s(str_log_to_read,_countof(str_log_to_read),str_temp,_TRUNCATE);

	//form the str_log
	strncpy_s(str_log,_countof(str_log),pRegistry_struct->type,_TRUNCATE);
	strncat_s(str_log,_countof(str_log),"|",_TRUNCATE);
	strncat_s(str_log,_countof(str_log),pRegistry_struct->name,_TRUNCATE);
	strncat_s(str_log,_countof(str_log),"|",_TRUNCATE);
	strncat_s(str_log,_countof(str_log),pRegistry_struct->format,_TRUNCATE);
		

	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, LOG_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) != ERROR_SUCCESS ) {
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, LOG_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}

	//No error checking required on this Reg Value
	
	if ( RegSetValueEx(hKey, str_log_to_read,0,REG_SZ,
			  (CONST BYTE *) str_log,(DWORD)strlen(str_log)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Recreate_Objective_Key()
{
	HKEY hKey;
	DWORD dwDisp; 
	int i_return_val = 0;
    
	//Delete the "Objective" Registry Key 
	if ( RegDeleteKey(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME) != ERROR_SUCCESS )
	{
		//The registry key could not be deleted
		i_return_val += 1;
	}
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
	{
		//The registry key was unable to be created. Return.
		i_return_val += 2;
	}
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Delete_Objective(int i_objective_number)
{
	HKEY hKey;
	int i_return_val = 0;
	char str_objective_to_delete[20] = "Objective",str_temp[10]=""; 
    
	_itoa_s(i_objective_number,str_temp,10);
	strncat_s(str_objective_to_delete,_countof(str_objective_to_delete),str_temp,_TRUNCATE);

	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) != ERROR_SUCCESS )
			return i_return_val += 1;

	if ( RegDeleteValue(hKey, str_objective_to_delete) != ERROR_SUCCESS )
		i_return_val += 2;
		
	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Delete_Log(int i_log_number)
{
	HKEY hKey;
	int i_return_val = 0;
	char str_log_to_delete[20] = "Log",str_temp[10]=""; 
    
	_itoa_s(i_log_number,str_temp,10);
	strncat_s(str_log_to_delete,_countof(str_log_to_delete),str_temp,_TRUNCATE);

	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, LOG_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) != ERROR_SUCCESS )
			return i_return_val += 1;

	if ( RegDeleteValue(hKey, str_log_to_delete) != ERROR_SUCCESS )
		i_return_val += 2;
		
	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Restart_Service() 
{
	STARTUPINFO StartupInfo;  // pointer to STARTUPINFO
	PROCESS_INFORMATION ProcessInformation,ProcessInformation2;  // pointer to PROCESS_INFORMATION
	SECURITY_ATTRIBUTES saAttr;
	HANDLE h_readInPipe, h_writeInPipe, h_readOutPipe, h_writeOutPipe;
	DWORD dw_bytes,dw_return_result,dw_error=0;
	char str_buffer[1024]="";

	//Create the pipe that will be used to read from the process
	//Also need to create a pipe that the process will write to
	saAttr.nLength = sizeof(SECURITY_ATTRIBUTES);
	saAttr.bInheritHandle = TRUE;
	saAttr.lpSecurityDescriptor = NULL;

    if (!CreatePipe(&h_readInPipe,  &h_writeInPipe, &saAttr, 0))
		dw_error += 256;
    if (!CreatePipe(&h_readOutPipe, &h_writeOutPipe, &saAttr, 0))
		dw_error += 512;

	StartupInfo.cb = sizeof(STARTUPINFO);
	StartupInfo.hStdOutput = h_writeOutPipe; 
	StartupInfo.hStdInput = h_readInPipe;  
	StartupInfo.hStdError = h_writeOutPipe;
	StartupInfo.lpTitle = NULL;
	StartupInfo.cbReserved2 = 0;
	StartupInfo.lpReserved2 = NULL;
	StartupInfo.lpReserved = NULL;
	// This must be in the defintion, or the process **__WILL NOT__** run from the toolbar.
	// STDHANDLES must be also specified.
	StartupInfo.lpDesktop = NULL;
	StartupInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW | STARTF_FORCEONFEEDBACK;


	// If I can't run this process, then something is wrong.
	// You must set the 5th value to TRUE....or it won't work properly with the handles...
	// Create a process to STOP the SNARE service. 
	if (CreateProcess(NULL,"net stop snare",NULL,NULL,TRUE,
		NORMAL_PRIORITY_CLASS,NULL,NULL,
		&StartupInfo,&ProcessInformation))
	{
		//Wait for up to 5 seconds for process to terminate
		dw_return_result = WaitForSingleObject(ProcessInformation.hProcess, 10000);
		if ((dw_return_result == WAIT_FAILED) || (dw_return_result == WAIT_TIMEOUT))
			dw_error += 1;		
		else
		{
			if (ReadFile(h_readOutPipe, str_buffer, _countof(str_buffer), &dw_bytes, NULL) != 0)
			{
				if (strstr(str_buffer,"stopped successfully") == NULL)
					dw_error += 2;		
			}
			else
				dw_error += 4;		
		}
	}
	else
		dw_error += 8;		


	// Now try and restart it
	if (CreateProcess(NULL,"net start snare",NULL,NULL,TRUE,
		NORMAL_PRIORITY_CLASS,NULL,NULL,
		&StartupInfo,&ProcessInformation2))
	{
		// Wait for up to 5 seconds for process to terminate
		dw_return_result = WaitForSingleObject(ProcessInformation2.hProcess, 10000);
		if ((dw_return_result == WAIT_FAILED) || (dw_return_result == WAIT_TIMEOUT))
			dw_error += 16;		
		else
		{
			if (ReadFile(h_readOutPipe, str_buffer, _countof(str_buffer), &dw_bytes, NULL) != 0)
			{
				if (strstr(str_buffer,"started successfully") == NULL)
					dw_error += 32;

			}
			else
				dw_error += 64;
		}
	}
	else
		dw_error += 128;
	
    if(h_writeOutPipe) CloseHandle(h_writeOutPipe);
	if(h_readOutPipe)  CloseHandle(h_readOutPipe);

	return dw_error;
}


// Write a DWORD to the registry
BOOL MyWriteProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nValue)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_DWORD,
		(LPBYTE)&nValue, sizeof(nValue));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get a DWORD from the registry
DWORD MyGetProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nDefault)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return nDefault;
	DWORD dwValue;
	DWORD dwType;
	DWORD dwCount = sizeof(DWORD);
	LONG lResult = RegQueryValueEx(hSecKey, (LPTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)&dwValue, &dwCount);
	RegCloseKey(hSecKey);
	if (lResult == ERROR_SUCCESS)
	{
		return dwValue;
	}
	return nDefault;
}

// Write a string to the registry
BOOL MyWriteProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_SZ,
		(unsigned char *)lpszString, (DWORD)(strlen(lpszString)+1));
//		(unsigned char *)lpszString, (strlen(lpszString)+1) * _countof(LPCTSTR));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get a string from the registry
BOOL MyGetProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString, DWORD dwStringBuffer)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	DWORD dwSize = dwStringBuffer;
	DWORD dwType;
	LONG lResult = RegQueryValueEx(hSecKey, (LPCTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)lpszString, &dwSize);
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get the setion registry key
HKEY MyGetSectionKey(LPCTSTR lpszSection)
{
	HKEY hSectionKey = NULL;
	HKEY hAppKey = MyGetServiceRegistryKey();
	if (hAppKey == NULL)
		return NULL;
	
	DWORD dw;
	RegCreateKeyEx(hAppKey, lpszSection, 0, REG_NONE,
		REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
		&hSectionKey, &dw);
	RegCloseKey(hAppKey);
	return hSectionKey;
}

HKEY MyGetServiceRegistryKey()
{
	// Store the information within the InterSect Alliance high level key.
	char m_sServiceName[256]="InterSect Alliance";
	
	HKEY hServicesKey = NULL;
	static HKEY hParametersKey = NULL;
	HKEY hAppKey = NULL;
	
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE", 0, KEY_WRITE|KEY_READ,
		&hServicesKey) == ERROR_SUCCESS)
	{
		DWORD dw;
		if (RegCreateKeyEx(hServicesKey, m_sServiceName, 0, REG_NONE,
			REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
			&hAppKey, &dw) == ERROR_SUCCESS)
		{
			RegCreateKeyEx(hAppKey, "Epilog", 0, REG_NONE,
				REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
				&hParametersKey, &dw);
		}
	}
	if (hServicesKey != NULL)
		RegCloseKey(hServicesKey);
	if (hAppKey != NULL)
		RegCloseKey(hAppKey);
	
	return hParametersKey;
}

int add_wildcard_start_and_end(char *source, char *dest, int length)
{
	//This routine is simply to add the wildcard "*" to the start and
	//end of a string

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) 
		  return(1);
	  else
	  {	
		  if(count < length)
		  {
			  *dest='*';
			  dest++;
			  count++;
		  }
	  }


      while(*source) 
	  {
		if(count < length)
		{ 
			*dest=*source; 
			dest++; 
			count++; 
		}
		source++;
	  }

      if((count+2) < length)
	  {
		  *dest='*';
		  dest++;
		  *dest='\0';
	  }


	  dest=copyofdest;

      return(0);
}

int remove_wildcard_start_and_end(char *source, char *dest, int length)
{
	//This routine is simply to remove the wildcard "*" to the start and
	//end of a string

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) 
		  return(1);

	  if (*source == '*')
	  {
		  source++;
		  if(count < length)
		  {
			  *dest = *source;
			  dest++;
			  count++;
			  source++;
		  }
	  }

	  while(*source)
	  {
		  if(count < length)
		  {
			  *dest = *source;
			  dest++;
			  count++;
		  }
		  source++;
	  }

	  source--;
	  dest--;
	  count--;
	  if (*source == '*')
	  {
		  if(count < length)
		  {
			  *dest = '\0';
			  dest++;
			  count++;
		  }
	  }



	  dest=copyofdest;

      return(0);
}


// return 0 for failure
// return 1 for file
// return 2 for directory
int validate_file_or_directory(char *filename)
{
	if(!filename)				return(FALSE);
	if(strlen(filename) < 3)	return(FALSE); // Must be at least "C:\"
	if(!((filename[0] >= 'a' && filename[0] <= 'z') || (filename[0] >= 'A' && filename[0] <= 'Z'))) {
		return(FALSE);
	}
	if(filename[1] != ':')		return(FALSE);
	if(filename[2] != '\\')		return(FALSE);

	// Ok, anything else is fair game.
	DWORD Attributes;
	Attributes=GetFileAttributes(filename);
	if(Attributes == 0xFFFFFFFF) {
		// File or directory does not exist
		return(FALSE);
	}
	if(Attributes & FILE_ATTRIBUTE_DIRECTORY) {
		return(2);
	}

	return(1);
}


int GetLine(FILE * fp, char * dest, int max)
{
	char c;
	int i=0,len=0,allspace=1;
	while((c=fgetc(fp))!='\n' && c != '\0' && !feof(fp)) {
		if (c=='\r') {
			len++;
			continue;
		}
		if (i < max) dest[i] = c;
		else break;
		if (allspace && c!=' ') allspace=0;
		i++; len++;
	}
	if (i!=max) {
		if (c == '\n') len++;
		dest[i]='\n';
		dest[i+1]='\0';
	} else {
		len++;
		if (c == '\n') dest[max]='\n';
		else dest[max]='\0';
	}
	if (allspace && (feof(fp) || i>=max)) return 0;
	else return len;
}