#define CONFIG_KEY_NAME "SOFTWARE\\Intersect Alliance\\Epilog\\Config\\"
#define NETWORK_KEY_NAME "SOFTWARE\\Intersect Alliance\\Epilog\\Network\\"
#define REMOTE_KEY_NAME "SOFTWARE\\Intersect Alliance\\Epilog\\Remote\\"
#define OBJECTIVE_KEY_NAME "SOFTWARE\\Intersect Alliance\\Epilog\\Objective\\"
#define LOG_KEY_NAME "SOFTWARE\\Intersect Alliance\\Epilog\\Log\\"

// Audit all events
#define AUDIT_ALL -99

#define CRITICAL_TOKEN "Critical"
#define PRIORITY_TOKEN "Priority"
#define WARNING_TOKEN "Warning"
#define INFORMATION_TOKEN "Information"
#define CLEAR_TOKEN "Clear"

#define EXCLUDE "Exclude"
#define INCLUDE "Include"

#define SIZE_OF_RESTRICTIP		 2048
#define SIZE_OF_PASSWORD		 256
#define SIZE_OF_GENERALMATCH	 512
#define SIZE_OF_EVENTLOG		 35
#define SIZE_OF_AN_OBJECTIVE	 1056
#define SIZE_OF_LOGNAME			 512
#define SIZE_OF_CLIENTNAME		 100
#define SIZE_OF_DESTINATION		 2048
#define SIZE_OF_MATCH_TYPE	 10
#define SIZE_OF_FILENAME		 1024

#define OBJECTIVE_DELIMITER		 "\t"

//These are definitions for the length of event record fields
#define MAX_OUTPUT_STRING		  8192
#define FIELD_SOURCE_NAME		  100
#define	FIELD_SIDTYPE			  100
#define FIELD_EVENTLOGTYPE	      50
#define FIELD_EXPANDEDSTRING	  1024
#define FIELD_DATASTRING		  1024
#define FIELD_CATEGORYSTRING      256
#define FIELD_DATETIME		      100
#define FIELD_SYSTEM			  256
#define FIELD_NULL			      256
#define FIELD_EVENTID			  10

#define READ_CONFIG_ERROR_CODE			210000;
#define READ_NETWORK_ERROR_CODE			230000;
#define READ_REMOTE_ERROR_CODE			260000;
#define READ_OBJECTIVE_ERROR_CODE		310000;
#define READ_LOG_ERROR_CODE				320000;
#define WRITE_CONFIG_ERROR_CODE			330000;
#define WRITE_NETWORK_ERROR_CODE		370000;
#define WRITE_REMOTE_ERROR_CODE			410000;
#define WRITE_OBJECTIVE_ERROR_CODE		440000;
#define WRITE_LOG_ERROR_CODE			460000;
#define RESTART_SERVICE_ERROR_CODE		480000;
#define WEB_READ_CONFIG_ERROR_CODE		510000;
#define WEB_READ_NETWORK_ERROR_CODE		530000;
#define WEB_READ_REMOTE_ERROR_CODE		580000;
#define WEB_READ_OBJECTIVE_ERROR_CODE	610000;
#define WEB_READ_LOG_ERROR_CODE			630000;
#define WEB_WRITE_CONFIG_ERROR_CODE		660000;
#define WEB_WRITE_NETWORK_ERROR_CODE	720000;
#define WEB_WRITE_REMOTE_ERROR_CODE		770000;
#define WEB_WRITE_OBJECTIVE_ERROR_CODE	850000;
#define WEB_WRITE_LOG_ERROR_CODE		870000;
#define WEB_RESTART_SERVICE_ERROR_CODE	890000;

#define WEB_CACHE_SIZE 50
#define MAX_AUDIT_CONFIG_LINE	8192
#define MAX_TYPE 64

#define SOCKETTYPE_UDP 0

// The following structure has been defined to cater for the 'config' registry settings
struct  Reg_Config
{
	char	str_Delimiter[3];
	char	str_ClientName[SIZE_OF_CLIENTNAME];
};

struct Reg_Network
{
	char	str_Destination[SIZE_OF_DESTINATION];
	DWORD	dw_SyslogDest;
	DWORD	dw_Syslog;
	DWORD	dw_DestPort;
	DWORD	dw_SocketType;
};

struct Reg_Remote
{
	DWORD	dw_Allow;
	DWORD	dw_WebPort;
	DWORD	dw_WebPortChange;
	DWORD	dw_Restrict;
	char	str_RestrictIP[SIZE_OF_RESTRICTIP];
	DWORD	dw_Password;
	char	str_Password[SIZE_OF_PASSWORD];
};

struct Reg_Objective
{
	char	str_match[SIZE_OF_GENERALMATCH];
	char	str_match_type[SIZE_OF_MATCH_TYPE];
	// The DWORD is ONLY to support READ operations for Leigh's code
	DWORD	dw_match_type;
};

struct Reg_Log {
	char name[SIZE_OF_LOGNAME];
	char type[SIZE_OF_LOGNAME];
	char format[SIZE_OF_LOGNAME];
};

int Read_Config_Registry(Reg_Config *);
int Read_Objective_Registry(int, Reg_Objective *);
int Read_Network_Registry(Reg_Network *);
int Read_Remote_Registry(Reg_Remote *);
int Read_Log_Registry(int, Reg_Log *);
int Write_Config_Registry(Reg_Config *);
int Write_Network_Registry(Reg_Network *);
int Write_Remote_Registry(Reg_Remote *);
int Write_Log_Registry(int, Reg_Log *);
int Write_Objective_Registry(int, Reg_Objective *);
int Recreate_Objective_Key();
int Restart_Service();
int Delete_Objective(int);
int Delete_Log(int);
int add_wildcard_start_and_end(char *,char *,int);
int remove_wildcard_start_and_end(char *,char *,int);
int	validate_file_or_directory(char *filename);
int GetLine(FILE * fp, char * dest, int max);

BOOL	MyWriteProfileString	(LPCTSTR,LPCTSTR,LPCTSTR);
BOOL	MyWriteProfileDWORD		(LPCTSTR,LPCTSTR,DWORD);
BOOL	MyGetProfileString		(LPCTSTR,LPCTSTR,LPCTSTR,DWORD);
DWORD	MyGetProfileDWORD		(LPCTSTR,LPCTSTR,DWORD);
HKEY	MyGetSectionKey			(LPCTSTR);
HKEY	MyGetServiceRegistryKey	();

BOOL	GetTextualSid(PSID pSid,LPTSTR TextualSid,LPDWORD lpdwBufferLen);

struct _eventcache {
	char Hostname[100];
	char msg[MAX_OUTPUT_STRING];
	// Log type
	char type[MAX_TYPE];
	TCHAR SubmitTime[26];
	int seenflag;
	struct _eventcache *next;
	struct _eventcache *prev;
};

typedef struct _eventcache EventCache;