// snareDlg.cpp : implementation file
//

#include "stdafx.h"
#include "snare.h"
#include "snareDlg.h"
#include "registry.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareDlg dialog

CSnareDlg::CSnareDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSnareDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSnareDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSnareDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSnareDlg)
	DDX_Control(pDX, IDC_MAIN_LIST, m_List);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSnareDlg, CDialog)
	//{{AFX_MSG_MAP(CSnareDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_FILE_EXIT, OnFileExit)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_ACTIVITY_APPLYANDRESTARTAUDIT, OnActivityApplyandrestartaudit)
	ON_COMMAND(ID_VIEW_AUDITSTATUS, OnViewAuditstatus)
	ON_COMMAND(ID_SETUP_AUDITCONFIGURATION, OnSetupAuditconfiguration)
	ON_COMMAND(ID_SETUP_MAILCONFIGURATION, OnSetupMailconfiguration)
	ON_COMMAND(ID_SETUP_REMOTECONTROLCONFIGURATION, OnSetupRemotecontrolconfiguration)
	ON_WM_TIMER()
	ON_COMMAND(ID_ACTIVITY_CLEARTHEDISPLAY, OnActivityClearthedisplay)
	ON_NOTIFY(NM_CLICK, IDC_MAIN_LIST, OnLeftClickMainList)
	ON_COMMAND(ID__EDITOBJECTIVE, OnEditobjective)
	ON_COMMAND(ID_TOOLBAR_COMMENTS, OnToolbarComments)
	ON_COMMAND(ID_TOOLBAR_INTERSECT, OnToolbarIntersect)
	ON_COMMAND(ID_TOOLBAR_STATUS, OnViewAuditstatus)
	ON_COMMAND(ID_TOOLBAR_CLEARDISPLAY, OnActivityClearthedisplay)
	ON_COMMAND(ID_TOOLBAR_AUDITCONF, OnSetupAuditconfiguration)
	ON_COMMAND(ID_TOOLBAR_MAILNOTIFY, OnSetupMailconfiguration)
	ON_COMMAND(ID_TOOLBAR_NETWORK, OnSetupRemotecontrolconfiguration)
	ON_COMMAND(ID_TOOLBAR_RESTART, OnActivityApplyandrestartaudit)
	ON_COMMAND(ID_HELP_COMMENTONSNARE, OnToolbarComments)
	ON_COMMAND(ID_HELP_INTERSECTALLIANCEWEBSITE, OnToolbarIntersect)
	//}}AFX_MSG_MAP
	//***TAKE OUT*** ON_NOTIFY(LVN_ITEMACTIVATE, IDC_MAIN_LIST, OnItemActivate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareDlg message handlers

BOOL CSnareDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rect;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon to TRUE
	SetIcon(m_hIcon, FALSE);		// Set small icon to FALSE
	
	// TODO: Add extra initialization here


	//DON'T KNOW WHAT THIS IS***********************
	DWORD dwCurType, dwViewType;
	HWND hWnd;

	dwViewType = LVS_REPORT;
	hWnd = m_List;
	GetSafeHwnd();
	dwCurType = ::GetWindowLong(hWnd,GWL_STYLE);
	dwCurType &= ~LVS_TYPEMASK;
	dwViewType |= dwCurType;
	::SetWindowLong(hWnd,GWL_STYLE,dwViewType);


	// Initialise the timer. Set to 1.5 seconds.
	SetTimer(ID_TIMER,1500,NULL);

	//***THIS IS JUST FOR TESTING >>>>DELETE
	m_iTimerControl = 0;

	//Create the image for the main clist display
	//DON'T KNOW WHAT THIS IS********************
	HIMAGELIST hImageList=ImageList_Create(16,16, ILC_COLOR32, 0, 10);
	m_imgSmallIcons.Attach(hImageList);
	CBitmap dummy;
	dummy.LoadBitmap(IDB_BITMAP_SMALL);
	m_imgSmallIcons.Add(&dummy, RGB(0, 0, 0));

	// This is to add the ability to select a row, which is not available in the control.
	ListView_SetExtendedListViewStyle(m_List, LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE);  

	m_imgLargeIcons.Create(IDB_BITMAP_LARGE,32,1,ILC_COLOR);
	m_List.SetImageList(&m_imgSmallIcons,LVSIL_SMALL);
	m_List.SetImageList(&m_imgLargeIcons,LVSIL_NORMAL);

	m_List.InsertColumn(0,"Alert",LVCFMT_RIGHT,33);
	m_List.InsertColumn(1,"Event Date/Time",LVCFMT_LEFT,100);
	m_List.InsertColumn(2,"Details",LVCFMT_LEFT,512);

	//Insert a zero width column, ie; a hidden column
	m_List.InsertColumn(3,"Hidden Details",LVCFMT_LEFT,0);
	


	//initialise and show the toolbar
	m_wndToolBar.Create(this);
	m_wndToolBar.LoadToolBar(IDR_TOOLBAR);
	m_wndToolBar.ShowWindow(SW_SHOW);
	m_wndToolBar.SetBarStyle(CBRS_ALIGN_TOP|CBRS_TOOLTIPS|CBRS_FLYBY);

	RepositionBars(AFX_IDW_CONTROLBAR_FIRST,AFX_IDW_CONTROLBAR_LAST,0);

	// Create the ToolTip control.
	m_snare_tooltip.Create(this);
	m_snare_tooltip.Activate(TRUE);
	m_snare_tooltip.AddTool(GetDlgItem(IDC_MAIN_LIST), "This list shows the filtered events as they are received");

	//This needs to be added since the toolbar has been "added" to the dialog box
	//Note that the comments can be found in the 'properties' section of the toolbar button
	m_wndToolBar.GetToolBarCtrl().GetItemRect(0, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_STATUS,rect,ID_TOOLBAR_STATUS);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(1, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_RESTART,rect,ID_TOOLBAR_RESTART);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(3, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_AUDITCONF,rect,ID_TOOLBAR_AUDITCONF);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(4, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_NETWORK,rect,ID_TOOLBAR_NETWORK);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(5, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_MAILNOTIFY,rect,ID_TOOLBAR_MAILNOTIFY);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(7, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_CLEARDISPLAY,rect,ID_TOOLBAR_CLEARDISPLAY);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(9, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_HELP,rect,ID_HELP);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(10, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_COMMENTS,rect,ID_TOOLBAR_COMMENTS);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(11, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_INTERSECT,rect,ID_TOOLBAR_INTERSECT);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSnareDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CSnareDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSnareDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSnareDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSnareDlg::OnFileExit() 
{
	OnOK();
	
}

void CAboutDlg::OnOK() 
{
	CDialog::OnOK();
}

void CSnareDlg::OnHelpAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();

}

void CSnareDlg::OnActivityApplyandrestartaudit() 
{
	int return_code = -1;
	CString str_error_msg = "The SNARE Audit Service could not be started and/or stopped. Check that it is installed.\nReport error code ";
	char temp[10];

	return_code = Restart_Service();
	
	if (return_code > 9)
	{
		return_code += RESTART_SERVICE_ERROR_CODE;
		_itoa( return_code, temp, sizeof(temp));
		str_error_msg = str_error_msg + temp;
		MessageBox(str_error_msg,"SNARE Service Problem",MB_ICONERROR|MB_OK);
	}
	else
		MessageBox("The SNARE Audit Service was restarted successfully.","SNARE Service",MB_ICONINFORMATION|MB_OK);

}


void CSnareDlg::OnViewAuditstatus() 
{
	//******THIS NEEDS TO BE FIXED UP*********************************
	STARTUPINFO StartupInfo;  // pointer to STARTUPINFO
	PROCESS_INFORMATION ProcessInformation;  // pointer to PROCESS_INFORMATION
	SECURITY_ATTRIBUTES saAttr;
	HANDLE readInPipe, writeInPipe, readOutPipe, writeOutPipe;
	DWORD cnt;

	//Create the pipe that will be used to read from the process
	// Also need to create a pipe that the process will write to
	saAttr.nLength = sizeof(SECURITY_ATTRIBUTES);
	saAttr.bInheritHandle = TRUE;
	saAttr.lpSecurityDescriptor = NULL;

    if (!CreatePipe(&readInPipe,  &writeInPipe, &saAttr, 0))
	{
		MessageBox("Error with a pipe","Error",MB_ICONERROR|MB_OK);
	}
    if (!CreatePipe(&readOutPipe, &writeOutPipe, &saAttr, 0))
	{
		MessageBox("Error with a pipe","Error",MB_ICONERROR|MB_OK);
	}

	//FOR TESTING
	//WriteFile(writeErrPipe,"xyz",3,&cnt,NULL);


	StartupInfo.cb = sizeof(STARTUPINFO);
	StartupInfo.hStdOutput = writeOutPipe; 
	StartupInfo.hStdInput = readInPipe;  
	StartupInfo.hStdError = writeOutPipe;
	StartupInfo.lpTitle = NULL;
	StartupInfo.cbReserved2 = 0;
	StartupInfo.lpReserved2 = NULL;
	StartupInfo.lpReserved = NULL;

	//This must be in the defintion, or the process wont run from the toolbar.
	StartupInfo.lpDesktop = NULL;
	//STDHANDLES must be specified.
	
	
	StartupInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW | STARTF_FORCEONFEEDBACK;


	//StartupInfo.lpReserved = NULL; 
	//StartupInfo.lpDesktop = NULL; 
   //If I can't run this process, then something is wrong.
	//You must set the 5th value to TRUE....or it won't work properly with the handles...
	if (CreateProcess(NULL,"hostname",NULL,NULL,TRUE,
		NORMAL_PRIORITY_CLASS,NULL,NULL,
		&StartupInfo,&ProcessInformation))
	{
		//Wait for up to 5 seconds for process to terminate
		if (WaitForSingleObject(ProcessInformation.hProcess, 5000) == WAIT_TIMEOUT)
		{
			MessageBox("The SNARE Audit Service timedd out.",
				"SNARE Service Problem",MB_ICONERROR|MB_OK);
		}
		else
		{
			//Call the dialog window
       		//m_dlgStatusDialog.DoModal();
		}
	}
	else
	{
		MessageBox("The SNARE Audit Service does nott appear \nto be running, or is not installed.",
				"SNARE Service Problem",MB_ICONERROR|MB_OK);
	}
	
	//NEED TO PLACE THIS IN A IF STATEMENT, IF THE CREATEPROCESS WAS SUCCESSFULL
	//CloseHandle(writeInPipe);
    CloseHandle(writeOutPipe);
	//CloseHandle(writeErrPipe);
	//CloseHandle(readInPipe);
    //CloseHandle(readOutPipe);
	//CloseHandle(readErrPipe);
	
	
   
   char c;
   CString Output = "Hostname = ";


   if (!ReadFile(readOutPipe, &c, 1, &cnt, NULL))
   {
		MessageBox("Nothing to read from pipe","No info",MB_ICONERROR|MB_OK);
   }
	else
	{
      while(ReadFile(readOutPipe, &c, 1, &cnt, NULL))
		{
		   Output = Output + c;
		}
		MessageBox(Output,"Output from the pipe, after running 'hostname'",MB_ICONINFORMATION|MB_OK);
	}

	m_dlgStatusDialog.DoModal();
}

void CSnareDlg::OnSetupAuditconfiguration() 
{
	m_dlgConfigDialog.DoModal();	
}

void CSnareDlg::OnSetupMailconfiguration() 
{
	m_dlgMailConfigDialog.DoModal();
}

void CSnareDlg::OnSetupRemotecontrolconfiguration() 
{
	m_dlgControlDialog.DoModal();
}

void CSnareDlg::OnTimer(UINT nIDEvent) 
{
	
	//**************THIS IS FOR TESTING ONLY*********************
	int nItem;
	if (m_iTimerControl == 0)
	{
		nItem = m_List.InsertItem(0,"",0);
		m_List.SetItemText(nItem,1,"25Jun02 11:01:02");
		m_List.SetItemText(nItem,2,"The file C:\\SECRET\\DOCUMENT.DOC has been accessed by user CORAG");	
		m_List.SetItemText(nItem,3,"You are an idiot");
	}
	if (m_iTimerControl == 1)
	{
		nItem = m_List.InsertItem(1,"",1);
		m_List.SetItemText(nItem,1,"25Jun02 11:01:03");
		m_List.SetItemText(nItem,2,"The process CALC.EXE has been terminated by the user CORAG");
		m_List.SetItemText(nItem,3,"Root your arse");
	}
	if (m_iTimerControl == 2)
	{
		nItem = m_List.InsertItem(2,"",2);
		m_List.SetItemText(nItem,1,"25Jun02 11:01:04");
		m_List.SetItemText(nItem,2,"The audit process has been restarted by user CORAG");
		m_List.SetItemText(nItem,3,"Rack off, I must surf");
	}
	if (m_iTimerControl == 3)
	{
		nItem = m_List.InsertItem(3,"",3);
		m_List.SetItemText(nItem,1,"25Jun02 11:01:05");
		m_List.SetItemText(nItem,2,"The system is being rebooted by ADMINISTRATOR");
		m_List.SetItemText(nItem,3,"Clear the engine");
	}
	if (m_iTimerControl == 4)
	{
		nItem = m_List.InsertItem(4,"",4);
		m_List.SetItemText(nItem,1,"25Jun02 11:01:06");
		m_List.SetItemText(nItem,2,"The user INET_USR has been deleted by user CORAG");
		m_List.SetItemText(nItem,3,"This is a test of emergency control system");
	}

	m_iTimerControl++;
	CDialog::OnTimer(nIDEvent);
}

void CSnareDlg::OnActivityClearthedisplay() 
{
	m_List.DeleteAllItems();
}

//*******IS THIS REQUIRED*************
void CSnareDlg::OnLeftClickMainList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int code = -1;
	char buffer[1024];
	char buffer_text[1024] = "Nothing yet.";
	LVITEM row_item;

	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	code = pNMListView->iItem;
	_itoa( code, buffer, 10 );

	row_item.iItem = code;
	row_item.iSubItem = 3;
	row_item.mask = LVIF_TEXT;
	row_item.cchTextMax = 1024;
	row_item.pszText = buffer_text;
	if (m_List.GetItem(&row_item))
	{
	   MessageBox(buffer_text,"The Hidden Column",MB_OK);
	}
	*pResult = 0;
}


void CSnareDlg::OnEditobjective() 
{
	CObjectiveDlg m_dObjectiveDlg;
	m_dObjectiveDlg.DoModal();

}


void CSnareDlg::OnToolbarComments() 
{
	ShellExecute(NULL, "open", "mailto:snare_comments@intersectalliance.com?subject=Comments on 'SNARE for Windows'", NULL, ".", SW_SHOWNORMAL);
}

void CSnareDlg::OnToolbarIntersect() 
{
	ShellExecute(NULL, "open", "http://www.intersectalliance.com", NULL, ".", SW_SHOWNORMAL);	
}

BOOL CSnareDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_snare_tooltip.RelayEvent(pMsg);
	return CDialog::PreTranslateMessage(pMsg);	
}
