// ObjectiveDlg.cpp : implementation file
//

#include "stdafx.h"
#include "snare.h"
#include "ObjectiveDlg.h"
#include "support.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectiveDlg dialog


CObjectiveDlg::CObjectiveDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CObjectiveDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CObjectiveDlg)
	m_strEventID = _T("");
	m_strUserFilter = _T("");
	m_iObjectiveType = -1;
	m_bSuccessCheck = FALSE;
	m_bFailureCheck = FALSE;
	m_bErrorCheck = FALSE;
	m_bWarningCheck = FALSE;
	m_bInformationCheck = FALSE;
	m_iAlertType = -1;
	m_bSecLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDirLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_strSearchFilter = _T("");
	m_InclExclUser = -1;
	//}}AFX_DATA_INIT
}


void CObjectiveDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectiveDlg)
	DDX_Text(pDX, IDC_EVENTID_EDIT, m_strEventID);
	DDV_MaxChars(pDX, m_strEventID, 256);
	DDX_Text(pDX, IDC_USER_EDIT, m_strUserFilter);
	DDV_MaxChars(pDX, m_strUserFilter, 256);
	DDX_Radio(pDX, IDC_LOGONOFF_RADIO, m_iObjectiveType);
	DDX_Check(pDX, IDC_SUCCESS_CHECK, m_bSuccessCheck);
	DDX_Check(pDX, IDC_FAILURE_CHECK, m_bFailureCheck);
	DDX_Check(pDX, IDC_ERROR_CHECK, m_bErrorCheck);
	DDX_Check(pDX, IDC_WARNING_CHECK, m_bWarningCheck);
	DDX_Check(pDX, IDC_INFO_CHECK, m_bInformationCheck);
	DDX_Radio(pDX, IDC_CRITIC_RADIO, m_iAlertType);
	DDX_Check(pDX, IDC_SECLOG_CHECK, m_bSecLogCheck);
	DDX_Check(pDX, IDC_REPLOG_CHECK, m_bRepLogCheck);
	DDX_Check(pDX, IDC_SYSLOG_CHECK, m_bSysLogCheck);
	DDX_Check(pDX, IDC_DIRLOG_CHECK, m_bDirLogCheck);
	DDX_Check(pDX, IDC_DNSLOG_CHECK, m_bDNSLogCheck);
	DDX_Check(pDX, IDC_APPLOG_CHECK, m_bAppLogCheck);
	DDX_Text(pDX, IDC_SEARCH_EDIT, m_strSearchFilter);
	DDV_MaxChars(pDX, m_strSearchFilter, 512);
	DDX_Radio(pDX, IDC_USER_RADIO, m_InclExclUser);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectiveDlg, CDialog)
	//{{AFX_MSG_MAP(CObjectiveDlg)
	ON_BN_CLICKED(IDC_FILEACCESS_RADIO, OnFileaccessRadio)
	ON_BN_CLICKED(IDC_PROCESS_RADIO, OnProcessRadio)
	ON_BN_CLICKED(IDC_USERRIGHT_RADIO, OnUserrightRadio)
	ON_BN_CLICKED(IDC_GROUP_RADIO, OnGroupRadio)
	ON_BN_CLICKED(IDC_SECPOLICY_RADIO, OnSecpolicyRadio)
	ON_BN_CLICKED(IDC_RESTART_RADIO, OnRestartRadio)
	ON_BN_CLICKED(IDC_ALLEVENTS_RADIO, OnAlleventsRadio)
	ON_BN_CLICKED(IDC_LOGONOFF_RADIO, OnLogonoffRadio)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectiveDlg message handlers


void CObjectiveDlg::OnFileaccessRadio() 
{

	UpdateData(TRUE);
	m_strEventID = FILE_EVENTS;
	m_iObjectiveType = 2;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
}

void CObjectiveDlg::OnProcessRadio() 
{

	UpdateData(TRUE);
	m_strEventID = PROCESS_EVENTS;
	m_iObjectiveType = 4;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
}

void CObjectiveDlg::OnUserrightRadio() 
{

	UpdateData(TRUE);
	m_strEventID = USER_OF_USER_RIGHTS_EVENTS;
	m_iObjectiveType = 6;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
}

void CObjectiveDlg::OnGroupRadio() 
{

	UpdateData(TRUE);
	m_strEventID = USER_GROUP_ADMIN_EVENTS;
	m_iObjectiveType = 1;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
}

void CObjectiveDlg::OnSecpolicyRadio() 
{

	UpdateData(TRUE);
	m_strEventID = SECURITY_POLICY_EVENTS;
	m_iObjectiveType = 3;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
}

void CObjectiveDlg::OnRestartRadio() 
{

	UpdateData(TRUE);
	m_strEventID = RESTART_EVENTS;
	m_iObjectiveType = 5;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
}

void CObjectiveDlg::OnAlleventsRadio() 
{

	UpdateData(TRUE);
	m_strEventID = "*";
	m_iObjectiveType = 7;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = TRUE;
	m_bSysLogCheck = TRUE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(TRUE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(TRUE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(TRUE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(TRUE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(TRUE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(TRUE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(TRUE);
}

BOOL CObjectiveDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Create the ToolTip control.
	m_objective_tooltip.Create(this);
	m_objective_tooltip.Activate(TRUE);
	m_objective_tooltip.AddTool(GetDlgItem(IDC_LOGONOFF_RADIO), "This will trap the logon/off related events");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_FILEACCESS_RADIO), "This will trap the file access related events");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_PROCESS_RADIO), "This will trap the process related events");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_USERRIGHT_RADIO), "This will trap events that related to user rights");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_GROUP_RADIO), "This will trap events related to account administration");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_SECPOLICY_RADIO), "This will trap events related to changes in the security policy");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_RESTART_RADIO), "This will trap events related to rebooting the host");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_ALLEVENTS_RADIO), "Enter the events of interest separated by commas, or the Asterisk (*) for all events.");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_EVENTID_EDIT), "Enter a comma separated list of event IDs to trap");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_USER_EDIT), "This expression will filter on the 'user' field of an event. Multiple users can be specified separated by commas, and wildcards are accepted.");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_SEARCH_EDIT), "This expression will match on any non-header field of an event");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_SUCCESS_CHECK), "Select the event type to capture");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_FAILURE_CHECK), "Select the event type to capture");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_INFO_CHECK), "Select the event type to capture");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_WARNING_CHECK), "Select the event type to capture");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_ERROR_CHECK), "Select the event type to capture");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_SECLOG_CHECK), "This will trap events only from the 'Security' event log");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_APPLOG_CHECK), "This will trap events only from the 'Application' event log");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_SYSLOG_CHECK), "This will trap events only from the 'System' event log");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_DNSLOG_CHECK), "The 'DNS Server' event log only exists on a Windows 2000 Server");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_DIRLOG_CHECK), "The 'Directory Service' event log only exists on a Windows 2000 Server");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_REPLOG_CHECK), "The 'File Replication' event log only exists on a Windows 2000 Server");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_CRITIC_RADIO), "Choose the alert level for this objective");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_PRIORITY_RADIO), "Choose the alert level for this objective");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_WARNING_RADIO), "Choose the alert level for this objective");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_INFO_RADIO), "Choose the alert level for this objective");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_CLEAR_RADIO), "Choose the alert level for this objective");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_USER_RADIO), "Events will only be trapped if the User field in the event matches the search term below");
	m_objective_tooltip.AddTool(GetDlgItem(IDC_USER_RADIO2), "Events will only be trapped if the User field in the event DOES NOT match the search term below");

	//If its any event ID other than "All events", then grey out the edit box
	if (m_iObjectiveType < 7)
	{
		m_bSecLogCheck = TRUE;
		m_bDirLogCheck = FALSE;
		m_bSysLogCheck = FALSE;
		m_bDNSLogCheck = FALSE;
		m_bAppLogCheck = FALSE;
		m_bRepLogCheck = FALSE;
	
		GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);

		GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
	}


	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CObjectiveDlg::OnLogonoffRadio() 
{
	
	UpdateData(TRUE);
	m_strEventID = LOGON_LOGOFF_EVENTS;
	m_iObjectiveType = 0;
	m_bSecLogCheck = TRUE;
	m_bDirLogCheck = FALSE;
	m_bSysLogCheck = FALSE;
	m_bDNSLogCheck = FALSE;
	m_bAppLogCheck = FALSE;
	m_bRepLogCheck = FALSE;
	UpdateData(FALSE);
	GetDlgItem(IDC_SECLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DIRLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_SYSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_DNSLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_APPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_REPLOG_CHECK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EVENTID_EDIT)->EnableWindow(FALSE);
}



void CObjectiveDlg::OnOK() 
{
	// Do we have a FILE objective?
	if(m_iObjectiveType == 2) {
		// Check the user input
		UpdateData(TRUE);

		if(validate_file_or_directory(m_strSearchFilter.GetBuffer(255))) {
			// Set auditing on the file.
			DWORD dw_FileAudit;
			dw_FileAudit=MyGetProfileDWORD("Config","FileAudit",1);
			if(dw_FileAudit) {
				// Enable the SE_SECURITY_NAME privilege.
				if (EnableSecurityName()) {
					AddEveryoneAceToFileSacl(m_strSearchFilter.GetBuffer(255),GENERIC_ALL | ACCESS_SYSTEM_SECURITY);
				}
				MessageBox("I have recursively set audit on the filepath specified in this objective.");
			}

			CDialog::OnOK();
		} else {
			MessageBox("The value supplied in the Non-Header Search filter, is not a valid file or directory.\nPlease supply a valid entry (eg: C:\\DIR\\TO\\AUDIT)");
		}
	} else {
	
		//NEED TO CHECK THAT AT LEAST ONE OF THE EVENT TYPES HAS BEEN SELECTED
		//NEED TO CHECK THAT AT LEAST ONE OF THE EVENT LOGS HAS BEEN SELECTED
		//ALSO, CHECK THAT THE RADI BUTTONS HAVE A VALUE BETWEEN 0 and WHATEVER
		CDialog::OnOK();
	}
}

BOOL CObjectiveDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_objective_tooltip.RelayEvent(pMsg);	
	return CDialog::PreTranslateMessage(pMsg);
}

