// EventDlg.cpp : implementation file
//

#include "stdafx.h"
#include "snare.h"
#include "EventDlg.h"
#include "support.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEventDlg dialog


CEventDlg::CEventDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEventDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEventDlg)
	m_strUser = _T("");
	m_strCriticality = _T("");
	m_strSystem = _T("");
	m_strSource = _T("");
	m_strDate = _T("");
	m_strEventID = _T("");
	m_strSID = _T("");
	m_strEventLog = _T("");
	m_strComputer = _T("");
	m_strCategory = _T("");
	m_strData = _T("");
	m_strExpand = _T("");
	//}}AFX_DATA_INIT
}


void CEventDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEventDlg)
	DDX_Text(pDX, IDC_USER_EDIT, m_strUser);
	DDV_MaxChars(pDX, m_strUser, 256);
	DDX_Text(pDX, IDC_CRITICALITY_EDIT, m_strCriticality);
	DDV_MaxChars(pDX, m_strCriticality, 20);
	DDX_Text(pDX, IDC_SYSTEM_EDIT, m_strSystem);
	DDV_MaxChars(pDX, m_strSystem, 256);
	DDX_Text(pDX, IDC_SOURCE_EDIT, m_strSource);
	DDV_MaxChars(pDX, m_strSource, 100);
	DDX_Text(pDX, IDC_DATE_EDIT, m_strDate);
	DDV_MaxChars(pDX, m_strDate, 100);
	DDX_Text(pDX, IDC_EVENTID_EDIT, m_strEventID);
	DDV_MaxChars(pDX, m_strEventID, 10);
	DDX_Text(pDX, IDC_SID_EDIT, m_strSID);
	DDV_MaxChars(pDX, m_strSID, 100);
	DDX_Text(pDX, IDC_EVENTLOGTYPE_EDIT, m_strEventLog);
	DDV_MaxChars(pDX, m_strEventLog, 50);
	DDX_Text(pDX, IDC_COMPUTER_EDIT, m_strComputer);
	DDV_MaxChars(pDX, m_strComputer, 256);
	DDX_Text(pDX, IDC_CATEGORY_EDIT, m_strCategory);
	DDV_MaxChars(pDX, m_strCategory, 256);
	DDX_Text(pDX, IDC_DATASTRING_EDIT, m_strData);
	DDV_MaxChars(pDX, m_strData, 1024);
	DDX_Text(pDX, IDC_EXPANDSTRING_EDIT, m_strExpand);
	DDV_MaxChars(pDX, m_strExpand, 1024);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEventDlg, CDialog)
	//{{AFX_MSG_MAP(CEventDlg)
	ON_BN_CLICKED(IDC_NEXT_BUTTON, OnNextButton)
	ON_BN_CLICKED(IDC_PREVIOUS_BUTTON, OnPreviousButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEventDlg message handlers

void CEventDlg::OnNextButton() 
{
	CWnd * pWindow=NULL;
	int nIndex_Current,nIndex_Next;

	CListCtrl* pList = ((CListCtrl*)GetParent()->GetDlgItem(IDC_MAIN_LIST));
	
	
	nIndex_Current = pList->GetNextItem( -1, LVNI_SELECTED );

	nIndex_Next = pList->GetNextItem(nIndex_Current,LVNI_ABOVE);
	if(nIndex_Next > -1) 
	{
		pList->SetItemState(nIndex_Next,0,LVIS_SELECTED);
		pList->SetItemState(nIndex_Next,LVIS_SELECTED,LVIS_SELECTED);
		Populate_Window(pList,nIndex_Next);
	}

}



void CEventDlg::OnPreviousButton() 
{
	CWnd * pWindow=NULL;
	int nIndex_Current,nIndex_Next;

	CListCtrl* pList = ((CListCtrl*)GetParent()->GetDlgItem(IDC_MAIN_LIST));
	
	
	nIndex_Current = pList->GetNextItem( -1, LVNI_SELECTED );

	nIndex_Next = pList->GetNextItem(nIndex_Current,LVNI_BELOW);
	if(nIndex_Next > -1) 
	{
		pList->SetItemState(nIndex_Next,0,LVIS_SELECTED);
		pList->SetItemState(nIndex_Next,LVIS_SELECTED,LVIS_SELECTED);
		Populate_Window(pList,nIndex_Next);
	}
	
}


int CEventDlg::Populate_Window(CListCtrl *pList, int iIndex)
{
	LVITEM row_item;
	char buffer_text[MAX_OUTPUT_STRING] = "";
	char SourceName[FIELD_SOURCE_NAME]="";	// Eg: "Security" or "Active Directory"
	char SIDType[FIELD_SIDTYPE]="";		// User or System
	char EventLogType[FIELD_EVENTLOGTYPE]="";	 // Warning / Information / success / failure
	char ExpandedString[FIELD_EXPANDEDSTRING]="";
	char DataString[FIELD_DATASTRING]="";
	char ComputerName[FIELD_COMPUTERNAME]="";
	char UserName[FIELD_USERNAME]="";
	char CategoryString[FIELD_CATEGORYSTRING]=""; // "Detailed Tracking"
	char DateTime[FIELD_DATETIME]="";
	char Criticality[FIELD_CRITICALITY]="";
	char Critic[20]="";
	char System[FIELD_SYSTEM]="";	
	char null[FIELD_NULL]="";
	char EventID[FIELD_EVENTID]="";
	char *stringp;


	row_item.iItem = iIndex;
	row_item.iSubItem = 3;
	row_item.mask = LVIF_TEXT;
	row_item.cchTextMax = 8024;
	row_item.pszText = buffer_text;

	if (pList->GetItem(&row_item))
	{
		// Add the stuff to the list
		read_event(buffer_text,SourceName,SIDType,EventLogType,ExpandedString,DataString,
				   ComputerName,UserName,CategoryString,DateTime,Criticality,System,
				   null,EventID);


		stringp=DataString;
		while(*stringp) 
		{
			if(*stringp=='	') 
				*stringp='\n';
			stringp++;
		}

		stringp=ExpandedString;
		while(*stringp) 
		{
			if(*stringp=='	') 
				*stringp='\n';
			stringp++;
		}

		m_strSystem	 = System;
		m_strCriticality = Criticality;
		m_strCategory=	  SourceName;
		m_strDate=	  DateTime;
		m_strEventID=	  EventID;
		m_strSource	=  SourceName;
		m_strUser	=  UserName;
		m_strSID	=  SIDType;
		m_strEventLog=	  EventLogType;
		m_strComputer=	  ComputerName;
		m_strCategory	=  CategoryString;
		m_strData = DataString;
		m_strExpand = ExpandedString;

	}

	UpdateData(FALSE);

	return 0;
}
