// ControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "snare.h"
#include "ControlDlg.h"
#include "registry.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlDlg dialog


CControlDlg::CControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CControlDlg)
	m_bRemote_Control = FALSE;
	m_iRemote_Control = -1;
	m_bWeb_Server_Port = FALSE;
	m_strWeb_Server_Port = _T("");
	m_strIP_Addresses = _T("");
	//}}AFX_DATA_INIT
}


void CControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlDlg)
	DDX_Check(pDX, IDC_REMOTE_CONTROL_CHECK, m_bRemote_Control);
	DDX_Radio(pDX, IDC_REMOTE_CONTROL_RADIO, m_iRemote_Control);
	DDX_Check(pDX, IDC_WEB_SERVER_PORT_CHECK, m_bWeb_Server_Port);
	DDX_Text(pDX, IDC_WEB_SERVER_PORT_EDIT, m_strWeb_Server_Port);
	DDV_MaxChars(pDX, m_strWeb_Server_Port, 5);
	DDX_Text(pDX, IDC_IP_ADDRESS_CONTROL_EDIT, m_strIP_Addresses);
	DDV_MaxChars(pDX, m_strIP_Addresses, 1024);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CControlDlg, CDialog)
	//{{AFX_MSG_MAP(CControlDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlDlg message handlers

BOOL CControlDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	int read_remote_result;
	Reg_Remote reg_remote;
	DWORD port_number;
	char buffer[20], error_msg[200] = "There was an error reading the registry. \nSome default remote control values will be used. \nReport error code ";
	
	// Create the ToolTip control.
	m_remote_tooltip.Create(this);
	m_remote_tooltip.Activate(TRUE);
	m_remote_tooltip.AddTool(GetDlgItem(IDC_REMOTE_CONTROL_CHECK), "This is will enable remote control of SNARE via a web browser");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_REMOTE_CONTROL_RADIO), "Allow any host to control this SNARE agent");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_RADIO1), "Allow only selected hosts to control this SNARE agent");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT), "Enter the IP address or range of the hosts");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_WEB_SERVER_PORT_CHECK), "This will change the default port, so as to access the remote functionality");

	// Read the "Remote" Registry settings
	read_remote_result = Read_Remote_Registry(&reg_remote);

	if (read_remote_result > 0)
	{	
		read_remote_result += READ_REMOTE_ERROR_CODE;
		_itoa(read_remote_result,buffer,10);
		strncat(error_msg,buffer,sizeof(buffer));
		MessageBox(error_msg,"Error Reading the Registry",MB_ICONERROR|MB_OK);
	}

	m_strIP_Addresses = reg_remote.str_RestrictIP;
		m_bRemote_Control = reg_remote.dw_Allow;
		port_number = reg_remote.dw_WebPort;
		m_iRemote_Control = reg_remote.dw_Restrict;
		m_bWeb_Server_Port = reg_remote.dw_WebPortChange;



	//*************NEED SOME ERROR CHECKING IN HERE
	_itoa(port_number,buffer,10);
	m_strWeb_Server_Port = buffer;

	UpdateData(FALSE);
	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CControlDlg::OnOK() 
{
	char buffer[20];
	char error_msg[200] = "Problems were encountered in writing to the registry.\nCheck that you are running SNARE with Administrator\nprivileges. Error code = ";
	Reg_Remote Registry_struct;
	int i_errornum = 0;
	

	//Need to update the data from the Window
	UpdateData(TRUE);

	Registry_struct.dw_WebPort = atoi(m_strWeb_Server_Port);
	if ((Registry_struct.dw_WebPort < 1) | (Registry_struct.dw_WebPort > 65535))
	{
		MessageBox("The \"Web Server port number\" must be between 1 and 65535","Error",MB_OK|MB_ICONERROR);
		return;
	}

	strncpy(Registry_struct.str_RestrictIP,m_strIP_Addresses,1024);


	if (m_bRemote_Control)
		Registry_struct.dw_Allow = 1;
	else
		Registry_struct.dw_Allow = 0;

	if (m_iRemote_Control == 0)
		Registry_struct.dw_Restrict = 0;
	else
		Registry_struct.dw_Restrict = 1;

	if (m_bWeb_Server_Port)
		Registry_struct.dw_WebPortChange = 1;
	else
		Registry_struct.dw_WebPortChange = 0;


	i_errornum = Write_Remote_Registry(&Registry_struct);

	if (i_errornum > 0)
	{	
		i_errornum += WRITE_REMOTE_ERROR_CODE;
		_itoa(i_errornum,buffer,10);
		strncat(error_msg,buffer,strlen(buffer));
		MessageBox(error_msg,"Error Writing to the Registry",MB_OK|MB_ICONERROR);
		return;
	}


	CDialog::OnOK();
}

BOOL CControlDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_remote_tooltip.RelayEvent(pMsg);
	return CDialog::PreTranslateMessage(pMsg);
}
