#include "stdafx.h"
#include <winreg.h>

#include "registry.h"

//Note that these functions are self contained, since they will need to be shared
//with the cgi-bin script tool.

int Read_Config_Registry(Reg_Config *pRegistry_struct)
{
	HKEY hKey;
	DWORD  dwBytesReturned = 100, dwRegType;
	char strclientname_buffer[SIZE_OF_CLIENTNAME], strclientname[SIZE_OF_CLIENTNAME] = "Hostname";
	char strdelimiter_buffer[2], strdelimiter[2] = ",";
	int i_return_val = 0;
    
	//Open the registry key for READ access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME, 0, KEY_READ,&hKey ) 
		== ERROR_SUCCESS )
	{
		
	  if ( RegQueryValueEx(hKey, "Clientname", NULL, &dwRegType, 
		     (LPBYTE) strclientname_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			//Copy only up to 100 characters
			if (dwRegType == REG_SZ)
				strncpy( strclientname,strclientname_buffer,SIZE_OF_CLIENTNAME);
			else
			{
				i_return_val += 1;
			}
	  }
	  else
	  {
		  i_return_val += 2;
	  }

	  if ( RegQueryValueEx(hKey, "Delimiter", NULL, &dwRegType, 
		     (LPBYTE) strdelimiter_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			if (dwRegType == REG_SZ)
			{
				strncpy( strdelimiter,strdelimiter_buffer,1);
			}
			else
			{
				i_return_val += 4;
			}
	  }
	  else
	  {
		  i_return_val += 8;
	  }

	  //Close the registry key when done
	  RegCloseKey(hKey);
    }
   else
	   i_return_val += 16;

   //Copy all the values to the struct
   //****NEED TO SET THIS TO THE COMMAND 'HOSTNAME'
   strncpy( pRegistry_struct->str_Delimiter,strdelimiter,1);
   strncpy( pRegistry_struct->str_ClientName,strclientname,SIZE_OF_CLIENTNAME);

	return i_return_val;
}


int Read_Objective_Registry(int i_objective_number, Reg_Objective *pRegistry_struct)
{
	HKEY hKey;
	DWORD  dwBytesReturned = 100, dwRegType;
	char objective_buffer[SIZE_OF_AN_OBJECTIVE], str_objective[SIZE_OF_AN_OBJECTIVE];
	int i_return_val = 0,i_event_type,i_type = 0,i_event_type_log;
	char str_objective_to_read[20] = "Objective",str_temp[5]; 
	char str_temp_pri[4],str_temp_evt_type[4],str_temp_log_type[4],str_temp_eventids[SIZE_OF_EVENTIDMATCH];
	char str_temp_usr[SIZE_OF_USERMATCH],str_temp_general[SIZE_OF_GENERALMATCH];
    
	_itoa(i_objective_number,str_temp,10);
	strncat(str_objective_to_read,str_temp,sizeof(str_temp));
	//Open the registry key for READ access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME, 0, KEY_READ,&hKey ) 
		== ERROR_SUCCESS )
	{
		
	  if ( RegQueryValueEx(hKey, str_objective_to_read, NULL, &dwRegType, 
		     (LPBYTE) objective_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			//Reject any str_objective that is longer than 1056 chars
			if ((dwRegType == REG_SZ) & (dwBytesReturned < 1057))
				strncpy( str_objective,objective_buffer,dwBytesReturned);
			else
			{
				//reject the str_objective and return immediately
				return (i_return_val += 1);
			}
	  }
	  else
	  {
		  return (i_return_val += 1024);
	  }

	  //Close the registry key when done
	  RegCloseKey(hKey);
    }
   else
	   return (i_return_val += 2);


	sscanf(str_objective,"%4[^;];%4[^;];%4[^;];%256[^;];%256[^;];%512[^\n]\n",str_temp_pri,str_temp_evt_type,str_temp_log_type,str_temp_eventids,str_temp_usr,str_temp_general);

	
   //Copy all the values to the struct

	//If the str_objective doesn't contain a valid criticality, assume it is 'clear'
	if (stricmp(str_temp_pri,"4") == 0)
		strncpy(pRegistry_struct->str_critic,CRITICAL_TOKEN,SIZE_OF_CRITICALITY);
	else if (stricmp(str_temp_pri,"3") == 0)
		strncpy(pRegistry_struct->str_critic,PRIORITY_TOKEN,SIZE_OF_CRITICALITY);
	else if (stricmp(str_temp_pri,"2") == 0)
		strncpy(pRegistry_struct->str_critic,WARNING_TOKEN,SIZE_OF_CRITICALITY);
	else if (stricmp(str_temp_pri,"1") == 0)
		strncpy(pRegistry_struct->str_critic,INFORMATION_TOKEN,SIZE_OF_CRITICALITY);
	else 
		strncpy(pRegistry_struct->str_critic,CLEAR_TOKEN,SIZE_OF_CRITICALITY);

	//If it doesn't return with a value we can use, reject the str_objective
	i_event_type = atoi(str_temp_evt_type);
	if (i_event_type != 0)
	{
		if (i_event_type & 16)
		{
			strncpy(pRegistry_struct->str_event_type,SUCCESS_TOKEN,SIZE_OF_EVENTLOG);
			i_type = 1;
		}
		if (i_event_type & 8)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_event_type,",",1);
				strncat(pRegistry_struct->str_event_type,FAILURE_TOKEN,SIZE_OF_EVENTLOG);
			}
			else
				strncpy(pRegistry_struct->str_event_type,FAILURE_TOKEN,SIZE_OF_EVENTLOG);

			i_type = 1;
		}
		if (i_event_type & 4)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_event_type,",",1);
				strncat(pRegistry_struct->str_event_type,ERROR_TOKEN,SIZE_OF_EVENTLOG);
			}
			else
				strncpy(pRegistry_struct->str_event_type,ERROR_TOKEN,SIZE_OF_EVENTLOG);
			i_type = 1;
		}
		if (i_event_type & 2)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_event_type,",",1);
				strncat(pRegistry_struct->str_event_type,INFO_TOKEN,SIZE_OF_EVENTLOG);
			}
			else
				strncpy(pRegistry_struct->str_event_type,INFO_TOKEN,SIZE_OF_EVENTLOG);
			i_type = 1;
		}
		if (i_event_type & 1)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_event_type,",",1);
				strncat(pRegistry_struct->str_event_type,WARN_TOKEN,SIZE_OF_EVENTLOG);
			}
			else
				strncpy(pRegistry_struct->str_event_type,WARN_TOKEN,SIZE_OF_EVENTLOG);

			i_type = 1;
		}
		if (i_type == 0)
			return (i_return_val += 8);
	}
	else
		return (i_return_val += 16);



	i_type = 0;

	i_event_type_log = atoi(str_temp_log_type);
	if (i_event_type_log != 0)
	{
		if (i_event_type_log & 32)
		{
			strncpy(pRegistry_struct->str_eventlog_type,SECLOG_TOKEN,SIZE_OF_EVENTLOG);
			i_type = 1;
		}
		if (i_event_type_log & 16)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_eventlog_type,",",1);
				strncat(pRegistry_struct->str_eventlog_type,SYSLOG_TOKEN,sizeof(SYSLOG_TOKEN));
			}
			else
				strncpy(pRegistry_struct->str_eventlog_type,SYSLOG_TOKEN,SIZE_OF_EVENTLOG);

			i_type = 1;
		}
		if (i_event_type_log & 8)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_eventlog_type,",",1);
				strncat(pRegistry_struct->str_eventlog_type,APPLOG_TOKEN,sizeof(APPLOG_TOKEN));
			}
			else
				strncpy(pRegistry_struct->str_eventlog_type,APPLOG_TOKEN,SIZE_OF_EVENTLOG);

			i_type = 1;
		}
		if (i_event_type_log & 4)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_eventlog_type,",",1);
				strncat(pRegistry_struct->str_eventlog_type,DIRLOG_TOKEN,sizeof(DIRLOG_TOKEN));
			}
			else
				strncpy(pRegistry_struct->str_eventlog_type,DIRLOG_TOKEN,SIZE_OF_EVENTLOG);

			i_type = 1;
		}
		if (i_event_type_log & 2)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_eventlog_type,",",1);
				strncat(pRegistry_struct->str_eventlog_type,DNSLOG_TOKEN,sizeof(DNSLOG_TOKEN));
			}
			else
				strncpy(pRegistry_struct->str_eventlog_type,DNSLOG_TOKEN,SIZE_OF_EVENTLOG);

			i_type = 1;
		}
		if (i_event_type_log & 1)
		{
			if (i_type)
			{
				strncat(pRegistry_struct->str_eventlog_type,",",1);
				strncat(pRegistry_struct->str_eventlog_type,REPLOG_TOKEN,sizeof(REPLOG_TOKEN));
			}
			else
				strncpy(pRegistry_struct->str_eventlog_type,REPLOG_TOKEN,SIZE_OF_EVENTLOG);

			i_type = 1;
		}
		if (i_type == 0)
			return (i_return_val += 32);
	}
	else
		return (i_return_val += 64);

	//if the event id search term is greater than 256 chars, reject the str_objective
	if (strlen(str_temp_eventids) < 257)
	{

		if (stricmp(str_temp_eventids,LOGON_LOGOFF_EVENTS) == 0)
		{
			strncpy(pRegistry_struct->str_eventid_match,LOGONOFF_TOKEN,SIZE_OF_EVENTIDMATCH);
		}
		else if (stricmp(str_temp_eventids,RESTART_EVENTS) == 0)
		{
			strncpy(pRegistry_struct->str_eventid_match,REBOOT_TOKEN,SIZE_OF_EVENTIDMATCH);
		}
		else if (stricmp(str_temp_eventids,SECURITY_POLICY_EVENTS) == 0)
		{
			strncpy(pRegistry_struct->str_eventid_match,SECPOL_TOKEN,SIZE_OF_EVENTIDMATCH);
		}
		else if (stricmp(str_temp_eventids,USER_GROUP_ADMIN_EVENTS) == 0)
		{
			strncpy(pRegistry_struct->str_eventid_match,MANAGE_TOKEN,SIZE_OF_EVENTIDMATCH);
		}
		else if (stricmp(str_temp_eventids,USER_OF_USER_RIGHTS_EVENTS) == 0)
		{
			strncpy(pRegistry_struct->str_eventid_match,USERIRGHTS_TOKEN,SIZE_OF_EVENTIDMATCH);
		}
		else if (stricmp(str_temp_eventids,PROCESS_EVENTS) == 0)
		{
			strncpy(pRegistry_struct->str_eventid_match,PROCESS_TOKEN,SIZE_OF_EVENTIDMATCH);
		}
		else if (stricmp(str_temp_eventids,FILE_EVENTS) == 0)
		{
			strncpy(pRegistry_struct->str_eventid_match,FILE_TOKEN,SIZE_OF_EVENTIDMATCH);
		}
		else
			strncpy(pRegistry_struct->str_eventid_match,str_temp_eventids,SIZE_OF_EVENTIDMATCH);
	}	
	else
		return (i_return_val += 128);

	//if the user search term is greater than 256 chars, reject the str_objective
	if (sizeof(str_temp_usr) < 257)
		strncpy(pRegistry_struct->str_user_match,str_temp_usr,SIZE_OF_USERMATCH);
	else
		return (i_return_val += 256);

	//if the general search term is greater than 512 chars, reject the str_objective
	if (sizeof(str_temp_general) < 513)
		strncpy(pRegistry_struct->str_general_match,str_temp_general,SIZE_OF_GENERALMATCH);
	else
		return (i_return_val += 512);
	

	return i_return_val;
}

int Read_Network_Registry(Reg_Network *pRegistry_struct)
{
	HKEY hKey;
	DWORD  dwBytesReturned = 100,dwRegType; 
	char str_destination_buffer[SIZE_OF_DESTINATION], str_destination[SIZE_OF_DESTINATION] = "No value set";
	DWORD dw_Destination_port = 6161, dw_Destination_port_buffer = 6161;
	DWORD dw_Syslog = 1, dw_Syslog_buffer = 1;
	DWORD dw_Syslog_Dest = 13, dw_Syslog_Dest_buffer = 13;
	int i_return_val = 0;
    
	//Open the registry key for READ access.
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, NETWORK_KEY_NAME, 0, KEY_READ,&hKey ) 
		== ERROR_SUCCESS )
	{
		
	  if ( RegQueryValueEx(hKey, "Destination", NULL, &dwRegType, 
		     (LPBYTE) str_destination_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			if (dwRegType == REG_SZ)
				strncpy( str_destination,str_destination_buffer,SIZE_OF_DESTINATION);
			else
			{
				i_return_val += 1;
			}
	  }
	  else
	  {
		  i_return_val += 2;
	  }

	  if ( RegQueryValueEx(hKey, "SyslogDest", NULL, &dwRegType, 
		     (LPBYTE) &dw_Syslog_Dest_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			 if (dwRegType == REG_DWORD)
				dw_Syslog_Dest = dw_Syslog_Dest_buffer;
			 else
			 {
				 i_return_val += 4;
			 }
	  }
	  else
	  {
		  i_return_val += 8;
	  }

	  if ( RegQueryValueEx(hKey, "Syslog", NULL, &dwRegType, 
		     (LPBYTE) &dw_Syslog_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			 if ((dwRegType == REG_DWORD) & (dw_Syslog_buffer >= 0) & (dw_Syslog_buffer <= 1))
				dw_Syslog = dw_Syslog_buffer;
			 else
			 {
				 i_return_val += 16;
			 }
	  }
	  else
	  {
		  i_return_val += 32;
	  }

	  if ( RegQueryValueEx(hKey, "DestPort", NULL, &dwRegType, 
		     (LPBYTE) &dw_Destination_port_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			 if ((dwRegType == REG_DWORD) & (dw_Destination_port_buffer >0) & 
					(dw_Destination_port_buffer < 65536))
				dw_Destination_port = dw_Destination_port_buffer;
			 else
			 {
				 i_return_val += 64;
			 }
			
	  }
	  else
	  {	
		  i_return_val += 128;
	  }


	  //Close the registry key when done
	  RegCloseKey(hKey);
    }
   else
	   i_return_val += 256;

   //Write the values to the struct
   strncpy( pRegistry_struct->str_Destination,str_destination,SIZE_OF_DESTINATION);
   pRegistry_struct->dw_SyslogDest = dw_Syslog_Dest;
   pRegistry_struct->dw_Syslog = dw_Syslog;
   pRegistry_struct->dw_DestPort = dw_Destination_port;
	return i_return_val;
}

int Read_Remote_Registry(Reg_Remote *pRegistry_struct)
{
	HKEY hKey;
	DWORD  dwBytesReturned,dwRegType; 
	char str_restrictip[SIZE_OF_RESTRICTIP] = "127.0.0.1", str_restrictip_buffer[SIZE_OF_RESTRICTIP];
	DWORD dw_webport = 8080, dw_webport_buffer = 8080;
	DWORD dw_allow = 0, dw_allow_buffer = 0;
	DWORD dw_restrict = 0, dw_restrict_buffer = 0;
	DWORD dw_webportchange = 0, dw_webportchange_buffer = 0;
	int i_return_val = 0;
    
	//Open the registry key for READ access.
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, REMOTE_KEY_NAME, 0, KEY_READ,&hKey ) 
		== ERROR_SUCCESS )
	{
		
	  if ( RegQueryValueEx(hKey, "RestrictIP", NULL, &dwRegType, 
		     (LPBYTE) str_restrictip_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			if (dwRegType == REG_SZ)
				strncpy( str_restrictip,str_restrictip_buffer,SIZE_OF_RESTRICTIP);
			else
			{
				i_return_val += 1;
			}
	  }
	  else
	  {
		  i_return_val += 2;
	  }

	  if ( RegQueryValueEx(hKey, "Allow", NULL, &dwRegType, 
		     (LPBYTE) &dw_allow_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			 if ((dwRegType == REG_DWORD)  & (dw_allow_buffer >= 0) &
				 (dw_allow_buffer < 2))
				dw_allow = dw_allow_buffer;
			 else
			 {
				 i_return_val += 4;
			 }
	  }
	  else
	  {
		  i_return_val += 8;
	  }

	  if ( RegQueryValueEx(hKey, "WebPort", NULL, &dwRegType, 
		     (LPBYTE) &dw_webport_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			if ((dwRegType == REG_DWORD) & (dw_webport_buffer >0) & 
					(dw_webport_buffer < 65536))
				dw_webport = dw_webport_buffer;
			else
			{
				i_return_val += 16;
			}
	  }
	  else
	  {
		  i_return_val += 32;
	  }

	  if ( RegQueryValueEx(hKey, "Restrict", NULL, &dwRegType, 
		     (LPBYTE) &dw_restrict_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			 if ((dwRegType == REG_DWORD) & (dw_restrict_buffer >= 0) 
					& (dw_restrict_buffer < 2))
				dw_restrict = dw_restrict_buffer;
			 else
			 {
				i_return_val += 64;
			 }
	  }
	  else
	  {
		  i_return_val += 128;
	  }

	  if ( RegQueryValueEx(hKey, "WebPortChange", NULL, &dwRegType, 
		     (LPBYTE) &dw_webportchange_buffer, &dwBytesReturned ) == ERROR_SUCCESS )
	  {
			if ((dwRegType == REG_DWORD) & (dw_webportchange_buffer >= 0) 
					& (dw_webportchange_buffer < 2))
				dw_webportchange = dw_webportchange_buffer;		
			else
			{
				i_return_val += 256;
			}
	  }
	  else
	  {
		  i_return_val += 512;
	  }

	  //Close the registry key when done
	  RegCloseKey(hKey);
    }
   else
   {
		i_return_val += 1024;
   }
	   
   //Copy all the values into the structure
   strncpy( pRegistry_struct->str_RestrictIP,str_restrictip,SIZE_OF_RESTRICTIP);
   pRegistry_struct->dw_Restrict = dw_restrict;
   pRegistry_struct->dw_WebPortChange = dw_webportchange;
   pRegistry_struct->dw_Allow = dw_allow;
   pRegistry_struct->dw_WebPort = dw_webport;

   //Return the error code
   return i_return_val;
}

int Write_Config_Registry(Reg_Config *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_clientnamebuffer[SIZE_OF_CLIENTNAME], str_delimiterbuffer[2];
    
	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	//Now attempt to set the registry values

	//No error checking required on this Reg Value
	strncpy(str_clientnamebuffer,pRegistry_struct->str_ClientName,SIZE_OF_CLIENTNAME);
	if ( RegSetValueEx(hKey, "Clientname",0,REG_SZ,
			  (CONST BYTE *) str_clientnamebuffer,strlen(str_clientnamebuffer)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		
	//Limit the write to TWO character ONLY (including the NULL char
	strncpy(str_delimiterbuffer,pRegistry_struct->str_Delimiter,2);
	if ( RegSetValueEx(hKey, "Delimiter",0,REG_SZ,
			  (CONST BYTE *) str_delimiterbuffer,2) 
			  != ERROR_SUCCESS )
		i_return_val += 8;
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Write_Network_Registry(Reg_Network *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_destination[SIZE_OF_DESTINATION];
    
	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, NETWORK_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, NETWORK_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	//Now attempt to set the registry values

	//No error checking required on this Reg Value
	strncpy(str_destination,pRegistry_struct->str_Destination,SIZE_OF_DESTINATION);
	if ( RegSetValueEx(hKey, "Destination",0,REG_SZ,
			  (CONST BYTE *) str_destination,strlen(str_destination)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		
	//If DestPort is out of bounds, then it becomes 6161
	if ((pRegistry_struct->dw_DestPort < 1) | (pRegistry_struct->dw_DestPort > 65535))
		pRegistry_struct->dw_DestPort = 6161;

	if ( RegSetValueEx(hKey, "DestPort",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_DestPort,
			  sizeof(pRegistry_struct->dw_DestPort))
			  != ERROR_SUCCESS )
		i_return_val += 8;

	//If Syslog is out of bounds, then it becomes 1
	if ((pRegistry_struct->dw_Syslog < 0) | (pRegistry_struct->dw_Syslog > 1))
		pRegistry_struct->dw_Syslog = 1;
	if ( RegSetValueEx(hKey, "Syslog",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Syslog,
			  sizeof(pRegistry_struct->dw_Syslog))
			  != ERROR_SUCCESS )
		i_return_val += 16;

	//No error checking for the Syslog catgeory and criticality
	if ( RegSetValueEx(hKey, "SyslogDest",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_SyslogDest,
			  sizeof(pRegistry_struct->dw_SyslogDest))
			  != ERROR_SUCCESS )
		i_return_val += 32;
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Write_Remote_Registry(Reg_Remote *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_restrictip[SIZE_OF_RESTRICTIP];
    
	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, REMOTE_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, REMOTE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	//Now attempt to set the registry values

	//No error checking required on this Reg Value
	strncpy(str_restrictip,pRegistry_struct->str_RestrictIP,SIZE_OF_RESTRICTIP);
	if ( RegSetValueEx(hKey, "RestrictIP",0,REG_SZ,
			  (CONST BYTE *) str_restrictip,strlen(str_restrictip)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		
	//If WebPort is out of bounds, then it becomes 8080
	if ((pRegistry_struct->dw_WebPort < 1) | (pRegistry_struct->dw_WebPort > 65535))
		pRegistry_struct->dw_WebPort = 8080;

	if ( RegSetValueEx(hKey, "WebPort",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_WebPort,
			  sizeof(pRegistry_struct->dw_WebPort))
			  != ERROR_SUCCESS )
		i_return_val += 8;

	//If Allow is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Allow < 0) | (pRegistry_struct->dw_Allow > 1))
		pRegistry_struct->dw_Allow = 0;

	if ( RegSetValueEx(hKey, "Allow",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Allow,
			  sizeof(pRegistry_struct->dw_Allow))
			  != ERROR_SUCCESS )
		i_return_val += 16;

	//If Restrict is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Restrict < 0) | (pRegistry_struct->dw_Restrict > 1))
		pRegistry_struct->dw_Restrict = 0;

	if ( RegSetValueEx(hKey, "Restrict",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Restrict,
			  sizeof(pRegistry_struct->dw_Restrict))
			  != ERROR_SUCCESS )
		i_return_val += 32;

	//If WebPortChange is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_WebPortChange < 0) | (pRegistry_struct->dw_WebPortChange > 1))
		pRegistry_struct->dw_WebPortChange = 0;

	if ( RegSetValueEx(hKey, "WebPortChange",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_WebPortChange,
			  sizeof(pRegistry_struct->dw_WebPortChange))
			  != ERROR_SUCCESS )
		i_return_val += 32;
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Write_Objective_Registry(int i_objective_number, Reg_Objective *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100,i_AlertType = 0,i_EventType = 0;
	DWORD i_EventLogType = 0;
	int i_return_val = 0;
	char str_UserMatch[SIZE_OF_USERMATCH], str_EventIDMatch[SIZE_OF_EVENTIDMATCH];
	char str_GeneralMatch[SIZE_OF_GENERALMATCH],str_Alert[2] = "1";
	char str_event_log[SIZE_OF_EVENTLOG],str_event_type[SIZE_OF_EVENTLOG];
	char str_objective[SIZE_OF_AN_OBJECTIVE] = "";
	char str_objective_to_read[20] = "Objective",str_temp[10]; 

	_itoa(i_objective_number,str_temp,10);
	strncat(str_objective_to_read,str_temp,strlen(str_temp));


	//Attempt to set the registry values
		if (stricmp(pRegistry_struct->str_critic,CRITICAL_TOKEN) == 0)
			strncpy(str_Alert,"4",SIZE_OF_CRITICALITY);
		else if (stricmp(pRegistry_struct->str_critic,PRIORITY_TOKEN) == 0)
			strncpy(str_Alert,"3",SIZE_OF_CRITICALITY);
		else if (stricmp(pRegistry_struct->str_critic,WARNING_TOKEN) == 0)
			strncpy(str_Alert,"2",SIZE_OF_CRITICALITY);
		else if (stricmp(pRegistry_struct->str_critic,INFORMATION_TOKEN) == 0)
			strncpy(str_Alert,"1",SIZE_OF_CRITICALITY);
		else 
			strncpy(str_Alert,"0",SIZE_OF_CRITICALITY);

		if (strstr(pRegistry_struct->str_event_type,SUCCESS_TOKEN) != NULL)
			i_EventType += 16;
		if (strstr(pRegistry_struct->str_event_type,FAILURE_TOKEN) != NULL)
			i_EventType += 8;
		if (strstr(pRegistry_struct->str_event_type,INFO_TOKEN) != NULL)
			i_EventType += 2;
		if (strstr(pRegistry_struct->str_event_type,WARN_TOKEN) != NULL)
			i_EventType += 1;
		if (strstr(pRegistry_struct->str_event_type,ERROR_TOKEN) != NULL)
			i_EventType += 4;
		_itoa(i_EventType,str_event_type,10);

		if (strstr(pRegistry_struct->str_eventlog_type,SECLOG_TOKEN) != NULL)
			i_EventLogType += 32;
		if (strstr(pRegistry_struct->str_eventlog_type,SYSLOG_TOKEN) != NULL)
			i_EventLogType += 16;
		if (strstr(pRegistry_struct->str_eventlog_type,APPLOG_TOKEN) != NULL)
			i_EventLogType += 8;
		if (strstr(pRegistry_struct->str_eventlog_type,DIRLOG_TOKEN) != NULL)
			i_EventLogType += 4;
		if (strstr(pRegistry_struct->str_eventlog_type,DNSLOG_TOKEN) != NULL)
			i_EventLogType += 2;
		if (strstr(pRegistry_struct->str_eventlog_type,REPLOG_TOKEN) != NULL)
			i_EventLogType += 1;
		_itoa(i_EventLogType,str_event_log,10);



		if (stricmp(pRegistry_struct->str_eventid_match,LOGONOFF_TOKEN) == 0)
			strncpy(str_EventIDMatch,LOGON_LOGOFF_EVENTS,SIZE_OF_EVENTIDMATCH);
		else if (stricmp(pRegistry_struct->str_eventid_match,FILE_TOKEN) == 0)
			strncpy(str_EventIDMatch,FILE_EVENTS,SIZE_OF_EVENTIDMATCH);
		else if (stricmp(pRegistry_struct->str_eventid_match,PROCESS_TOKEN) == 0)
			strncpy(str_EventIDMatch,PROCESS_EVENTS,SIZE_OF_EVENTIDMATCH);
		else if (stricmp(pRegistry_struct->str_eventid_match,USERIRGHTS_TOKEN) == 0)
			strncpy(str_EventIDMatch,USER_OF_USER_RIGHTS_EVENTS,SIZE_OF_EVENTIDMATCH);
		else if (stricmp(pRegistry_struct->str_eventid_match,MANAGE_TOKEN) == 0)
			strncpy(str_EventIDMatch,USER_GROUP_ADMIN_EVENTS,SIZE_OF_EVENTIDMATCH);
		else if (stricmp(pRegistry_struct->str_eventid_match,SECPOL_TOKEN) == 0)
			strncpy(str_EventIDMatch,SECURITY_POLICY_EVENTS,SIZE_OF_EVENTIDMATCH);
		else if (stricmp(pRegistry_struct->str_eventid_match,REBOOT_TOKEN) == 0)
			strncpy(str_EventIDMatch,RESTART_EVENTS,SIZE_OF_EVENTIDMATCH);
		else
		{
			//Need to make sure the length is limited
			strncpy(str_EventIDMatch,pRegistry_struct->str_eventid_match,SIZE_OF_EVENTIDMATCH);
		}
		

		//Need to make sure the length is limited
		strncpy(str_UserMatch,pRegistry_struct->str_user_match,SIZE_OF_USERMATCH);

		//Need to make sure the length is limited
		strncpy(str_GeneralMatch,pRegistry_struct->str_general_match,SIZE_OF_GENERALMATCH);

		
		//form the str_objective
		strncpy(str_objective,str_Alert,strlen(str_Alert));
		strncat(str_objective,OBJECTIVE_DELIMITER,strlen(OBJECTIVE_DELIMITER));
		strncat(str_objective,str_event_type,strlen(str_event_type));
		strncat(str_objective,OBJECTIVE_DELIMITER,strlen(OBJECTIVE_DELIMITER));
		strncat(str_objective,str_event_log,strlen(str_event_log));
		strncat(str_objective,OBJECTIVE_DELIMITER,strlen(OBJECTIVE_DELIMITER));
		strncat(str_objective,str_EventIDMatch,strlen(str_EventIDMatch));
		strncat(str_objective,OBJECTIVE_DELIMITER,strlen(OBJECTIVE_DELIMITER));
		strncat(str_objective,str_UserMatch,strlen(str_UserMatch));
		strncat(str_objective,OBJECTIVE_DELIMITER,strlen(OBJECTIVE_DELIMITER));
		strncat(str_objective,str_GeneralMatch,strlen(str_GeneralMatch));
		

	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}

	//No error checking required on this Reg Value
	//strncpy(str_buffer,pRegistry_struct->str_RestrictIP,1024);
	
	if ( RegSetValueEx(hKey, str_objective_to_read,0,REG_SZ,
			  (CONST BYTE *) str_objective,strlen(str_objective)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Recreate_Objective_Key()
{
	HKEY hKey;
	DWORD dwDisp; 
	int i_return_val = 0;
    
	//Delete the "Objective" Registry Key 
	if ( RegDeleteKey(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME) != ERROR_SUCCESS )
	{
		//The registry key could not be deleted
		i_return_val += 1;
	}
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
	{
		//The registry key was unable to be created. Return.
		i_return_val += 2;
	}
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Restart_Service() 
{

	STARTUPINFO StartupInfo;  // pointer to STARTUPINFO
	PROCESS_INFORMATION ProcessInformation,ProcessInformation2;  // pointer to PROCESS_INFORMATION
	SECURITY_ATTRIBUTES saAttr;
	HANDLE h_readInPipe, h_writeInPipe, h_readOutPipe, h_writeOutPipe;
	DWORD dw_bytes,dw_return_result,dw_error=0;
	char str_buffer[1024];
	CString str_Output;

	//Create the pipe that will be used to read from the process
	//Also need to create a pipe that the process will write to
	saAttr.nLength = sizeof(SECURITY_ATTRIBUTES);
	saAttr.bInheritHandle = TRUE;
	saAttr.lpSecurityDescriptor = NULL;

    if (!CreatePipe(&h_readInPipe,  &h_writeInPipe, &saAttr, 0))
		dw_error += 256;
    if (!CreatePipe(&h_readOutPipe, &h_writeOutPipe, &saAttr, 0))
		dw_error += 512;

	StartupInfo.cb = sizeof(STARTUPINFO);
	StartupInfo.hStdOutput = h_writeOutPipe; 
	StartupInfo.hStdInput = h_readInPipe;  
	StartupInfo.hStdError = h_writeOutPipe;
	StartupInfo.lpTitle = NULL;
	StartupInfo.cbReserved2 = 0;
	StartupInfo.lpReserved2 = NULL;
	StartupInfo.lpReserved = NULL;
	//This must be in the defintion, or the process **__WILL NOT__** run from the toolbar.
	//STDHANDLES must be also specified.
	StartupInfo.lpDesktop = NULL;
	StartupInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW | STARTF_FORCEONFEEDBACK;


	//If I can't run this process, then something is wrong.
	//You must set the 5th value to TRUE....or it won't work properly with the handles...
	//Create a process to STOP the SNARE service. 
	if (CreateProcess(NULL,"net stop backlog",NULL,NULL,TRUE,
		NORMAL_PRIORITY_CLASS,NULL,NULL,
		&StartupInfo,&ProcessInformation))
	{
		//Wait for up to 5 seconds for process to terminate
		dw_return_result = WaitForSingleObject(ProcessInformation.hProcess, 10000);
		if ((dw_return_result == WAIT_FAILED) || (dw_return_result == WAIT_TIMEOUT))
			dw_error += 1;		
		else
		{
			if (ReadFile(h_readOutPipe, str_buffer, 1024, &dw_bytes, NULL) != 0)
			{
				str_Output = str_buffer;
				if (str_Output.Find("stopped successfully") == -1)
					dw_error += 2;		
			}
			else
				dw_error += 4;		
		}
	}
	else
		dw_error += 8;		


	//Now try and restart it
	if (CreateProcess(NULL,"net start backlog",NULL,NULL,TRUE,
		NORMAL_PRIORITY_CLASS,NULL,NULL,
		&StartupInfo,&ProcessInformation2))
	{
		//Wait for up to 5 seconds for process to terminate
		dw_return_result = WaitForSingleObject(ProcessInformation2.hProcess, 10000);
		if ((dw_return_result == WAIT_FAILED) || (dw_return_result == WAIT_TIMEOUT))
			dw_error += 16;		
		else
		{
			if (ReadFile(h_readOutPipe, str_buffer, 1024, &dw_bytes, NULL) != 0)
			{
				str_Output = str_buffer;
				if (str_Output.Find("started successfully") == -1)
					dw_error += 32;

			}
			else
				dw_error += 64;
		}
	}
	else
		dw_error += 128;
	
    CloseHandle(h_writeOutPipe);

	return dw_error;
}

