

#define CONFIG_KEY_NAME "SOFTWARE\\Intersect Alliance\\AuditService\\Config\\"
#define NETWORK_KEY_NAME "SOFTWARE\\Intersect Alliance\\AuditService\\Network\\"
#define REMOTE_KEY_NAME "SOFTWARE\\Intersect Alliance\\AuditService\\Remote\\"
#define OBJECTIVE_KEY_NAME "SOFTWARE\\Intersect Alliance\\AuditService\\Objective\\"

#define LOGON_LOGOFF_EVENTS "528,529,530,531,532,533,534,535,536,537,539"
#define RESTART_EVENTS "512,513"
#define SECURITY_POLICY_EVENTS "516,517,576,577,578,612"
#define USER_GROUP_ADMIN_EVENTS "624,625,626,627,628,629,630,642,631,632,633,634,635,636,637,638,639,641"
#define USER_OF_USER_RIGHTS_EVENTS "576,577,578,608,609"
#define PROCESS_EVENTS "592,593,594,595"
#define FILE_EVENTS "560,561,562,563,564,594,595"

#define LOGONOFF_TOKEN "Logon/Logoff"
#define FILE_TOKEN "File Events"
#define PROCESS_TOKEN "Process Events"
#define USERIRGHTS_TOKEN "User Right Events"
#define MANAGE_TOKEN "User/Group Management Events"
#define SECPOL_TOKEN "Security Policy Events"
#define REBOOT_TOKEN "Reboot Events"

#define CRITICAL_TOKEN "Critical"
#define PRIORITY_TOKEN "Priority"
#define WARNING_TOKEN "Warning"
#define INFORMATION_TOKEN "Information"
#define CLEAR_TOKEN "Clear"

#define SUCCESS_TOKEN "Success"
#define FAILURE_TOKEN "Failure"
#define INFO_TOKEN "Info"
#define WARN_TOKEN "Warn"
#define ERROR_TOKEN "Error"

#define SECLOG_TOKEN "Sec"
#define SYSLOG_TOKEN "Sys"
#define APPLOG_TOKEN "App"
#define DIRLOG_TOKEN "Dir"
#define DNSLOG_TOKEN "DNS"
#define REPLOG_TOKEN "Rep"

#define SIZE_OF_RESTRICTIP		 1024
#define SIZE_OF_EVENTIDMATCH	 256
#define SIZE_OF_USERMATCH		 256
#define SIZE_OF_GENERALMATCH	 512
#define SIZE_OF_EVENTLOG		 35
#define SIZE_OF_CRITICALITY		 12
#define SIZE_OF_AN_OBJECTIVE	 1056
#define SIZE_OF_CLIENTNAME		 100
#define SIZE_OF_DESTINATION		 100

#define OBJECTIVE_DELIMITER		 ";"


#define READ_CONFIG_ERROR_CODE		340000;
#define READ_NETWORK_ERROR_CODE		240000;
#define READ_REMOTE_ERROR_CODE		740000;
#define READ_OBJECTIVE_ERROR_CODE	440000;
#define WRITE_CONFIG_ERROR_CODE		560000;
#define WRITE_NETWORK_ERROR_CODE	260000;
#define WRITE_REMOTE_ERROR_CODE		760000;
#define WRITE_OBJECTIVE_ERROR_CODE	860000;
#define RESTART_SERVICE_ERROR_CODE	770000;


// The following structure has been defined to cater for the 'config' registry settings
struct  Reg_Config
{
	char	str_Delimiter[2];
	char	str_ClientName[SIZE_OF_CLIENTNAME];
};

struct Reg_Network
{
	char	str_Destination[SIZE_OF_DESTINATION];
	DWORD	dw_SyslogDest;
	DWORD	dw_Syslog;
	DWORD	dw_DestPort;
};

struct Reg_Remote
{
	DWORD	dw_Allow;
	DWORD	dw_WebPort;
	DWORD	dw_WebPortChange;
	DWORD	dw_Restrict;
	char	str_RestrictIP[1024];
};

struct Reg_Objective
{
	char	str_critic[SIZE_OF_CRITICALITY];
	char	str_event_type[SIZE_OF_EVENTLOG];
	char	str_eventlog_type[SIZE_OF_EVENTLOG];
	char	str_eventid_match[SIZE_OF_EVENTIDMATCH];
	char	str_user_match[SIZE_OF_USERMATCH];
	char	str_general_match[SIZE_OF_GENERALMATCH];
};


int Read_Config_Registry(Reg_Config *);
int Read_Objective_Registry(int, Reg_Objective *);
int Read_Network_Registry(Reg_Network *);
int Read_Remote_Registry(Reg_Remote *);
int Write_Config_Registry(Reg_Config *);
int Write_Network_Registry(Reg_Network *);
int Write_Remote_Registry(Reg_Remote *);
int Write_Objective_Registry(int, Reg_Objective *);
int Recreate_Objective_Key();
int Restart_Service();
