// ControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "snare.h"
#include "ControlDlg.h"
#include "support.h"

#include "MD5.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlDlg dialog


CControlDlg::CControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CControlDlg)
	m_bRemote_Control = FALSE;
	m_bWeb_Server_Port = FALSE;
	m_strWeb_Server_Port = _T("");
	m_strIP_Addresses = _T("");
	m_bAllow_IP = FALSE;
	m_strSet_Password = _T("");
	m_bSet_Password = FALSE;
	//}}AFX_DATA_INIT
}


void CControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlDlg)
	DDX_Check(pDX, IDC_REMOTE_CONTROL_CHECK, m_bRemote_Control);
	DDX_Check(pDX, IDC_WEB_SERVER_PORT_CHECK, m_bWeb_Server_Port);
	DDX_Text(pDX, IDC_WEB_SERVER_PORT_EDIT, m_strWeb_Server_Port);
	DDV_MaxChars(pDX, m_strWeb_Server_Port, 5);
	DDX_Text(pDX, IDC_IP_ADDRESS_CONTROL_EDIT, m_strIP_Addresses);
	DDV_MaxChars(pDX, m_strIP_Addresses, SIZE_OF_RESTRICTIP);
	DDX_Check(pDX, IDC_IP_ALLOW_CHECK, m_bAllow_IP);
	DDX_Text(pDX, IDC_PASSWORD_EDIT, m_strSet_Password);
	DDV_MaxChars(pDX, m_strSet_Password, SIZE_OF_PASSWORD);
	DDX_Check(pDX, IDC_PASSWORD_CHECK, m_bSet_Password);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CControlDlg, CDialog)
	//{{AFX_MSG_MAP(CControlDlg)
	ON_BN_CLICKED(IDC_REMOTE_CONTROL_CHECK, OnRemoteControlCheck)
	ON_BN_CLICKED(IDC_IP_ALLOW_CHECK, OnAllowCheck)
	ON_BN_CLICKED(IDC_PASSWORD_CHECK, OnPasswordCheck)
	ON_BN_CLICKED(IDC_WEB_SERVER_PORT_CHECK, OnWebServerPortCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlDlg message handlers

BOOL CControlDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	int read_remote_result = 0;
	Reg_Remote reg_remote;
	DWORD port_number;
	char buffer[20], error_msg[200] = "There was an error reading the registry. \nSome default remote control values will be used. \nReport error code ";
	
	// Create the ToolTip control.
	m_remote_tooltip.Create(this);
	m_remote_tooltip.Activate(TRUE);
	m_remote_tooltip.AddTool(GetDlgItem(IDC_REMOTE_CONTROL_CHECK), "This will enable remote control of SNARE via a web browser");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_IP_ALLOW_CHECK), "Allow only a selected host to control this SNARE agent");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_WEB_SERVER_PORT_CHECK), "This will change the default web server port");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_PASSWORD_CHECK), "This will set a password to control remote access");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT), "Enter the IP address or range of the hosts");	
	m_remote_tooltip.AddTool(GetDlgItem(IDC_PASSWORD_EDIT), "Enter the password");
	m_remote_tooltip.AddTool(GetDlgItem(IDC_WEB_SERVER_PORT_EDIT), "Enter the new web server port");

	// Read the "Remote" Registry settings
	read_remote_result = Read_Remote_Registry(&reg_remote);

	if (read_remote_result > 0)
	{	
		read_remote_result += READ_REMOTE_ERROR_CODE;
		_itoa(read_remote_result,buffer,10);
		strncat(error_msg,buffer,sizeof(buffer));
		MessageBox(error_msg,"Error Reading the Registry",MB_ICONERROR|MB_OK);
	}

	m_strIP_Addresses = reg_remote.str_RestrictIP;
	m_strSet_Password = reg_remote.str_Password;
	m_bRemote_Control = reg_remote.dw_Allow;
	port_number = reg_remote.dw_WebPort;
	m_bAllow_IP = reg_remote.dw_Restrict;
	m_bSet_Password = reg_remote.dw_Password;
	m_bWeb_Server_Port = reg_remote.dw_WebPortChange;

	_itoa(port_number,buffer,10);
	m_strWeb_Server_Port = buffer;

	if (m_bRemote_Control == TRUE)
	{
		GetDlgItem(IDC_IP_ALLOW_CHECK)->EnableWindow(TRUE);
		GetDlgItem(IDC_PASSWORD_CHECK)->EnableWindow(TRUE);
		GetDlgItem(IDC_WEB_SERVER_PORT_CHECK)->EnableWindow(TRUE);
		GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(TRUE);
		GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(TRUE);
		GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(TRUE);

		if (m_bAllow_IP == TRUE)
			GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(TRUE);
		else
			GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(FALSE);

		if (m_bSet_Password == TRUE) {
			GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(TRUE);
		} else {
			GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(FALSE);
		}

		if (m_bWeb_Server_Port == TRUE) {
			GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(TRUE);
		} else {
			m_strWeb_Server_Port = "80";
			GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(FALSE);
		}

	} else {
		GetDlgItem(IDC_IP_ALLOW_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_PASSWORD_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_WEB_SERVER_PORT_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(FALSE);
		GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(FALSE);
		GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(FALSE);
	}

	UpdateData(FALSE);
	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CControlDlg::OnOK() 
{
	Reg_Remote Registry_struct;
	char buffer[20];
	char error_msg[200];
	int i_errornum = 0;
	char temppassword[SIZE_OF_PASSWORD];
	CString CryptTemp;

	strncpy(error_msg,"Problems were encountered in writing to the registry.\nCheck that you are running SNARE with Administrator\nprivileges. Error code = ",200);
	
	strncpy(temppassword,m_strSet_Password,SIZE_OF_PASSWORD);
	
	//Need to update the data from the Window
	UpdateData(TRUE);

	Registry_struct.dw_WebPort = atoi(m_strWeb_Server_Port);
	if ((Registry_struct.dw_WebPort < 1) | (Registry_struct.dw_WebPort > 65535))
	{
		MessageBox("The \"Web Server port number\" must be between 1 and 65535","Error",MB_OK|MB_ICONERROR);
		return;
	}

	strncpy(Registry_struct.str_RestrictIP,m_strIP_Addresses,SIZE_OF_RESTRICTIP);
	if(strcmp(temppassword,m_strSet_Password)!=0) {
		strncpy(temppassword,m_strSet_Password,SIZE_OF_PASSWORD);
		CryptTemp=MD5String(temppassword);		
		strncpy(Registry_struct.str_Password,CryptTemp,sizeof(Registry_struct.str_Password));
	} else {
		strncpy(Registry_struct.str_Password,temppassword,sizeof(Registry_struct.str_Password));
	}


	if (m_bRemote_Control)
		Registry_struct.dw_Allow = 1;
	else
		Registry_struct.dw_Allow = 0;

	if (m_bAllow_IP == 0)
		Registry_struct.dw_Restrict = 0;
	else
		Registry_struct.dw_Restrict = 1;

	if (m_bWeb_Server_Port)
		Registry_struct.dw_WebPortChange = 1;
	else
		Registry_struct.dw_WebPortChange = 0;

	if (m_bSet_Password)
		Registry_struct.dw_Password = 1;
	else
		Registry_struct.dw_Password = 0;


	i_errornum = Write_Remote_Registry(&Registry_struct);

	if (i_errornum > 0)
	{	
		i_errornum += WRITE_REMOTE_ERROR_CODE;
		_itoa(i_errornum,buffer,10);
		strncat(error_msg,buffer,strlen(buffer));
		MessageBox(error_msg,"Error Writing to the Registry",MB_OK|MB_ICONERROR);
		return;
	}


	CDialog::OnOK();
}

BOOL CControlDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_remote_tooltip.RelayEvent(pMsg);
	return CDialog::PreTranslateMessage(pMsg);
}


void CControlDlg::OnRemoteControlCheck() 
{
	UpdateData(TRUE);

	if (m_bRemote_Control == TRUE)
	{
		GetDlgItem(IDC_IP_ALLOW_CHECK)->EnableWindow(TRUE);
		GetDlgItem(IDC_PASSWORD_CHECK)->EnableWindow(TRUE);
		GetDlgItem(IDC_WEB_SERVER_PORT_CHECK)->EnableWindow(TRUE);
		GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(TRUE);
		GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(TRUE);
		GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_IP_ALLOW_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_PASSWORD_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_WEB_SERVER_PORT_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(FALSE);
		GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(FALSE);
		GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(FALSE);
	}
	
}

void CControlDlg::OnAllowCheck() 
{
	UpdateData(TRUE);

	if (m_bAllow_IP == TRUE)
		GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(TRUE);
	else
		GetDlgItem(IDC_IP_ADDRESS_CONTROL_EDIT)->EnableWindow(FALSE);
	
}

void CControlDlg::OnPasswordCheck() 
{
	UpdateData(TRUE);

	if (m_bSet_Password == TRUE)
		GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(TRUE);
	else
		GetDlgItem(IDC_PASSWORD_EDIT)->EnableWindow(FALSE);
	
}

void CControlDlg::OnWebServerPortCheck() 
{
	UpdateData(TRUE);

	if (m_bWeb_Server_Port == TRUE)
		GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(TRUE);
	else
	{
		m_strWeb_Server_Port = "80";
		GetDlgItem(IDC_WEB_SERVER_PORT_EDIT)->EnableWindow(FALSE);
	}

	UpdateData(FALSE);
	
}
