// snareDlg.cpp : implementation file
//

#include "stdafx.h"
#include "snare.h"
#include "snareDlg.h"
#include "WaitDlg.h"
#include "support.h"
#include "EventDlg.h"

#include <process.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


HANDLE hGUIPipe;

void DebugMsg(const char* pszFormat, ...);

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareDlg dialog

CSnareDlg::CSnareDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSnareDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSnareDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSnareDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSnareDlg)
	DDX_Control(pDX, IDC_MAIN_LIST, m_List);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSnareDlg, CDialog)
	//{{AFX_MSG_MAP(CSnareDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_FILE_EXIT, OnFileExit)
	ON_COMMAND(ID_HELP, OnSnareHelp)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_ACTIVITY_APPLYANDRESTARTAUDIT, OnActivityApplyandrestartaudit)
	ON_COMMAND(ID_VIEW_AUDITSTATUS, OnViewAuditstatus)
	ON_COMMAND(ID_SETUP_AUDITCONFIGURATION, OnSetupAuditconfiguration)
	ON_COMMAND(ID_SETUP_REMOTECONTROLCONFIGURATION, OnSetupRemotecontrolconfiguration)
	ON_WM_TIMER()
	ON_COMMAND(ID_ACTIVITY_CLEARTHEDISPLAY, OnActivityClearthedisplay)
	ON_NOTIFY(NM_CLICK, IDC_MAIN_LIST, OnLeftClickMainList)
	ON_COMMAND(ID__EDITOBJECTIVE, OnEditobjective)
	ON_COMMAND(ID_TOOLBAR_COMMENTS, OnToolbarComments)
	ON_COMMAND(ID_TOOLBAR_INTERSECT, OnToolbarIntersect)
	ON_COMMAND(ID_TOOLBAR_STATUS, OnViewAuditstatus)
	ON_COMMAND(ID_TOOLBAR_CLEARDISPLAY, OnActivityClearthedisplay)
	ON_COMMAND(ID_TOOLBAR_AUDITCONF, OnSetupAuditconfiguration)
	ON_COMMAND(ID_TOOLBAR_NETWORK, OnSetupRemotecontrolconfiguration)
	ON_COMMAND(ID_TOOLBAR_RESTART, OnActivityApplyandrestartaudit)
	ON_COMMAND(ID_HELP_COMMENTONSNARE, OnToolbarComments)
	ON_COMMAND(ID_HELP_INTERSECTALLIANCEWEBSITE, OnToolbarIntersect)
	//}}AFX_MSG_MAP
	//***TAKE OUT*** ON_NOTIFY(LVN_ITEMACTIVATE, IDC_MAIN_LIST, OnItemActivate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareDlg message handlers

BOOL CSnareDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rect;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}


	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon to TRUE
	SetIcon(m_hIcon, FALSE);		// Set small icon to FALSE
	
	// TODO: Add extra initialization here
	
	
	// Thread start	
	StartPipe((CListCtrl *)GetDlgItem(IDC_MAIN_LIST));

	//DON'T KNOW WHAT THIS IS***********************
	DWORD dwCurType, dwViewType;
	HWND hWnd;

	dwViewType = LVS_REPORT;
	hWnd = m_List;
	GetSafeHwnd();
	dwCurType = ::GetWindowLong(hWnd,GWL_STYLE);
	dwCurType &= ~LVS_TYPEMASK;
	dwViewType |= dwCurType;
	::SetWindowLong(hWnd,GWL_STYLE,dwViewType);

	//Create the image for the main clist display
	HIMAGELIST hImageList=ImageList_Create(16,16, ILC_COLOR32, 0, 10);
	m_imgSmallIcons.Attach(hImageList);
	CBitmap dummy;
	dummy.LoadBitmap(IDB_BITMAP_SMALL);
	m_imgSmallIcons.Add(&dummy, RGB(0, 0, 0));

	// This is to add the ability to select a row, which is not available in the control.
	ListView_SetExtendedListViewStyle(m_List, LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE);  

	m_imgLargeIcons.Create(IDB_BITMAP_LARGE,32,1,ILC_COLOR);
	m_List.SetImageList(&m_imgSmallIcons,LVSIL_SMALL);
	m_List.SetImageList(&m_imgLargeIcons,LVSIL_NORMAL);

	m_List.InsertColumn(0,"Alert",LVCFMT_RIGHT,33);
	m_List.InsertColumn(1,"Event Date/Time",LVCFMT_LEFT,150);
	m_List.InsertColumn(2,"Details",LVCFMT_LEFT,512);

	//Insert a zero width column, ie; a hidden column
	m_List.InsertColumn(3,"Hidden Details",LVCFMT_LEFT,0);
	
	//initialise and show the toolbar
	m_wndToolBar.Create(this);
	m_wndToolBar.LoadToolBar(IDR_TOOLBAR);
	m_wndToolBar.ShowWindow(SW_SHOW);
	m_wndToolBar.SetBarStyle(CBRS_ALIGN_TOP|CBRS_TOOLTIPS|CBRS_FLYBY);

	RepositionBars(AFX_IDW_CONTROLBAR_FIRST,AFX_IDW_CONTROLBAR_LAST,0);

	// Create the ToolTip control.
	m_snare_tooltip.Create(this);
	m_snare_tooltip.Activate(TRUE);
	m_snare_tooltip.AddTool(GetDlgItem(IDC_MAIN_LIST), "This list shows the filtered events as they are received");

	//This needs to be added since the toolbar has been "added" to the dialog box
	//Note that the comments can be found in the 'properties' section of the toolbar button
	m_wndToolBar.GetToolBarCtrl().GetItemRect(0, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_STATUS,rect,ID_TOOLBAR_STATUS);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(1, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_RESTART,rect,ID_TOOLBAR_RESTART);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(3, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_AUDITCONF,rect,ID_TOOLBAR_AUDITCONF);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(4, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_NETWORK,rect,ID_TOOLBAR_NETWORK);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(6, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_CLEARDISPLAY,rect,ID_TOOLBAR_CLEARDISPLAY);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(7, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_HELP,rect,ID_HELP);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(8, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_COMMENTS,rect,ID_TOOLBAR_COMMENTS);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(9, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_INTERSECT,rect,ID_TOOLBAR_INTERSECT);


	// Check registry permissions - try to open the key in write mode. If it failes,
	// the user must not have permission, so don't bother them with the dialog.
	HKEY hSecKey = MyGetSectionKey("Config");
	if(hSecKey) {
		RegCloseKey(hSecKey);

		// Check to see if this is our first run.
		DWORD FirstRun=0;
		FirstRun=MyGetProfileDWORD("Config","Activate",0);
		if(FirstRun==0) {
			// This is the first time we have been run. Ask the user if they want to have their
			// config auto-set.
			int nChoice = AfxMessageBox("This seems to be the first time you have run the SNARE GUI\n\nIf you wish, SNARE can be configured to manage your EventLog configuration.\nSNARE will set the Event Configuration on the Local Machine, and will\nrecursively set file auditing on your local files, based on the Objectives you configure.\nHowever, this will override any existing audit settings on the local machine.\n\nNote that these values can be changed in the 'Configuration' section of the SNARE GUI.\n\nDo you want SNARE to take over control of your EventLog Configuration? (Recommended)",MB_YESNO|MB_ICONQUESTION);
			if(nChoice == IDYES) {
				MyWriteProfileDWORD("Config","Audit",1);
				MyWriteProfileDWORD("Config","FileAudit",1);
			} else {
				// We are not taking over audit. Fair enough, just forward all currently activated events.
				// Forward all Current audit 
				MyWriteProfileString("Objective","Objective6","1	31	63	*	***	0	*");
			}
			MyWriteProfileDWORD("Config","Activate",1);
		}
	}


	// Create the Event Window
	m_Event_dlg.Create(IDD_EVENT_DIALOG,NULL);


	// Read from the "snare" pipe server
	hPipeSNARECORE = CreateFile("\\\\.\\PIPE\\snare",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,NULL);

	
	if (hPipeSNARECORE == INVALID_HANDLE_VALUE)
	{
		MessageBox("Unable to connect to the \"SNARE\" service. \nCheck to see the \"SNARE\" service is running, or has finished restarting.\nEvents will not be displayed","SNARE Pipe Problem",MB_ICONERROR|MB_OK);
	} else {
		char str_buffer[1024];
		DWORD dwRead;
		//Not interested in an error report at this stage
		ReadFile(hPipeSNARECORE,str_buffer,sizeof(str_buffer),&dwRead,NULL);
		if(dwRead) {
			// Terminate our read buffer with a null.
			str_buffer[dwRead]='\0';
		}
		CloseHandle(hPipeSNARECORE);
	}


	return TRUE;  // return TRUE  unless you set the focus to a control
}



int CSnareDlg::StartPipe(void *list)
{
	// printf("DEBUG: Starting thread.. list is %d\n",list);
	
	if(_beginthread(ListenThread, 0, list ) == -1)
	{
		MessageBox("Unable to Start the SNARE Listen Thread. \nCheck to see the \"SNARE\" service is running.\nEvents will not be displayed","SNARE Pipe Problem",MB_ICONERROR|MB_OK);
		return(-1);
	}

	// printf("thread started..\n");
	return(1);
}


void ListenThread(void *list)
{
	char str_buffer[MAX_OUTPUT_STRING]="";
	int nItem;
	DWORD dwRead;
	CListCtrl *List = (CListCtrl *)list;
	char ListString[1024];
	char SourceName[FIELD_SOURCE_NAME]="";	// Eg: "Security" or "Active Directory"
	char SIDType[FIELD_SIDTYPE]="";		// User or System
	char EventLogType[FIELD_EVENTLOGTYPE]="";	 // Warning / Information / success / failure
	char ExpandedString[FIELD_EXPANDEDSTRING]="";
	char DataString[FIELD_DATASTRING]="";
	char ComputerName[FIELD_COMPUTERNAME]="";
	char UserName[FIELD_USERNAME]="";
	char CategoryString[FIELD_CATEGORYSTRING]=""; // "Detailed Tracking"
	char DateTime[FIELD_DATETIME]="";
	char Criticality[FIELD_CRITICALITY]="";
	char System[FIELD_SYSTEM]="";	
	char null[FIELD_NULL]="";
	char EventID[FIELD_EVENTID]="";
	int crit=0;
	int error = -99;
	BOOL read_result = FALSE;
	HANDLE hPipeSNARECOREt;
	
	//DONT THINK I NEED THIS********
	if(!List)
		return;
	
//	hGUIPipe = CreateNamedPipe("\\\\.\\pipe\\snaregui",PIPE_ACCESS_INBOUND|FILE_FLAG_OVERLAPPED,
//							 PIPE_WAIT,1,5000,5000,0,NULL);
	hGUIPipe = CreateNamedPipe("\\\\.\\pipe\\snaregui",PIPE_ACCESS_INBOUND,
							 PIPE_WAIT,1,5000,5000,0,NULL);

	
	while(1) 
	{
		// Read from pipe
		str_buffer[0]='\0';
		read_result = ReadFile(hGUIPipe,str_buffer,sizeof(str_buffer),&dwRead,NULL);
		error = GetLastError();

		if(dwRead) {
			// Terminate our read buffer with a null.
			str_buffer[dwRead]='\0';

		}

		if (read_result)
		{
			// Add the stuff to the list
			read_event(str_buffer,SourceName,SIDType,EventLogType,ExpandedString,DataString,
				   ComputerName,UserName,CategoryString,DateTime,Criticality,System,
				   null,EventID);

			crit=atoi(Criticality);

			// Is DataString blank?
			//if(!strlen(ExpandedString)) {
			//	strcpy(ExpandedString,DataString);
			//}
			//ExpandedString[strlen(ExpandedString)-1]='\0';
			
			_snprintf(ListString,1024,"%s: %s - %s",SourceName,UserName,ExpandedString);
			// Just in case.
			ListString[sizeof(ListString)-1]='\0';
						
			nItem = List->InsertItem(0,"",crit);
			List->SetItemText(nItem,1,DateTime);
			List->SetItemText(nItem,2,ListString);	
			List->SetItemText(nItem,3,str_buffer);

		} else {
			//Note: 6 = The handle is invalid.  ERROR_INVALID_HANDLE  and
			// 109 = The pipe has been ended.  ERROR_BROKEN_PIPE 
			if (error == 109)
			{
				if(hGUIPipe != INVALID_HANDLE_VALUE) {
					CloseHandle(hGUIPipe);
				}
//				hGUIPipe = CreateNamedPipe("\\\\.\\pipe\\snaregui",PIPE_ACCESS_INBOUND|FILE_FLAG_OVERLAPPED,
//							 PIPE_WAIT,1,5000,5000,0,NULL);
				hGUIPipe = CreateNamedPipe("\\\\.\\pipe\\snaregui",PIPE_ACCESS_INBOUND,
							 PIPE_WAIT,1,5000,5000,0,NULL);


				// Try and connect to the SNARE PIPE.
				hPipeSNARECOREt = INVALID_HANDLE_VALUE;
				while(hPipeSNARECOREt == INVALID_HANDLE_VALUE) {
//					hPipeSNARECOREt = CreateFile("\\\\.\\PIPE\\snare",GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,
//						FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED,NULL);
					hPipeSNARECOREt = CreateFile("\\\\.\\PIPE\\snare",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL,NULL);

					if (hPipeSNARECOREt != INVALID_HANDLE_VALUE)
					{
						ReadFile(hPipeSNARECOREt,str_buffer,sizeof(str_buffer),&dwRead,NULL);
						if(dwRead) {
							// Terminate our read buffer with a null.
							str_buffer[dwRead]='\0';
						}
					} else {
						SleepEx(5000,FALSE);
					}
				}
				CloseHandle(hPipeSNARECOREt);
			} else if(error == 536) {
				SleepEx(5000,FALSE);
			} else {
				// Some other error occurred - Sleep for a moment.
				SleepEx(5000,FALSE);
			}
		}
	}
}



void CSnareDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX) {
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	} else {
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CSnareDlg::OnDestroy()
{
	//If you get an OnOK for the SNAREDlg, put this in
	CloseHandle(hPipeSNAREGUI);

	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSnareDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSnareDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSnareDlg::OnFileExit() 
{
	exit(EXIT_FAILURE);
	
}

void CAboutDlg::OnOK() 
{
	CDialog::OnOK();
}

void CSnareDlg::OnHelpAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();

}

void CSnareDlg::OnSnareHelp() 
{
	ShellExecute(NULL, "open", "http://www.intersectalliance.com/resources/index.html", NULL, ".", SW_SHOWNORMAL);	
}

void CSnareDlg::OnActivityApplyandrestartaudit() 
{
	int return_code = -1, return_modal = 0;
	CString str_error_msg = "The SNARE Audit Service could not be started and/or stopped. Check that it is installed.\nReport error code ";
	char temp[10];
	CWaitDlg wait_dlg;

	//This display the "Please wait..." message
	wait_dlg.Create(IDD_WAIT_DIALOG,NULL);
	wait_dlg.ShowWindow(SW_SHOW);

	return_code = Restart_Service();

	wait_dlg.EndDialog(return_modal);

	if (return_code >= 2)
	{
		return_code += RESTART_SERVICE_ERROR_CODE;
		_itoa( return_code, temp, sizeof(temp));
		str_error_msg = str_error_msg + temp;
		MessageBox(str_error_msg,"SNARE Service Problem",MB_ICONERROR|MB_OK);
	}
	else
		MessageBox("The SNARE Audit Service was restarted successfully.","SNARE Service",MB_ICONINFORMATION|MB_OK);

}


void CSnareDlg::OnViewAuditstatus() 
{
	char str_buffer[1024]="";
	DWORD dwRead;
	HANDLE hPipeSNARECOREt;


	// NEW - TEST
	// WaitNamedPipe("\\\\.\\PIPE\\snare",NMPWAIT_WAIT_FOREVER);
	WaitNamedPipe("\\\\.\\PIPE\\snare",1000);
	
	//Read from the status information from the "snare" pipe server
//	hPipeSNARECOREt = CreateFile("\\\\.\\PIPE\\snare",GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,
//			FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED,NULL);

	hPipeSNARECOREt = CreateFile("\\\\.\\PIPE\\snare",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,NULL);


	if (hPipeSNARECOREt != INVALID_HANDLE_VALUE) {

		if (ReadFile(hPipeSNARECOREt,str_buffer,sizeof(str_buffer),&dwRead,NULL) != 0) {
			if(dwRead) {
				// Terminate our read buffer with a null.
				str_buffer[dwRead]='\0';
			}
			MessageBox(str_buffer,"Status Details",MB_OK);
		} else {
			MessageBox("Unable to read the status information.","SNARE Status Problem",MB_ICONERROR|MB_OK);
		}
		CloseHandle(hPipeSNARECOREt);
	} else {
		MessageBox("Unable to read the status information.","SNARE Status Problem",MB_ICONERROR|MB_OK);
	}


	//***INCLUDE THIS WHEN READY m_dlgStatusDialog.DoModal();
}


void CSnareDlg::OnSetupAuditconfiguration() 
{
	m_dlgConfigDialog.DoModal();	
}

void CSnareDlg::OnSetupRemotecontrolconfiguration() 
{
	m_dlgControlDialog.DoModal();
}


void CSnareDlg::OnActivityClearthedisplay() 
{
	m_List.DeleteAllItems();
}


void CSnareDlg::OnLeftClickMainList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int code = -1;
	char buffer[MAX_OUTPUT_STRING];
	char buffer_text[MAX_OUTPUT_STRING] = "";
	LVITEM row_item;
	char SourceName[FIELD_SOURCE_NAME]="";	// Eg: "Security" or "Active Directory"
	char SIDType[FIELD_SIDTYPE]="";		// User or System
	char EventLogType[FIELD_EVENTLOGTYPE]="";	 // Warning / Information / success / failure
	char ExpandedString[FIELD_EXPANDEDSTRING]="";
	char DataString[FIELD_DATASTRING]="";
	char ComputerName[FIELD_COMPUTERNAME]="";
	char UserName[FIELD_USERNAME]="";
	char CategoryString[FIELD_CATEGORYSTRING]=""; // "Detailed Tracking"
	char DateTime[FIELD_DATETIME]="";
	char Criticality[FIELD_CRITICALITY]="";
	char Critic[20]="";
	char System[FIELD_SYSTEM]="";	
	char null[FIELD_NULL]="";
	char EventID[FIELD_EVENTID]="";
	char *stringp;
	CString temp="default";


	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	code = pNMListView->iItem;
	_itoa( code, buffer, 10 );

	buffer_text[0]='\0';
	row_item.iItem = code;
	row_item.iSubItem = 3;
	row_item.mask = LVIF_TEXT;
	row_item.cchTextMax = sizeof(buffer_text);
	row_item.pszText = buffer_text;
	

	if (m_List.GetItem(&row_item))
	{
		// Add the stuff to the list
		read_event(buffer_text,SourceName,SIDType,EventLogType,ExpandedString,DataString,
				   ComputerName,UserName,CategoryString,DateTime,Criticality,System,
				   null,EventID);

		// Convert tabs to newlines in DataString and Expanded String
		stringp=DataString;
		while(*stringp) 
		{
			if(*stringp=='	') 
				*stringp='\n';
			stringp++;
		}
		stringp=ExpandedString;
		while(*stringp) 
		{
			if(*stringp=='	') 
				*stringp='\n';
			stringp++;
		}

		m_Event_dlg.m_strSystem	 = System;
		m_Event_dlg.m_strCriticality = Criticality;
		m_Event_dlg.m_strCategory=	  SourceName;
		m_Event_dlg.m_strDate=	  DateTime;
		m_Event_dlg.m_strEventID=	  EventID;
		m_Event_dlg.m_strSource	=  SourceName;
		m_Event_dlg.m_strUser	=  UserName;
		m_Event_dlg.m_strSID	=  SIDType;
		m_Event_dlg.m_strEventLog=	  EventLogType;
		m_Event_dlg.m_strComputer=	  ComputerName;
		m_Event_dlg.m_strCategory	=  CategoryString;
		m_Event_dlg.m_strData = DataString;
		m_Event_dlg.m_strExpand = ExpandedString;

		
		m_Event_dlg.UpdateData(FALSE);
		m_Event_dlg.ShowWindow(SW_SHOW);

	}
	*pResult = 0;
}


void CSnareDlg::OnEditobjective() 
{
	CObjectiveDlg m_dObjectiveDlg;
	m_dObjectiveDlg.DoModal();

}


void CSnareDlg::OnToolbarComments() 
{
	ShellExecute(NULL, "open", "mailto:snare_comments@intersectalliance.com", NULL, ".", SW_SHOWNORMAL);
}

void CSnareDlg::OnToolbarIntersect() 
{
	ShellExecute(NULL, "open", "http://www.intersectalliance.com", NULL, ".", SW_SHOWNORMAL);	
}

BOOL CSnareDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_snare_tooltip.RelayEvent(pMsg);
	return CDialog::PreTranslateMessage(pMsg);	
}

void CSnareDlg::OnOK()
{

}


// Duplicate of the CNTService DebugMsg
void DebugMsg(const char* pszFormat, ...)
{
	char buf[8192];
	char date[50];
	char time[50];

	if(!pszFormat) return;
	
	SYSTEMTIME st;

	GetLocalTime(&st);
	GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"dd'/'MM'/'yyyy",date,sizeof(date));
	GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"HH':'mm':'ss",time,sizeof(time));

	_snprintf(buf, 8192, "[SNARE](%lu - %s %s): ", GetCurrentThreadId(),date,time);
	va_list arglist;
	va_start(arglist, pszFormat);
    _vsnprintf(&buf[strlen(buf)],8192-strlen(buf)-1,pszFormat,arglist);
	va_end(arglist);
    _snprintf(buf,8192,"%s\n",buf);

	FILE *fp;

	if(!strlen(pszFormat)) {
		// Send a "" to truncate the file back to zero
		fp=fopen("C:\\SNAREDebug.log","wt");
	} else {
		fp=fopen("C:\\SNAREDebug.log","a");
	}
	if(fp) {
		fprintf(fp,"%s",buf);
		fflush(fp);
		fclose(fp);
	}
}