// COnfigDlg.cpp : implementation file
//



#include "stdafx.h"
#include "snare.h"
#include "COnfigDlg.h"
#include "snareDlg.h"
#include "support.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCOnfigDlg dialog


CCOnfigDlg::CCOnfigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCOnfigDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCOnfigDlg)
	m_strLocal_Host_Name = _T("");
	m_strRemote_IP_Address = _T("");
	m_strRemote_Port_Number = _T("");
	m_bSyslogCheck = FALSE;
	m_iSyslogClass = -1;
	m_iSyslogCritic = -1;
	m_bAudit = FALSE;
	m_bFile_Audit = FALSE;
	m_bFile_Export = FALSE;
	m_bCrit_Audit = FALSE;
	//}}AFX_DATA_INIT
}


void CCOnfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCOnfigDlg)
	DDX_Control(pDX, IDC_OBJECTIVE_LIST, m_ctlObjective_List);
	DDX_Text(pDX, IDC_LOCAL_HOST_NAME, m_strLocal_Host_Name);
	DDV_MaxChars(pDX, m_strLocal_Host_Name, 100);
	DDX_Text(pDX, IDC_REMOTE_IP_ADDRESS, m_strRemote_IP_Address);
	DDV_MaxChars(pDX, m_strRemote_IP_Address, 100);
	DDX_Text(pDX, IDC_PORT_NUMBER, m_strRemote_Port_Number);
	DDV_MaxChars(pDX, m_strRemote_Port_Number, 5);
	DDX_Check(pDX, IDC_SYSLOG_CHECK, m_bSyslogCheck);
	DDX_CBIndex(pDX, IDC_SYSLOG_CLASSIFICATION, m_iSyslogClass);
	DDX_CBIndex(pDX, IDC_SYSLOG_CRITIC, m_iSyslogCritic);
	DDX_Check(pDX, IDC_AUDIT_CHECK, m_bAudit);
	DDX_Check(pDX, IDC_FILE_AUDIT_CHECK, m_bFile_Audit);
	DDX_Check(pDX, IDC_EXPORT_CHECK, m_bFile_Export);
	DDX_Check(pDX, IDC_AUDIT_CRIT_CHECK, m_bCrit_Audit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCOnfigDlg, CDialog)
	//{{AFX_MSG_MAP(CCOnfigDlg)
	ON_BN_CLICKED(IDC_ADD_AN_OBJECTIVE, OnAddAnObjective)
	ON_BN_CLICKED(IDC_SYSLOG_CHECK, OnSyslogCheck)
	ON_NOTIFY(NM_RCLICK, IDC_OBJECTIVE_LIST, OnRclickObjectiveList)
	ON_COMMAND(ID_EDITOBJECTIVE, OnEditPopup)
	ON_COMMAND(ID__DELETEOBJECTIVE, OnDeletePopup)
	ON_BN_CLICKED(ID_OK, OnOk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCOnfigDlg message handlers

BOOL CCOnfigDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	char buffer[1024] = "";
	Reg_Config reg_config;
	Reg_Network reg_network;
	Reg_Objective reg_objective;
	int i_read_config_result = 0, i_read_network_result = 0, i_read_objective_result = 0;
	int objective_count = 0;
	DWORD dw_syslog_value;
	DWORD dw_DynamicCritic=0;
	DWORD dw_syslog,dw_Audit=1,dw_FileAudit=1,dw_CritAudit=0,dw_FileExport=0;
	DWORD port_number;
	char error_msg[200] = "There was an error reading the registry. \nSome default configuration values will be used. \nReport error code ";



	//Set the Objective List View Parameters
	ListView_SetExtendedListViewStyle(m_ctlObjective_List, LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE);  
	m_ctlObjective_List.InsertColumn(0,"Alert Level",LVCFMT_LEFT,70);
	m_ctlObjective_List.InsertColumn(1,"EventType Match",LVCFMT_LEFT,100);
	m_ctlObjective_List.InsertColumn(2,"Event Logs",LVCFMT_LEFT,100);
	m_ctlObjective_List.InsertColumn(3,"Event ID Match",LVCFMT_LEFT,100);
	m_ctlObjective_List.InsertColumn(4,"Non-header Match String",LVCFMT_LEFT,150);
	m_ctlObjective_List.InsertColumn(5,"User Match Type",LVCFMT_LEFT,150);
	m_ctlObjective_List.InsertColumn(6,"User Match String",LVCFMT_LEFT,150);



	// Create the ToolTip control.
	m_control_tooltip.Create(this);
	m_control_tooltip.Activate(TRUE);
	m_control_tooltip.AddTool(GetDlgItem(IDC_LOCAL_HOST_NAME), "This is the name of the local machine. It will default to the local fully qualified hostname");
	m_control_tooltip.AddTool(GetDlgItem(IDC_REMOTE_IP_ADDRESS), "This is the IP address or DNS name of the host which collects the events");
	m_control_tooltip.AddTool(GetDlgItem(IDC_PORT_NUMBER), "This is the UDP Port number, and needs to be set if the events are NOT being sent to a remote SYSLOG server");
	m_control_tooltip.AddTool(GetDlgItem(IDC_SYSLOG_CHECK), "If the events are being sent to a remote SYSLOG server, select this check box.");
	m_control_tooltip.AddTool(GetDlgItem(IDC_OBJECTIVE_LIST), "This contains the list of all the filtering objectives currently in place");
	m_control_tooltip.AddTool(GetDlgItem(IDC_SYSLOG_CLASSIFICATION), "This is the SYSLOG classification");
	m_control_tooltip.AddTool(GetDlgItem(IDC_SYSLOG_CRITIC), "This is the SYSLOG criticality");
	m_control_tooltip.AddTool(GetDlgItem(IDC_AUDIT_CHECK), "When the Snare Audit Service loads, configure the local audit settings based on your objectives");
	m_control_tooltip.AddTool(GetDlgItem(IDC_FILE_AUDIT_CHECK), "When an objective is added or modified, enable auditing on files on the local file system that match your requirements");
	m_control_tooltip.AddTool(GetDlgItem(IDC_EXPORT_CHECK), "Export log files to the LogDir directory within your windows system32 path.");
	m_control_tooltip.AddTool(GetDlgItem(IDC_AUDIT_CRIT_CHECK), "Go through ALL objectives to find the highest criticality match, or just return the first match (faster)");

	// Initialise the var that controls the row that is to be deleted
	m_iObjective_Row = -1;
	m_iAdd_or_Edit_Row = 0;

	// Read the "Config" Registry settings
	i_read_config_result = Read_Config_Registry(&reg_config);
	m_strLocal_Host_Name = reg_config.str_ClientName;
	dw_Audit = reg_config.dw_Audit;
	dw_FileAudit = reg_config.dw_FileAudit;
	dw_FileExport = reg_config.dw_FileExport;
	dw_CritAudit = reg_config.dw_CritAudit;

	if (dw_Audit)
		m_bAudit = TRUE;
	else
		m_bAudit = FALSE;

	if (dw_FileAudit)
		m_bFile_Audit = TRUE;
	else
		m_bFile_Audit = FALSE;

	if (dw_FileExport)
		m_bFile_Export = TRUE;
	else
		m_bFile_Export = FALSE;


	if (dw_CritAudit)
		m_bCrit_Audit = TRUE;
	else
		m_bCrit_Audit = FALSE;


	// Read the "Network" Registry settings
	i_read_network_result = Read_Network_Registry(&reg_network);

	m_strRemote_IP_Address = reg_network.str_Destination;
	dw_syslog_value = reg_network.dw_SyslogDest;
	dw_DynamicCritic=reg_network.dw_DynamicCritic;
	dw_syslog = reg_network.dw_Syslog;
	port_number = reg_network.dw_DestPort;


	// In SYSLOG: First 3 bits = Criticality (eg: emerg, alert, etc.)
	// Rest = Class. Note that there is a gap between ftp and local1.
	if(dw_DynamicCritic) {
		m_iSyslogCritic = 8;
	} else {
		m_iSyslogCritic = (UINT)dw_syslog_value & 7;
	}
	m_iSyslogClass = (UINT)dw_syslog_value >> 3;

	
	if(m_iSyslogClass > 11) 
		m_iSyslogClass = m_iSyslogClass - 4;



	_itoa(port_number,buffer,10);
	//TESTING ONLY*************MessageBox(buffer,"Row",MB_OK);
	m_strRemote_Port_Number = buffer;

	if (dw_syslog)
	{
		m_bSyslogCheck = TRUE;
		m_strRemote_Port_Number = "514";
		GetDlgItem(IDC_PORT_STATIC)->EnableWindow(FALSE);
		GetDlgItem(IDC_PORT_NUMBER)->EnableWindow(FALSE);
		GetDlgItem(IDC_SYSLOG_CLASSIFICATION)->EnableWindow(TRUE);
		GetDlgItem(IDC_SYSLOG_CRITICALITY)->EnableWindow(TRUE);		
	}
	else
	{
		m_bSyslogCheck = FALSE;
		GetDlgItem(IDC_PORT_STATIC)->EnableWindow(TRUE);
		GetDlgItem(IDC_PORT_NUMBER)->EnableWindow(TRUE);
		GetDlgItem(IDC_SYSLOG_CLASSIFICATION)->EnableWindow(FALSE);
		GetDlgItem(IDC_SYSLOG_CRITICALITY)->EnableWindow(FALSE);
	}
	

	int nItem;

	i_read_objective_result = Read_Objective_Registry(objective_count,&reg_objective);
	
	while (i_read_objective_result == 0)
	{
		
		nItem = m_ctlObjective_List.InsertItem(0,reg_objective.str_critic);
		m_ctlObjective_List.SetItemText(nItem,1,reg_objective.str_event_type);
		m_ctlObjective_List.SetItemText(nItem,2,reg_objective.str_eventlog_type);	
		m_ctlObjective_List.SetItemText(nItem,3,reg_objective.str_eventid_match);
		m_ctlObjective_List.SetItemText(nItem,4,reg_objective.str_general_match);
		m_ctlObjective_List.SetItemText(nItem,5,reg_objective.str_user_match_type);
		m_ctlObjective_List.SetItemText(nItem,6,reg_objective.str_user_match);

		objective_count++;
		i_read_objective_result = Read_Objective_Registry(objective_count,&reg_objective);
		
	}
	//TESTING ONLY******_itoa(i_read_objective_result,buffer,10);
	//TESTING ONLY******MessageBox(buffer,"Error",MB_OK|MB_ICONERROR);


	//Report error code is errors were detected
	if ((i_read_config_result > 0) || (i_read_network_result > 0) || 
		((i_read_objective_result > 0) & (i_read_objective_result < 3)))
	{	
		//Display an error to notify that registry writing problems were encountered
		if (i_read_config_result > 0)
		{
			i_read_config_result += READ_CONFIG_ERROR_CODE;
			_itoa(i_read_config_result,buffer,10);
			strncat(error_msg,buffer,strlen(buffer));
		}
		strncpy(buffer,"",sizeof(buffer));
		if (i_read_network_result > 0)
		{
			i_read_network_result += READ_NETWORK_ERROR_CODE;
			_itoa(i_read_network_result,buffer,10);
			if (i_read_config_result > 0)
				strncat(error_msg,".",1);
			strncat(error_msg,buffer,strlen(buffer));
		}
		strncpy(buffer,"",sizeof(buffer));
		if ((i_read_objective_result > 0) & (i_read_objective_result < 3))
		{
			i_read_objective_result += READ_OBJECTIVE_ERROR_CODE;
			_itoa(i_read_objective_result,buffer,10);
			if ((i_read_config_result > 0) || (i_read_network_result > 0))
				strncat(error_msg,".",1);
			strncat(error_msg,buffer,strlen(buffer));
		}

		//Display an error to notify that registry reading problems were encountered
		MessageBox(error_msg,"Error reading from the Registry",MB_OK|MB_ICONERROR);
	}


	//Update the Configuration Window with the new values
	UpdateData(FALSE);

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCOnfigDlg::OnAddAnObjective() 
{
	//This is a private class variable to tell whether the objective is new or existing
	m_iAdd_or_Edit_Row = 0;
	AddorEditanObjective();
}

void CCOnfigDlg::OnSyslogCheck() 
{
	// TODO: Add your control notification handler code here

	UpdateData(TRUE);

	if (m_bSyslogCheck == TRUE)
	{
		// REDREDRED
		m_strRemote_Port_Number = "514";
		UpdateData(FALSE);
		GetDlgItem(IDC_PORT_STATIC)->EnableWindow(FALSE);
		GetDlgItem(IDC_PORT_NUMBER)->EnableWindow(FALSE);
		GetDlgItem(IDC_SYSLOG_CLASSIFICATION)->EnableWindow(TRUE);
		GetDlgItem(IDC_SYSLOG_CRITICALITY)->EnableWindow(TRUE);
	} else {
		m_strRemote_Port_Number = "6161";
		UpdateData(FALSE);
		GetDlgItem(IDC_PORT_STATIC)->EnableWindow(TRUE);
		GetDlgItem(IDC_PORT_NUMBER)->EnableWindow(TRUE);
		GetDlgItem(IDC_SYSLOG_CLASSIFICATION)->EnableWindow(FALSE);
		GetDlgItem(IDC_SYSLOG_CRITICALITY)->EnableWindow(FALSE);
	}
}


void CCOnfigDlg::OnRclickObjectiveList(NMHDR* pNMHDR, LRESULT* pResult) 
{

	CMenu m_dMenu;
	CPoint m_pPoint,pp;
	DWORD selection;
	int code = -1;
	char buffer[1024];


	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;	
	code = pNMListView->iItem;
	_itoa( code, buffer, 10 );

	//The following line will record which row has been selected...for furture processing
	m_iObjective_Row = code;

	if (code > -1)
	{
		if (m_dMenu.LoadMenu(IDR_POPUP_MENU))
		{
		   GetCursorPos(&pp);
		   CMenu* pPopupMenu = m_dMenu.GetSubMenu(0);
		    selection = pPopupMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON , pp.x+2,pp.y+2, this);
		   m_dMenu.DestroyMenu();
		}		
	}
	*pResult = 0;
}

void CCOnfigDlg::OnEditPopup() 
{
	//This is a private class variable to tell whether the objective is new or existing
	m_iAdd_or_Edit_Row = 1;
	AddorEditanObjective();
}


void CCOnfigDlg::OnDeletePopup() 
{
	m_ctlObjective_List.DeleteItem(m_iObjective_Row);
}


BOOL CCOnfigDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_control_tooltip.RelayEvent(pMsg);
	return CDialog::PreTranslateMessage(pMsg);
}

void CCOnfigDlg::OnOk() 
{
	char buffer[100];
	char error_msg[200] = "Problems were encountered in writing to the registry.\nCheck that you are running SNARE with Administrator\nprivileges. Error code = ";
	Reg_Config Registry_struct;
	Reg_Network Network_Registry_struct;
	Reg_Objective Objective_Registry_struct;
	int i_network_errornum = 0,i_config_errornum = 0,i_obj_errornum = 0,i_count = 0,i_total_objectives = 0;
	//TESTING*** *hostname;

	//Need to update the data from the Window
	UpdateData(TRUE);

	//TESTING***strncpy(buffer,m_strRemote_Port_Number,100);
	//TESTING***Network_Registry_struct.dw_DestPort = atoi(buffer);
	Network_Registry_struct.dw_DestPort = atoi(m_strRemote_Port_Number);
	if ((Network_Registry_struct.dw_DestPort < 1) | 
		(Network_Registry_struct.dw_DestPort > 65535))
	{
		MessageBox("The \"remote port number\" must be between 1 and 65535","Error",MB_OK|MB_ICONERROR);
		return;
	}

	strncpy(Registry_struct.str_ClientName,m_strLocal_Host_Name,sizeof(Registry_struct.str_ClientName));

	if (m_bAudit)
		Registry_struct.dw_Audit = 1;
	else
		Registry_struct.dw_Audit = 0;


	if (m_bFile_Audit)
		Registry_struct.dw_FileAudit = 1;
	else
		Registry_struct.dw_FileAudit = 0;

	if (m_bFile_Export)
		Registry_struct.dw_FileExport = 1;
	else
		Registry_struct.dw_FileExport = 0;


	if (m_bCrit_Audit)
		Registry_struct.dw_CritAudit = 1;
	else
		Registry_struct.dw_CritAudit = 0;

	i_config_errornum = Write_Config_Registry(&Registry_struct);


	if (m_bSyslogCheck) {
		Network_Registry_struct.dw_Syslog = 1;
		MessageBox("Notice: Many Syslog servers are not designed to cope with the volume of information that can be generated by Snare Agents. We have seen upwards of 80% loss rates in some cases. Please consider using the Snare Micro Server for audit delivery.","SNARE Service",MB_ICONINFORMATION|MB_OK);
	} else {
		Network_Registry_struct.dw_Syslog = 0;
	}


	strncpy(Network_Registry_struct.str_Destination,m_strRemote_IP_Address,sizeof(Network_Registry_struct.str_Destination));
	
	HOSTENT *hp;
	if(!IsIPAddr(m_strRemote_IP_Address)) {

		if ( (hp = gethostbyname(m_strRemote_IP_Address)) == NULL)
		{
			MessageBox("The host name cannot be resolved by this system. Please enter a hostname that this server understands, or an IP address","Error",MB_OK|MB_ICONERROR);
			return;
		}
	}

	// First 3 bits = criticality (eg: emerg, alert, etc.)
	// Rest = category.
	if(m_iSyslogCritic > 7) {
		m_iSyslogCritic=0;
		Network_Registry_struct.dw_DynamicCritic=1;
	} else {
		Network_Registry_struct.dw_DynamicCritic=0;
	}
	Network_Registry_struct.dw_SyslogDest = m_iSyslogCritic;
	if(m_iSyslogClass > 11)  
		m_iSyslogClass = m_iSyslogClass + 4;
	Network_Registry_struct.dw_SyslogDest = Network_Registry_struct.dw_SyslogDest | (m_iSyslogClass << 3);


	i_network_errornum = Write_Network_Registry(&Network_Registry_struct);
	
	
	Recreate_Objective_Key();

	i_total_objectives = m_ctlObjective_List.GetItemCount();

	for (i_count = 0; i_count < i_total_objectives; i_count++)
	{
		m_ctlObjective_List.GetItemText(i_count,0,Objective_Registry_struct.str_critic,SIZE_OF_CRITICALITY);
		m_ctlObjective_List.GetItemText(i_count,1,Objective_Registry_struct.str_event_type,SIZE_OF_EVENTLOG);
		m_ctlObjective_List.GetItemText(i_count,2,Objective_Registry_struct.str_eventlog_type,SIZE_OF_EVENTLOG);	
		m_ctlObjective_List.GetItemText(i_count,3,Objective_Registry_struct.str_eventid_match,SIZE_OF_USERMATCH);
		m_ctlObjective_List.GetItemText(i_count,4,Objective_Registry_struct.str_general_match,SIZE_OF_GENERALMATCH);
		m_ctlObjective_List.GetItemText(i_count,5,Objective_Registry_struct.str_user_match_type,SIZE_OF_USER_MATCH_TYPE);
		m_ctlObjective_List.GetItemText(i_count,6,Objective_Registry_struct.str_user_match,SIZE_OF_USERMATCH);

		i_obj_errornum = Write_Objective_Registry(i_count, &Objective_Registry_struct);
	}

	if ((i_config_errornum > 0) || (i_network_errornum > 0) || (i_obj_errornum > 0))
	{	
		//Display an error to notify that registry writing problems were encountered
		if (i_config_errornum > 0)
		{
			i_config_errornum += WRITE_CONFIG_ERROR_CODE;
			_itoa(i_config_errornum,buffer,10);
			strncat(error_msg,buffer,strlen(buffer));
		}
		strncpy(buffer,"",sizeof(buffer));
		if (i_network_errornum > 0)
		{
			i_network_errornum += WRITE_NETWORK_ERROR_CODE;
			_itoa(i_network_errornum,buffer,10);
			if (i_config_errornum > 0)
				strncat(error_msg,".",1);
			strncat(error_msg,buffer,strlen(buffer));
		}
		strncpy(buffer,"",sizeof(buffer));
		if (i_obj_errornum > 0)
		{
			i_obj_errornum += WRITE_OBJECTIVE_ERROR_CODE;
			_itoa(i_obj_errornum,buffer,10);
			if ((i_config_errornum > 0) || (i_network_errornum > 0))
				strncat(error_msg,".",1);
			strncat(error_msg,buffer,strlen(buffer));
		}

		//Display an error to notify that registry writing problems were encountered, and
		//do not close the window
		MessageBox(error_msg,"Error Writing to the Registry",MB_OK|MB_ICONERROR);
		return;
	}
	else
	{
		OnOK();
	}

}


void CCOnfigDlg::AddorEditanObjective()
{
	CString str_critic="",str_type="",str_log="",str_obj="",str_user_match_type="";
	int i_Item, i_type = 0;
	CObjectiveDlg m_dObjectiveDlg;
	
	//Edit an existing objective
	if (m_iAdd_or_Edit_Row == 1)
	{
		i_Item = m_iObjective_Row;
		m_dObjectiveDlg.m_strSearchFilter = m_ctlObjective_List.GetItemText(i_Item,4);
		m_dObjectiveDlg.m_strUserFilter = m_ctlObjective_List.GetItemText(i_Item,6);
		str_critic = m_ctlObjective_List.GetItemText(i_Item,0);
		str_type = m_ctlObjective_List.GetItemText(i_Item,1);
		str_log = m_ctlObjective_List.GetItemText(i_Item,2);
		str_obj = m_ctlObjective_List.GetItemText(i_Item,3);
		str_user_match_type = m_ctlObjective_List.GetItemText(i_Item,5);

		if (str_critic.Compare(CRITICAL_TOKEN) == 0)
			m_dObjectiveDlg.m_iAlertType = 0;
		else if (str_critic.Compare(PRIORITY_TOKEN) == 0)
			m_dObjectiveDlg.m_iAlertType = 1;
		else if (str_critic.Compare(WARNING_TOKEN) == 0)
			m_dObjectiveDlg.m_iAlertType = 2;
		else if (str_critic.Compare(INFORMATION_TOKEN) == 0)
			m_dObjectiveDlg.m_iAlertType = 3;
		else 
			m_dObjectiveDlg.m_iAlertType = 4;

		if (str_user_match_type.Compare(INCLUDE) == 0)
			m_dObjectiveDlg.m_InclExclUser = 0;
		else
			m_dObjectiveDlg.m_InclExclUser = 1;

		if (str_type.Find(SUCCESS_TOKEN) > -1)
			m_dObjectiveDlg.m_bSuccessCheck = TRUE;
		if (str_type.Find(FAILURE_TOKEN) > -1)
			m_dObjectiveDlg.m_bFailureCheck = TRUE;
		if (str_type.Find(INFO_TOKEN) > -1)
			m_dObjectiveDlg.m_bInformationCheck = TRUE;
		if (str_type.Find(WARN_TOKEN) > -1)
			m_dObjectiveDlg.m_bWarningCheck = TRUE;
		if (str_type.Find(ERROR_TOKEN) > -1)
			m_dObjectiveDlg.m_bErrorCheck = TRUE;


		if (str_log.Find(SECLOG_TOKEN) > -1)
			m_dObjectiveDlg.m_bSecLogCheck = TRUE;
		if (str_log.Find(SYSLOG_TOKEN) > -1)
			m_dObjectiveDlg.m_bSysLogCheck = TRUE;
		if (str_log.Find(APPLOG_TOKEN) > -1)
			m_dObjectiveDlg.m_bAppLogCheck = TRUE;
		if (str_log.Find(DIRLOG_TOKEN) > -1)
			m_dObjectiveDlg.m_bDirLogCheck = TRUE;
		if (str_log.Find(DNSLOG_TOKEN) > -1)
			m_dObjectiveDlg.m_bDNSLogCheck = TRUE;
		if (str_log.Find(REPLOG_TOKEN) > -1)
			m_dObjectiveDlg.m_bRepLogCheck = TRUE;

		if (str_obj.Compare(LOGONOFF_TOKEN) == 0)
		{
			m_dObjectiveDlg.m_strEventID = LOGON_LOGOFF_EVENTS;
			m_dObjectiveDlg.m_iObjectiveType = 0;
		}
		else if (str_obj.Compare(FILE_TOKEN) == 0)
		{
			m_dObjectiveDlg.m_strEventID = FILE_EVENTS;
			m_dObjectiveDlg.m_iObjectiveType = 2;
		}
		else if (str_obj.Compare(PROCESS_TOKEN) == 0)
		{
			m_dObjectiveDlg.m_strEventID = PROCESS_EVENTS;
			m_dObjectiveDlg.m_iObjectiveType = 4;
		}
		else if (str_obj.Compare(USERRIGHTS_TOKEN) == 0)
		{
			m_dObjectiveDlg.m_strEventID = USER_OF_USER_RIGHTS_EVENTS;
			m_dObjectiveDlg.m_iObjectiveType = 6;
		}
		else if (str_obj.Compare(MANAGE_TOKEN) == 0)
		{
			m_dObjectiveDlg.m_strEventID = USER_GROUP_ADMIN_EVENTS;
			m_dObjectiveDlg.m_iObjectiveType = 1;
		}
		else if (str_obj.Compare(SECPOL_TOKEN) == 0)
		{
			m_dObjectiveDlg.m_strEventID = SECURITY_POLICY_EVENTS;
			m_dObjectiveDlg.m_iObjectiveType = 3;
		}
		else if (str_obj.Compare(REBOOT_TOKEN) == 0)
		{
			m_dObjectiveDlg.m_strEventID = RESTART_EVENTS;
			m_dObjectiveDlg.m_iObjectiveType = 5;
		}
		else 
		{
			m_dObjectiveDlg.m_strEventID = str_obj;
			m_dObjectiveDlg.m_iObjectiveType = 7;
		}

		//Reset the variables since they're re-used later in this function
		str_critic="";
		str_type="";
		str_log="";
		str_obj="";
		str_user_match_type="";
	}
	else if (m_iAdd_or_Edit_Row == 0)  //Add an objective
	{
		m_dObjectiveDlg.m_iAlertType = 0;
		m_dObjectiveDlg.m_InclExclUser = 0;
		m_dObjectiveDlg.m_bSuccessCheck = TRUE;
		m_dObjectiveDlg.m_bFailureCheck = TRUE;
		m_dObjectiveDlg.m_bSecLogCheck = TRUE;
		m_dObjectiveDlg.m_bSysLogCheck = TRUE;
		m_dObjectiveDlg.m_bAppLogCheck = TRUE;
		m_dObjectiveDlg.m_iObjectiveType = 7;
		m_dObjectiveDlg.m_strSearchFilter = "*";
		m_dObjectiveDlg.m_strUserFilter = "*";
		m_dObjectiveDlg.m_strEventID = "*";
	}


	if (m_dObjectiveDlg.DoModal() == IDOK)
	{
		
		if (m_dObjectiveDlg.m_iAlertType == 0)
			str_critic = CRITICAL_TOKEN;
		else if (m_dObjectiveDlg.m_iAlertType == 1)
			str_critic = PRIORITY_TOKEN;
		else if (m_dObjectiveDlg.m_iAlertType == 2)
			str_critic = WARNING_TOKEN;
		else if (m_dObjectiveDlg.m_iAlertType == 3)
			str_critic = INFORMATION_TOKEN;
		else 
			str_critic = CLEAR_TOKEN;

		if (m_dObjectiveDlg.m_InclExclUser == 0)
			str_user_match_type=INCLUDE;
		else
			str_user_match_type=EXCLUDE;
		
		if (m_dObjectiveDlg.m_bSuccessCheck)
		{
			str_type = SUCCESS_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bFailureCheck)
		{
			if (i_type)
				str_type += ",";
			str_type += FAILURE_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bInformationCheck)
		{
			if (i_type)
				str_type += ",";
			str_type += INFO_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bWarningCheck)
		{
			if (i_type)
				str_type += ",";
			str_type += WARN_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bErrorCheck)
		{
			if (i_type)
				str_type += ",";
			str_type += ERROR_TOKEN;
			i_type = 1;
		}

		//This variable is to insert the commas
		i_type = 0;

		if (m_dObjectiveDlg.m_bSecLogCheck)
		{
			str_log = SECLOG_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bSysLogCheck)
		{
			if (i_type)
				str_log += ",";
			str_log += SYSLOG_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bAppLogCheck)
		{
			if (i_type)
				str_log += ",";
			str_log += APPLOG_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bDirLogCheck)
		{
			if (i_type)
				str_log += ",";
			str_log += DIRLOG_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bDNSLogCheck)
		{
			if (i_type)
				str_log += ",";
			str_log += DNSLOG_TOKEN;
			i_type = 1;
		}
		if (m_dObjectiveDlg.m_bRepLogCheck)
		{
			if (i_type)
				str_log += ",";
			str_log += REPLOG_TOKEN;
			i_type = 1;
		}

		if (m_dObjectiveDlg.m_iObjectiveType == 0)
			str_obj = LOGONOFF_TOKEN;
		else if (m_dObjectiveDlg.m_iObjectiveType == 2)
			str_obj = FILE_TOKEN;
		else if (m_dObjectiveDlg.m_iObjectiveType == 4)
			str_obj = PROCESS_TOKEN;
		else if (m_dObjectiveDlg.m_iObjectiveType == 6)
			str_obj = USERRIGHTS_TOKEN;
		else if (m_dObjectiveDlg.m_iObjectiveType == 1)
			str_obj = MANAGE_TOKEN;
		else if (m_dObjectiveDlg.m_iObjectiveType == 3)
			str_obj = SECPOL_TOKEN;
		else if (m_dObjectiveDlg.m_iObjectiveType == 5)
			str_obj = REBOOT_TOKEN;
		else if (m_dObjectiveDlg.m_iObjectiveType == 7)
			str_obj = m_dObjectiveDlg.m_strEventID;


		//If the m_iAdd_or_Edit_Row is 0, then we want to add a row
		if (m_iAdd_or_Edit_Row == 0)
		{
			i_Item = m_ctlObjective_List.GetItemCount( );
			m_ctlObjective_List.InsertItem(i_Item,str_critic,1);
			m_ctlObjective_List.SetItemText(i_Item,1,str_type);
			m_ctlObjective_List.SetItemText(i_Item,2,str_log);
			m_ctlObjective_List.SetItemText(i_Item,3,str_obj);
			m_ctlObjective_List.SetItemText(i_Item,4,m_dObjectiveDlg.m_strSearchFilter);
			m_ctlObjective_List.SetItemText(i_Item,5,str_user_match_type);
			m_ctlObjective_List.SetItemText(i_Item,6,m_dObjectiveDlg.m_strUserFilter);
		}
		//If the m_iAdd_or_Edit_Row is 1, then we want to edit a row
		if (m_iAdd_or_Edit_Row == 1)
		{
			m_ctlObjective_List.SetItemText(i_Item,0,str_critic);
			m_ctlObjective_List.SetItemText(i_Item,1,str_type);
			m_ctlObjective_List.SetItemText(i_Item,2,str_log);
			m_ctlObjective_List.SetItemText(i_Item,3,str_obj);
			m_ctlObjective_List.SetItemText(i_Item,4,m_dObjectiveDlg.m_strSearchFilter);
			m_ctlObjective_List.SetItemText(i_Item,5,str_user_match_type);
			m_ctlObjective_List.SetItemText(i_Item,6,m_dObjectiveDlg.m_strUserFilter);
		}

	}
	

}

int CCOnfigDlg::IsIPAddr(CString CSaddr)
{
	TCHAR addr[64];
	strncpy(addr,CSaddr,sizeof(addr));

	char lastChar = '.', *p;
	int digitCnt = 0, dotCnt = 0;

    for (p = addr; p && *p; p++) {
        if (*p == '.' && lastChar != '.')
            dotCnt++;
        else if (*p>='0' && *p<='9')
            digitCnt++;
        else
            return 0;
        lastChar = *p;
    }
    if (digitCnt > 3 && digitCnt < 13 && dotCnt == 3 && (lastChar >='0' && lastChar <= '9'))
        return 1;
    return 0;
}
	
