#!/bin/sh
########################################################################
#    
#    (c) 2001-2005 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of the snare audit daemon.
#   
#   Version 1.8
#    
#    Usage: ./install.sh
#
########################################################################





########################################################################
#   Check that the necessary files are contained within the local
#   directory. 
########################################################################

file_check()
{

     if [ ! -e src/snarecore ];then
        echo "The snarecore binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -e src/bintest ];then
        echo "The bintest binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -e install/snare.conf.basic ];then
        echo "The new basic configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -e install/snare.conf.medium ];then
        echo "The new medium configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -e install/snare.conf.advanced ];then
        echo "The new advanced configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -e install/restartsnare ];then
        echo "The audit restart script is missing. Terminating script."
        exit 1 
     fi

     if [ ! -e install/snarestream ];then
        echo "The snare stream script is missing. Terminating script."
        exit 1 
     fi

     if [ ! -e uninstall.sh ]
     then
        echo "The snare removal script is missing. Terminating script."
        exit 1 
     fi
}

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ]
	then
           echo "You need to be root to run this script. Terminating script."
           exit 1
        else
           echo "Confirmed that you are logged in as root"
	fi

}

########################################################################
#   Check that the software patch level is OK.
########################################################################

check_os_and_patch_level()
{
   uname -a | egrep "AIX" > /dev/null
   RETVAL=$?

   if [ $RETVAL -gt 0 ]
   then
     echo "This application is designed for AIX systems only. Terminating script"
     exit 1
   fi 
}

########################################################################
#   Check that the AIX audit sub-system is installed.
########################################################################

check_audit_is_on()
{
    # Seems to be on by default. Continue for the moment.
    echo
}


########################################################################
#   This routine will back up the key audit related files
########################################################################

backup_key_files()
{
   echo "Backing up key files..........."

   if [ ! -e /etc/security/audit/config.snare-backup ];then
      cp /etc/security/audit/config /etc/security/audit/config.snare-backup
      RETVAL=$?
      if [ $RETVAL -gt 0 ]
      then
        echo "Unable to backup the /etc/security/audit/config file. Terminating script"
        exit 1
      fi
   else
      echo "Backup of the audit config file already exists. Not overwriting"
   fi
}

check_binary()
{
	echo "Verifying that the binaries will work on this system..."

	if [ ! -e src/snarecore ] || [ ! -e src/snarejoin ]; then
		recompile
	fi

	src/bintest >/dev/null 2>&1
	if [ $? -ne 1 ]; then
		recompile
	else
		echo "The included binaries seem to work on this system."
	fi
}

recompile()
{
	echo "The included binaries do not work on your architecture."
	echo "I am attempting to recompile snare to work on your system."

	which gcc >/dev/null
	if [ $? -ne 0 ]; then
		echo ""
		echo "Sorry - I cannot seem to find gcc in your current PATH."
		echo "Please update your path environment variable, and retry"
		echo "this installation."
		exit 1
	fi
	cd src
	which make >/dev/null
	if [ $? -ne 0 ]; then
		echo ""
		echo "Sorry - I cannot seem to find 'make' in your current PATH."
		echo "Please update your path environment variable, and retry"
		echo "this installation."
		exit 1
	fi
	make clean
	make
	if [ $? -ne 0 ]; then
		echo ""
		echo "I attempted to build the Snare binaries for this system,"
		echo "but the 'make' process reported that there were problems."
		echo ""
		echo "Please send the output above, to the team at InterSect Alliance,"
		echo "and we will try to assist."
		exit 1
	fi
	echo ""
	echo "The compilation process succeeded!"
	echo ""
	cd ..
}

########################################################################
#  This is the main loop  
########################################################################

check_audit_is_on
file_check 
root_check
check_os_and_patch_level
backup_key_files
check_binary

INSTAL=0
SNAREC=0

if [ -e /etc/security/audit/snare.conf ]; then
   SNAREC=1
fi

if [ -e /etc/security/audit/snarestream ]; then
	echo "WARNING: It looks as though Snare is already installed."
	echo
	echo "Please uninstall Snare first before proceeding, using the snare_uninstall.sh script in /etc/security/audit/"
	echo
	exit
fi

# Kill off any outstanding pid files.
if [ -e /var/run/snarecore.pid ]; then
	rm -f /var/run/snarecore.pid >/dev/null 2>&1
fi

while [ "$INSTAL" -ne "1" ] && [ "$INSTAL" -ne "2" ] && [ "$INSTAL" -ne "3" ]
do
  echo 
  echo "Enter [1] to install a basic starting configuration:"
  echo "  - login/logout, su, password changes, mounts, system reboots"
  echo "  - Recommended for workstations"
  echo "Enter [2] to install an average starting configuration:"
  echo "  - Basic install, plus process execution events"
  echo "  - Recommended for servers"
  echo "Enter [3] to install an advanced starting configuration:"
  echo "  - Normal install, plus file-based auditing"
  if [ "$SNAREC" -eq "1" ]; then
     echo "Enter [4] to preserve the EXISTING snare configuration file"
  fi
  echo "Enter anything else to terminate the script"
  echo "Please enter your selection: on the next line: "
    read INSTAL
    case $INSTAL in
       1) echo "Installing basic configuration files"; INSTALL_TYPE=1 ;;
       2) echo "Installing average configuration files"; INSTALL_TYPE=2 ;;
       3) echo "Installing advanced configuration files"; INSTALL_TYPE=3 ;;
       4) if [ "$SNAREC" -eq "1" ]; then
		echo "Preserving existing SNARE configuration"
		INSTALL_TYPE=4
	  else
		echo "Script terminating at user request";
		exit 1;
	  fi;;
       *) echo "Script terminating at user request"; exit 1 ;;
    esac 
done
 

########################################################################
#  This provides the final warning before the software is loaded onto
#  the system. In case of mistakes, it allows the user to escape before 
#  the software is loaded.   
########################################################################

echo 
echo "*************************************************"
echo 
echo "You are about to install Snare on this host."
echo "Your selections are as follows:"
if [ $INSTALL_TYPE -eq 1 ]; then
  echo "Basic Installation"
elif [ $INSTALL_TYPE -eq 2 ]; then
  echo "Normal Installation"
elif [ $INSTALL_TYPE -eq 3 ]; then
  echo "Advanced Installation"
else
  echo "Preserving existing configuration file."
fi



########################################################################
#  This will copy the common workstation and server files to
#  to /etc directory.  
########################################################################

if [ $INSTALL_TYPE -eq 1 ] || [ $INSTALL_TYPE -eq 2 ] || [ $INSTALL_TYPE -eq 3 ] || [ $INSTALL_TYPE -eq 4 ]; then

   # Kill the audit daemon, if it is alive
   /usr/sbin/audit shutdown >/dev/null 2>&1
   sleep 2

   echo
   echo "Installing common files..........."

   cp src/snarecore src/snarejoin /usr/bin/

   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to copy the snarecore and snarejoin programs to /usr/bin. Terminating script"
     exit 1
   fi

   chown root:system /usr/bin/snarecore /usr/bin/snarejoin
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to change owner for file to /usr/bin/snarecore and /usr/bin/snarejoin. Terminating script"
     exit 1
   fi
   chmod  550 /usr/bin/snarecore /usr/bin/snarejoin
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to change the permissions for file to /usr/bin/snarecore and /usr/bin/snarejoin. Terminating script"
     exit 1
   fi

   cp install/restartsnare install/snareconfig.template install/snarestream /etc/security/audit/
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to copy support files into /etc/security/audit. Terminating script"
     exit 1
   fi

   chown root:system /etc/security/audit/restartsnare /etc/security/audit/snareconfig.template /etc/security/audit/snarestream
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to change owner for the support files in /etc/security/audit. Terminating script"
     exit 1
   fi

   chmod  550 /etc/security/audit/restartsnare /etc/security/audit/snarestream
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to change the permissions for the support files in /etc/security/audit. Terminating script"
     exit 1
   fi


   cp uninstall.sh /etc/security/audit/snare_uninstall.sh
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to copy the snare uninstall.sh script to /etc/security/audit. Terminating script"
     exit 1
   fi

   echo
   echo "Successfully installed the common files"
   echo
fi


########################################################################
#  This will copy the workstation files to /etc/security/audit, for a
#  workstation setup. It will also change the owner and permissions
#  for these files.
########################################################################

if [ $INSTALL_TYPE -eq 1 ];then
   echo
   echo "Installing basic configuration files..........."

   cp install/snare.conf.basic /etc/security/audit/snare.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to copy the audit_event file to /etc/security/audit. Terminating script"
     exit 1 
   fi
   chown root:system /etc/security/audit/snare.conf
   chmod 600 /etc/security/audit/snare.conf

fi


########################################################################
#  This will copy the server files to /etc/security/audit, for a
#  workstation setup. It will also change the owner and permissions
#  for these files.
########################################################################


if [ $INSTALL_TYPE -eq 2 ];then
   echo
   echo "Installing average configuration files..........."


   cp install/snare.conf.medium /etc/security/audit/snare.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ];then
     echo "Unable to copy the audit_event file to /etc/security/audit. Terminating script"
     exit 1 
   fi
   chown root:system /etc/security/audit/snare.conf
   chmod 700 /etc/security/audit/snare.conf
fi

if [ $INSTALL_TYPE -eq 3 ];then
   echo
   echo "Installing average configuration files..........."


   #cp intall/snare.conf.advanced /etc/security/audit/snare.conf
   cp install/snare.conf.advanced /etc/security/audit/snare.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the audit_event file to /etc/security/audit. Terminating script"
     exit 1 
   fi
   chown root:system /etc/security/audit/snare.conf
   chmod 700 /etc/security/audit/snare.conf
fi


echo
echo "Successfully installed the necessary files. Activating auditing..."
echo 

/etc/security/audit/restartsnare

sleep 2

PID=`/usr/bin/ps -e -u 0|/usr/bin/fgrep snarecor|/usr/bin/egrep -v fgrep|/usr/bin/awk '{print $1}'`
if [ -z "$PID" ] ;  then
        echo "Snare not running. Please check installation parameters."
        exit 1;
fi

echo "Done."
echo
echo "Snare will also be activated after a reboot via the"
echo "normal AIX audit init process."
echo
echo "Please connect to the local machine using your web browser"
echo "using the following URL: http://"`hostname`":6161/"
echo "and a userid and password of 'snare'"
echo "Once connected, please CHANGE THE DEFAULT PASSWORD, configure"
echo "any additonal audit objectives you require, and restart"
echo "the audit server".
echo ""

exit 0

