/**********************************************************
 *
 * Snare for AIX header file
 *
 * Author: InterSect Alliance Pty Ltd
 *
 * Copyright 2001-2004 InterSect Alliance Pty Ltd
 *
 * Last Modified: 7/12/2004
 *
 * Available under the terms of the GNU Public Licence.
 * - See www.gnu.org
 *
 **********************************************************
 *
 * History:
 *       7/11/2004  Initial working version
 *
 **********************************************************/

// Linked List
struct _node {
	// int event_number;    // The event number this is supposed to match
	char event_name[MAX_EVENTNAME];	// The event number this is supposed to match
	int criticality;	// How critical is this particular node
	int returncode;		// return code required.
	int excludeflag;	// Include or exclude users?
	int excludematchflag;	// Include or exclude the match?
	char username[MAX_USERREG];	// Remember, this will be a regular expression.
	regex_t usernameRE;
	char path[MAX_PATH];	// NOTE: this could match either path or destpath
	regex_t pathRE;
	char options[MAX_OPTIONS];	// Options associated with a audit type (eg: O_RDONLY|O_CREAT)
	regex_t optionsRE;
	struct _node *next;
};

typedef struct _node Node;

// Linked List
struct _msgcache {
	char * msg;
	int msglen;
	struct _msgcache *next;
};

typedef struct _msgcache MsgCache;

struct _hostnode
{
	int AuditSocket;
	struct sockaddr_in      AuditSocketName;
	socklen_t dest_addr_size;
	time_t last_error;
	char desthost[MAX_HOSTID];
	int port;
	int protocol;
	int cacheflag;
	struct _hostnode *next;
};

typedef struct _hostnode HostNode;

int turn_event_on(int);
int turn_event_off(int);
int setclass(unsigned int);
int read_config_file(int);
char *gethostident(char *string, char *host, int length);
char *getconfstring(char *string, char *file, int length);
int getport(char *string);

int flush_audit_events(void);

void trim(char *string);
void trimallwhitespace(char *string);
int IsListEmpty(void);

Node *AddToList(char *eventname, char *username, char *path,
		int criticality, char *options, int excludeflag,
		int excludematchflag, int returncode);
char *getfqdn(char *FQDN);

Node *CheckObjective(char *username, char *searchterm, char *eventname,
		     char *options, int returncode);
char *FormatDelimiters(char *eventbuffer);
int GetAIXDetails(char *logbuffer, char *username, char *searchterm,
		  char *eventname, char *options);
int GetElement(char *source, int count, char *dest, int buffersize);
Node *GetCurrentItem(void);

char *FindToken(char *,char *);

void DestroyList(void);

int audit_off(void);
int iscomment(char *);
int isheader(char *);
int getheader(char *);
int splitobjective(char *,char *,char *,char *,int *,int *,int *);
int isfilename(char *);
int isnetwork(char *);
int regmatch(const char *, const char *);
int regmatchi(const char *, const char *);
int sendevent(char *,int);
void syslogdate(char *, struct tm *);
int issyslog(char *);
int get_syslog_dest(char *);


int open_audit_network(char *);
int open_audit_output(char *);

extern int StartThread(void);

void DebugMsg(const char *,...);
int IsSocketValid(int socket);
void * purge_cache();
int fix_last_error(HostNode *hn);
