#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <crypt.h>
#include <ctype.h>
#include <netdb.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "webserver.h"
#include "WebPages.h"

#define MAX_RESTRICTIP 1

// Socket for our pseudo-httpd server
int http_listen_socket;
int http_message_socket;

// NOTE: This password sits in RAM.
// A user with appropriate access could pull it out.
char SnarePass[256];
char SnareIP[MAX_RESTRICTIP][17];
char SnareHost[MAX_RESTRICTIP][SIZE_OF_CLIENTNAME];
int SnareIP_count=0;
int caught_web_kill = 0;
extern int EvtCount;
extern void DebugMsg(const char *,...);

void webkill(sig) {
#ifdef DEBUG
	DebugMsg("WEBKILL called");
#endif //DEBUG
	caught_web_kill++;
	if(http_listen_socket > 0) {
		shutdown(http_listen_socket,SHUT_RDWR);
		close(http_listen_socket);
		http_listen_socket=-1;
	}
	return;
}

int InitWebServer(unsigned short port, char *ip, char *password)
{
	struct sockaddr_in local;
	int sockopt = 1;
	struct hostent *phostent;
	struct in_addr in;
	char rsip[SIZE_OF_RESTRICTIP];

	strncpy(SnarePass, "", 255);
	strncpy(SnareIP[0], "", 15);
	http_listen_socket = 0;
	http_message_socket = 0;

	signal(SIGPIPE,webkill);
	signal(SIGTERM,webkill);

	if (password) {
		strncpy(SnarePass, password, 256);
	}

	if (ip) {
		if (strlen(ip)) {
			phostent=gethostbyname(ip);
			if(phostent) {
				// strncpy(lpszIPAddress,phostent->h_addr_list[0],size);
				memcpy(&in.s_addr, phostent->h_addr, phostent->h_length);
				strncpy(SnareIP[SnareIP_count],inet_ntoa(in),sizeof(SnareIP[SnareIP_count]));
			} else {
				strncpy(SnareIP[SnareIP_count],ip,sizeof(SnareIP[SnareIP_count]));
			}
			SnareIP_count++;
		} else {
			strcpy(SnareIP[0], "");
		}
	} else {
		strcpy(SnareIP[0], "");
	}

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = INADDR_ANY;

	local.sin_port = htons(port);

	http_listen_socket = socket(AF_INET, SOCK_STREAM, 0);	// TCP socket
	setsockopt(http_listen_socket, SOL_SOCKET, SO_REUSEADDR, &sockopt,
		   sizeof(sockopt));

	if (http_listen_socket == -1) {
		perror("socket() failed");
		return -1;
	}

	if (bind
	    (http_listen_socket, (struct sockaddr *) &local,
	     sizeof(local))) {
		perror("bind() failed");
		return -1;
	}

	if (listen(http_listen_socket, 5)) {
		perror("listen() failed");
		return -1;
	}

	return (1);
}

int CloseWebServer()
{
	DebugMsg("Closing web server");
	if(http_message_socket > 0) {
		shutdown(http_message_socket,SHUT_RDWR);
		close(http_message_socket);
		http_message_socket=-1;
	}

	if(http_listen_socket > 0) {
		shutdown(http_listen_socket,SHUT_RDWR);
		close(http_listen_socket);
		http_listen_socket=-1;
	}
	return (1);
}

int HandleConnect()
{
	int retval;
	// 8k buffer for input and output. Suggest we may need more for output.
	char HTTPBuffer[MAX_HTTPBUFFER];
	char HTTPBufferTemp[MAX_HTTPBUFFER];
	char HTTPOutputBuffer[MAX_HTTPBUFFER];
	char *pos;
	int size = 0;
	int header = 1;

	struct timeval tv;
	fd_set webread;

	tv.tv_sec = 1;
	tv.tv_usec = 0;
	FD_ZERO(&webread);
	FD_SET(http_message_socket,&webread);

	DebugMsg("Handle Connect");

	retval =
	    recv(http_message_socket, HTTPBuffer, sizeof(HTTPBuffer), 0);
	// NOTE: Should probably do something about requests that are bigger than
	// HTTPBuffer also..

	if (retval == -1) {
		// perror("recv() failed");
		DebugMsg("recv failed");
		close(http_message_socket);
		return (1);
	}
	if (retval == 0) {
		DebugMsg("recv failed 2");
		close(http_message_socket);
		return (1);
	}

	HTTPBuffer[retval] = '\0';

	if (!strstr(HTTPBuffer,"\r\n\r\n")) {
		int tempval;
		//fopen patch, sleep then check if there is anything left to grab
		sleep(2);
		if (select(0,&webread,NULL,NULL,&tv) > 0) {
			tempval = recv(http_message_socket,HTTPBufferTemp,sizeof (HTTPBufferTemp),0 );
			HTTPBufferTemp[tempval]='\0';
			strncat(HTTPBuffer,HTTPBufferTemp,sizeof(HTTPBuffer));
		} else {
			close(http_message_socket);
			return(1);
		}
	}

	// Hunt down the authentication string
	// Dont ask for authentication if the password is blank.
	pos = strstr(HTTPBuffer, "Authorization: Basic ");
	if (strlen(SnarePass) && !pos) {
		RequestAuth(HTTPOutputBuffer, MAX_HTTPBUFFER);
		header = 0;
	} else if (strlen(SnarePass)
		   && !MatchAuth(pos + strlen("Authorization: Basic "))) {
		RequestAuth(HTTPOutputBuffer, MAX_HTTPBUFFER);
		header = 0;
	} else {
		// Don't care about anything after the GET
		pos = strstr(HTTPBuffer, "\n");
		if (pos) {
			*pos = '\0';
		}
		pos = strstr(HTTPBuffer, "\r");
		if (pos) {
			*pos = '\0';
		}
		// Get rid of the "GET "
		pos = strstr(HTTPBuffer, " ");
		if (pos) {
			strncpy(HTTPBuffer, pos + 1, MAX_HTTPBUFFER);
		}
		// and the HTTP/1.x
		pos = strstr(HTTPBuffer, " ");
		if (pos) {
			*pos = '\0';
		}

	DebugMsg("decoding");
		decodeurl(HTTPBuffer);

		size =
		    HandleWebPages(HTTPBuffer, HTTPOutputBuffer,
				   MAX_HTTPBUFFER, http_listen_socket,
				   http_message_socket);
	}

	if (size == -1) {
		size = 0;
	} else if (size == 0 && HTTPOutputBuffer) {
		size = strlen(HTTPOutputBuffer);
	}

	if (size) {
		// Overwrite HTTPBuffer with the header data.
		strncpy(HTTPBuffer, "HTTP/1.0 200 OK\r\n"
			"Server: SNARE/1.1\r\n"
			"MIME-version: 1.0\r\n"
			"Content-type: text/html\r\n\r\n",
			sizeof(HTTPBuffer));

		if (header) {
			retval =
			    send(http_message_socket, HTTPBuffer,
				 strlen(HTTPBuffer), 0);
			if (retval == -1) {
				perror("send() failed");
			}
		}

		retval =
		    send(http_message_socket, HTTPOutputBuffer, size, 0);

		//if (retval == -1) {
		//	perror("send() failed");
		//}
	}

	shutdown(http_message_socket,SHUT_RDWR);
	close(http_message_socket);

	return (1);
}

int StartThread()
{
	int ret = 0;
	time_t lasttime=(time_t)0;

	while (!caught_web_kill) {
		ret = ListenThread(&lasttime);

		if (!ret) {
			break;
		}
	}
	CloseWebServer();

	if (caught_web_kill) {
		return (-1);
	}

	if (ret) {
		return (1);
	}

	return (0);
}

int ListenThread(time_t *lasttime)
{
	struct sockaddr_in from;
	socklen_t fromlen;
	int invalidrequest = 1;
	char ip_address[16];
	time_t currenttime;

	//struct timeval timeout;
	//bzero(&timeout, sizeof(timeout));
	//timeout.tv_sec = 1;

	fromlen = sizeof (from);

	while (invalidrequest) {
		http_message_socket =
		    accept(http_listen_socket, (struct sockaddr *) &from, &fromlen);

		//setsockopt(http_message_socket,SOL_SOCKET,SO_SNDTIMEO,&timeout,sizeof(timeout));

		if(caught_web_kill) {
			//caught_web_kill = 0;
			DebugMsg("WEB: caught kill signal, exitting...");
			return(0);
		}

		if (http_message_socket == -1) {
			perror
			    ("accept() error - The target TCP port looks to be currently in use");
			return (0);

		}
		// printf("DEBUG: accepted connection from %s, port %d\n", 
		//      inet_ntoa(from.sin_addr),
		//      htons(from.sin_port)) ;

		strncpy(ip_address, inet_ntoa(from.sin_addr), 16);

		if (AuthorisedSource(ip_address)) {
			invalidrequest = 0;
		} else {
			invalidrequest = 1;
			send(http_message_socket,
			     "<HTML><BODY><CENTER>Authentication failed</CENTER></BODY></HTML>\n\0",
			     66, 0);
			close(http_message_socket);
		}
	}

	HandleConnect();
	return (1);

}

int AuthorisedSource(char *address)
{
	int i;
	if (!address) return (0);
	if (!strlen(address)) return (1);
	if (!SnareIP_count) return (1);
	for (i=0;i<SnareIP_count;i++) {
		if(!strncmp(address,SnareIP[i],strlen(SnareIP[i]))) {
			return(1);
		}
	}
	return (0);
}

void decodeurl(char *pEncoded)
{
	char *pDecoded;

	pDecoded = pEncoded;
	while (*pDecoded) {
		if (*pDecoded == '+')
			*pDecoded = ' ';
		pDecoded++;
	};
	pDecoded = pEncoded;
	while (*pEncoded) {
		if (*pEncoded == '%') {
			pEncoded++;
			if (pEncoded[0]) {
				if (pEncoded[1]) {
					if (isxdigit((int)pEncoded[0])
					    && isxdigit((int)pEncoded[1])) {
						// *pDecoded++=(char)hex2int((char *)pEncoded);
						// Special InterSect Alliance - escape ampersands and slashes.
						// Note: hex characters are 3 bytes, we are only substituting 2, so no
						// problems with buffer overflows.
						*pDecoded =
						    (char) hex2int((char *)
								   pEncoded);
						if (*pDecoded == '&') {
							*pDecoded++ = '\\';
							*pDecoded = '&';
						} else if (*pDecoded ==
							   '\\') {
							*pDecoded++ = '\\';
							*pDecoded = '\\';
						} else if (*pDecoded ==
							   '=') {
							*pDecoded++ = '\\';
							*pDecoded = '=';
						}
						pDecoded++;

						pEncoded += 2;
					}
				} else {
					break;
				}
			} else {
				break;
			}
		} else {
			*pDecoded++ = *pEncoded++;
		}
	}
	*pDecoded = '\0';
}

// Find ampersand-delimited strings (but ignore escaped ampersands).
char *GetNextArgument(char *source, char *destvar, int varlength,
		      char *destval, int vallength)
{
	char prevchar = '\0';
	int destlen = 0;

	if (!source || !destvar || !destval) {
		return ((char *) NULL);
	}

	if (!*source) {
		return ((char *) NULL);
	}

	*destvar = '\0';
	*destval = '\0';

	// length = maximum size of dest
	while (*source && !(*source == '&' && prevchar != '\\')
	       && !(*source == '=' && prevchar != '\\')
	       && destlen < (varlength - 1)) {

		if (*source != '\\'
		    || (*source == '\\' && prevchar == '\\')) {
			*destvar = *source;
			destvar++;
			destlen++;
		}

		if(*source == '\\' && prevchar == '\\') {
			prevchar=0;
		} else {
			prevchar = *source;
		}
		source++;
	}
	*destvar = '\0';

	destlen = 0;

	if (*source == '=') {
		// We have a value. Excellent.
		source++;

		while (*source && !(*source == '&' && prevchar != '\\')
		       && destlen < (vallength - 1)) {
			if (*source != '\\'
			    || (*source == '\\' && prevchar == '\\')) {
				*destval = *source;
				destval++;
				destlen++;
			}

			if(*source == '\\' && prevchar == '\\') {
				prevchar=0;
			} else {
				prevchar = *source;
			}
			source++;
		}
		*destval = '\0';
	}
	// Return our position in the new string, or null for end of string.
	if (*source) {
		source++;
	}

	return (source);
}

int hex2int(char *pChars)
{
	int Hi;
	int Lo;
	int Result;

	Hi = pChars[0];
	if ('0' <= Hi && Hi <= '9') {
		Hi -= '0';
	} else if ('a' <= Hi && Hi <= 'f') {
		Hi -= ('a' - 10);
	} else if ('A' <= Hi && Hi <= 'F') {
		Hi -= ('A' - 10);
	}
	Lo = pChars[1];
	if ('0' <= Lo && Lo <= '9') {
		Lo -= '0';
	} else if ('a' <= Lo && Lo <= 'f') {
		Lo -= ('a' - 10);
	} else if ('A' <= Lo && Lo <= 'F') {
		Lo -= ('A' - 10);
	}
	Result = Lo + (16 * Hi);
	return (Result);
}

void RequestAuth(char *HTTPOutputBuffer, int size)
{
	strncpy(HTTPOutputBuffer,"HTTP/1.0 401 Unauthorized\r\n" \
		"Connection: close\r\n" \
		"Content-Type: text/html\r\n" \
		"Server: SNARE\r\n" \
		"WWW-Authenticate: Basic realm=\"SNARE\"\r\n\r\n" \
		"<HTML><HEAD>\r\n<TITLE>401 Authorization Required</TITLE>\r\n" \
		"</HEAD><BODY>\r\n<H2>Authorization Required</H2>\r\nSnare could not " \
		"verify that you.are authorized to access the remote control facility. " \
		"You may have supplied the wrong credentials<P>\r\n<HR>\r\n" \
		"<ADDRESS>Snare Server Remote Control facility</ADDRESS>\r\n</BODY></HTML>\r\n",size);
}

int MatchAuth(char *AuthStart)
{
	char AuthString[256] = "";
	char AuthString2[256] = "";
	char *pos;
	int length = 0;

	// Hunt down end of line
	pos = AuthStart;

	while (isalpha((int) *pos) || (*pos >= '0' && *pos <= '9')
	       || *pos == '+' || *pos == '=') {
		pos++;
	}

	if(!pos) return(0);

	length=pos-AuthStart;
	if(length<1) return(0);

	if(length >= sizeof(AuthString)) {
		length=sizeof(AuthString) - 1;
	}
	strncpy(AuthString,AuthStart,length);
	AuthString[length]='\0';

	length=base64decode(AuthString2,AuthString);

	pos=strstr(AuthString2,":");

	if(!pos) return(0);

	*pos='\0';
	pos++;

	if (strcmp(AuthString2, "snare") && strcmp(AuthString2, "Snare")
	    && strcmp(AuthString2, "SNARE")) {
		// Username does not match
		return (0);
	}
	// Reuse authstring here.
	strncpy(AuthString2, (char *) crypt(pos, SALT),
		sizeof(AuthString2));

	if (!strcmp(AuthString2, SnarePass)) {
		// Password matches
		return (1);
	}

	return (0);
}

int base64decode(char *dest, char *src)
{
	char *ascii, *pBase64, *mBase64;
	char TopVal, BottomVal;
	int chars_left, i, padding, count=0;

	mBase64 = (char *) malloc(strlen(src) + 1);
	pBase64 = mBase64;
	if (pBase64 == NULL) {
		dest[0] = '\0';	// Returns null if there was a problem
		return(0);
	}

	strcpy(pBase64, src);
	ascii = dest;

	chars_left = strlen(pBase64);
	while (chars_left > 0) {
		padding = 0;
		for (i = 0; i < 4; i++) {
			if (pBase64[i] == '=') {
				padding++;
			} else if (pBase64[i] == '+') {
				pBase64[i] = 62;
			} else if (pBase64[i] == '/') {
				pBase64[i] = 63;
			} else if (pBase64[i] <= '9') {
				pBase64[i] = pBase64[i] + 52 - '0';
			} else if (pBase64[i] <= 'Z') {
				pBase64[i] = pBase64[i] - 'A';
			} else {
				pBase64[i] = pBase64[i] + 26 - 'a';
			}
		}
		TopVal = pBase64[0] << 2;
		BottomVal = pBase64[1] >> 4;
		ascii[0] = TopVal | BottomVal;
		count++;

		if (padding < 2) {
			TopVal = pBase64[1] << 4;
			BottomVal = pBase64[2] >> 2;
			ascii[1] = TopVal | BottomVal;
			count++;
			if (padding < 1) {
				TopVal = pBase64[2] << 6;
				ascii[2] = TopVal | pBase64[3];
				count++;
			} else {
				ascii[2] = '\0';
			}
		} else {
			ascii[1] = '\0';
		}

		ascii += 3;
		pBase64 += 4;
		chars_left -= 4;
	}
	*ascii = '\0';
	free(mBase64);
	return (count);
}
