//
// webserver.h
// Copyright (c) 1999-2007 InterSect Alliance Pty Ltd
//

// Comment this out to ensure logs are not written out to a file.
//#define DEBUGLOGFILE 1
//#define DEBUG 1 //Extra debugging

#ifndef _WEBSERVER_H_
#define _WEBSERVER_H_ 1

//#define MAX_HTTPBUFFER 8192
#define MAX_HTTPBUFFER 16384
//#define MAX_HTTPBUFFER 32768

#if defined (__linux__)
	#define SALT "$1$Snare$"
#elif defined __sgi
	// IRIX
	#define SALT "Sn"
#elif defined _AIX
	// AIX
	#define SALT "Sn"
#else
	// Solaris
	#define SALT "$1"
#endif
//Signal
int caught_kill;                // variable that lets us know when a SIGKILL has been received

void	decodeurl(char *pEncoded);
int	hex2int(char *pChars);
int	InitWebServer(unsigned short, char *, char *);
int	StartThread();
int	ListenThread(time_t *);
int	HandleConnect(void);
int	CloseWebServer();
void	RequestAuth(char *HTTPOutputBuffer,int size);
int	MatchAuth(char *AuthStart);
int	AuthorisedSource(char *address);
char *	GetNextArgument(char *source,char *destvar,int varlength,char *destval,int vallength);
int base64decode(char *dest, char *src);
#endif				// _WEBSERVER_H_ 1
