#!/bin/sh

########################################################################
#    
#    (c) 2001-2007 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of the snare audit daemon.
#   
#   Version 1.1
#    
#    Usage: ./uninstall.sh
#
########################################################################

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ];then
           echo "You need to be root to run this script. Terminating script."
           exit 7
        else
           echo "Confirmed your are logged in as root"
	fi

}

########################################################################
#   This routine will restore the key audit related files in
#   /etc/security/audit
########################################################################

restore_key_files()
{
   echo "Restoring key files..........."

   echo "Restoring oringinal /etc/security/audit/config..."
   if [ -f /etc/security/audit/config.snare-backup ];then
      cp /etc/security/audit/config.snare-backup /etc/security/audit/config
      RETVAL=$?
      if [ $RETVAL -gt 0 ];then
        echo "Unable to restore /etc/security/audit/config to its original value."
      fi
   else
	echo "Cannot find /etc/security/audit/config.snare-backup. Cannot restore."
   fi 

   echo "Removing snarecore binary..."
   if [ -f /usr/bin/snarecore ];then
	rm /usr/bin/snarecore 2>/dev/null
        echo "Done."
   fi

   if [ -f /usr/bin/snarejoin ];then
        echo "Removing snarejoin binary..."
        rm /usr/bin/snarejoin 2>/dev/null
        echo "Done."
   fi

   if [ -f /etc/security/audit/restartsnare ];then
        echo "Removing snare restart script..."
        rm /etc/security/audit/restartsnare 2>/dev/null
        echo "Done."
   fi

   if [ -f /etc/security/audit/snarestream ];then
        echo "Removing snare stream script..."
        rm /etc/security/audit/snarestream 2>/dev/null
        echo "Done."
   fi

   if [ -f /etc/security/audit/snareconfig.template ];then
        echo "Removing snare configuration template..."
        rm /etc/security/audit/snareconfig.template 2>/dev/null
        echo "Done."
   fi


   echo "Removing snare backup files."
   rm -f /etc/security/audit/*.snare-backup
   echo "Done."

   echo "I will leave the snare configuration file (/etc/security/audit/snare.conf) - please remove it manually if you intend to permanently remove SNARE..."
}

/usr/sbin/audit shutdown

root_check
restore_key_files

rm -f /var/run/snarecore.pid 2>/dev/null
rm -f /etc/security/audit/snare_uninstall.sh

