/*
FILE: SnareCore.h
*/

#include "NTService.h"
#include "support.h"
#include <ntsecapi.h>

#define MAX_EVENT 8192
#define MAX_STRING 1024
#define MAX_OUTPUT_STRING 8192
#define MAX_USERNAME	512

struct _node
{
	int event_number;				// The event number this is supposed to match
	int criticality;				// How critical is this particular node
//	int returncode;					// return code required.
	int excludeflag;				// Include or exclude users?
	int eventlogtype;				// binary Warning / Information / Success / Failure / Error
	int sourcename;					// binary Security / Application / Active Directory etc
	// char eventlogtype[SIZE_OF_EVENTLOG];	// Warning / Information / Success / Failure / Error
	// char sourcename[SIZE_OF_EVENTLOG];		// Security / Application / Active Directory etc
	char username[SIZE_OF_USERMATCH];	// Remember, this will be a wildcard match.
	char match[SIZE_OF_GENERALMATCH];
	struct _node *next;
};

typedef struct _node Node;


class CSnarecoreService : public CNTService
{
public:
	CSnarecoreService();
	virtual BOOL OnInit();
    virtual void Run();
    virtual BOOL OnUserControl(DWORD dwOpcode);
	void OnShutdown();

    void SaveStatus();

// 	int SNAREDEBUG;

private:
	HANDLE m_hEventList[9]; // Eight elements at the moment.

	HANDLE hEventLog[6];
	HANDLE hPipe;
	HANDLE hWritePipe;		// Pipe to the Audit GUI
};

// Function Prototypes.
BOOL	InitWinsock				(char *);
int		RunServer				();
void	TerminateWinsock		(SOCKET);
SOCKET	StartServer				(UINT, char *);
BOOL	WINAPI ClientThread		(LPVOID);

void	syslogdate				(char *, struct tm *);

int		wildmatch				(char *, char *);
void	splitstrings			(char *, int, char *, int);

SOCKET	ConnectToServer			(char *, UINT, char *);

BOOL	GetCategoryString		(PEVENTLOGRECORD pELR, char *Trigger, char *StringBuffer, DWORD length);
BOOL	GetEventLogType			(TCHAR *sz, unsigned short uEventType, DWORD length);
BOOL	SendToSocket			(SOCKET hSocket, char *buf, int nSize, char *szError);
BOOL	GetSIDType				(SID_NAME_USE _SidNameUse, TCHAR *szSIDType, DWORD length);
BOOL	ExpandStrings			(PEVENTLOGRECORD pELR, char *Trigger, char *StringBuffer, DWORD length);
BOOL	GetDataString			(PEVENTLOGRECORD pELR, char *StringBuffer, DWORD length);
void	GetArgs					(const EVENTLOGRECORD *pELR, char **Args);

BOOL	CheckLogExists			(TCHAR *LogName);
char *	GetParameterMsg			(char *message, char *tmp);
void	GetFQDN					(char *string,int length);

int		ReadObjectives();
Node *	AddToList				(int eventnumber, char *username, char *match, int criticality,
								 int excludeflag, int eventlogtype, int sourcename);
// Node *	CheckObjective			(int eventnumber, char *username, char *match, char *eventlogtype, char *sourcename);
Node *	CheckObjective			(int eventnumber, char *username, char *match, int etype, int stype);
void	ResetCurrentNode		(void);
void	NextItemInList			(void);
Node *	GetCurrentItem			(void);
int		IsValidItem				(void);
void	DestroyList				(void);


BOOL	SwitchAudit				(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure, BOOL Switch);
BOOL	ClearAllAuditCategories	(void);
BOOL	TurnOnEvent				(DWORD EventID,DWORD SuccessFailure);

int		SetAuditEvent			(LSA_HANDLE PolicyHandle, POLICY_AUDIT_EVENT_TYPE EventType,
									 POLICY_AUDIT_EVENT_OPTIONS EventOption);
int		SetAuditMode			(LSA_HANDLE PolicyHandle, BOOL bEnable);

void	GetHostname				(char * Hostname,int size);
void	GetDestPort				(DWORD * dwDestPort);
void	GetSyslog				(DWORD * dwSyslog);
void	GetSyslogHeader			(DWORD * dwSyslogHeader);
void	GetWEBSERVER_ACTIVE		(DWORD * WEBSERVER_ACTIVE);
void	GetPortNumber			(DWORD * dwPortNumber);
void	GetDestination			(char * lpszDestination,int size);
void	GetDelim				(char * DELIM,int size);
void	GetPassword				(char * lpszPassword,int size);
void	GetIPAddress			(char * lpszIPAddress,int size);
void	GetClearTabs			(DWORD * ClearTabs);


typedef struct _tagEVENTID
{
	TCHAR lpszMachineName[_MAX_PATH + 1];
	TCHAR lpszEventName[_MAX_PATH + 1];
	DWORD dwEventId;
	HWND  hwndDlg;
} EVENTID, *LPEVENTID;

// thread structure
typedef struct
{
	SOCKET hSocket;
	BOOL bTerminate;
} ThreadStruct;









