#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <winsock2.h>
#include <lm.h>

#include "WebPages.h"
#include <windows.h>
#include "support.h"

#define snprintf _snprintf

// Make sure we return the size, or zero (for strings).
// Note that for the most part, the socket will be ignored
int HandleWebPages(char *HTTPBuffer,char *HTTPOutputBuffer,int size,SOCKET http_socket, HANDLE event)
{
	int returncode=0;
	char *ArgPosition;

	// Stuff without the header/footer
	if(!strcmp(HTTPBuffer,"/intersect.gif")) {
		return(InterSectImage(HTTPBuffer,HTTPOutputBuffer,size));
	} else {
		char * pBuffer=HTTPOutputBuffer;
		int length=0;
		int psize=0;

		ArgPosition=strstr(HTTPBuffer,"?");
		// No arguments passed?
		if(!ArgPosition) {
			// Set argument position to the beginning of the buffer.
			ArgPosition=HTTPBuffer;
		} else {
			ArgPosition++;
		}

		if(!strcmp(HTTPBuffer,"/LocalUsers")) {
			DisplayTextHeader(http_socket);
			ShowLocalUsers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/DomainUsers")) {
			DisplayTextHeader(http_socket);
			ShowDomainUsers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/LocalGroups")) {
			DisplayTextHeader(http_socket);
			ShowLocalGroups(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/DomainGroups")) {
			DisplayTextHeader(http_socket);
			ShowDomainGroups(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/LocalGroupMembers")) {
			DisplayTextHeader(http_socket);
			ShowLocalGroupMembers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/DomainGroupMembers")) {
			DisplayTextHeader(http_socket);
			ShowDomainGroupMembers(http_socket);
			return(-1);
		}

		returncode=DefaultHeader(HTTPBuffer,pBuffer,size);
		length=strlen(HTTPOutputBuffer);
		
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}


		// Web pages
		if(!strcmp(HTTPBuffer,"/network")) {
			returncode+=Network_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/network?",9)) {
			strncpy(pBuffer,"Nothing here yet",psize);
		} else if(!strcmp(HTTPBuffer,"/remote")) {
			returncode+=Remote_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setremote",10)) {
			returncode+=Remote_Set(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/objective",10)) {
			returncode+=Objective_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setobjective",13)) {
			returncode+=Objective_Display(HTTPBuffer,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/changeobjective",16)) {
			returncode+=Objective_Result(HTTPBuffer,pBuffer,psize);
		} else if(!strcmp(HTTPBuffer,"/restart")) {
			returncode+=Restart(HTTPBuffer,pBuffer,psize,event);
		} else if(!strncmp(HTTPBuffer,"/restart?",10)) {
			strncpy(pBuffer,"Nothing here yet",psize);
		} else if(!strncmp(HTTPBuffer,"/setnetwork",11)) {
			returncode+=Network_Set(HTTPBuffer,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/status",6)) {
			returncode+=Status_Page(ArgPosition,pBuffer,psize);
		} else {
			returncode=+Status_Page(ArgPosition,pBuffer,psize);
		}

		pBuffer = HTTPOutputBuffer;
		length=strlen(HTTPOutputBuffer);
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}

		returncode+=DefaultFooter(HTTPBuffer,pBuffer,psize);
	}

	return(returncode);
}


// This page will be usefull for debug information
int Status_Page(char *source, char *dest, int size)
{
	strncpy(dest,"<HTML><BODY><H1><CENTER>SNARE Status Page</H1><P><font color=green>Snare for Windows is currently active.</font></CENTER></BODY></HTML>",size);
	return(0);
}

int Network_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Config config_struct;
	Reg_Network network_struct;
	DWORD dw_config_error,dw_network_error;
	char str_DestPort[10];
	char str_conferr[10],str_neterr[10];
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug"};
	UINT i,i_SyslogFacility,i_SyslogPriority;
		
	dw_config_error = Read_Config_Registry(&config_struct);
	dw_network_error = Read_Network_Registry(&network_struct);

	//This function will display the form used to set the audit configuration
	//The result of the form will be sent to "network_set"
	strncpy(dest,"<form action=setnetwork><h1><center>SNARE Network Configuration</h1>",size);

	//Will display an error if unable to completely read from the registry
	if ((dw_network_error > 0) || (dw_config_error > 0))
	{
		dw_network_error += WEB_READ_NETWORK_ERROR_CODE;
		dw_config_error += WEB_READ_CONFIG_ERROR_CODE;
		itoa(dw_network_error,str_neterr,10);
		itoa(dw_config_error,str_conferr,10);

		strncat(dest,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: ",size - strlen(dest));
		strncat(dest,str_neterr,size - strlen(dest));
		strncat(dest,".",size - strlen(dest));
		strncat(dest,str_conferr,size - strlen(dest));
		strncat(dest,"</b><br>",size - strlen(dest));
	}

	strncat(dest,"<br>The following network configuration parameters of the SNARE unit is set to the following values:<br><br>" \
		"<table  width=70% border=0>" \
		"<tr bgcolor=#FFFFCC><td>Clientname</td><td><input type=text name=str_ClientName size=25 value=\"",size - strlen(dest));
	
	strncat(dest,config_struct.str_ClientName,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFBB><td>Destination Server address </td><td><input type=text name=str_Destination size=25 value=\"",size - strlen(dest));
	strncat(dest,network_struct.str_Destination,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>Destination UDP Port <br>(if SYSLOG Header NOT enabled)</td><td><input type=text name=dw_DestPort size=8 value=\"",size - strlen(dest));
	itoa(network_struct.dw_DestPort,str_DestPort,10);
	strncat(dest,str_DestPort,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	//Need to convert this next section to YES or NO
	strncat(dest,"<tr bgcolor=#FFFFBB><td>Allow SNARE to automatically set audit configuration?</td><td><input type=checkbox name=dw_Audit",size - strlen(dest));
	if (config_struct.dw_Audit != 0)
		strncat(dest," checked",size - strlen(dest));	
	strncat(dest,"></td></tr>",size - strlen(dest));

	//Need to convert this next section to YES or NO
	strncat(dest,"<tr bgcolor=#FFFFCC><td>Allow SNARE to automatically set file audit configuration?</td><td><input type=checkbox name=dw_FileAudit",size - strlen(dest));
	if (config_struct.dw_FileAudit != 0)
		strncat(dest," checked",size - strlen(dest));	
	strncat(dest,"></td></tr><tr bgcolor=#FFFFFF><td><br></td></tr>",size - strlen(dest));

	// First 3 bits = facility (eg: emerg, alert, etc.)
	// Rest = priority. Note that there is a gap between ftp and local1.
	i_SyslogPriority = (UINT)network_struct.dw_SyslogDest & 7;
	i_SyslogFacility = (UINT)network_struct.dw_SyslogDest >> 3;
	if(i_SyslogFacility > 11) { 
		i_SyslogFacility = i_SyslogFacility - 4;
	}


	//Need to convert this next section to YES or NO
	strncat(dest,"<tr bgcolor=#FFFFBB><td>Enable SYSLOG Header?</td><td><input type=checkbox name=dw_Syslog",size - strlen(dest));
	if (network_struct.dw_Syslog != 0)
		strncat(dest," checked",size - strlen(dest));	
	strncat(dest,"></td></tr>",size - strlen(dest));

	//The use of a delimiter has been deprecated in this version
	//strncat(dest,"<tr bgcolor=#FFFFBB><td>SYSLOG Field Delimiting Character</td><td> ",size - strlen(dest));
	//strncat(dest,"<input type=radio name=str_Delimiter value=Tab",size - strlen(dest));
	//if (strstr(config_struct.str_Delimiter,"\t") != NULL)
	//if (config_struct.str_Delimiter[0]=='	') {
	//	strncat(dest," checked",size - strlen(dest));
	//}
	//strncat(dest,">Tab   <input type=radio name=str_Delimiter value=Comma",size - strlen(dest));
	//if (config_struct.str_Delimiter[0] == ',') {
	//	strncat(dest," checked",size - strlen(dest));
	//}
	//strncat(dest,">Comma   <input type=radio name=str_Delimiter value=Other",size - strlen(dest));
	//if (config_struct.str_Delimiter[0] !='	' && config_struct.str_Delimiter[0] !=',') {
	//	strncat(dest," checked",size - strlen(dest));
	//}
	//strncat(dest,">Other   <input type=text name=str_Delimiter_Text size=2 value=\"",size - strlen(dest));
	//strncat(dest,config_struct.str_Delimiter,size - strlen(dest));
	//strncat(dest,"\"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>SYSLOG Facility </td><td><select name=SyslogFacility>",size - strlen(dest));
	for (i = 0; i < 19; i++)
	{
		strncat(dest,"<option",size - strlen(dest));
		if (i == i_SyslogFacility)
			strncat(dest," selected>",size - strlen(dest));
		else
			strncat(dest,">",size - strlen(dest));
		strncat(dest,str_facility[i],size - strlen(dest));
	}
	strncat(dest,"</select></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFBB><td>SYSLOG Priority </td><td><select name=SyslogPriority>",size - strlen(dest));
	for (i = 0; i < 8; i++)
	{
		strncat(dest,"<option",size - strlen(dest));
		if (i == i_SyslogPriority)
			strncat(dest," selected>",size - strlen(dest));
		else
			strncat(dest,">",size - strlen(dest));
		strncat(dest,str_priority[i],size - strlen(dest));
	}
	strncat(dest,"</select></td></tr>",size - strlen(dest));

	strncat(dest,"</table><br>",size - strlen(dest));
	strncat(dest,"<input type=submit value=\"Change Configuration\">    ",size - strlen(dest));
	strncat(dest,"<input type=reset value=\"Reset Form\"></form>",size - strlen(dest));
	
	return(0);
}

int Network_Set(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100], web_port[100],syslog_fac[100],syslog_pri[100];
	char Argument[100], delimiter[5];
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug"};
	Reg_Network network_struct;
	Reg_Config config_struct;
	DWORD dw_error_network = 1,dw_error_config = 1,dw_SyslogClass = 0,dw_delimiter_set = 0;
	int i;

	//This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy(dest,"<h1><center>SNARE Network Configuration</h1>",size);

	//Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	//via a checkbox will not be listed if the checkbox has been deselected.
	//Checking is limited to ensuring the Detsination port in the range 1-65535.
	//The variable associated with the checkbox (dw_Syslog) must be
	//exactly "on" or it will be defaulted to "off".
	//str_Destination,str_Delimiter_Text,str_ClientName can be anything it wants to be, so long 
	//as it is within size bounds.

	network_struct.dw_DestPort = -1;
	network_struct.dw_Syslog = 0;
	config_struct.dw_Audit = 0;
	config_struct.dw_FileAudit = 0;

	while((psource=GetNextArgument(psource,Variable,sizeof(Variable),Argument,sizeof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_Delimiter") != NULL)
		{
			if (strcmp(Argument,"Comma") == 0)
			{
				strncpy(config_struct.str_Delimiter,",",sizeof(config_struct.str_Delimiter));
				dw_delimiter_set = 1;
			}
			else if (strcmp(Argument,"Tab") == 0)
			{
				strncpy(config_struct.str_Delimiter,"	",sizeof(config_struct.str_Delimiter));
				dw_delimiter_set = 1;
			}
			
		}
		if (strstr(Variable,"str_Delimiter_Text") != NULL)
		{
			strncpy(delimiter,Argument,sizeof(delimiter));
		}
		if (strstr(Variable,"str_ClientName") != NULL)
		{
			strncpy(config_struct.str_ClientName,Argument,sizeof(config_struct.str_ClientName));
		}
		if (strstr(Variable,"str_Destination") != NULL)
		{
			strncpy(network_struct.str_Destination,Argument,sizeof(network_struct.str_Destination));
		}
		if (strstr(Variable,"dw_DestPort") != NULL)
		{
			strncpy(web_port,Argument,sizeof(web_port));
		}
		if (strstr(Variable,"SyslogPriority") != NULL)
		{
			strncpy(syslog_pri,Argument,sizeof(syslog_pri));
		}
		if (strstr(Variable,"SyslogFacility") != NULL)
		{
			strncpy(syslog_fac,Argument,sizeof(syslog_fac));
		}
		if (strstr(Variable,"dw_Syslog") != NULL)
		{
			if (strcmp(Argument,"on") == 0)
				network_struct.dw_Syslog = 1;
		}
		if (strstr(Variable,"dw_Audit") != NULL)
		{
			if (strcmp(Argument,"on") == 0)
				config_struct.dw_Audit = 1;
		}
		if (strstr(Variable,"dw_FileAudit") != NULL)
		{
			if (strcmp(Argument,"on") == 0)
				config_struct.dw_FileAudit = 1;
		}

	}

	if (dw_delimiter_set == 0)
		strncpy(config_struct.str_Delimiter,delimiter,sizeof(config_struct.str_Delimiter));

	for (i = 0; i < 8; i++)
	{
		if (strstr(syslog_pri,str_priority[i]) != NULL)
			network_struct.dw_SyslogDest = i;
	}
	for (i = 0; i < 19; i++)
	{
		if (strstr(syslog_fac,str_facility[i]) != NULL)
			dw_SyslogClass = i;
	}


	if(dw_SyslogClass > 11)  
		dw_SyslogClass = dw_SyslogClass + 4;
	network_struct.dw_SyslogDest = network_struct.dw_SyslogDest | (dw_SyslogClass << 3);


	network_struct.dw_DestPort = atoi(web_port);
	if ((network_struct.dw_DestPort < 1) || (network_struct.dw_DestPort > 65535))
	{
		strncat(dest,"The Destination Port value must be between 1 and 65535. Use the 'back' button to change the value.",size - strlen(dest));
	}
	else
	{
		dw_error_network = Write_Network_Registry(&network_struct);
		dw_error_config = Write_Config_Registry(&config_struct);
		if ((dw_error_network != 0) || (dw_error_config != 0))
		{
			strncat(dest,"Values have NOT been changed.",size - strlen(dest));
			//**********PUT AN ERROR CODE IN HERE
		}
		else
			strncat(dest,"Values have been changed.",size - strlen(dest));
	}
	return(0);

}


int Remote_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Remote remote_struct;
	DWORD dw_remote_error;
	char str_WebPort[10];
	char str_remerr[10];


	dw_remote_error = Read_Remote_Registry(&remote_struct);

	//This function will display the form used to set the remote audit configuration
	strncpy(dest,"<form action=setremote><h1><center>SNARE Remote Control Configuration</h1>",size);

	//Will display an error if unable to completely read from the registry
	if (dw_remote_error > 0)
	{
		dw_remote_error += WEB_READ_REMOTE_ERROR_CODE;
		itoa(dw_remote_error,str_remerr,10);
		
		strncat(dest,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: ",size - strlen(dest));
		strncat(dest,str_remerr,size - strlen(dest));
		strncat(dest,"</b><br>",size - strlen(dest));
	}
	strncat(dest,"<br>The following remote control configuration parameters of the SNARE unit is set to the following values:<br><br>" \
		"<table  width=70% border=0>" \
		"<tr bgcolor=#FFFFCC><td>Allow remote control of SNARE agent</td><td><input type=checkbox name=dw_Allow",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_Allow != 0)
		strncat(dest," checked",size - strlen(dest));
	
	strncat(dest,"></td></tr><tr bgcolor=#FFFFFF><td><br></td></tr>",size - strlen(dest));
	strncat(dest,"<tr bgcolor=#FFFFBB><td>Restrict remote control of SNARE agent to certain hosts </td><td><input type=checkbox name=dw_Restrict",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_Restrict != 0)
		strncat(dest," checked",size - strlen(dest));
	strncat(dest,"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>IP Address allowed to remote control SNARE </td><td><input type=text name=str_RestrictIP size=12 value=\"",size - strlen(dest));
	strncat(dest,remote_struct.str_RestrictIP,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));
	

	strncat(dest,"<tr bgcolor=#FFFFBB><td>Require a password for remote control? </td><td><input type=checkbox name=dw_Password",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_Password != 0)
		strncat(dest," checked",size - strlen(dest));
	strncat(dest,"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>Password to allow remote control of SNARE </td><td><input type=password name=str_Password size=12 value=\"",size - strlen(dest));
	strncat(dest,remote_struct.str_Password,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));



	strncat(dest,"<tr bgcolor=#FFFFBB><td>Change Web Server default (80) port </td><td><input type=checkbox name=dw_PortChange",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_WebPortChange != 0)
		strncat(dest," checked",size - strlen(dest));
	strncat(dest,"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>Web Server Port </td><td><input type=text name=dw_WebPort size=8 value=\"",size - strlen(dest));
	itoa(remote_struct.dw_WebPort,str_WebPort,10);
	strncat(dest,str_WebPort,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	strncat(dest,"</table><br>",size - strlen(dest));
	strncat(dest,"<input type=submit value=\"Change Configuration\">    ",size - strlen(dest));
	strncat(dest,"<input type=reset value=\"Reset Form\"></form>",size - strlen(dest));
	
	return(0);
}

int Remote_Set(char *source, char *dest, int size) 
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100], web_port[100];
	char Argument[100];
	Reg_Remote remote_struct;
	DWORD dw_error = 0;
	
	//This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy(dest,"<h1><center>SNARE Remote Control Configuration</h1>",size);

	//Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	//via a checkbox will not be listed if the checkbox has been deselected.
	//Also be aware that there may not be any arguments for this objective. If a sysadmin does not want
	//remote control, then there will be no arguments.
	//Hence: Checking is limited to Webport in the range 1-65535 only if portchange is "on"
	//The three variable associated with the checkboxes (dw_Allow, dw_Restrict, and dw_PortChange) must be
	//exactly "on" or they will be defaulted to "off".
	//str_RestrictIP can be anything it wants to be, so long as it is within size bounds.

	remote_struct.dw_WebPort = -1;

	while((psource=GetNextArgument(psource,Variable,sizeof(Variable),Argument,sizeof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"dw_WebPort") != NULL)
		{
			strncpy(web_port,Argument,sizeof(web_port));
		}
		if (strstr(Variable,"str_RestrictIP") != NULL)
		{
			strncpy(remote_struct.str_RestrictIP,Argument,sizeof(remote_struct.str_RestrictIP));
		}
		if (strstr(Variable,"str_Password") != NULL)
		{
			strncpy(remote_struct.str_Password,Argument,sizeof(remote_struct.str_Password));
		}
		if (strstr(Variable,"dw_Allow") != NULL)
		{
			if (strcmp(Argument,"on") == 0)
				remote_struct.dw_Allow = 1;
			else
				remote_struct.dw_Allow = 0;
		}
		if (strstr(Variable,"dw_Password") != NULL)
		{
			if (strcmp(Argument,"on") == 0)
				remote_struct.dw_Password = 1;
			else
				remote_struct.dw_Password = 0;
		}
		if (strstr(Variable,"dw_Restrict") != NULL)
		{
			if (strcmp(Argument,"on") == 0)
				remote_struct.dw_Restrict = 1;
			else
				remote_struct.dw_Restrict = 0;
		}
		if (strstr(Variable,"dw_PortChange") != NULL)
		{
			if (strcmp(Argument,"on") == 0)
				remote_struct.dw_WebPortChange = 1;
			else
				remote_struct.dw_WebPortChange = 0;
		}
	}

	remote_struct.dw_WebPort = atoi(web_port);
	if ((remote_struct.dw_WebPort < 1) || (remote_struct.dw_WebPort > 65535))
	{
		strncat(dest,"The Web Port value must be between 1 and 65535. Use the 'back' button to change the value.",size - strlen(dest));
	}
	else
	{
		dw_error = Write_Remote_Registry(&remote_struct);
		if (dw_error != 0)
		{
			strncat(dest,"Remote Control Values have NOT been changed. Report error: ",size - strlen(dest));
			//**********PUT AN ERROR CODE IN HERE
		}
		else
			strncat(dest,"Remote Control Values have been changed.",size - strlen(dest));
	}
	return(0);
}


int Objective_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective;
	DWORD dw_objective_error = 0;
	int i_objective_count = 0;
	char str_obj_count[10];
	char str_user_match_metachar_remove[SIZE_OF_USERMATCH*2];
	char str_eventid_match_metachar_remove[SIZE_OF_EVENTIDMATCH*2];
	char str_general_match_metachar_remove[SIZE_OF_GENERALMATCH*2];


	strncpy(dest,"<form action=setobjective><H1><CENTER>SNARE Filtering Objectives Configuration</H1>",size);
		
	dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
	if (dw_objective_error == 0)
	{
		strncat(dest,"<br>The following filtering objectives of the SNARE unit are active:<br><br>" \
		"<table  width=100% border=1>",size - strlen(dest));

		strncat(dest,"<tr bgcolor=#FFFFBB><center><td><b>Action Required</b></td><td><b>Criticality</b></td>" \
			        "<td><b>Event ID Match</b></td><td><b>User Match</b></td><td><b>Non-Header Match</b>" \
					"</td></center></tr>",size - strlen(dest));

		while (dw_objective_error == 0)
		{
			itoa(i_objective_count,str_obj_count,10);		
			
			if ((i_objective_count%2) == 0)
				strncat(dest,"<tr bgcolor=#FFFFCC><td><input type=submit name=",size - strlen(dest));
			else
				strncat(dest,"<tr bgcolor=#FFFFBB><td><input type=submit name=",size - strlen(dest));

			strncat(dest,str_obj_count,size - strlen(dest));
			strncat(dest," value=Delete>     ",size - strlen(dest));

			strncat(dest,"<input type=submit name=",size - strlen(dest));
			strncat(dest,str_obj_count,size - strlen(dest));
			strncat(dest," value=Modify>",size - strlen(dest));
			strncat(dest,"</td><td>",size - strlen(dest));

			strncat(dest,reg_objective.str_critic,size - strlen(dest));
			strncat(dest,"</td><td>",size - strlen(dest));


			//Debracket the strings in here. For HTML display purposes, the HTML metacharacters
			//need to be replaced. This is done with the "debracket" routine.
			//Note that the new strings are allowed to be twice as long as the real strings

			debracket(reg_objective.str_user_match,str_user_match_metachar_remove,SIZE_OF_USERMATCH*2);
			debracket(reg_objective.str_eventid_match,str_eventid_match_metachar_remove,SIZE_OF_EVENTIDMATCH*2);
			debracket(reg_objective.str_general_match,str_general_match_metachar_remove,SIZE_OF_GENERALMATCH*2);

			if (strlen(reg_objective.str_eventid_match) == 0)
				strncat(dest,"&nbsp",size - strlen(dest));
			else
				strncat(dest,str_eventid_match_metachar_remove,size - strlen(dest));
			strncat(dest,"</td><td>      ",size - strlen(dest));
			
			if (strlen(reg_objective.str_user_match) == 0)
				strncat(dest,"&nbsp",size - strlen(dest));
			else
				strncat(dest,str_user_match_metachar_remove,size - strlen(dest));
			strncat(dest,"</td><td>",size - strlen(dest));
			
			if (strlen(reg_objective.str_general_match) == 0)
				strncat(dest,"&nbsp",size - strlen(dest));
			else
				strncat(dest,str_general_match_metachar_remove,size - strlen(dest));
			strncat(dest,"</td></tr>",size - strlen(dest));

			i_objective_count++;
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		}
		strncat(dest,"</table><br>",size - strlen(dest));
	}
	else
	{
		strncat(dest,"<br>There are no current filtering objectives active.<br><br>",size - strlen(dest));
	}

	strncat(dest,"Select this button to add a new objective.  ",size - strlen(dest));
	strncat(dest,"<input type=submit name=0",size - strlen(dest));
	strncat(dest," value=Add>",size - strlen(dest));



	return(0);
}


int Objective_Display(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective;
	DWORD dw_objective_error = 0, dw_objective_write_error = 0,dw_objective_delete_error = 0;
;
	char str_objerr[10];
	int i_set=0,i_objective_count = 0,i_type = 0;
	char *psource=source, Variable[100], Argument[100];
	char str_temp[20], str_temp_objective[10];
	

	//This function will display an existing, or a blank, objective
	strncpy(dest,"<form action=changeobjective><h1><center>SNARE Filtering Objective Configuration</h1>",size);

	//Determine whether the objective will be modified or deleted
	while((psource=GetNextArgument(psource,Variable,sizeof(Variable),Argument,sizeof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Argument,"Delete") != NULL)
		{
			sscanf(Variable,"%20[^?]?%10[^\n]\n",str_temp,str_temp_objective);
			i_type = 0;
			break;
		}
		if (strstr(Argument,"Modify") != NULL)
		{
			sscanf(Variable,"%20[^?]?%10[^\n]\n",str_temp,str_temp_objective);
			i_type = 1;
			break;
		}
		if (strstr(Argument,"Add") != NULL)
		{
			strncpy(str_temp_objective,"-2",sizeof(str_temp_objective));
			i_type = 2;
			break;
		}
	}

	//Extract the objective number. I have to do this stuff, because atoi returns 0 if it cannot convert the string
	if (strcmp(str_temp_objective,"0") == 0)
		i_objective_count = -1;
	else
		i_objective_count = atoi(str_temp_objective);

	//If the objective number could not be successfully extracted, return immediately.
	if (i_objective_count == 0)
	{
		strncat(dest,"<br><b>NOTE: It appears the URL is encoded incorrectly.",size - strlen(dest));
		return 0;
	}

	if (i_objective_count == -1)
		i_objective_count = 0;
		
	//If the objective is being modified or added
	if (i_type > 0)
	{
		if (i_type == 1)
		{
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		}
		else
		{
			strncpy(reg_objective.str_event_type,SUCCESS_TOKEN,sizeof(reg_objective.str_event_type));
			strncpy(reg_objective.str_eventlog_type,SECLOG_TOKEN,sizeof(reg_objective.str_eventlog_type));
			strncpy(reg_objective.str_critic,CRITICAL_TOKEN,sizeof(reg_objective.str_critic));
			strncpy(reg_objective.str_eventid_match,LOGONOFF_TOKEN,sizeof(reg_objective.str_eventid_match));
			strncpy(reg_objective.str_general_match,"\"Enter the non-header search term here\"",sizeof(reg_objective.str_general_match));
			strncpy(reg_objective.str_user_match,"\"Enter the user match here\"",sizeof(reg_objective.str_user_match));
		}


		//Will display an error if unable to completely read from the registry
		if (dw_objective_error > 0)
		{
			dw_objective_error += WEB_READ_OBJECTIVE_ERROR_CODE;
			itoa(dw_objective_error,str_objerr,10);
	
			strncat(dest,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
						"may be used.<br> Report error: ",size - strlen(dest));
			strncat(dest,str_objerr,size - strlen(dest));
			strncat(dest,"</b><br>",size - strlen(dest));
		}

		strncat(dest,"<br>The following parameters of the SNARE objective may be set:<br><br>" \
			"<table  width=100% border=0>",size - strlen(dest));

		//Identify the high level event. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		strncat(dest,"<tr bgcolor=#FFFFBB><td>Identify the high level event</td><td><table  width=100% border=0><tr>",size - strlen(dest));
		strncat(dest,"<td><input type=radio name=str_eventid_match value=",size - strlen(dest));
		strncat(dest,LOGONOFF_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventid_match,LOGONOFF_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Logon or Logoff  </td><td><input type=radio name=str_eventid_match value=",size - strlen(dest));
		strncat(dest,MANAGE_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventid_match,MANAGE_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Account Administration  </td></tr><tr><td><input type=radio name=str_eventid_match value=",size - strlen(dest));
		strncat(dest,FILE_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventid_match,FILE_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Access a file or directory  </td><td><input type=radio name=str_eventid_match value=",size - strlen(dest));
		strncat(dest,SECPOL_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventid_match,SECPOL_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Change the security policy  </td></tr><tr><td><input type=radio name=str_eventid_match value=",size - strlen(dest));
		strncat(dest,PROCESS_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventid_match,PROCESS_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Start or stop a process  </td><td><input type=radio name=str_eventid_match value=",size - strlen(dest));
		strncat(dest,REBOOT_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventid_match,REBOOT_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Restart, shutdown and system  </td></tr><tr><td><input type=radio name=str_eventid_match value=",size - strlen(dest));
		strncat(dest,USERRIGHTS_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventid_match,USERRIGHTS_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Use of user rights  </td><td><input type=radio name=str_eventid_match value=Any_Event",size - strlen(dest));
		if (i_set == 0)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Any event(s) </td></tr></table></td></tr>",size - strlen(dest));
	
		strncat(dest,"<tr bgcolor=#FFFFCC><td>Event ID Search Term </td><td><input type=text name=str_eventid_text size=50 value=\"",size - strlen(dest));
		strncat(dest,reg_objective.str_eventid_match,size - strlen(dest));
		strncat(dest,"\"></td></tr>",size - strlen(dest));

		strncat(dest,"<tr bgcolor=#FFFFBB><td>Non-Header Search Term </td><td><input type=text name=str_general_match size=50 value=\"",size - strlen(dest));
		strncat(dest,reg_objective.str_general_match,size - strlen(dest));
		strncat(dest,"\"></td></tr>",size - strlen(dest));

		strncat(dest,"<tr bgcolor=#FFFFCC><td>Select the User Match Type</td><td>",size - strlen(dest));
		strncat(dest,"<input type=radio name=str_user_match_type value=",size - strlen(dest));
		strncat(dest,INCLUDE,size - strlen(dest));
		if (strstr(reg_objective.str_user_match_type,INCLUDE) != NULL)
			strncat(dest," checked",size - strlen(dest));
		strncat(dest,">Include    <input type=radio name=str_user_match_type value=",size - strlen(dest));
		strncat(dest,EXCLUDE,size - strlen(dest));
		if (strstr(reg_objective.str_user_match_type,EXCLUDE) != NULL)
			strncat(dest," checked",size - strlen(dest));
		strncat(dest,">Exclude    </td></tr>",size - strlen(dest));

		strncat(dest,"<tr bgcolor=#FFFFCC><td>User Search Term </td><td><input type=text name=str_user_match size=50 value=\"",size - strlen(dest));
		strncat(dest,reg_objective.str_user_match,size - strlen(dest));
		strncat(dest,"\"></td></tr>",size - strlen(dest));

		//Identify the event type to capture. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		strncat(dest,"<tr bgcolor=#FFFFBB><td>Identify the event types to be captured</td><td><table  width=100% border=0><tr>",size - strlen(dest));
		strncat(dest,"<td><input type=checkbox name=str_event_type_succ value=",size - strlen(dest));
		strncat(dest,SUCCESS_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_event_type,SUCCESS_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Success Audit  </td><td><input type=checkbox name=str_event_type_fail value=",size - strlen(dest));
		strncat(dest,FAILURE_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_event_type,FAILURE_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Failure Audit  </td></tr><tr><td><input type=checkbox name=str_event_type_info value=",size - strlen(dest));
		strncat(dest,INFO_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_event_type,INFO_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Information  </td><td><input type=checkbox name=str_event_type_warn value=",size - strlen(dest));
		strncat(dest,WARN_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_event_type,WARN_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Warning  </td></tr><tr><td><input type=checkbox name=str_event_type_error value=",size - strlen(dest));
		strncat(dest,ERROR_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_event_type,ERROR_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Error  </td></tr></table></td></tr>",size - strlen(dest));

	
		//Identify the log type to capture. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		strncat(dest,"<tr bgcolor=#FFFFCC><td>Identify the event logs <br>(ignored if any objective other <br>than 'Any event(s)' is selected):</td><td><table  width=100% border=0><tr>",size - strlen(dest));
		strncat(dest,"<td><input type=checkbox name=str_eventlog_type_seclog value=",size - strlen(dest));
		strncat(dest,SECLOG_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventlog_type,SECLOG_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Security  </td><td><input type=checkbox name=str_eventlog_type_syslog value=",size - strlen(dest));
		strncat(dest,SYSLOG_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventlog_type,SYSLOG_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">System  </td></tr><tr><td><input type=checkbox name=str_eventlog_type_applog value=",size - strlen(dest));
		strncat(dest,APPLOG_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventlog_type,APPLOG_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Application  </td><td><input type=checkbox name=str_eventlog_type_dirlog value=",size - strlen(dest));
		strncat(dest,DIRLOG_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventlog_type,DIRLOG_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">Directory Service  </td></tr><tr><td><input type=checkbox name=str_eventlog_type_dnslog value=",size - strlen(dest));
		strncat(dest,DNSLOG_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventlog_type,DNSLOG_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">DNS Server  </td><td><input type=checkbox name=str_eventlog_type_replog value=",size - strlen(dest));
		strncat(dest,REPLOG_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_eventlog_type,REPLOG_TOKEN) != NULL)
		{
			strncat(dest," checked",size - strlen(dest));
			i_set = 1;
		}
		strncat(dest,">File Replication  </td></tr></table></td></tr>",size - strlen(dest));

		strncat(dest,"<tr bgcolor=#FFFFBB><td>Select the Alert Level</td><td>",size - strlen(dest));

		//Determine the criticality level
		strncat(dest,"<input type=radio name=str_critic value=",size - strlen(dest));
		strncat(dest,CRITICAL_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_critic,CRITICAL_TOKEN) != NULL)
			strncat(dest," checked",size - strlen(dest));
		strncat(dest,">Critical    <input type=radio name=str_critic value=",size - strlen(dest));
		strncat(dest,PRIORITY_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_critic,PRIORITY_TOKEN) != NULL)
			strncat(dest," checked",size - strlen(dest));
		strncat(dest,">Priority    <input type=radio name=str_critic value=",size - strlen(dest));
		strncat(dest,WARNING_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_critic,WARNING_TOKEN) != NULL)
			strncat(dest," checked",size - strlen(dest));
		strncat(dest,">Warning    <input type=radio name=str_critic value=",size - strlen(dest));
		strncat(dest,INFORMATION_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_critic,INFORMATION_TOKEN) != NULL)
			strncat(dest," checked",size - strlen(dest));
		strncat(dest,">Information    <input type=radio name=str_critic value=",size - strlen(dest));
		strncat(dest,CLEAR_TOKEN,size - strlen(dest));
		if (strstr(reg_objective.str_critic,CLEAR_TOKEN) != NULL)
			strncat(dest," checked",size - strlen(dest));
		strncat(dest,">Clear    </td></tr>",size - strlen(dest));


		strncat(dest,"</table><br>",size - strlen(dest));
		strncat(dest,"<input type=hidden name=objnumber value=",size - strlen(dest));
		strncat(dest,str_temp_objective,size - strlen(dest));//Objective number goes here
		strncat(dest,"><input type=submit value=\"Change Configuration\">    ",size - strlen(dest));
		strncat(dest,"<input type=reset value=\"Reset Form\"></form>",size - strlen(dest));
	}
	else
	{
		dw_objective_delete_error = Delete_Objective(i_objective_count);
		i_objective_count++;
		dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		while (dw_objective_error == 0)
		{
			dw_objective_write_error = Write_Objective_Registry(i_objective_count-1,&reg_objective);
			dw_objective_delete_error = Delete_Objective(i_objective_count);
			i_objective_count++;
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		}

		if (dw_objective_delete_error == 0)
			strncat(dest,"<br>The objective has been deleted.",size - strlen(dest));
		else
			strncat(dest,"<br>The objective was unable to be deleted.",size - strlen(dest));
			//***REPORT AN ERROR
	}
	
	return(0);
}


int Objective_Result(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective, reg_objective_read;
	// DWORD dw_objective_error = -1;
	DWORD dw_objective_error = 0;

	int i_objective_count = 0,i_objective = 0, i_event_type_set = 0, i_event_type_log_set = 0;
	char str_obj_count[10],str_eventid_radio[50],str_eventid_text[SIZE_OF_EVENTIDMATCH];
	char *psource=source, Variable[100], Argument[100];

	strncpy(dest,"<form action=setobjective><H1><CENTER>SNARE Filtering Objectives Configuration</H1>",size);

	strncpy(reg_objective.str_event_type,"",sizeof(reg_objective.str_event_type));
	strncpy(reg_objective.str_eventlog_type,"",sizeof(reg_objective.str_eventlog_type));

	while((psource=GetNextArgument(psource,Variable,sizeof(Variable),Argument,sizeof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_user_match") != NULL)
		{
			strncpy(reg_objective.str_user_match,Argument,sizeof(reg_objective.str_user_match));
		}
		if (strstr(Variable,"str_general_match") != NULL)
		{
			strncpy(reg_objective.str_general_match,Argument,sizeof(reg_objective.str_general_match));
		}
		if (strstr(Variable,"str_event_type_succ") != NULL)
		{
			strncat(reg_objective.str_event_type,SUCCESS_TOKEN,sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			if (i_event_type_set == 1)
				strncat(reg_objective.str_event_type,",",sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_fail") != NULL)
		{
			strncat(reg_objective.str_event_type,FAILURE_TOKEN,sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			if (i_event_type_set == 1)
				strncat(reg_objective.str_event_type,",",sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_info") != NULL)
		{
			strncat(reg_objective.str_event_type,INFO_TOKEN,sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			if (i_event_type_set == 1)
				strncat(reg_objective.str_event_type,",",sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_warn") != NULL)
		{
			strncat(reg_objective.str_event_type,WARN_TOKEN,sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			if (i_event_type_set == 1)
				strncat(reg_objective.str_event_type,",",sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_error") != NULL)
		{
			strncat(reg_objective.str_event_type,ERROR_TOKEN,sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			if (i_event_type_set == 1)
				strncat(reg_objective.str_event_type,",",sizeof(reg_objective.str_event_type) - strlen(reg_objective.str_event_type));
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_seclog") != NULL)
		{
			strncat(reg_objective.str_eventlog_type,SECLOG_TOKEN,sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			if (i_event_type_log_set == 1)
				strncat(reg_objective.str_eventlog_type,",",sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_syslog") != NULL)
		{
			strncat(reg_objective.str_eventlog_type,SYSLOG_TOKEN,sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			if (i_event_type_log_set == 1)
				strncat(reg_objective.str_eventlog_type,",",sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_applog") != NULL)
		{
			strncat(reg_objective.str_eventlog_type,APPLOG_TOKEN,sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			if (i_event_type_log_set == 1)
				strncat(reg_objective.str_eventlog_type,",",sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_dirlog") != NULL)
		{
			strncat(reg_objective.str_eventlog_type,DIRLOG_TOKEN,sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			if (i_event_type_log_set == 1)
				strncat(reg_objective.str_eventlog_type,",",sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_dnslog") != NULL)
		{
			strncat(reg_objective.str_eventlog_type,DNSLOG_TOKEN,sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			if (i_event_type_log_set == 1)
				strncat(reg_objective.str_eventlog_type,",",sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_replog") != NULL)
		{
			strncat(reg_objective.str_eventlog_type,REPLOG_TOKEN,sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			if (i_event_type_log_set == 1)
				strncat(reg_objective.str_eventlog_type,",",sizeof(reg_objective.str_eventlog_type) - strlen(reg_objective.str_eventlog_type));
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventid_match") != NULL)
		{
			strncpy(str_eventid_radio,Argument,sizeof(str_eventid_radio));
		}
		if (strstr(Variable,"str_eventid_text") != NULL)
		{
			strncpy(str_eventid_text,Argument,sizeof(str_eventid_text));
		}
		if (strstr(Variable,"objnumber") != NULL)
		{
			strncpy(str_obj_count,Argument,sizeof(str_obj_count));
		}
		if (strstr(Variable,"str_critic") != NULL)
		{
			strncpy(reg_objective.str_critic,Argument,sizeof(reg_objective.str_critic));
		}
		if (strstr(Variable,"str_user_match_type") != NULL)
		{
			strncpy(reg_objective.str_user_match_type,Argument,sizeof(reg_objective.str_user_match_type));
		}
	}

	if (strstr(str_eventid_radio,"Any_Event") != NULL)
		strncpy(reg_objective.str_eventid_match,str_eventid_text,sizeof(reg_objective.str_eventid_match));
	else
	{
		if (strstr(str_eventid_radio,FILE_TOKEN) != NULL) {
			// Turn on file auditing for the specified general match term.

			if(validate_file_or_directory(reg_objective.str_general_match)) {
				// Set auditing on the file.
				DWORD dw_FileAudit;
				dw_FileAudit=MyGetProfileDWORD("Config","FileAudit",1);
				if(dw_FileAudit) {
					// Enable the SE_SECURITY_NAME privilege.
					if (EnableSecurityName()) {
						AddEveryoneAceToFileSacl(reg_objective.str_general_match,GENERIC_ALL | ACCESS_SYSTEM_SECURITY);
					}
					// "I have recursively set audit on the filepath specified in this objective."
					strncat(dest,"<br>I have recursively set audit on the filepath specified in this objective.",size - strlen(dest));
				}
			} else {
				// Tell the user something stuffed up.
				dw_objective_error=1;
				strncat(dest,"<br>The value supplied in the Non-Header Search filter, is not a valid file or directory.<P>Please supply a valid entry (eg: C:\\DIR\\TO\\AUDIT).",size - strlen(dest));
			}

		}
		/*if (strstr(str_eventid_radio,"Logon_Logoff") != NULL)
			strncpy(reg_objective.str_eventid_match,LOGON_LOGOFF_EVENTS,sizeof(reg_objective.str_eventid_match));
		if (strstr(str_eventid_radio,FILE_TOKEN) != NULL)
			strncpy(reg_objective.str_eventid_match,FILE_EVENTS,sizeof(reg_objective.str_eventid_match));
		if (strstr(str_eventid_radio,PROCESS_TOKEN) != NULL)
			strncpy(reg_objective.str_eventid_match,PROCESS_EVENTS,sizeof(reg_objective.str_eventid_match));
		if (strstr(str_eventid_radio,USERRIGHTS_TOKEN) != NULL)
			strncpy(reg_objective.str_eventid_match,USER_OF_USER_RIGHTS_EVENTS,sizeof(reg_objective.str_eventid_match));
		if (strstr(str_eventid_radio,MANAGE_TOKEN) != NULL)
			strncpy(reg_objective.str_eventid_match,USER_GROUP_ADMIN_EVENTS,sizeof(reg_objective.str_eventid_match));
		if (strstr(str_eventid_radio,SECPOL_TOKEN) != NULL)
			strncpy(reg_objective.str_eventid_match,SECURITY_POLICY_EVENTS,sizeof(reg_objective.str_eventid_match));
		if (strstr(str_eventid_radio,REBOOT_TOKEN) != NULL)
			strncpy(reg_objective.str_eventid_match,RESTART_EVENTS,sizeof(reg_objective.str_eventid_match));
		else*/

		strncpy(reg_objective.str_eventid_match,str_eventid_radio,sizeof(reg_objective.str_eventid_match));
	}

	if(!dw_objective_error) {
		i_objective = atoi(str_obj_count);
		
		//-2 = "Add a new objective", hence we must go to the end of the list.
		if (i_objective == -2)
		{
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective_read);
			while (dw_objective_error == 0)
			{
				i_objective_count++;
				dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective_read);
			}
			i_objective = i_objective_count;
		}

		dw_objective_error = Write_Objective_Registry(i_objective,&reg_objective);
		if (dw_objective_error  == 0)
			strncat(dest,"<br>The objective has been modifed/added.",size - strlen(dest));
		else
			strncat(dest,"<br>The objective was unable to be modifed/added.",size - strlen(dest));
			//***REPORT AN ERROR
	}

	return(0);
}


int DefaultHeader(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy(dest,"<HTML><head>" \
	"<title>InterSect Alliance - Information Technology Security</title>" \
	"<meta name=\"TITLE\" content=\"InterSect Alliance - Information Technology Security\">" \
	"<meta HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">" \
	"<meta HTTP-EQUIV=\"Expires\" CONTENT=\"-1\">" \
	"</head>" \
	"<body text=black bgcolor=white link=#000066 vlink=#000044 alink=#000055>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=3 width=100%>" \
	"<tbody>" \
    "<tr>" \
    "<td height=70><img src=/intersect.gif alt=\"InterSect\" width=205 height=70 hspace=20 vspace=0 border=0 align=Right>" \
    "</td>" \
    "<td height=70 width=1% bgcolor=#eeeeee><br></td>" \
	"<td height=70 width=1% bgcolor=#dddddd><br></td>" \
	"<td height=70 width=1% bgcolor=#cccccc><br></td>" \
	"<td height=70 width=1% bgcolor=#ccbbbb><br></td>" \
	"<td height=70 width=1% bgcolor=#ccaaaa><br></td>" \
	"<td height=70 width=1% bgcolor=#cc9999><br></td>" \
	"<td height=70 width=1% bgcolor=#cc8888><br></td>" \
	"<td height=70 width=1% bgcolor=#cc7777><br></td>" \
	"<td height=70 width=1% bgcolor=#cc6666><br></td>" \
	"<td height=70 width=1% bgcolor=#cc5555><br></td>" \
	"<td height=70 width=1% bgcolor=#cc4444><br></td>" \
	"<td height=70 width=1% bgcolor=#cc3333><br></td>" \
	"<td height=70 width=1% bgcolor=#cc2222><br></td>" \
	"<td height=70 width=1% bgcolor=#cc1111><br></td>" \
	"<td height=70 width=86% bgcolor=#cc0000><div align=right><font face=\"Helvetica,Arial,sans-serif\" size=+2 color=white><b><center>SNARE for Windows&nbsp;</b></font><font color=white></font>&nbsp;&nbsp;</center></div></td>" \
    "</tr>" \
    "</tbody>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=1 width=100%>" \
    "<tr><td height=3 border=0 bgcolor=white width=100%></td></tr>" \
    "<tr><td height=3 border=0 bgcolor=black width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=#AAAAAA width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=white width=100%></td></tr>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=5 columns=2 width=100% height=100%>" \
	"<tbody>" \
    "<tr>" \
      "<td valign=Top width=20% bgcolor=#cc0000>" \
      "<div align=Center><font color=#ffffff>" \
      "<br>" \
      "<font face=\"Helvetica,Arial,sans-serif\" size=-1><B>" \
      "<br><A HREF=\"/network\" style=\"color:FFFFFF;text-decoration:none\">Network Configuration</A><br>" \
      "<br><A HREF=\"/remote\" style=\"color:FFFFFF;text-decoration:none\">Remote Control Configuration</A><br>" \
      "<br><A HREF=\"/objective\" style=\"color:FFFFFF;text-decoration:none\">Objectives Configuration</A><br>" \
      "<br><A HREF=\"/status\" style=\"color:FFFFFF;text-decoration:none\">View Audit Service Status</A><br>" \
	  "<br><A HREF=\"/restart\" style=\"color:FFFFFF;text-decoration:none\">Apply the Latest Audit Configuration</A><br>" \
	  "</div>" \
	  "<br><font size=-2><A HREF=\"/LocalUsers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Local Users</A></font>" \
	  "<br><font size=-2><A HREF=\"/LocalGroups\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Local Groups</A></font>" \
	  "<br><font size=-2><A HREF=\"/DomainUsers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Domain Users</A></font>" \
	  "<br><font size=-2><A HREF=\"/DomainGroups\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Domain Groups</A></font>" \
	  "<br><font size=-2><A HREF=\"/LocalGroupMembers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Local Group Members</A></font>" \
	  "<br><font size=-2><A HREF=\"/DomainGroupMembers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Domain Group Members</A></font><br>" \
      "</b></font>" \
      "<br>" \
      
    "</td>" \
    "<td width=100% valign=Top>" \
     "<table cellpadding=0 cellspacing=10 border=0 width=100%>" \
      "<tbody>" \
       "<tr>" \
        "<td valign=Top align=Justify>",size);

	return(0);
}

int DefaultFooter(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy(dest,"</td>" \
		"</tr>" \
		"</tbody>" \
		"</table>" \
		"</body><center>" \
		"<BR><BR><FONT SIZE=-1 face=helvetica>(c) <A HREF=\"http://www.intersectalliance.com\">Intersect Alliance</A> Pty Ltd 2001-2003. " \
		"This site is powered by <A HREF=\"http://www.intersectalliance.com/projects/\">SNARE for Windows.</A></FONT>" \
		"</center></html>",size);

	return(0);
}

int Restart(char *source, char *dest, int size, HANDLE event)
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy(dest,"<HTML><BODY><H1><CENTER>Reapply the Latest Configuration</H1><P>Snare Objectives have been reapplied to the running system.</CENTER></BODY></HTML>",size);

	// Notify the main thread that we want to reapply config changes
	SetEvent(event);

    return(0);
}



int ShowLocalUsers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[1024]="";

	USER_INFO_2	*UserInfo, *UISave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwResume=0,dwReturn=0;
	char szName[255],szDesc[255],szFName[255];

	char szTextualSid[256];
	DWORD dwBufferLen;

	do {
		dwReturn = NetUserEnum( NULL, 2, 0, (LPBYTE *)&UserInfo, 65536, 
                &dwEntriesRead,	&dwTotalEntries, &dwResume );
		UISave=UserInfo;

		while ( dwEntriesRead ) {
			
			// Is this a local user account?
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,UserInfo->usri2_name,-1, szName, 254, NULL, NULL );
			WideCharToMultiByte( CP_ACP, 0,UserInfo->usri2_usr_comment,-1, szDesc, 254, NULL, NULL );
			WideCharToMultiByte( CP_ACP, 0,UserInfo->usri2_full_name,-1, szFName, 254, NULL, NULL );
			

			if(szName) {
				// GET SID HERE

				dwBufferLen=sizeof(szTextualSid);

				// Obtain the textual representation of the SID.
				GetUserSid(szName,szTextualSid,&dwBufferLen);
			}

			// Get rid of tabs in the Description field
			char * t;
			t=szDesc;
			if(t) {
				while(*t) {
					if(*t == '\t') { *t=' '; }
					t++;
				}
			}

			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t%s (%s)\t%s",szName,szFName,szDesc,szTextualSid);

			if(UserInfo->usri2_flags & UF_ACCOUNTDISABLE) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tACCOUNTDISABLE",HTTPBuffer);
			}
			if(UserInfo->usri2_flags & UF_PASSWD_NOTREQD) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tPASSWD_NOTREQD",HTTPBuffer);
			}
			if(UserInfo->usri2_flags & UF_PASSWD_CANT_CHANGE) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tPASSWD_CANT_CHANGE",HTTPBuffer);
			}
			if(UserInfo->usri2_flags & UF_LOCKOUT) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tLOCKOUT",HTTPBuffer);
			}
			if(UserInfo->usri2_flags & UF_DONT_EXPIRE_PASSWD) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tDONT_EXPIRE_PASSWD",HTTPBuffer);
			}
			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\n",HTTPBuffer);
		
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);
			
			UserInfo += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(UISave != NULL) {
			NetApiBufferFree(UISave);
			UISave=NULL;
		}
	} while(dwReturn == ERROR_MORE_DATA);

	if(UISave != NULL) {
		NetApiBufferFree(UISave);
	}

	// Send a newline to finish off.
	retval = send(http_socket,"\n",strlen("\n"),0);

	return(0);
}

int ShowDomainUsers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";

	LPWSTR tPrimaryDC = NULL;
	WCHAR PrimaryDC[256];
	WCHAR *PDC;
	NET_API_STATUS netErr=1;

	// Get the primary domain controller
	netErr = NetGetDCName(NULL,NULL,(LPBYTE *)&tPrimaryDC);
	if(netErr == NERR_Success) {
		char temp[256]="", temp2[256]="";
		if(tPrimaryDC) {
			wcsncpy(PrimaryDC,tPrimaryDC,255);
			PDC=PrimaryDC;

			WideCharToMultiByte( CP_ACP, 0,PDC,-1, temp, 255, NULL, NULL );
			_snprintf(temp2,255,"PDC: %s\n",temp);
			retval = send(http_socket,temp2,strlen(temp2),0);
		} else {
			char temp[256];
			PDC=NULL;
			strncpy(temp,"PDC: LOCAL\n",sizeof(temp));
			retval = send(http_socket,temp,strlen(temp),0);	
		}
	} else {
		char temp[256];
		
		PDC=NULL;

		strncpy(temp,"PDC: LOCAL\n",sizeof(temp));
		retval = send(http_socket,temp,strlen(temp),0);	
	}

	if(tPrimaryDC) {
	  NetApiBufferFree(tPrimaryDC);
	}


	NET_API_STATUS nasReturn;
	NET_DISPLAY_USER * pNDUBuff;
	DWORD  dwUsers;
	char szNameBuffer[256];
	char szCommentBuffer[256];
	char szFNameBuffer[256];

	char szTextualSid[256];
	DWORD dwBufferLen;


	DWORD i=0;
	DWORD next=0;

	do {
		// 1 = Users, 2 = Machines, 3 = groups
		nasReturn = NetQueryDisplayInformation(PDC,1,next,100,-1,&dwUsers,(PVOID*)&pNDUBuff);
		
		if(nasReturn == ERROR_ACCESS_DENIED) {
			char temp[256]="Access Denied. Cannot query domain groups while SNARE is running with the privileges of the local administrator";
            retval=send(http_socket,temp,strlen(temp),0);
			break;
        }

		for (i=0; i<dwUsers; i++)
		{
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           pNDUBuff [i].usri1_name,
                           -1,
                           szNameBuffer,
                           sizeof(szNameBuffer),
                           NULL,
                           NULL);
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           pNDUBuff [i].usri1_comment,
                           -1,
                           szCommentBuffer,
                           sizeof(szCommentBuffer),
                           NULL,
                           NULL);

			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           pNDUBuff [i].usri1_full_name,
                           -1,
                           szFNameBuffer,
                           sizeof(szFNameBuffer),
                           NULL,
                           NULL);

			if(szNameBuffer) {
				// GET SID HERE

				dwBufferLen=sizeof(szTextualSid);

				// Obtain the textual representation of the SID.
				GetUserSid(szNameBuffer,szTextualSid,&dwBufferLen);
			}


			// Get rid of tabs in the Description field
			char * t;
			t=szCommentBuffer;
			if(t) {
				while(*t) {
					if(*t == '\t') { *t=' '; }
					t++;
				}
			}


			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t%s (%s)\t%s",szNameBuffer,szFNameBuffer,szCommentBuffer,szTextualSid);
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);

			strcpy(HTTPBuffer,"");

			if(pNDUBuff->usri1_flags & UF_ACCOUNTDISABLE) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tACCOUNTDISABLE",HTTPBuffer);
			}
			if(pNDUBuff->usri1_flags & UF_PASSWD_NOTREQD) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tPASSWD_NOTREQD",HTTPBuffer);
			}
			if(pNDUBuff->usri1_flags & UF_PASSWD_CANT_CHANGE) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tPASSWD_CANT_CHANGE",HTTPBuffer);
			}
			if(pNDUBuff->usri1_flags & UF_LOCKOUT) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tLOCKOUT",HTTPBuffer);
			}
			if(pNDUBuff->usri1_flags & UF_DONT_EXPIRE_PASSWD) {
				snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\tDONT_EXPIRE_PASSWD",HTTPBuffer);
			}
			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\n",HTTPBuffer);
		
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);

		}
		if(dwUsers) {
			next = pNDUBuff[dwUsers - 1].usri1_next_index;
		}

		if(pNDUBuff) {
			NetApiBufferFree (pNDUBuff);
		}
	} while(nasReturn == ERROR_MORE_DATA);
	
	return(1);
}



int ShowDomainGroups(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";

	LPWSTR tPrimaryDC = NULL;
	WCHAR PrimaryDC[256];
	WCHAR *PDC;
	NET_API_STATUS netErr=1;

	// Get the primary domain controller
	netErr = NetGetDCName(NULL,NULL,(LPBYTE *)&tPrimaryDC);
	if(netErr == NERR_Success) {
		char temp[256]="", temp2[256]="";
		if(tPrimaryDC) {
			wcsncpy(PrimaryDC,tPrimaryDC,255);
			PDC=PrimaryDC;

			WideCharToMultiByte( CP_ACP, 0,PDC,-1, temp, 255, NULL, NULL );
			_snprintf(temp2,255,"PDC: %s\n",temp);
			retval = send(http_socket,temp2,strlen(temp2),0);
		} else {
			char temp[256];
			PDC=NULL;
			strncpy(temp,"PDC: LOCAL\n",sizeof(temp));
			retval = send(http_socket,temp,strlen(temp),0);	
		}
	} else {
		char temp[256];
		
		PDC=NULL;

		strncpy(temp,"PDC: LOCAL\n",sizeof(temp));
		retval = send(http_socket,temp,strlen(temp),0);	
	}

	if(tPrimaryDC) {
	  NetApiBufferFree(tPrimaryDC);
	}


	NET_API_STATUS nasReturn;
	NET_DISPLAY_GROUP * pNDUBuff;
	DWORD  dwGroups;
	char szNameBuffer[256];
	char szCommentBuffer[256];

	DWORD i=0;
	DWORD next=0;

	do {
		// 1 = Users, 2 = Machines, 3 = groups
		nasReturn = NetQueryDisplayInformation(PDC,3,next,100,-1,&dwGroups,(PVOID*)&pNDUBuff);
		
		if(nasReturn == ERROR_ACCESS_DENIED) {
			char temp[256]="Access Denied. Cannot query domain groups while SNARE is running with the privileges of the local administrator";
            retval=send(http_socket,temp,strlen(temp),0);
			break;
        }

		for (i=0; i<dwGroups; i++)
		{
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           pNDUBuff [i].grpi3_name,
                           -1,
                           szNameBuffer,
                           sizeof(szNameBuffer),
                           NULL,
                           NULL);
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           pNDUBuff [i].grpi3_comment,
                           -1,
                           szCommentBuffer,
                           sizeof(szCommentBuffer),
                           NULL,
                           NULL);

			// Get rid of tabs in the Description field
			char * t;
			t=szCommentBuffer;
			if(t) {
				while(*t) {
					if(*t == '\t') { *t=' '; }
					t++;
				}
			}

			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t%s\n",szNameBuffer,szCommentBuffer);
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);


		}
		if(dwGroups) {
			next = pNDUBuff[dwGroups - 1].grpi3_next_index;
		}

		if(pNDUBuff) {
			NetApiBufferFree (pNDUBuff);
		}
	} while(nasReturn == ERROR_MORE_DATA);
	
	return(1);
}

int ShowLocalGroups(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";

	GROUP_INFO_1	*GroupInfo,*GISave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwResume=0,dwReturn=0;
	char szName[255],szComment[255];

	do {
		dwReturn = NetLocalGroupEnum( NULL, 1, (LPBYTE *)&GroupInfo, 65536, 
                &dwEntriesRead,	&dwTotalEntries, &dwResume );
		GISave=GroupInfo;

		while ( dwEntriesRead ) {
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,GroupInfo->grpi1_name,-1, szName, 254, NULL, NULL );
			WideCharToMultiByte( CP_ACP, 0,GroupInfo->grpi1_comment,-1, szComment, 254, NULL, NULL );

			// Get rid of tabs in the Description field
			char * t;
			t=szComment;
			if(t) {
				while(*t) {
					if(*t == '\t') { *t=' '; }
					t++;
				}
			}
		
			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t%s\n",szName,szComment);
		
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);
			
			GroupInfo += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(GISave != NULL) {
			NetApiBufferFree(GISave);
			GISave=NULL;
		}
	} while(dwReturn == ERROR_MORE_DATA);

	if(GISave != NULL) {
		NetApiBufferFree(GISave);
	}

	// Send a newline to finish off.
	retval = send(http_socket,"\n",strlen("\n"),0);

	return(0);
}


int ShowLocalGroupMembers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[4096]="";

	GROUP_INFO_1	*GroupInfo,*GISave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwResume=0,dwReturn=0;
	char szName[255];
	char szComment[255];

	do {
		dwReturn = NetLocalGroupEnum( NULL, 1, (LPBYTE *)&GroupInfo, 65536, 
                &dwEntriesRead,	&dwTotalEntries, &dwResume );
		GISave=GroupInfo;

		while ( dwEntriesRead ) {
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,GroupInfo->grpi1_name,-1, szName, 254, NULL, NULL );
	
			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t",szName);
		
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);
			
			WideCharToMultiByte( CP_ACP, 0,GroupInfo->grpi1_comment,-1, szComment, 254, NULL, NULL );
	
			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t",szComment);
		
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);

			ShowThisLocalGroupMembers(GroupInfo->grpi1_name,http_socket);
			retval = send(http_socket,"\n",strlen("\n"),0);
			
			GroupInfo += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(GISave != NULL) {
			NetApiBufferFree(GISave);
			GISave=NULL;
		}
	} while(dwReturn == ERROR_MORE_DATA);

	if(GISave != NULL) {
		NetApiBufferFree(GISave);
	}

	// Send a newline to finish off.
	retval = send(http_socket,"\n",strlen("\n"),0);

	return(0);
}


int ShowDomainGroupMembers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";

	LPWSTR tPrimaryDC = NULL;
	WCHAR PrimaryDC[256];
	WCHAR *PDC;
	NET_API_STATUS netErr=1;

	// Get the primary domain controller
	netErr = NetGetDCName(NULL,NULL,(LPBYTE *)&tPrimaryDC);
	if(netErr == NERR_Success) {
		char temp[256]="", temp2[256]="";
		if(tPrimaryDC) {
			wcsncpy(PrimaryDC,tPrimaryDC,255);
			PDC=PrimaryDC;

			WideCharToMultiByte( CP_ACP, 0,PDC,-1, temp, 255, NULL, NULL );
			_snprintf(temp2,255,"PDC: %s\n",temp);
			retval = send(http_socket,temp2,strlen(temp2),0);
		} else {
			char temp[256];
			PDC=NULL;
			strncpy(temp,"PDC: LOCAL\n",sizeof(temp));
			retval = send(http_socket,temp,strlen(temp),0);	
		}
	} else {
		char temp[256];
		
		PDC=NULL;

		strncpy(temp,"PDC: LOCAL\n",sizeof(temp));
		retval = send(http_socket,temp,strlen(temp),0);	
	}

	if(tPrimaryDC) {
	  NetApiBufferFree(tPrimaryDC);
	}


	NET_API_STATUS nasReturn;
	NET_DISPLAY_GROUP * pNDUBuff;
	DWORD  dwGroups;
	char szNameBuffer[256];
	char szCommentBuffer[256];

	DWORD i=0;
	DWORD next=0;

	do {
		// 1 = Users, 2 = Machines, 3 = groups
		nasReturn = NetQueryDisplayInformation(PDC,3,next,100,-1,&dwGroups,(PVOID*)&pNDUBuff);
		
		if(nasReturn == ERROR_ACCESS_DENIED) {
			char temp[256]="Access Denied. Cannot query domain groups while SNARE is running with the privileges of the local administrator";
            retval=send(http_socket,temp,strlen(temp),0);
			break;
        }

		for (i=0; i<dwGroups; i++)
		{
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           pNDUBuff [i].grpi3_name,
                           -1,
                           szNameBuffer,
                           sizeof(szNameBuffer),
                           NULL,
                           NULL);
		
			
			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t",szNameBuffer);
		
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);

			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           pNDUBuff [i].grpi3_comment,
                           -1,
                           szCommentBuffer,
                           sizeof(szCommentBuffer),
                           NULL,
                           NULL);
		
			
			snprintf(HTTPBuffer,sizeof(HTTPBuffer),"%s\t",szCommentBuffer);
		
			retval = send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0);

			ShowThisDomainGroupMembers(pNDUBuff[i].grpi3_name,PDC,http_socket);
			retval = send(http_socket,"\n",strlen("\n"),0);
		}
		if(dwGroups) {
			next = pNDUBuff[dwGroups - 1].grpi3_next_index;
		}

		if(pNDUBuff) {
			NetApiBufferFree (pNDUBuff);
		}
	} while(nasReturn == ERROR_MORE_DATA);
	
	return(1);
}


char * ShowThisLocalGroupMembers(WCHAR *Group,SOCKET http_socket)
{
	LOCALGROUP_MEMBERS_INFO_3* Members,*MSave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwResume=0,dwReturn=0;
	char szName[255]="";
	char Buffer[256]="";
	int first=1;
	int retval;

	do {
		dwReturn = NetLocalGroupGetMembers(NULL, Group, 3,
         (PBYTE*) &Members, 65536,
         &dwEntriesRead,	&dwTotalEntries, &dwResume );
		MSave=Members;

		while ( dwEntriesRead ) {
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,Members->lgrmi3_domainandname,-1, szName, 254, NULL, NULL );

			if(!first) {
				snprintf(Buffer,255,",%s",szName);
			} else {
				first=0;
				snprintf(Buffer,255,"%s",szName);
			}
			
			retval = send(http_socket,Buffer,strlen(Buffer),0);			

			Members += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(MSave != NULL) {
			NetApiBufferFree(MSave);
			MSave=NULL;
		}
	} while(dwReturn == ERROR_MORE_DATA);

	if(MSave != NULL) {
		NetApiBufferFree(MSave);
	}

	return(0);
}


char * ShowThisDomainGroupMembers(WCHAR *Group,WCHAR *PDC, SOCKET http_socket)
{
	GROUP_USERS_INFO_0* Members,*MSave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwResume=0,dwReturn=0;
	char szName[255]="";
	char Buffer[256]="";
	int first=1;
	int retval;

	do {
		dwReturn = NetGroupGetUsers(PDC, Group, 0,
         (PBYTE*) &Members, 65536,
         &dwEntriesRead,	&dwTotalEntries, &dwResume );
		MSave=Members;

		while ( dwEntriesRead ) {
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,Members->grui0_name,-1, szName, 254, NULL, NULL );

			if(!first) {
				snprintf(Buffer,255,",%s",szName);
			} else {
				first=0;
				snprintf(Buffer,255,"%s",szName);
			}
			
			retval = send(http_socket,Buffer,strlen(Buffer),0);			

			Members += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(MSave != NULL) {
			NetApiBufferFree(MSave);
			MSave=NULL;
		}
	} while(dwReturn == ERROR_MORE_DATA);

	if(MSave != NULL) {
		NetApiBufferFree(MSave);
	}

	return(0);
}








// General instructions:
// $ expr `./base64 intersect.gif | wc -c` - `./base64 intersect.gif | wc -l` "*" 2 + 1
//   2029
// ./base64 intersect.gif | sed 's/^/   "/' | sed 's/.$/"  \\/' >out.txt
// 
//  mangle out.txt as appropriate - add the (wc -c) - ((wc -l)*2) + 1 figure to the buffer size.
int InterSectImage(char *source, char *dest, int size)
{
	char IntersectGif[2029];

	strncpy(IntersectGif,"R0lGODlhzQBGALMAAB8aF01JR2toZtwrGYF+fONVRo+Mi5eWleuCePKzrLOysszLy/jRzunl" \
	    "5f////j29SwAAAAAzQBGAEAI/gAdCBxIsKDBgw4eIFxIUCHDhxAjSkT4AMGAAQgmatw40CHH" \
	    "jxs9ghQJsuTEBxdTpkxgsqXLlzBjyvyoMuXMmzAB6NQp0MDOnzoDkOz504ADn0CTAniAVOlO" \
		"oQqcSgVqdKpVAARrXiyA0+XQkkCJ7jRakMDPAA3MjmUYtikAsgfV6lTw9WFYgwKACj34gIFW" \
		"jF0DCx5MeGPUsw08WtTKMqFcAGgZNghQ9ChQAQ1Kuq36s7DnzxL7/kXw4DFah6gFpk4o8ADV" \
		"Bwpjs45d1/Lau6Bz6y5YQCvXmbV3Cx++MUHvvxcZHFSgoOGB5g4WGFhAfUFmAwqqL2i94EGD" \
		"AwSZ/nNXreDA9gXmq5vvmb165sDBIcYnfjAB8gLz6ev3up+ifa0i5VeYgCEtROBIsyUIm0Gy" \
		"seZgbatFqNqEBB2nUkb9BXbXZgJN9hN0YukE10FtVYbQY1clxVmKSjW0WE0HZijRhiYetIBS" \
		"AdjVGYcUPZAXi0Bth9tBHv4EnkEWqjQUU5SxKMB2HTEFpJBXrTiVjFhO9F9NGKIIpE7g8ahZ" \
		"ZUNmaeZGL6rUkQJNfgllQmyyCKJBHJZ55p0LNZBkSr8VhN4D66mGnkGBEjRdRwcUetQB7zmw" \
		"HnraBYqddo3ieecDe2IUo6WcdtrRlkp6KuqoqmH6F34ZbkrqpZkOoOqq/7DqZmpNjcVqK55/" \
		"VSrjqyR2BmdSkSHEoVtS2TbVXkV+CQB0yho5EKgp6XorQmFJudZjBJAkZq87GfvWQo/NKWyN" \
		"8jnQwJDQXlTrtNT6KuYDN/6UmLcjGlTiWic2K68D+s5VEEq+Ycmrve6S21GbKrK1o8Edndsv" \
		"AN3ZqRrCAAiAUJopKcfuTQ0oYMChGwsU709vCuRXwAMl2+x7FF9FpVVWFhsyfMRaPBByDj0m" \
		"wMc898wzwgZYK2JLdfo6s4ytKqSzz0z3zGiIbw1cdLdH75rpbz/qC2XWci40NU9Vy4jxRWGX" \
		"/dnYA6zLWgPW8fUvTEtS5KDZoD2QLp/LpYceiP6DFqRoT1B+pxBzDk33HV2PHkloon/TLRhy" \
		"KzkuuWB9JYnh5C8N7OndgOmnOeaUN3DfgqCb9DmenDd6eulho315qpfSLRpjq7NOd6av244g" \
		"f2f+RXpH+9UON+h/6W78RpmqPXfIuMHbZAAEzMvXsCkKLdVesBnQslRPDtSv4g6MjWqWtd/l" \
		"MLDSQm0UsU5565RQD2zPYmYPL9XhXwl4JHx/NJ71k83A2xbBuiVAgpgmfSkDmmGGhLb9Yal/" \
		"Q3MAwsBHL4URkGEDWVrTeqbADW6QYvo7FfliAsFvdShIhcOg9xaGr7jUDzwPyxFB7pY/s5Ww" \
		"XocJynVUKJB7RZBBGv70oNPeQxWfcU1E3TlIAx24nxsy6IhUsSBPCphBxDyIQqvpodEKckQZ" \
		"HkSEsMtJwVpYkPMlpWQDnCIPHQDFKfFri2WkWL1MNpoeXfGOEIINbRS0PBKO8YfL0QsCV3hB" \
		"MiIkTsqKGBwNYkZ/FQRtDBCJyoAEovi56QEpiln7jheRHO4EjUkbiCebZZSRTQmTVXqjVTg5" \
		"EdecxSMnq0mfwgUR6j1FamRaJCs5ogAC9OxNaGuMl760vqLg8ja63CXcTqW0+u3QkBz5GlaU" \
		"2RVIluZDH3GLAAg0FGlSsysA45K56tedRqaILuNCJtW+eRPxqaaNKUqiJSlZF2+ys53FA6ne" \
		"PY3nzgLtM2TeqeM/jxdLGDHIY+Jim0GsQ5K2pQyNDhVZZuClnTdVlKED1UhsGNCqAWjMOdsp" \
		"j0ekQyc0OupNzBHcQJ5zKECdZ0QONQ8TOVkRyA1AV94xAOMSZYD3DEokMvVbEj2203mt5wHM" \
		"OVTfBJId7ugvoxJBm0qUZ66IdqhtbKNUdCoq0ehUCl6ZsWrbKKodh1x0kFAliFQL8NG0lm5L" \
		"CJAe3QICADs=",2029);

	return(base64decode(dest,IntersectGif,size));
}

int Pipe_Request(char *source, char *dest, int size)
{
	HANDLE hPipe;
	DWORD dwSize = size;
	char str_buffer[100] = "";

	hPipe = CreateFile("\\\\.\\PIPE\\snare",GENERIC_READ,0,NULL,OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED,NULL);
	if (hPipe == INVALID_HANDLE_VALUE)
	{
		strncpy(dest,"<center>Pipe Server not available</center>",size);
		return(0);
	}

	// HERE: Send the 'source' to the pipe
	if(WriteFile(hPipe,source,strlen(source),&dwSize,NULL)==0) {
		strncpy(dest,"<center>Cannot send any data to the Pipe Server</center>",size);
		return(0);
	}

	if(ReadFile(hPipe,dest,size,&dwSize,NULL)==0) {
		strncpy(dest,"<center>Cannot read data from Pipe Server</center>",size);
		return(0);
	}

	CloseHandle(hPipe);

	return(0);
}

int debracket(char *source, char *dest, int length)
{
	//This routine is simply to replace the HTML metacharacters "<" and ">" with
	// "&lt;" and "&gt;". That's all!

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) return(1);

      while(*source) 
	  {
              if(*source == '<') 
			  {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='l'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } 
			  else if(*source == '>') 
			  {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='g'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } 
			  else 
			  {
                      if(count < length) { *dest=*source; dest++; count++;}
              }
              source++;
      }
      *dest='\0';

	  dest=copyofdest;

      return(0);
}

int DisplayTextHeader(SOCKET http_socket)
{
	char HTTPBuffer[512];
	// Overwrite HTTPBuffer with the header data.
	strncpy(HTTPBuffer, "HTTP/1.0 200 OK\r\n" \
						"Server: SNARE/1.0\r\n" \
						"MIME-version: 1.0\r\n" \
						"Content-type: text/plain\r\n\r\n",
			sizeof(HTTPBuffer));
	return(send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0));
}

// Convert sid to text.
BOOL GetUserSid(
    LPSTR szName,            // username
    LPTSTR TextualSid,    // buffer for Textual representation of SID
    LPDWORD lpdwBufferLen // required/provided TextualSid buffersize
    )
{
	// For LookupAccountName
	PSID pSid = NULL;
	DWORD cbSid = 0;
	char *pszDomainName = NULL;
    unsigned long cbDomainName = 0;
	SID_NAME_USE su;
	
	LookupAccountName(NULL,(LPCSTR)szName,pSid,&cbSid,(LPSTR)pszDomainName,&cbDomainName,&su);
	

	if(cbSid) {
		pSid=(PSID)malloc(cbSid);
					
		if(pSid) {
			pszDomainName=(char *)malloc(cbDomainName);
			if (!pszDomainName)
			{
				free (pSid);
				pSid=NULL;
			}
		}

		if(pSid) {
			if (!(LookupAccountName(NULL,(LPCSTR) szName,
                      pSid,
                      &cbSid,
                      (LPSTR) pszDomainName,
                      &cbDomainName,
                      &su))) {
				free (pSid);
				free (pszDomainName);
				pSid=NULL;
			}
		}

		if(pSid) {
			if (!IsValidSid(pSid))	{
				free (pSid);
				free (pszDomainName);
				pSid=NULL;
			}
		}
					
		if(pSid) {
			// Obtain the textual representation of the SID.
			if (!GetTextualSid(
				pSid, // user binary Sid
				TextualSid,      // buffer for TextualSid
				lpdwBufferLen)) {       // size/required buffer
					strncpy(TextualSid,"Unknown",*lpdwBufferLen);
			}

			free(pSid);
			free(pszDomainName);
		} else {
			strncpy(TextualSid,"Unknown",*lpdwBufferLen);
		}
	} else {
		strncpy(TextualSid,"Unknown",*lpdwBufferLen);
	}
	
	return(0);
}

// Convert sid to text.
BOOL GetTextualSid(
    PSID pSid,            // binary SID
    LPTSTR TextualSid,    // buffer for Textual representation of SID
    LPDWORD lpdwBufferLen // required/provided TextualSid buffersize
    )
{
    PSID_IDENTIFIER_AUTHORITY psia;
    DWORD dwSubAuthorities;
    DWORD dwSidRev=SID_REVISION;
    DWORD dwCounter;
    DWORD dwSidSize;

    // Validate the binary SID.

    if(!IsValidSid(pSid)) return FALSE;

    // Get the identifier authority value from the SID.

    psia = GetSidIdentifierAuthority(pSid);

    // Get the number of subauthorities in the SID.

    dwSubAuthorities = *GetSidSubAuthorityCount(pSid);

    // Compute the buffer length.
    // S-SID_REVISION- + IdentifierAuthority- + subauthorities- + NULL

    dwSidSize=(15 + 12 + (12 * dwSubAuthorities) + 1) * sizeof(TCHAR);

    // Check input buffer length.
    // If too small, indicate the proper size and set last error.

    if (*lpdwBufferLen < dwSidSize)
    {
        *lpdwBufferLen = dwSidSize;
        SetLastError(ERROR_INSUFFICIENT_BUFFER);
        return FALSE;
    }

    // Add 'S' prefix and revision number to the string.

    dwSidSize=wsprintf(TextualSid, TEXT("S-%lu-"), dwSidRev );

    // Add SID identifier authority to the string.

    if ( (psia->Value[0] != 0) || (psia->Value[1] != 0) )
    {
        dwSidSize+=wsprintf(TextualSid + lstrlen(TextualSid),
                    TEXT("0x%02hx%02hx%02hx%02hx%02hx%02hx"),
                    (USHORT)psia->Value[0],
                    (USHORT)psia->Value[1],
                    (USHORT)psia->Value[2],
                    (USHORT)psia->Value[3],
                    (USHORT)psia->Value[4],
                    (USHORT)psia->Value[5]);
    }
    else
    {
        dwSidSize+=wsprintf(TextualSid + lstrlen(TextualSid),
                    TEXT("%lu"),
                    (ULONG)(psia->Value[5]      )   +
                    (ULONG)(psia->Value[4] <<  8)   +
                    (ULONG)(psia->Value[3] << 16)   +
                    (ULONG)(psia->Value[2] << 24)   );
    }

    // Add SID subauthorities to the string.
    //
    for (dwCounter=0 ; dwCounter < dwSubAuthorities ; dwCounter++)
    {
        dwSidSize+=wsprintf(TextualSid + dwSidSize, TEXT("-%lu"),
                    *GetSidSubAuthority(pSid, dwCounter) );
    }

    return TRUE;
}

